/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager;

import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.xdb.dlock.DLock;
import kd.bos.xdb.exception.ExceptionUtil;

public interface LockCreateTableCall {
    public void call() throws SQLException;

    public static void lockAndCall(String table, LockCreateTableCall call) {
        String key = "/xdb/createTable/" + table;
        try {
            AtomicBoolean created = new AtomicBoolean();
            while (true) {
                DLock.lock(key, () -> {
                    call.call();
                    created.set(true);
                    return null;
                });
                if (!created.get()) {
                    Thread.sleep(100L);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }
}

