/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.sharding.config.DataRowsRange;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.tablemanager.AbstractTableManager;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;

final class VersionedTableManager
extends AbstractTableManager
implements TableManager {
    private final TableManager tm;
    private Map<String, Tables> cache = new ConcurrentHashMap<String, Tables>();

    VersionedTableManager(TableManager tm) {
        this.tm = tm;
    }

    private Tables getTables(String tableName) {
        tableName = TableName.of(tableName).getOriginalName();
        return this.cache.computeIfAbsent(tableName, key -> new Tables((String)key, this));
    }

    @Override
    public boolean existTable(String tableName) throws SQLException {
        Tables ts = this.getTables(tableName);
        if (ts.hasTable(tableName)) {
            return true;
        }
        if (this.tm.existTable(tableName)) {
            ts.addNonShardingDataTable(tableName);
            return true;
        }
        return false;
    }

    @Override
    public String[] getShardingTable(String tableName) throws SQLException {
        Tables ts;
        block5: {
            long lastVersion;
            block6: {
                block4: {
                    ts = this.getTables(tableName);
                    if (!this.tableVersionUpdator.isMaskIncVersion(tableName)) break block4;
                    this.reloadShardingTable(tableName);
                    break block5;
                }
                lastVersion = -1L;
                if (ts.shardingDataTables.length == 0) break block6;
                lastVersion = this.tableVersionUpdator.getLastVersion(TableName.of(tableName).getOriginalName());
                if (ts.version.get() == lastVersion) break block5;
            }
            if (lastVersion == -1L) {
                lastVersion = this.tableVersionUpdator.getLastVersion(TableName.of(tableName).getOriginalName());
            }
            this.reloadShardingTable(tableName);
            ts.version.set(lastVersion);
        }
        return ts.shardingDataTables;
    }

    private void reloadShardingTable(String tableName) throws SQLException {
        Tables ts = this.getTables(tableName);
        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getMainConfig(tableName);
        if (mainConfig != null) {
            Set<String> dbRoutes = mainConfig.getOptions().getIndexRoute().getDbRoutes();
            HashSet<String> shardingDataTableSet = new HashSet<String>();
            for (String dbRoute : dbRoutes) {
                String[] routeShardingTable = this.tm.getShardingTable(dbRoute, tableName);
                ts.setRouteShardingDataTable(dbRoute, routeShardingTable);
                shardingDataTableSet.addAll(Arrays.asList(routeShardingTable));
            }
            String[] shardingTable = shardingDataTableSet.toArray(new String[shardingDataTableSet.size()]);
            ts.setShardingDataTables(shardingTable);
        } else {
            List<String> dataTables = Arrays.asList(this.tm.getShardingTable(tableName));
            String[] shardingTable = dataTables.toArray(new String[dataTables.size()]);
            ts.setShardingDataTables(shardingTable);
        }
    }

    @Override
    public String[] getShardingTable(String dbRoute, String tableName) throws SQLException {
        Tables ts = this.getTables(tableName);
        Set mapDataTableSet = (Set)ts.routeShardingDataTableMap.get(dbRoute);
        return mapDataTableSet.toArray(new String[mapDataTableSet.size()]);
    }

    @Override
    public String[] getMovingTable(String tableName) throws SQLException {
        Tables ts;
        block5: {
            long lastVersion;
            block6: {
                block4: {
                    ts = this.getTables(tableName);
                    if (!this.tableVersionUpdator.isMaskIncVersion(tableName)) break block4;
                    String[] movingTable = this.tm.getMovingTable(tableName);
                    ts.setMovingDataTables(movingTable);
                    break block5;
                }
                lastVersion = -1L;
                if (ts.movingDataTables.length == 0) break block6;
                lastVersion = this.tableVersionUpdator.getLastVersion(TableName.of(tableName).getOriginalName());
                if (ts.version.get() == lastVersion) break block5;
            }
            if (lastVersion == -1L) {
                lastVersion = this.tableVersionUpdator.getLastVersion(TableName.of(tableName).getOriginalName());
            }
            String[] movingTable = this.tm.getMovingTable(tableName);
            ts.setMovingDataTables(movingTable);
            ts.version.set(lastVersion);
        }
        return ts.movingDataTables;
    }

    @Override
    public String createShardingTable(String dbRoute, String tableName, long shardingIndex) throws SQLException {
        String shardingTable = TableName.of(tableName).getShardingTable(shardingIndex);
        this.tm.createShardingTable(dbRoute, tableName, shardingIndex);
        return shardingTable;
    }

    @Override
    public String createShardingTable(String tableName, long shardingIndex) throws SQLException {
        String shardingTable;
        Tables ts = this.getTables(tableName);
        if (!ts.hasTable(shardingTable = TableName.of(tableName).getShardingTable(shardingIndex))) {
            this.tm.createShardingTable(tableName, shardingIndex);
            ts.addShardingDataTable(shardingTable);
            ts.version.incrementAndGet();
            if (!this.tableVersionUpdator.isMaskIncVersion(tableName)) {
                long lastVersion = this.tableVersionUpdator.incVersion(TableName.of(tableName).getOriginalName());
                this.fireTableCreated(shardingTable, lastVersion);
            }
        }
        return shardingTable;
    }

    @Override
    public String createRTTable(String tableName) throws SQLException {
        String rtTable;
        Tables ts = this.getTables(tableName);
        if (!ts.hasTable(rtTable = TableName.of(tableName).getRTTable())) {
            this.tm.createRTTable(tableName);
            ts.addNonShardingDataTable(rtTable);
            ts.version.incrementAndGet();
            if (!this.tableVersionUpdator.isMaskIncVersion(tableName)) {
                long lastVersion = this.tableVersionUpdator.incVersion(TableName.of(tableName).getOriginalName());
                this.fireTableCreated(rtTable, lastVersion);
            }
        }
        return rtTable;
    }

    @Override
    public String createMapTable(String tableName) throws SQLException {
        String mapTable;
        Tables ts = this.getTables(tableName);
        if (!ts.hasTable(mapTable = TableName.of(tableName).getMapTable())) {
            this.tm.createMapTable(tableName);
            ts.addNonShardingDataTable(mapTable);
            ts.version.incrementAndGet();
            if (!this.tableVersionUpdator.isMaskIncVersion(tableName)) {
                long lastVersion = this.tableVersionUpdator.incVersion(TableName.of(tableName).getOriginalName());
                this.fireTableCreated(mapTable, lastVersion);
            }
        }
        return mapTable;
    }

    @Override
    public String createPKTable(String dbRoute, String tableName, PkTypeEnum type, DataRowsRange drr, IndexDefine[] indexDefines) throws SQLException {
        Tables ts = this.getTables(tableName);
        String pkTable = TableName.of(tableName).getPKTable();
        this.tm.createPKTable(dbRoute, tableName, type, drr, indexDefines);
        ts.addNonShardingDataTable(pkTable);
        return pkTable;
    }

    @Override
    public String createPKTempTable(String dbRoute, String tableName, PkTypeEnum type, DataRowsRange drr, IndexDefine[] indexDefines) throws SQLException {
        Tables ts = this.getTables(tableName);
        String pkTempTable = TableName.of(tableName).getPKTempTable();
        this.tm.createPKTempTable(dbRoute, tableName, type, drr, indexDefines);
        ts.addNonShardingDataTable(pkTempTable);
        return pkTempTable;
    }

    @Override
    public String createMovingTable(String tableName, long shardingIndex, PkTypeEnum type) throws SQLException {
        String movingTable;
        Tables ts = this.getTables(tableName);
        if (!ts.hasTable(movingTable = TableName.of(tableName).getMovingTable(shardingIndex))) {
            this.tm.createMovingTable(tableName, shardingIndex, type);
            ts.addMovingDataTable(movingTable);
            ts.version.incrementAndGet();
            if (!this.tableVersionUpdator.isMaskIncVersion(tableName)) {
                long lastVersion = this.tableVersionUpdator.incVersion(TableName.of(tableName).getOriginalName());
                this.fireTableCreated(movingTable, lastVersion);
            }
        }
        return movingTable;
    }

    @Override
    public String createPrototypeTable(String tableName) throws SQLException {
        String prototypeTable;
        Tables ts = this.getTables(tableName);
        if (!ts.hasTable(prototypeTable = TableName.of(tableName).getPrototypeTable())) {
            this.tm.createPrototypeTable(tableName);
            ts.addNonShardingDataTable(prototypeTable);
            ts.version.incrementAndGet();
            if (!this.tableVersionUpdator.isMaskIncVersion(tableName)) {
                long lastVersion = this.tableVersionUpdator.incVersion(TableName.of(tableName).getOriginalName());
                this.fireTableCreated(prototypeTable, lastVersion);
            }
        }
        return prototypeTable;
    }

    @Override
    public void clearCahce(String tableName) {
        this.cache.remove(TableName.of(tableName).getOriginalName());
    }

    @Override
    public void add2Cahce(String specificTableName) {
        Tables ts = this.getTables(specificTableName);
        if (!ts.hasTable(specificTableName)) {
            if (TableName.of(specificTableName).isDataTable()) {
                ts.addShardingDataTable(specificTableName);
            } else {
                ts.addNonShardingDataTable(specificTableName);
            }
        }
    }

    @Override
    public void removeCahce(String specificTableName) {
        TableName tn = TableName.of(specificTableName);
        Tables ts = this.getTables(tn.getOriginalName());
        ts.removeTable(specificTableName);
    }

    private static class Tables {
        private AtomicLong version = new AtomicLong(0L);
        private Object lock = new Object();
        private String[] shardingDataTables = new String[0];
        private String[] movingDataTables = new String[0];
        private Map<String, Set<String>> routeShardingDataTableMap = new ConcurrentHashMap<String, Set<String>>();
        private Set<String> shardingDataTableSet = new HashSet<String>();
        private Set<String> movingDataTableSet = new HashSet<String>();
        private Set<String> allTableSet = new HashSet<String>();

        Tables(String tableName, VersionedTableManager vtm) {
            try {
                MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getMainConfig(tableName);
                if (mainConfig != null) {
                    Set<String> dbRoutes = mainConfig.getOptions().getIndexRoute().getDbRoutes();
                    for (String dbRoute : dbRoutes) {
                        List<String> dataTables = Arrays.asList(vtm.tm.getShardingTable(dbRoute, tableName));
                        Set mapDataTableSet = this.routeShardingDataTableMap.computeIfAbsent(dbRoute, key -> new HashSet());
                        mapDataTableSet.addAll(dataTables);
                        this.shardingDataTableSet.addAll(dataTables);
                        this.allTableSet.addAll(dataTables);
                    }
                } else {
                    List<String> dataTables = Arrays.asList(vtm.tm.getShardingTable(tableName));
                    this.shardingDataTableSet.addAll(dataTables);
                    this.allTableSet.addAll(dataTables);
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.asRuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setRouteShardingDataTable(String route, String[] shardingTableNames) {
            Object object = this.lock;
            synchronized (object) {
                HashSet<String> mapDataTableSet = new HashSet<String>(Arrays.asList(shardingTableNames));
                this.routeShardingDataTableMap.remove(route);
                this.routeShardingDataTableMap.put(route, mapDataTableSet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addShardingDataTable(String shardingTableName) {
            Object object = this.lock;
            synchronized (object) {
                this.allTableSet.add(shardingTableName);
                if (this.shardingDataTableSet.add(shardingTableName)) {
                    String dbRoute = ExtContext.get().getDBRoute();
                    Set mapTableSet = this.routeShardingDataTableMap.computeIfAbsent(dbRoute, key -> new HashSet());
                    mapTableSet.add(dbRoute);
                    this.shardingDataTables = this.shardingDataTableSet.toArray(new String[this.shardingDataTableSet.size()]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setShardingDataTables(String[] shardingTableNames) {
            Object object = this.lock;
            synchronized (object) {
                this.allTableSet.removeAll(this.shardingDataTableSet);
                this.shardingDataTableSet.clear();
                this.shardingDataTableSet.addAll(Arrays.asList(shardingTableNames));
                this.allTableSet.addAll(this.shardingDataTableSet);
                this.shardingDataTables = shardingTableNames;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addMovingDataTable(String movingTableName) {
            Object object = this.lock;
            synchronized (object) {
                this.allTableSet.add(movingTableName);
                if (this.movingDataTableSet.add(movingTableName)) {
                    this.movingDataTables = this.movingDataTableSet.toArray(new String[this.movingDataTableSet.size()]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setMovingDataTables(String[] movingTableNames) {
            Object object = this.lock;
            synchronized (object) {
                this.allTableSet.removeAll(this.movingDataTableSet);
                this.movingDataTableSet.clear();
                this.movingDataTableSet.addAll(Arrays.asList(movingTableNames));
                this.allTableSet.addAll(this.movingDataTableSet);
                this.movingDataTables = movingTableNames;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addNonShardingDataTable(String tableName) {
            Object object = this.lock;
            synchronized (object) {
                return this.allTableSet.add(tableName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeTable(String tableName) {
            Object object = this.lock;
            synchronized (object) {
                if (this.shardingDataTableSet.remove(tableName)) {
                    this.shardingDataTables = this.shardingDataTableSet.toArray(new String[this.shardingDataTableSet.size()]);
                }
                if (this.movingDataTableSet.remove(tableName)) {
                    this.movingDataTables = this.movingDataTableSet.toArray(new String[this.movingDataTableSet.size()]);
                }
                this.allTableSet.remove(tableName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasTable(String tableName) {
            Object object = this.lock;
            synchronized (object) {
                return this.allTableSet.contains(tableName);
            }
        }
    }
}

