/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager.ksql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.XDBManageContext;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.ext.KSQLTransfer;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.id.IDUtil;
import kd.bos.xdb.sharding.config.DataRowsRange;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.tablemanager.AbstractTableManager;
import kd.bos.xdb.tablemanager.LockCreateTableCall;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.xpm.metrics.action.sharding.table.ExistsTableSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.table.LoadShardingTableSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class KSQLTableManager
extends AbstractTableManager {
    @Override
    public boolean existTable(String tableName) throws SQLException {
        ExistsTableSpan span = null;
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            span = new ExistsTableSpan(tableName);
            mc.actionMetric().stat(span);
        }
        String sql = NoShardingHint.genNoShardingSQL("SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME='" + tableName + "'");
        try (XDBManageContext xm = XDB.get().withManageContext();){
            ResultSet rs = XDB.get().query(sql, new Object[0]);
            if (rs.next()) {
                rs.close();
                if (span != null) {
                    span.setExists(true);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public String[] getShardingTable(String tableName) throws SQLException {
        LoadShardingTableSpan span = null;
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            span = new LoadShardingTableSpan(tableName);
            mc.actionMetric().stat(span);
        }
        TableName tn = TableName.of(tableName);
        String p = this.adaptSchemaTableName(tn.getAliasName() + "$") + "%";
        String sql = NoShardingHint.genNoShardingSQL("SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE KSQL_TABNAME like '" + p + "'");
        ArrayList<String> ret = new ArrayList<String>();
        try (XDBManageContext xm = XDB.get().withManageContext();){
            ResultSet rs = XDB.get().query(sql, new Object[0]);
            while (rs.next()) {
                String t = rs.getString(1).toLowerCase();
                if (!TableName.of(t).isDataTable()) continue;
                ret.add(t);
            }
            rs.close();
        }
        if (span != null) {
            span.setShardingTables(ret);
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String[] getShardingTable(String dbRoute, String tableName) throws SQLException {
        LoadShardingTableSpan span = null;
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            span = new LoadShardingTableSpan(tableName);
            mc.actionMetric().stat(span);
        }
        TableName tn = TableName.of(tableName);
        String p = this.adaptSchemaTableName(tn.getAliasName() + "$") + "%";
        String sql = NoShardingHint.genNoShardingSQL("SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE KSQL_TABNAME like '" + p + "'");
        ArrayList<String> ret = new ArrayList<String>();
        try (XDBManageContext xm = XDB.get().withManageContext();
             XDBExternal xdbe = XDBExternal.requiresNew("getShardingTable");){
            xdbe.query(dbRoute, sql, null, rs -> {
                try {
                    while (rs.next()) {
                        String t = rs.getString(1);
                        if (!TableName.of(t).isDataTable()) continue;
                        ret.add(t);
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        if (span != null) {
            span.setShardingTables(ret);
        }
        return ret.toArray(new String[ret.size()]);
    }

    private String adaptSchemaTableName(String table) {
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        switch (dbType) {
            case dm: 
            case oracle: 
            case yasdb: 
            case oceanbase_oracle: 
            case hana: {
                return table.toUpperCase();
            }
            case postgresql: 
            case gs: 
            case gs100: 
            case gaussdb: 
            case gauss200: 
            case gbase: 
            case kingbase: 
            case vastbase: {
                return table.toLowerCase();
            }
        }
        return table;
    }

    @Override
    public String[] getMovingTable(String tableName) throws SQLException {
        TableName tn = TableName.of(tableName);
        String p = this.adaptSchemaTableName(tn.getAliasName() + "$M") + "%";
        String sql = NoShardingHint.genNoShardingSQL("SELECT KSQL_TABNAME FROM KSQL_USERTABLES WHERE KSQL_TABNAME like '" + p + "'");
        ArrayList<String> ret = new ArrayList<String>();
        try (XDBManageContext xm = XDB.get().withManageContext();){
            ResultSet rs = XDB.get().query(sql, new Object[0]);
            while (rs.next()) {
                String t = rs.getString(1).toLowerCase();
                if (!TableName.of(t).isMovingTable()) continue;
                ret.add(t);
            }
            rs.close();
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String createRTTable(String tableName) throws SQLException {
        String rtTable = TableName.of(tableName).getRTTable();
        LockCreateTableCall.lockAndCall(rtTable, () -> {
            if (!this.existTable(rtTable)) {
                String sql = NoShardingHint.genNoShardingSQL("create table " + rtTable + "(findex bigint primary key, froute varchar(50))");
                try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.createRTTable");){
                    xdbe.execute(sql);
                }
            }
        });
        return rtTable;
    }

    @Override
    public String createMapTable(String tableName) throws SQLException {
        String mapTable = TableName.of(tableName).getMapTable();
        LockCreateTableCall.lockAndCall(mapTable, () -> {
            if (!this.existTable(mapTable)) {
                String sql = NoShardingHint.genNoShardingSQL("create table " + mapTable + "(fkey varchar(255) primary key, findex bigint, fdesc varchar(255))");
                try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.createMapTable");){
                    xdbe.execute(sql);
                    sql = NoShardingHint.genNoShardingSQL("create index ix_" + mapTable + " on " + mapTable + "(fkey, findex)");
                    xdbe.execute(sql);
                }
            }
        });
        return mapTable;
    }

    @Override
    public String createPKTable(String dbRoute, String tableName, PkTypeEnum type, DataRowsRange drr, IndexDefine[] indexDefines) throws SQLException {
        String pkTable = TableName.of(tableName).getPKTable();
        this.createTable(dbRoute, pkTable, type, drr, indexDefines);
        return pkTable;
    }

    @Override
    public String createPKTempTable(String dbRoute, String tableName, PkTypeEnum type, DataRowsRange drr, IndexDefine[] indexDefines) throws SQLException {
        String pkTempTable = TableName.of(tableName).getPKTempTable();
        this.createTable(dbRoute, pkTempTable, type, drr, indexDefines);
        return pkTempTable;
    }

    private void createTable(String dbRoute, String pkTable, PkTypeEnum type, DataRowsRange drr, IndexDefine[] indexDefines) {
        LockCreateTableCall.lockAndCall(pkTable, () -> {
            if (!this.existTable(dbRoute, pkTable)) {
                try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.createPKTable");){
                    DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
                    KSQLTransfer transfer = XDBConfig.get().getKSqlTransfer();
                    StringBuilder sql = new StringBuilder(256).append("create table ").append(pkTable).append("(fpk ").append(type.getValue()).append(", findex bigint");
                    ArrayList<String> otherSQLList = new ArrayList<String>(indexDefines == null ? 1 : indexDefines.length + 1);
                    ArrayList<String> dialectSQLList = new ArrayList<String>();
                    otherSQLList.add("create index ix_" + IDUtil.stringId() + "_pkindex on " + pkTable + "(fpk,findex)");
                    if (indexDefines != null && indexDefines.length > 0) {
                        for (IndexDefine def : indexDefines) {
                            sql.append(", ").append(def.getField()).append(' ');
                            switch (def.getType()) {
                                case DATE: {
                                    sql.append("datetime");
                                    break;
                                }
                                case INTEGER: {
                                    sql.append("int default 0");
                                    break;
                                }
                                case LONG: {
                                    sql.append("bigint default 0");
                                    break;
                                }
                                case STRING: {
                                    sql.append("varchar(255) default ' '");
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException("XDB unsupported index field type: " + (Object)((Object)def.getType()));
                                }
                            }
                            StringBuilder indexSQL = new StringBuilder(64).append("create index ix_").append(IDUtil.stringId()).append('_').append(def.getField()).append(" on ").append(pkTable).append('(').append(def.getField()).append(')');
                            otherSQLList.add(indexSQL.toString());
                        }
                    }
                    sql.append(')');
                    String buf = KSQL.dialect(NoShardingHint.genNoShardingSQL(transfer.trans(sql.toString(), dbType)));
                    sql.setLength(0);
                    sql.append(buf);
                    int p = drr.getPartitions();
                    if (p > 0 && type == PkTypeEnum.pk_long) {
                        switch (dbType) {
                            case dm: 
                            case oracle: 
                            case yasdb: 
                            case oceanbase_oracle: 
                            case hana: {
                                int i;
                                sql.append(" partition by hash(fpk) (");
                                for (i = 1; i <= p; ++i) {
                                    if (i > 1) {
                                        sql.append(',');
                                    }
                                    sql.append("partition p").append(i);
                                }
                                sql.append(')');
                                break;
                            }
                            case mysql: 
                            case tdsql: 
                            case tidb: {
                                sql.append(" partition by hash(fpk) partitions ").append(p);
                                break;
                            }
                            case postgresql: {
                                int i;
                                sql.append(" partition by hash(fpk)");
                                for (i = 0; i < p; ++i) {
                                    dialectSQLList.add("create table " + pkTable + "_p" + i + " partition of " + pkTable + " for values with (modulus " + p + ", remainder " + i + ")");
                                }
                                break;
                            }
                        }
                    }
                    xdbe.execute(dbRoute, sql.toString());
                    for (String otherSQL : otherSQLList) {
                        xdbe.execute(dbRoute, KSQL.dialect(NoShardingHint.genNoShardingSQL(transfer.trans(otherSQL, dbType))));
                    }
                    for (String otherSQL : dialectSQLList) {
                        xdbe.execute(dbRoute, KSQL.dialect(NoShardingHint.genNoShardingSQL(otherSQL)));
                    }
                }
            }
        });
    }

    @Override
    public String createMovingTable(String tableName, long shardingIndex, PkTypeEnum type) throws SQLException {
        String movingTable = TableName.of(tableName).getMovingTable(shardingIndex);
        LockCreateTableCall.lockAndCall(movingTable, () -> {
            if (!this.existTable(movingTable)) {
                String sql = NoShardingHint.genNoShardingSQL("create table " + movingTable + "(fid " + type.getValue() + ")");
                try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.createMovingTable");){
                    xdbe.execute(sql);
                    sql = NoShardingHint.genNoShardingSQL("create index ix_" + movingTable + " on " + movingTable + "(fid)");
                    xdbe.execute(sql);
                }
            }
        });
        return movingTable;
    }
}

