/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager.meta;

import java.util.List;
import java.util.Locale;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.Imeta;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public abstract class MetaAbs
implements Imeta,
XDBLogable {
    protected int parseIntNullAsZero(String s) {
        try {
            return s == null ? 0 : Double.valueOf(s).intValue();
        }
        catch (Throwable e) {
            log.error("kd.bos.xdb.tablemanager.meta.MetaAbs parseIntNullAsZero,param:" + s, e);
            return 0;
        }
    }

    protected long parseLongNullAsZero(String s) {
        try {
            return s == null ? 0L : Double.valueOf(s).longValue();
        }
        catch (Throwable e) {
            log.error("kd.bos.xdb.tablemanager.meta.MetaAbs parseLongNullAsZero,param:" + s, e);
            return 0L;
        }
    }

    @Override
    public List<Column> queryColumns(String table) {
        return this.queryColumns(ExtContext.get().getDBRoute(), table);
    }

    @Override
    public void addColumn(String table, Column column) {
        this.addColumn(ExtContext.get().getDBRoute(), table, column);
    }

    @Override
    public void dropColumn(String table, String column) {
        this.dropColumn(ExtContext.get().getDBRoute(), table, column);
    }

    @Override
    public void dropColumn(String dbRoute, String table, String column) {
        try (XDBExternal xdbe = XDBExternal.requiresNew("dropColumn");){
            String sql = "alter table " + table + " drop column " + column;
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public PkInfo queryPkInfo(String table) {
        return this.queryPkInfo(ExtContext.get().getDBRoute(), table);
    }

    @Override
    public List<IndexInfo> queryIndexInfos(String likeTable) {
        return this.queryIndexInfos(ExtContext.get().getDBRoute(), likeTable);
    }

    @Override
    public List<CreateIndexSqlInfo> createIndexSql(String table, String likeTable, PkInfo pkInfo) {
        return this.createIndexSql(ExtContext.get().getDBRoute(), table, likeTable, pkInfo);
    }

    @Override
    public void dropIndex(String table, String index) {
        this.dropIndex(ExtContext.get().getDBRoute(), table, index);
    }

    @Override
    public void dropPkIndex(String table, String index) {
        this.dropPkIndex(ExtContext.get().getDBRoute(), table, index);
    }

    @Override
    public void addIndex(String table, IndexInfo index) {
        this.addIndex(ExtContext.get().getDBRoute(), table, index);
    }

    @Override
    public void renameTable(String fromTable, String toTable) {
        this.renameTable(ExtContext.get().getDBRoute(), fromTable, toTable);
    }

    @Override
    public void renameTable(String dbRoute, String fromTable, String toTable) {
        try (XDBExternal xdbe = XDBExternal.requiresNew("renameTable");){
            StringBuilder renameSql = new StringBuilder();
            renameSql.append("exec p_ModifyObjectName '', '").append(fromTable.toUpperCase(Locale.ENGLISH)).append("', '").append(toTable.toUpperCase(Locale.ENGLISH)).append("', 'OBJECT',''");
            String sql = NoShardingHint.genNoShardingSQL(renameSql.toString());
            xdbe.execute(dbRoute, sql);
        }
    }
}

