/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.temptable.manager;

import java.util.concurrent.atomic.AtomicReference;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.temptable.manager.TemptableService;

public final class TemptableManager {
    private static final Log log = LogFactory.getLog(TemptableManager.class);
    private static final AtomicReference<TemptableService> registerServiceReference = new AtomicReference();

    public static void register(TemptableService service) {
        if (service == null) {
            return;
        }
        if (registerServiceReference.compareAndSet(null, service)) {
            log.info("Register Temptable service success, service class = [" + service.getClass().getName() + ']');
        } else {
            log.warn("Register Temptable service fail, service has been registered");
        }
    }

    private static void loadServiceImpl() {
        if (registerServiceReference.get() != null) {
            return;
        }
        try {
            Class.forName("kd.bos.db.pktemptable.manager.impl.StandardTemptableManager");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static TemptableService get() {
        TemptableManager.loadServiceImpl();
        return registerServiceReference.get();
    }
}

