/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.util;

import java.util.Arrays;
import java.util.Comparator;

public class InParamComparator
implements Comparator<Object> {
    private static final InParamComparator instance = new InParamComparator();

    public static InParamComparator getInstance() {
        return instance;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof String && o2 instanceof String) {
            return ((String)o1).compareTo((String)o2);
        }
        if (o1 instanceof Integer) {
            o1 = ((Integer)o1).longValue();
        }
        if (o2 instanceof Integer) {
            o2 = ((Integer)o2).longValue();
        }
        if (o1 instanceof Long && o2 instanceof Long) {
            return ((Long)o1).compareTo((Long)o2);
        }
        return 0;
    }

    public static boolean isAllowSort(Object[] array) {
        if (array == null || array.length == 0) {
            return false;
        }
        Object first = array[0];
        if (first == null) {
            return false;
        }
        if (first.getClass().equals(String.class)) {
            return InParamComparator.checkArrayItemClass(array, new Class[]{String.class});
        }
        if (first.getClass().equals(Long.class) || first.getClass().equals(Integer.class)) {
            return InParamComparator.checkArrayItemClass(array, new Class[]{Long.class, Integer.class});
        }
        return false;
    }

    public static boolean checkArrayItemClass(Object[] array, Class<?>[] allowClass) {
        for (Object o : array) {
            if (o == null) {
                return false;
            }
            boolean allow = false;
            for (Class<?> aClass : allowClass) {
                if (!o.getClass().equals(aClass)) continue;
                allow = true;
                break;
            }
            if (allow) continue;
            return false;
        }
        return true;
    }

    public static void trySort(Object[] array) {
        try {
            if (InParamComparator.isAllowSort(array)) {
                Arrays.sort(array, InParamComparator.getInstance());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

