/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.metrics.action.sharding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.xdb.sharding.ShardingFieldValue;
import kd.bos.xdb.sharding.ShardingGroupTable;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.spare.IndexSpareStrategy;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.TableSuffixNameComparator;
import kd.bos.xdb.xpm.metrics.action.ActionSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.ShardingSpan;

public final class MixShardingSpan
extends ActionSpan
implements ShardingSpan {
    private final ShardingStrategy mainShardingStrategy;
    private final boolean mixShardingEnabled;
    private ShardingGroupTable[] mixed;
    private ShardingGroupTable[] main;
    private ShardingGroupTable[] pk;
    private Map<ShardingStrategy, ShardingGroupTable[]> spareMap;
    private Map<ShardingStrategy, ShardingGroupTable[]> indexMap;

    public MixShardingSpan(ShardingStrategy mainShardingStrategy, boolean mixShardingEnabled) {
        this.mixShardingEnabled = mixShardingEnabled;
        this.mainShardingStrategy = mainShardingStrategy;
    }

    public void setMain(ShardingGroupTable[] main) {
        this.main = main;
    }

    public ShardingGroupTable[] getMixed() {
        return this.mixed;
    }

    public void setMixed(ShardingGroupTable[] mixed) {
        this.mixed = mixed;
    }

    public ShardingGroupTable[] getPK() {
        return this.pk;
    }

    public void setPK(ShardingGroupTable[] pk) {
        this.pk = pk;
    }

    public Map<ShardingStrategy, ShardingGroupTable[]> getSpareMap() {
        if (this.spareMap == null) {
            this.spareMap = new HashMap<ShardingStrategy, ShardingGroupTable[]>();
        }
        return this.spareMap;
    }

    public Map<ShardingStrategy, ShardingGroupTable[]> getIndexMap() {
        if (this.indexMap == null) {
            this.indexMap = new HashMap<ShardingStrategy, ShardingGroupTable[]>();
        }
        return this.indexMap;
    }

    public ShardingGroupTable[] getMain() {
        return this.main;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(256).append(this.getSpanNameSegment());
        sb.append("\n\tenable: ").append(this.mixShardingEnabled);
        if (this.main != null) {
            sb.append("\n\tmain:\n\t\t").append(this.toString(this.main, this.mainShardingStrategy));
        }
        if (this.pk != null) {
            for (ShardingStrategy shardingStrategy : ((AbstractShardingStrategy)this.mainShardingStrategy).getCreateSpareStrategies()) {
                if (!(shardingStrategy instanceof IndexSpareStrategy)) continue;
                sb.append("\n\tpk:\n\t\t").append(this.toString(this.pk, shardingStrategy));
                break;
            }
        }
        if (this.spareMap != null) {
            sb.append("\n\tspare:");
            for (Map.Entry entry : this.spareMap.entrySet()) {
                sb.append("\n\t\t").append(this.toString((ShardingGroupTable[])entry.getValue(), (ShardingStrategy)entry.getKey()));
            }
        }
        if (this.indexMap != null) {
            sb.append("\n\tindex:");
            for (Map.Entry entry : this.indexMap.entrySet()) {
                sb.append("\n\t\t").append(this.toString((ShardingGroupTable[])entry.getValue(), (ShardingStrategy)entry.getKey()));
            }
        }
        return sb.toString();
    }

    private String toString(ShardingGroupTable[] sgs, ShardingStrategy ss) {
        if (sgs.length == 0) {
            return "[]";
        }
        HashMap<String, Set> map = new HashMap<String, Set>();
        for (ShardingGroupTable sg : sgs) {
            TableName tn = TableName.of(sg.getShardingTable());
            HashSet<String> shardingFields = new HashSet<String>(Arrays.asList(ss.getConfig().getShardingFields()));
            ArrayList<ShardingFieldValue> fieldValues = new ArrayList<ShardingFieldValue>();
            for (ShardingFieldValue sfv : sg.getFieldValues()) {
                if (!shardingFields.contains(sfv.getField())) continue;
                fieldValues.add(sfv);
            }
            Set set = map.computeIfAbsent(tn.getOriginalName() + '#' + fieldValues, k -> new TreeSet<String>(TableSuffixNameComparator.INSTANCE));
            set.add(tn.getSuffix());
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            sb.append((String)entry.getKey()).append(" $(").append(((Set)entry.getValue()).size()).append(")=").append(entry.getValue());
        }
        return sb.toString();
    }
}

