/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.metrics.action.sharding;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.TableSuffixNameComparator;
import kd.bos.xdb.xpm.metrics.action.ActionSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.ShardingSpan;

public final class ShardingTableSpan
extends ActionSpan
implements ShardingSpan {
    private boolean shardingSubStmt;
    private List<List<String>> shardingGroupTables;

    public ShardingTableSpan(List<List<String>> shardingGroupTables, boolean shardingSubStmt) {
        this.shardingGroupTables = shardingGroupTables;
        this.shardingSubStmt = shardingSubStmt;
    }

    public boolean isShardingSubStmt() {
        return this.shardingSubStmt;
    }

    public int getShardingGroupCount() {
        return this.shardingGroupTables.size();
    }

    public List<List<String>> getShardingGroupTables() {
        return this.shardingGroupTables;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(512).append(this.getSpanNameSegment()).append(' ');
        sb.append("$(").append(this.shardingGroupTables.size()).append(')').append(':');
        HashMap<String, Set> map = new HashMap<String, Set>();
        for (List<String> list : this.shardingGroupTables) {
            for (String table : list) {
                TableName tn = TableName.of(table);
                Set set = map.computeIfAbsent(tn.getOriginalName(), k -> new TreeSet<String>(TableSuffixNameComparator.INSTANCE));
                set.add(tn.getSuffix());
            }
        }
        sb.append(map);
        return sb.toString();
    }
}

