/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.metrics.collector;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.xpm.config.XpmConfig;
import kd.bos.xdb.xpm.exporter.ExporterService;
import kd.bos.xdb.xpm.metrics.Metrics;
import kd.bos.xdb.xpm.metrics.action.ActionMetric;
import kd.bos.xdb.xpm.metrics.collector.StatTimeStamp;
import kd.bos.xdb.xpm.metrics.export.QueryMetrics;
import kd.bos.xdb.xpm.metrics.feature.IgnoredSQLFeature;
import kd.bos.xdb.xpm.metrics.feature.SQLFeature;
import kd.bos.xdb.xpm.metrics.listener.MetricsListenerContext;
import kd.bos.xdb.xpm.metrics.performance.MetricFlagEnum;
import kd.bos.xdb.xpm.metrics.performance.PerformanceMetric;

public final class MetricsCollector
implements AutoCloseable {
    boolean xpmEnabled;
    private long beginTime;
    private AtomicInteger idSeq;
    private final SQLFeature sqlFeature;
    private List<String> allSQL;
    private ActionMetric actionMetric;
    private PerformanceMetric performanceMetric;
    private final MetricsCollector parent;
    private static ThreadLocal<LinkedList<MetricsCollector>> thAll = ThreadLocals.create();
    private static ThreadLocal<MetricsCollector> thCur = ThreadLocals.create();

    private MetricsCollector(MetricsCollector parent) {
        this.parent = parent;
        if (XDBConfig.isXDBEnabled()) {
            int level;
            String traceId;
            int parentId;
            if (parent == null) {
                parentId = -1;
                this.idSeq = new AtomicInteger();
                traceId = TraceIdUtil.getCurrentTraceIdString();
                if (traceId == null || traceId.isEmpty()) {
                    traceId = TraceIdUtil.createTraceIdString();
                    TraceIdUtil.setCurrentTraceId((String)traceId);
                }
                this.xpmEnabled = XpmConfig.isEnabled();
                if (this.xpmEnabled) {
                    this.allSQL = new LinkedList<String>();
                }
                level = 0;
            } else {
                parentId = parent.sqlFeature.getId();
                this.idSeq = parent.idSeq;
                if (this.idSeq == null) {
                    this.idSeq = new AtomicInteger();
                }
                this.allSQL = parent.allSQL;
                traceId = parent.sqlFeature.getTraceId();
                this.xpmEnabled = parent.xpmEnabled;
                level = parent.sqlFeature.getLevel() + 1;
            }
            this.beginTime = System.currentTimeMillis();
            this.sqlFeature = new SQLFeature(this.idSeq.getAndIncrement(), parentId, traceId, level){

                @Override
                public void setWithActionMetricHint(boolean withActionMetricHint) {
                    super.setWithActionMetricHint(withActionMetricHint);
                    if (withActionMetricHint && MetricsCollector.this.actionMetric == null) {
                        MetricsCollector.this.actionMetric = new ActionMetric();
                        MetricsCollector.this.ensureCreateAllSQL();
                    }
                }

                @Override
                public void setWithPerformanceMetricHint(boolean withPerformanceMetricHint) {
                    super.setWithPerformanceMetricHint(withPerformanceMetricHint);
                    if (withPerformanceMetricHint && MetricsCollector.this.performanceMetric == null) {
                        MetricsCollector.this.performanceMetric = new PerformanceMetric();
                    }
                }
            };
            if (this.xpmEnabled || parent != null && parent.actionMetric != null) {
                this.actionMetric = new ActionMetric();
                this.ensureCreateAllSQL();
            }
            if (this.xpmEnabled || parent != null && parent.performanceMetric != null) {
                this.performanceMetric = new PerformanceMetric();
            }
        } else {
            this.sqlFeature = IgnoredSQLFeature.INSTANCE;
        }
    }

    private void ensureCreateAllSQL() {
        if (this.allSQL == null && this.sqlFeature.getParentId() == -1) {
            this.allSQL = new LinkedList<String>();
        }
    }

    public StatTimeStamp collectExecuteSpent() {
        if (this.isPerformanceMetricEnabled()) {
            long ts = System.currentTimeMillis();
            return () -> this.performanceMetric.setExecuteSpent(this.performanceMetric.getExecuteSpent() + System.currentTimeMillis() - ts);
        }
        return StatTimeStamp.empty;
    }

    public StatTimeStamp collectExecuteSpentSync() {
        if (this.isPerformanceMetricEnabled()) {
            long ts = System.currentTimeMillis();
            return () -> {
                PerformanceMetric performanceMetric = this.performanceMetric;
                synchronized (performanceMetric) {
                    this.performanceMetric.setExecuteSpent(this.performanceMetric.getExecuteSpent() + System.currentTimeMillis() - ts);
                }
            };
        }
        return StatTimeStamp.empty;
    }

    public boolean isActionMetricEnabled() {
        return this.actionMetric != null;
    }

    public boolean isPerformanceMetricEnabled() {
        return this.performanceMetric != null;
    }

    public SQLFeature sqlFeature() {
        return this.sqlFeature;
    }

    public ActionMetric actionMetric() {
        return this.actionMetric;
    }

    public PerformanceMetric performanceMetric() {
        return this.performanceMetric;
    }

    public List<String> getAllSQL() {
        return this.allSQL == null ? Collections.emptyList() : Collections.unmodifiableList(this.allSQL);
    }

    public void collectSQL(String sql) {
        if (this.allSQL != null) {
            StringBuilder sb = new StringBuilder(sql.length() + 20);
            int level = this.sqlFeature.getLevel();
            for (int i = 0; i < level; ++i) {
                sb.append('\t');
            }
            String indent = sb.toString();
            sb.append('#').append(this.sqlFeature.getId()).append('/').append(this.sqlFeature.getParentId());
            sb.append('\n').append(indent).append(sql.replaceAll("\n", "\n" + indent));
            this.allSQL.add(sb.toString());
        }
    }

    public Metrics exportMetrics() {
        return new QueryMetrics(this.sqlFeature, this.performanceMetric);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2048);
        sb.append(this.sqlFeature);
        if (this.performanceMetric != null) {
            sb.append("\n").append(this.performanceMetric);
        }
        if (this.actionMetric != null) {
            sb.append("\n").append(this.actionMetric);
        }
        return sb.toString();
    }

    public MetricsCollector subCollector() {
        MetricsCollector mc = new MetricsCollector(this);
        if (!XpmConfig.isIgnoreCollectorAll() || this.xpmEnabled || XpmConfig.isEnabled() || this.isActionMetricEnabled() || this.isPerformanceMetricEnabled()) {
            thAll.get().add(mc);
        }
        thCur.set(mc);
        return mc;
    }

    @Override
    public void close() {
        thCur.set(this.parent);
        LinkedList<MetricsCollector> list = thAll.get();
        if (list.getFirst() != this) {
            return;
        }
        thAll.remove();
        thCur.remove();
        if (this.xpmEnabled || XpmConfig.isEnabled() || !list.isEmpty() && (list.getFirst().isActionMetricEnabled() || list.getFirst().isPerformanceMetricEnabled())) {
            long now = System.currentTimeMillis();
            for (MetricsCollector mc : list) {
                if (mc.isPerformanceMetricEnabled()) {
                    mc.performanceMetric.setTotalSpent(now - mc.beginTime);
                }
                if (!mc.sqlFeature().isSharding()) continue;
                if (mc.isActionMetricEnabled()) {
                    ExporterService.exportMetrics(mc.sqlFeature);
                }
                if (mc.isPerformanceMetricEnabled()) {
                    if (mc.performanceMetric.getTotalSpent() > (long)XpmConfig.getAlarmTotalSpent()) {
                        mc.performanceMetric.logCallStack("TotalSpent over limit (" + mc.performanceMetric.getTotalSpent() + ">" + XpmConfig.getAlarmTotalSpent() + "ms)");
                        mc.performanceMetric.setMetricFlag(MetricFlagEnum.totalSpentOverLimit);
                    }
                    ExporterService.exportMetrics(mc.exportMetrics());
                }
                if (!mc.isActionMetricEnabled()) continue;
                ExporterService.exportMetrics(mc.actionMetric);
            }
            MetricsListenerContext ctx = MetricsListenerContext.get();
            if (ctx != null || MetricsListenerContext.getGlobalMetricsListener() != null) {
                MetricsCollector[] mcs = list.toArray(new MetricsCollector[list.size()]);
                if (ctx != null) {
                    ctx.getMetricsListener().onExecuted(mcs[0].getAllSQL(), mcs);
                }
                if (MetricsListenerContext.getGlobalMetricsListener() != null) {
                    MetricsListenerContext.getGlobalMetricsListener().onExecuted(mcs[0].getAllSQL(), mcs);
                }
            }
        }
    }

    public static MetricsCollector createCollector() {
        MetricsCollector parent = thCur.get();
        if (parent == null) {
            return MetricsCollector.getCurrent();
        }
        MetricsCollector mc = new MetricsCollector(parent);
        LinkedList<MetricsCollector> list = thAll.get();
        if (!XpmConfig.isIgnoreCollectorAll() || XpmConfig.isEnabled() || !list.isEmpty() && (list.getFirst().isActionMetricEnabled() || list.getFirst().isPerformanceMetricEnabled())) {
            thAll.get().add(mc);
        }
        thCur.set(mc);
        return mc;
    }

    public static MetricsCollector getCurrent() {
        MetricsCollector mc = thCur.get();
        if (mc == null) {
            mc = new MetricsCollector(null);
            thCur.set(mc);
            LinkedList<MetricsCollector> list = new LinkedList<MetricsCollector>();
            list.add(mc);
            thAll.set(list);
        }
        return mc;
    }

    public static void setCurrent(MetricsCollector cur) {
        thCur.set(cur);
    }
}

