/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.metrics.export;

import kd.bos.xdb.xpm.metrics.Metrics;
import kd.bos.xdb.xpm.metrics.export.QueryMetrics;
import kd.bos.xdb.xpm.metrics.feature.SQLFeature;
import kd.bos.xdb.xpm.metrics.performance.PerformanceMetric;

public class QueryStatMetrics
implements Metrics {
    private int merged;
    private final String name;
    private int sharding;
    private long totalSpent;
    private long parseSpent;
    private long shardingSpent;
    private long executeSpent;
    private int shardingSQLCount;
    private int parallelQuery;
    private int hintCondition;
    private int pkCondition;
    private int indexCondition;
    private int fullShardingCondition;
    private int partShardingCondition;
    private int noneShardingCondition;
    private int updateShardingField;
    private int executeError;

    public QueryStatMetrics() {
        this("QuerySummary");
    }

    public QueryStatMetrics(String name) {
        this.name = name;
    }

    @Override
    public boolean merge(Metrics metrics) {
        if (metrics instanceof QueryMetrics) {
            ++this.merged;
            this.doMerge((QueryMetrics)metrics);
            return true;
        }
        return false;
    }

    private void doMerge(QueryMetrics m) {
        SQLFeature sf = m.getSQLFeature();
        PerformanceMetric pm = m.getPerformanceMetric();
        if (sf.isSharding()) {
            ++this.sharding;
        }
        this.totalSpent += pm.getTotalSpent();
        this.parseSpent += pm.getParseSpent();
        this.shardingSpent += pm.getShardingSpent();
        this.executeSpent += pm.getExecuteSpent();
        this.shardingSQLCount += pm.getShardingSQLCount();
        this.parallelQuery += pm.getParallelQuery();
        if (pm.isExecuteError()) {
            ++this.executeError;
        }
        if (sf.isSharding()) {
            if (pm.isUseHint()) {
                ++this.hintCondition;
            }
            if (pm.isUsePK()) {
                ++this.pkCondition;
            } else if (pm.isUseIndex()) {
                ++this.indexCondition;
            } else if (pm.isFullShardingCondition()) {
                ++this.fullShardingCondition;
            } else if (pm.isPartShardingCondition()) {
                ++this.partShardingCondition;
            } else {
                ++this.noneShardingCondition;
            }
            if (pm.isUpdateShardingField()) {
                ++this.updateShardingField;
            }
        }
    }

    public int getMerged() {
        return this.merged;
    }

    public QueryStatMetrics calcAvgMetrics() {
        QueryStatMetrics m = new QueryStatMetrics("QueryAvg");
        m.merged = 0;
        m.sharding = this.sharding / this.merged;
        m.totalSpent = this.totalSpent / (long)this.merged;
        m.parseSpent = this.parseSpent / (long)this.merged;
        m.shardingSpent = this.shardingSpent / (long)this.merged;
        m.executeSpent = this.executeSpent / (long)this.merged;
        m.shardingSQLCount = this.shardingSQLCount / this.merged;
        m.parallelQuery = this.parallelQuery / this.merged;
        m.hintCondition = this.hintCondition / this.merged;
        m.pkCondition = this.pkCondition / this.merged;
        m.indexCondition = this.indexCondition / this.merged;
        m.fullShardingCondition = this.fullShardingCondition / this.merged;
        m.partShardingCondition = this.partShardingCondition / this.merged;
        m.noneShardingCondition = this.noneShardingCondition / this.merged;
        m.updateShardingField = this.updateShardingField / this.merged;
        m.executeError = this.executeError / this.merged;
        return m;
    }

    public String toString() {
        return "QueryStatMetrics{name=" + this.name + ", merged=" + this.merged + ", sharding=" + this.sharding + ", totalSpent=" + this.totalSpent + ", parseSpent=" + this.parseSpent + ", shardingSpent=" + this.shardingSpent + ", executeSpent=" + this.executeSpent + ", hintCondition=" + this.hintCondition + ", pkCondition=" + this.pkCondition + ", indexCondition=" + this.indexCondition + ", fullShardingCondition=" + this.fullShardingCondition + ", partShardingCondition=" + this.partShardingCondition + ", noneShardingCondition=" + this.noneShardingCondition + ", shardingSQLCount=" + this.shardingSQLCount + ", parallelQuery=" + this.parallelQuery + ", updateShardingField=" + this.updateShardingField + ", executeError=" + this.executeError + '}';
    }
}

