/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm;

import java.util.HashSet;
import java.util.Set;
import kd.bos.lang.Lang;
import kd.bos.orm.query.cache.CacheQueryObjects;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class ORMHint {
    private static final String INNER_JOIN_TABLES = "orm.inner_join_tables";
    private static Set<String> innerJoinTables = new HashSet<String>();
    private JoinHinter joinHinter;
    private String queryOrders;
    private boolean selectNullIfNotExistsProperty;
    private boolean queryAlone = false;
    private Lang lang = Lang.get();
    private Integer cacheSize;
    private boolean isConvertField = true;
    private CacheQueryObjects cacheQueryObjects;
    private boolean NotEqualTransEnable;
    private boolean NotInTransEnable;
    private boolean NotLikeTransEnable;
    private boolean NotNullTransEnable;
    private Boolean ormOptOnCost;
    private boolean loadMultiLang;
    private Boolean optMainExtJoin;
    private Boolean useInnerJoinOpt;
    private Integer toTempTableSize;

    @SdkInternal
    public static boolean isInnerJoinConfigured(String tableName) {
        return tableName == null ? false : innerJoinTables.contains(tableName.toLowerCase());
    }

    public JoinHinter getJoinHinter() {
        return this.joinHinter;
    }

    public void setJoinHinter(JoinHinter joinHinter) {
        this.joinHinter = joinHinter;
    }

    public JoinHint joinHint(String entityPath) {
        return this.joinHint(entityPath, JoinHint.LEFT);
    }

    public JoinHint joinHint(String entityPath, JoinHint replaceDefaultHint) {
        JoinHint hint = null;
        if (this.joinHinter != null) {
            hint = this.joinHinter.hint(entityPath);
        }
        if (hint == null || hint == JoinHint.DEFAULT) {
            return replaceDefaultHint == null ? JoinHint.LEFT : replaceDefaultHint;
        }
        return hint;
    }

    @SdkInternal
    public String getQueryOrders() {
        return this.queryOrders;
    }

    @SdkInternal
    public void setQueryOrders(String queryOrders) {
        this.queryOrders = queryOrders;
    }

    @SdkInternal
    public boolean isSelectNullIfNotExistsProperty() {
        return this.selectNullIfNotExistsProperty;
    }

    @SdkInternal
    public void setSelectNullIfNotExistsProperty(boolean b) {
        this.selectNullIfNotExistsProperty = b;
    }

    @SdkInternal
    public boolean isQueryAlone() {
        return this.queryAlone;
    }

    @SdkInternal
    public void setQueryAlone(boolean queryAlone) {
        this.queryAlone = queryAlone;
    }

    public Lang getLang() {
        return this.lang;
    }

    public void setLang(Lang lang) {
        this.lang = lang;
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        this.cacheSize = cacheSize;
    }

    @SdkInternal
    public void setCacheQueryObjects(String cacheQueryObjects) {
        this.cacheQueryObjects = new CacheQueryObjects(cacheQueryObjects);
    }

    @SdkInternal
    public CacheQueryObjects getCacheQueryObjects() {
        return this.cacheQueryObjects == null ? CacheQueryObjects.EMPTY : this.cacheQueryObjects;
    }

    @SdkInternal
    public boolean isConvertField() {
        return this.isConvertField;
    }

    @SdkInternal
    public void $setConvertField(boolean isConvertField) {
        this.isConvertField = isConvertField;
    }

    public boolean isNotEqualTransEnable() {
        return this.NotEqualTransEnable;
    }

    public void setNotEqualTransEnable(boolean notEqualTransEnable) {
        this.NotEqualTransEnable = notEqualTransEnable;
    }

    public boolean isNotInTransEnable() {
        return this.NotInTransEnable;
    }

    public void setNotInTransEnable(boolean notInTransEnable) {
        this.NotInTransEnable = notInTransEnable;
    }

    public boolean isNotLikeTransEnable() {
        return this.NotLikeTransEnable;
    }

    public void setNotLikeTransEnable(boolean notLikeTransEnable) {
        this.NotLikeTransEnable = notLikeTransEnable;
    }

    public boolean isNotNullTransEnable() {
        return this.NotNullTransEnable;
    }

    public void setNotNullTransEnable(boolean notNullTransEnable) {
        this.NotNullTransEnable = notNullTransEnable;
    }

    public Boolean isOrmOptOnCost() {
        return this.ormOptOnCost;
    }

    public void setOrmOptOnCost(Boolean ormOptOnCost) {
        this.ormOptOnCost = ormOptOnCost;
    }

    public boolean isLoadMultiLang() {
        return this.loadMultiLang;
    }

    public void setLoadMultiLang(boolean loadMultiLang) {
        this.loadMultiLang = loadMultiLang;
    }

    public Boolean isOptMainExtJoin() {
        return this.optMainExtJoin;
    }

    public void setOptMainExtJoin(Boolean optMainExtJoin) {
        this.optMainExtJoin = optMainExtJoin;
    }

    public Boolean isUseInnerJoinOpt() {
        return this.useInnerJoinOpt;
    }

    public void setUseInnerJoinOpt(Boolean useInnerJoinOpt) {
        this.useInnerJoinOpt = useInnerJoinOpt;
    }

    public void setToTempTableSize(Integer toTempTableSize) {
        this.toTempTableSize = toTempTableSize;
    }

    public Integer getToTempTableSize() {
        return this.toTempTableSize;
    }

    static {
        ConfigurationUtil.observeString((String)INNER_JOIN_TABLES, (String)"", v -> {
            HashSet<String> set = new HashSet<String>();
            if (v.length() > 0) {
                String[] tables;
                for (String table : tables = v.split(",")) {
                    if ((table = table.trim().toLowerCase()).length() <= 0) continue;
                    set.add(table);
                }
            }
            innerJoinTables = set;
        });
    }

    @FunctionalInterface
    @SdkPublic
    public static interface JoinHinter {
        public JoinHint hint(String var1);
    }

    @SdkPublic
    public static enum JoinHint {
        DEFAULT("LEFT JOIN"),
        LEFT("LEFT JOIN"),
        INNER("INNER JOIN");

        private String join;

        private JoinHint(String join) {
            this.join = join;
        }

        @SdkInternal
        public String getJoin() {
            return this.join;
        }
    }
}

