/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.List;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.dataentity.BatchInsertTask;

public class BatchInsertShardingTask
extends BatchInsertTask {
    private String shardingTableName;

    public BatchInsertShardingTask(DBRoute dbRoute, String tableName, String shardingTableName, DbMetadataColumn[] columns, int level, List<Object[]> rows, List<IColumnValuePair> oids) {
        super(dbRoute, tableName, columns, level, rows, oids);
        this.shardingTableName = shardingTableName;
    }

    @Override
    protected String getInsertTableName() {
        return this.shardingTableName;
    }

    @Override
    protected void doBatchExecute(String sql, List<Object[]> psList) {
        sql = "/*XDB:NO_SHARDING*/" + sql;
        DB.executeBatch((DBRoute)this.dbRoute, (String)sql, psList);
    }
}

