/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.db.SqlParameter;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.dataentity.IDatabaseTask;
import kd.bos.xdb.hint.ShardingHintContext;

public class BatchUpdateSeqTask
implements IDatabaseTask {
    private DBRoute dbRoute;
    private DbMetadataTable table;
    private ShardingHintContext ctx;
    private List<ThreeTuple<Object, Object, Integer>> changeRows;

    public BatchUpdateSeqTask(DBRoute dbRoute, DbMetadataTable table, List<ThreeTuple<Object, Object, Integer>> changeRows) {
        this.dbRoute = dbRoute;
        this.table = table;
        this.changeRows = changeRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() {
        DbMetadataColumn pcol = this.table.getParentRelation().getChildColumn();
        DbMetadataColumn seqCol = this.table.getSeq();
        boolean safeSeqCol = false;
        boolean safePcol = false;
        List fieldInfos = DB.getFieldInfo((DBRoute)this.dbRoute, (String)this.table.getName());
        for (FieldInfo fieldInfo : fieldInfos) {
            if (StringUtils.equalsIgnoreCase((CharSequence)fieldInfo.getFieldName(), (CharSequence)seqCol.getName())) {
                safeSeqCol = true;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldInfo.getFieldName(), (CharSequence)pcol.getName())) {
                safePcol = true;
            }
            if (!safePcol || !safeSeqCol) continue;
            break;
        }
        String sql = "UPDATE " + this.table.getName() + " SET " + seqCol.getName() + "=" + seqCol.getName() + "+? WHERE " + pcol.getName() + "=? AND " + seqCol.getName() + ">?";
        if (safePcol && safeSeqCol) {
            ArrayList<SqlParameter[]> listParas = new ArrayList<SqlParameter[]>(this.changeRows.size());
            for (ThreeTuple<Object, Object, Integer> row : this.changeRows) {
                SqlParameter[] parameters = new SqlParameter[]{new SqlParameter(seqCol.getName(), seqCol.getDbType(), row.item3), new SqlParameter(pcol.getName(), pcol.getDbType(), row.item1), new SqlParameter(seqCol.getName() + 1, seqCol.getDbType(), row.item2)};
                listParas.add(parameters);
            }
            if (this.ctx != null) {
                this.ctx.set();
                try {
                    DB.executeBatch((DBRoute)this.dbRoute, (String)("/*ORM*/ " + sql), listParas);
                }
                finally {
                    this.ctx.close();
                }
            } else {
                DB.executeBatch((DBRoute)this.dbRoute, (String)("/*ORM*/ " + sql), listParas);
            }
        } else {
            throw new RuntimeException((Throwable)new KDException(BosErrorCode.sQL, new Object[]{sql}));
        }
        return 0;
    }

    @Override
    public int getLevel() {
        return -1;
    }

    public void setShardingHintContext(ShardingHintContext ctx) {
        this.ctx = ctx;
    }
}

