/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.IFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataRelation;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.encrypt.Encrypters;
import kd.bos.orm.dataentity.DeleteSqlTask;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.dataentity.SqlTask;
import kd.bos.orm.dataentity.TableColumnConverterContainer;
import kd.bos.orm.datamanager.SimpleColumnValuePair;
import kd.bos.xdb.hint.ShardingHintContext;

public final class CRUDHelper {
    private static final String WHERE = " WHERE ";
    private static Map<Integer, String> inParameterMap = new ConcurrentHashMap<Integer, String>();

    private CRUDHelper() {
    }

    protected static SqlTask createSqlTask(DBRoute dbRoute, int level) {
        return new SqlTask(dbRoute, level);
    }

    protected static DeleteSqlTask createDeleteSqlTask(DBRoute dbRoute, int level) {
        return new DeleteSqlTask(dbRoute, level);
    }

    public static final Collection<SqlTask> insert(DBRoute dbRoute, DbMetadataTable table, IColumnValuePair[] inputValues, IColumnValuePair[] outputValues, IColumnValuePair oid) {
        String tableGroup;
        DbMetadataColumn colum;
        int tableLevel = CRUDHelper.getTableLevel(table);
        SqlTask headSqlBuilderTupe = null;
        HashMap<String, SqlTask> dictGroupSql = new HashMap<String, SqlTask>();
        TableColumnConverterContainer columnConverter = CRUDHelper.getTableConverter(table);
        if (table.getVersionColumn() != null) {
            inputValues = CRUDHelper.TryAddColumnValuePair(inputValues, new SimpleColumnValuePair(table.getVersionColumn(), 0));
        }
        IColumnValuePair exTableParentColumnValuePair = null;
        if (CRUDHelper.getExTableHaveRelitionField() && table.getParentRelation() != null) {
            DbMetadataColumn exTableParentColumn = table.getParentRelation().getChildColumn();
            for (IColumnValuePair pair : inputValues) {
                if (pair.getColumn().getColumnIndex() != exTableParentColumn.getColumnIndex()) continue;
                exTableParentColumnValuePair = pair;
                break;
            }
        }
        for (DbMetadataColumn dbMetadataColumn : table.getColumns()) {
            String tableGroup2 = dbMetadataColumn.getTableGroup();
            if (tableGroup2 == null) {
                tableGroup2 = "";
            }
            if (tableGroup2.length() == 0 && headSqlBuilderTupe != null || dictGroupSql.containsKey(tableGroup2)) continue;
            String tableName = CRUDHelper.getTableNameWithGroup(table.getName(), tableGroup2);
            SqlTask sqlTask = CRUDHelper.createSqlTask(dbRoute, tableLevel);
            StringBuilder sqlBuilder = sqlTask.getSqlBuilder();
            sqlBuilder.append(" INSERT INTO  ");
            sqlBuilder.append(tableName);
            sqlBuilder.append('(');
            if (tableGroup2.length() == 0) {
                headSqlBuilderTupe = sqlTask;
            } else {
                sqlBuilder.append(table.getPrimaryKey().getName());
                sqlBuilder.append(',');
                if (exTableParentColumnValuePair != null) {
                    sqlBuilder.append(exTableParentColumnValuePair.getColumn().getName());
                    sqlBuilder.append(',');
                }
            }
            dictGroupSql.put(tableGroup2, sqlTask);
        }
        for (IColumnValuePair tuple : inputValues) {
            colum = tuple.getColumn();
            tableGroup = colum.getTableGroup() != null ? colum.getTableGroup() : "";
            StringBuilder sqlBuilder = CRUDHelper.getSqlBuilder(dictGroupSql, tableGroup, headSqlBuilderTupe).getSqlBuilder();
            sqlBuilder.append(colum.getName());
            sqlBuilder.append(',');
        }
        for (Map.Entry entry : dictGroupSql.entrySet()) {
            StringBuilder sql = ((SqlTask)entry.getValue()).getSqlBuilder();
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") VALUES (");
            if (((String)entry.getKey()).length() <= 0) continue;
            ((SqlTask)entry.getValue()).addParamter(table.getPrimaryKey().getName(), table.getPrimaryKey().getDbType(), oid.getValue());
            sql.append('?');
            sql.append(',');
            if (exTableParentColumnValuePair == null) continue;
            DbMetadataColumn column = exTableParentColumnValuePair.getColumn();
            ((SqlTask)entry.getValue()).addParamter(column.getName(), column.getDbType(), exTableParentColumnValuePair.getValue());
            sql.append('?');
            sql.append(',');
        }
        for (IColumnValuePair tuple : inputValues) {
            colum = tuple.getColumn();
            tableGroup = colum.getTableGroup() != null ? colum.getTableGroup() : "";
            Object value = columnConverter.getColumnDbValue(tuple);
            SqlTask sqlBuilderTupe = CRUDHelper.getSqlBuilder(dictGroupSql, tableGroup, headSqlBuilderTupe);
            sqlBuilderTupe.addParamter(colum.getName(), colum.getDbType(), value);
            sqlBuilderTupe.getSqlBuilder().append('?').append(',');
        }
        for (Map.Entry entry : dictGroupSql.entrySet()) {
            StringBuilder sql = ((SqlTask)entry.getValue()).getSqlBuilder();
            sql.deleteCharAt(sql.length() - 1);
            sql.append(')');
        }
        return dictGroupSql.values();
    }

    public static boolean getExTableHaveRelitionField() {
        return true;
    }

    public static final Collection<SqlTask> update(DBRoute dbRoute, DbMetadataTable table, IColumnValuePair[] inputValues, IColumnValuePair oid, IColumnValuePair originalVersion) {
        SqlTask headSqlBuilderTupe = null;
        HashMap<String, SqlTask> dictGroupSql = new HashMap<String, SqlTask>();
        TableColumnConverterContainer columnConverter = CRUDHelper.getTableConverter(table);
        DbMetadataColumn versionColumn = table.getVersionColumn();
        int originalVersionValue = 0;
        if (versionColumn != null) {
            assert (originalVersion != null);
            originalVersionValue = (Integer)columnConverter.getColumnDbValue(originalVersion);
            originalVersion.setValue((Object)(originalVersionValue + 1));
            inputValues = CRUDHelper.TryAddColumnValuePair(inputValues, originalVersion);
        }
        int tableLevel = CRUDHelper.getTableLevel(table);
        for (IColumnValuePair tuple : inputValues) {
            String tableGroup;
            String string = tableGroup = tuple.getColumn().getTableGroup() != null ? tuple.getColumn().getTableGroup() : "";
            if (headSqlBuilderTupe != null && tableGroup.length() == 0 || dictGroupSql.containsKey(tableGroup)) continue;
            String tableName = CRUDHelper.getTableNameWithGroup(table.getName(), tableGroup);
            SqlTask sqlTask = CRUDHelper.createSqlTask(dbRoute, tableLevel);
            StringBuilder sb = sqlTask.getSqlBuilder();
            sb.append(" UPDATE ");
            sb.append(tableName);
            sb.append(" SET ");
            if (tableGroup.length() == 0) {
                headSqlBuilderTupe = sqlTask;
            }
            dictGroupSql.put(tableGroup, sqlTask);
        }
        for (IColumnValuePair tuple : inputValues) {
            DbMetadataColumn colum = tuple.getColumn();
            String tableGroup = colum.getTableGroup() != null ? colum.getTableGroup() : "";
            Object value = columnConverter.getColumnDbValue(tuple);
            SqlTask sqlTask = CRUDHelper.getSqlBuilder(dictGroupSql, tableGroup, headSqlBuilderTupe);
            sqlTask.addParamter(colum.getName(), colum.getDbType(), value);
            StringBuilder sb = sqlTask.getSqlBuilder();
            sb.append(colum.getName());
            sb.append('=');
            sb.append('?');
            sb.append(',');
        }
        for (Map.Entry entry : dictGroupSql.entrySet()) {
            StringBuilder sql = ((SqlTask)entry.getValue()).getSqlBuilder();
            sql.deleteCharAt(sql.length() - 1);
            ((SqlTask)entry.getValue()).addParamter("OID", table.getPrimaryKey().getDbType(), columnConverter.getColumnDbValue(oid));
            sql.append(WHERE).append(table.getPrimaryKey().getName()).append("=?");
            if (versionColumn == null || !StringUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) continue;
            ((SqlTask)entry.getValue()).addParamter("originalVersion", versionColumn.getDbType(), originalVersionValue);
            sql.append(" AND ").append(versionColumn.getName()).append("=?");
        }
        return dictGroupSql.values();
    }

    private static List<SqlParameter> getPKs(Object[] oids, int dbtype) {
        ArrayList<SqlParameter> sps = new ArrayList<SqlParameter>(oids.length);
        if (oids.length > 0) {
            for (int i = 0; i < oids.length; ++i) {
                sps.add(new SqlParameter(dbtype, oids[i] instanceof DynamicObject ? ((DynamicObject)oids[i]).getPkValue() : oids[i]));
            }
        } else {
            sps.add(new SqlParameter(dbtype, dbtype == 12 || dbtype == -9 || dbtype == -15 ? "" : Integer.valueOf(0)));
        }
        return sps;
    }

    private static String getPkTable0(Object[] oids, int dbtype) {
        StringBuilder sql = new StringBuilder();
        if (oids.length > 0) {
            for (int i = 0; i < oids.length; ++i) {
                if (i != 0) {
                    sql.append(',');
                }
                sql.append('\'').append(oids[i] instanceof DynamicObject ? ((DynamicObject)oids[i]).getPkValue() : oids[i]).append('\'');
            }
        } else {
            sql.append("'0'");
        }
        return sql.toString();
    }

    protected static String getPkTable(String stype) {
        String sql = " table(fn_StrSplit(@FID, ','," + stype + ")) ";
        return sql;
    }

    public static final List<SqlTask> delete(DBRoute dbRoute, DbMetadataTable table, Object[] oids, Object[] originalVersions) {
        int tableLevel = CRUDHelper.getTableLevel(table);
        ArrayList<String> tableGroupList = CRUDHelper.getTableGroups(table);
        ArrayList<SqlTask> tasks = new ArrayList<SqlTask>();
        for (String tableGroup : tableGroupList) {
            String tableName = CRUDHelper.getTableNameWithGroup(table.getName(), tableGroup);
            DeleteSqlTask sqlTask = CRUDHelper.createDeleteSqlTask(dbRoute, tableLevel);
            sqlTask.getDeleteSqlBuiler().append("DELETE FROM ", new Object[0]).append(tableName, new Object[0]).append(WHERE, new Object[0]).appendIn(table.getPrimaryKey().getName(), oids);
            tasks.add(sqlTask);
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int delete(DBRoute dbRoute, Iterable<DbMetadataTable> tablesSchema, DbMetadataTable rootTable, Object[] rootOids) {
        ShardingHintContext ctx = ShardingHinter.tryHint(rootTable, rootOids);
        if (ctx != null) {
            ctx.set();
        }
        try {
            List<SqlParameter> pks = CRUDHelper.getPKs(rootOids, rootTable.getPrimaryKey().getDbType());
            Stack<DeleteSqlTask> sqllist = new Stack<DeleteSqlTask>();
            for (DbMetadataTable table : tablesSchema) {
                for (String tableGroup : CRUDHelper.getTableGroups(table)) {
                    DeleteSqlTask sqlTask = CRUDHelper.createDeleteSqlTask(dbRoute, 0);
                    CRUDHelper.getDeleteSql(rootTable, table, tableGroup, pks, sqlTask);
                    sqllist.push(sqlTask);
                }
            }
            int c = 0;
            while (!sqllist.isEmpty()) {
                c += CRUDHelper.executeSqlStask((SqlTask)sqllist.pop());
            }
            int n = c;
            return n;
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }

    private static void getDeleteSql(DbMetadataTable rootTable, DbMetadataTable currentTable, String tableGroup, List<SqlParameter> pks, DeleteSqlTask sqlTask) {
        String currentTableName = CRUDHelper.getTableNameWithGroup(currentTable.getName(), tableGroup);
        sqlTask.getDeleteSqlBuiler().append("DELETE FROM ", new Object[0]).append(currentTableName, new Object[0]);
        DbMetadataRelation parentRelation = currentTable.getParentRelation();
        ArrayList<Object> pkIdList = new ArrayList<Object>(pks.size());
        for (SqlParameter pk : pks) {
            pkIdList.add(pk.getValue());
        }
        if (parentRelation != null) {
            DbMetadataTable childTable = currentTable;
            String childTableName = currentTable.getName();
            if (parentRelation.getParentTable() != rootTable) {
                if (parentRelation.getParentTable().getParentRelation().getParentTable() == rootTable) {
                    childTable = parentRelation.getParentTable();
                    childTableName = childTable.getName();
                    parentRelation = childTable.getParentRelation();
                    sqlTask.getDeleteSqlBuiler().append(String.format(" WHERE %1$s IN(SELECT %1$s FROM %2$s WHERE ", currentTable.getParentRelation().getParentTable().getPrimaryKey().getName(), childTableName), new Object[0]).appendIn(parentRelation.getChildColumn().getName(), pkIdList).append(") ", new Object[0]);
                    sqlTask.getParameters().addAll(pks);
                    sqlTask.setShardingHintContext(ShardingHinter.tryHint(parentRelation.getParentTable().getName(), parentRelation.getChildColumn().getName(), pkIdList));
                } else {
                    childTable = parentRelation.getParentTable();
                    childTableName = childTable.getName();
                    parentRelation = childTable.getParentRelation();
                    sqlTask.getDeleteSqlBuiler().append(String.format(" WHERE %1$s IN(SELECT %1$s FROM %2$s WHERE %3$s IN (SELECT %3$s FROM %4$s WHERE  ", currentTable.getParentRelation().getParentTable().getPrimaryKey().getName(), childTableName, parentRelation.getChildColumn().getName(), parentRelation.getParentTable().getName()), new Object[0]).appendIn(parentRelation.getParentTable().getParentRelation().getChildColumn().getName(), pkIdList).append("))", new Object[0]);
                    sqlTask.setShardingHintContext(ShardingHinter.tryHint(parentRelation.getParentTable().getParentRelation().getParentTable().getName(), parentRelation.getParentTable().getParentRelation().getChildColumn().getName(), pkIdList));
                }
            } else {
                sqlTask.getDeleteSqlBuiler().append(WHERE, new Object[0]).appendIn(parentRelation.getParentTable().getPrimaryKey().getName(), pkIdList);
            }
        } else {
            sqlTask.getDeleteSqlBuiler().append(WHERE, new Object[0]).appendIn(currentTable.getPrimaryKey().getName(), pkIdList);
        }
    }

    public static final TableColumnConverterContainer getTableConverter(DbMetadataTable table) {
        assert (table != null);
        return CRUDHelper.createTableConverter(table);
    }

    private static TableColumnConverterContainer createTableConverter(DbMetadataTable table) {
        assert (table != null);
        DbMetadataColumnCollection columns = table.getColumns();
        IFunction[] converters = (IFunction[])Array.newInstance(IFunction.class, columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            converters[i] = CRUDHelper.getConverter((DbMetadataColumn)columns.get(i));
        }
        return new TableColumnConverterContainer(converters);
    }

    private static Object DateTimeToDateTime(Object obj) {
        return obj;
    }

    public static Object decode(Object obj) {
        return Encrypters.decode((String)String.valueOf(obj));
    }

    public static Object encode(Object obj) {
        if (obj == null) {
            return obj;
        }
        if (obj instanceof Date) {
            return Encrypters.encode((String)String.valueOf(((Date)obj).getTime()));
        }
        return Encrypters.encode((String)String.valueOf(obj));
    }

    public static IFunction<Object, Object> getConverterByColumn(DbMetadataColumn col) {
        return CRUDHelper.getConverter(col);
    }

    protected static IFunction<Object, Object> getConverter(DbMetadataColumn col) {
        if (col.getEncrypt()) {
            IFunction<Object, Object> func = new IFunction<Object, Object>(){

                public Object apply(Object o) {
                    return CRUDHelper.encode(o);
                }
            };
            return func;
        }
        if (col.getClrType() == Date.class) {
            if (col.getDbType() == 91) {
                IFunction<Object, Object> func = new IFunction<Object, Object>(){

                    public Object apply(Object o) {
                        return CRUDHelper.DateTimeToDateTime(o);
                    }
                };
                return func;
            }
        } else if (col.getClrType() == Boolean.TYPE) {
            if (col.getDbType() == 1) {
                IFunction<Object, Object> func = new IFunction<Object, Object>(){

                    public Object apply(Object o) {
                        boolean v = (Boolean)o;
                        if (v) {
                            return "1";
                        }
                        return "0";
                    }
                };
                return func;
            }
        } else if (col.getClrType() == String.class && col.getDbType() == 1) {
            IFunction<Object, Object> func = new IFunction<Object, Object>(){

                public Object apply(Object o) {
                    String v = (String)o;
                    if ("".equals(v)) {
                        return " ";
                    }
                    return v;
                }
            };
            return func;
        }
        return null;
    }

    private static IColumnValuePair[] TryAddColumnValuePair(IColumnValuePair[] inputValues, IColumnValuePair addpair) {
        int addColumnIndex = addpair.getColumn().getColumnIndex();
        for (int i = 0; i < inputValues.length; ++i) {
            if (inputValues[i].getColumn().getColumnIndex() != addColumnIndex) continue;
            return inputValues;
        }
        IColumnValuePair[] newArray = Arrays.copyOf(inputValues, inputValues.length + 1);
        newArray[newArray.length - 1] = addpair;
        return newArray;
    }

    public static int getTableLevel(DbMetadataTable currentTable) {
        int i = 1;
        DbMetadataRelation parentRelation = currentTable.getParentRelation();
        DbMetadataTable childTable = currentTable;
        while (parentRelation != null) {
            childTable = parentRelation.getParentTable();
            parentRelation = childTable.getParentRelation();
            ++i;
        }
        return i;
    }

    private static ArrayList<String> getTableGroups(DbMetadataTable currentTable) {
        ArrayList<String> result = new ArrayList<String>();
        for (DbMetadataColumn column : currentTable.getColumns()) {
            String tableGroup = column.getTableGroup() != null ? column.getTableGroup() : "";
            if (result.contains(tableGroup)) continue;
            result.add(tableGroup);
        }
        return result;
    }

    public static String getTableNameWithGroup(String tableName, String tableGroup) {
        if (StringUtils.isEmpty((CharSequence)tableGroup)) {
            return tableName;
        }
        return tableName + "_" + tableGroup;
    }

    private static SqlTask getSqlBuilder(Map<String, SqlTask> dictGroupSql, String tableGroup, SqlTask headSqlBuilderTupe) {
        if (StringUtils.isEmpty((CharSequence)tableGroup)) {
            return headSqlBuilderTupe;
        }
        return dictGroupSql.get(tableGroup);
    }

    private static int executeSqlStask(SqlTask sqlTask) {
        return sqlTask.execute();
    }

    private static String inParameter(int count) {
        return inParameterMap.computeIfAbsent(count, c -> {
            if (c == 0) {
                return " IN()";
            }
            if (c == 1) {
                return "=?";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(" IN(");
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('?');
            }
            sb.append(')');
            return sb.toString();
        });
    }
}

