/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.DataManagerImplement;
import kd.bos.util.ThreadLocals;

final class DataEntityPkSnapshotCommitListener
implements CommitListener {
    private static final Log log = LogFactory.getLog(DataEntityPkSnapshotCommitListener.class);
    private WeakReference[] refObjects = null;
    private SoftReference<DataManagerImplement> refDataManager = null;
    private IDataEntityType dt;
    private static final ThreadLocal<AtomicInteger> thDataSetCount = ThreadLocals.create(() -> new AtomicInteger());
    private static final int defOverloadPercent = 95;

    public static void registerNewCommitListener(Object[] objects, DataManagerImplement managerImplement) {
        DataEntityPkSnapshotCommitListener listener = new DataEntityPkSnapshotCommitListener(objects, managerImplement);
        listener.addToCurrentTX();
    }

    private DataEntityPkSnapshotCommitListener(Object[] objects, DataManagerImplement managerImplement) {
        this.dt = managerImplement.getDataEntityType();
        if (objects != null) {
            this.refObjects = new WeakReference[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                this.refObjects[i] = new WeakReference<Object>(objects[i]);
            }
        }
        this.refDataManager = new SoftReference<DataManagerImplement>(managerImplement);
    }

    private void addToCurrentTX() {
        this.checkLimit();
        thDataSetCount.get().incrementAndGet();
        TX.addCommitListener((CommitListener)this);
    }

    private void checkLimit() {
        int count = thDataSetCount.get().get();
        if (count >= 10) {
            int overLoadPercent;
            Runtime runtime = Runtime.getRuntime();
            long free = runtime.freeMemory();
            long total = runtime.maxMemory();
            if ((total - free) * 100L / total > (long)(overLoadPercent = this.getOverLoadPercent())) {
                String msg = "in low memory, current thread has " + count + " uncommitted bigdata listener";
                throw new OrmException("bos-exception", msg);
            }
        }
    }

    private int getOverLoadPercent() {
        int percent = 95;
        try {
            percent = Integer.getInteger("orm.datamanager.overload.percent", 95);
            if (percent >= 97) {
                percent = 97;
            } else if (percent < 0) {
                percent = 95;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return percent;
    }

    public void onCommitted() {
        if (this.dt == null || this.refObjects == null) {
            return;
        }
        ArrayList objectList = new ArrayList(this.refObjects.length);
        boolean containNull = false;
        for (WeakReference it : this.refObjects) {
            Object data = it.get();
            if (data != null) {
                objectList.add(data);
                continue;
            }
            containNull = true;
        }
        if (!objectList.isEmpty()) {
            DataManagerImplement managerInstance = this.refDataManager.get();
            if (managerInstance == null || containNull) {
                managerInstance = new DataManagerImplement(this.dt);
            }
            managerInstance.commitSnapData(objectList.toArray());
        } else {
            log.info("no ref objs need set snapdata");
        }
    }

    public void onEnded(boolean rollbacked) {
        super.onEnded(rollbacked);
        thDataSetCount.get().decrementAndGet();
    }
}

