/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.DynamicObjectParamUtils;
import kd.bos.dataentity.IFunction;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.AutoSync;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DataEntityCollectionWithSnapshot;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IDeleteMetaRow;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.IModifierProperty;
import kd.bos.dataentity.metadata.IModifyTimeProperty;
import kd.bos.dataentity.metadata.ISaveDataSet;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.RowOperateType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.database.CollectionPropertyMap;
import kd.bos.dataentity.metadata.database.ComplexPropertyMap;
import kd.bos.dataentity.metadata.database.DataEntityTypeMap;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataDatabase;
import kd.bos.dataentity.metadata.database.DbMetadataRelation;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.database.DbMetadataTableCollection;
import kd.bos.dataentity.metadata.database.SimplePropertyMap;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.privacy.IPrivacyDataService;
import kd.bos.dataentity.privacy.IPrivacyProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.db.splittingread.ThreadReadWriteContext;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.BatchUpdateSeqTask;
import kd.bos.orm.dataentity.CRUDHelper;
import kd.bos.orm.dataentity.DataEntityPkSnapshotCommitListener;
import kd.bos.orm.dataentity.EventServiceImpl;
import kd.bos.orm.dataentity.IEventService;
import kd.bos.orm.dataentity.OrmDBTasks;
import kd.bos.orm.dataentity.QuickRowSetCallBack;
import kd.bos.orm.dataentity.RowCountSetCallBack;
import kd.bos.orm.dataentity.SelectSql;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.dataentity.SqlTask;
import kd.bos.orm.dataentity.SyncFormModelTableTask;
import kd.bos.orm.dataentity.TableAliasGenner;
import kd.bos.orm.datamanager.DataEntityTypeSelector;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.ObjectCache;
import kd.bos.orm.datamanager.PathSelector;
import kd.bos.orm.datamanager.QuickDataSet;
import kd.bos.orm.datamanager.QuickDataTable;
import kd.bos.orm.datamanager.QuickRow;
import kd.bos.orm.datamanager.ReadWhere;
import kd.bos.orm.datamanager.RuntimePkSnapshot;
import kd.bos.orm.datamanager.RuntimePkSnapshotSet;
import kd.bos.orm.datamanager.SaveDataSet;
import kd.bos.orm.datamanager.SaveDataTable;
import kd.bos.orm.datamanager.SaveRow;
import kd.bos.orm.datamanager.SimpleColumnValuePair;
import kd.bos.orm.datamanager.SyncColumnValuePair;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DeleteDataSyncValue;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.datasync.DtsThreadContext;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.DataSyncAgent;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.temptable.facade.TemptableFacade;
import kd.bos.xdb.temptable.facade.TemptableFacadeContext;
import kd.bos.xdb.temptable.facade.TemptableFacadeContexts;
import kd.bos.xdb.temptable.facade.TemptableFacades;
import kd.bos.xdb.temptable.facade.TemptableType;

public final class DataManagerImplement
implements IDataManager {
    private static final String batch_delete_size = "batch_delete_size";
    private static final String batch_maxObjects = "orm_maxobjects";
    private static final Log log = LogFactory.getLog((String)"DataManagerImplement");
    private int batchDeleteSize = 5000;
    private int maxObjects = 1000000;
    private boolean saveOriginalData4Encryption = false;
    private DBRoute dbRoute = null;
    private TableAliasGenner aliasGenner = new TableAliasGenner();
    private boolean selectHeadOnly = false;
    private Map<DbMetadataTable, EntryInfo> entryPageInfo = null;
    private SaveDataSet totalSds;
    private RuntimePkSnapshotSet[] onCommitRuntimeSets;
    private Object currentUserId;
    private static final String AND = " AND ";
    private boolean updateModify;
    private boolean enableUpdateModifierNew;
    private boolean enableUpdateModifierAudit;
    private String operateKey;
    private List<TemptableFacade> innerTempTableList = new ArrayList<TemptableFacade>(3);
    private IEventService eventService = new EventServiceImpl();
    private static final IColumnValuePair[] EmptyColumnValuePairArray = new IColumnValuePair[0];
    private ObjectCache<IDataEntityType, Tuple<DataEntityTypeMap, DbMetadataDatabase>> _cache = ObjectCache.create();
    private IDataEntityType _dataEntityType;
    private DataEntityTypeMap privateDataEntityTypeMap;
    private DbMetadataDatabase privateDatabase;
    private static final Object[] EmptyObjectArray = new Object[0];
    private static final Object[] EmptyObjects = new Object[0];
    private static final Object[] EmptyDynmaicObjects = new DynamicObject[0];
    private static final String S_NO_DATA_FILTER = " 0=1 ";
    private String privateConnectionString;
    private int startRowIndex;
    private Integer pageSize;
    private OperateOption option = OperateOption.create();

    public DataManagerImplement() {
        this.init();
    }

    public DataManagerImplement(IDataEntityType dt) {
        this(dt, null);
    }

    public DataManagerImplement(IDataEntityType dt, DBRoute dbRoute) {
        this.dbRoute = dbRoute;
        this.setDataEntityType(dt);
        this.init();
    }

    private void init() {
        try {
            this.batchDeleteSize = Integer.parseInt(System.getProperty(batch_delete_size, "5000").trim());
            this.maxObjects = Integer.parseInt(System.getProperty(batch_maxObjects, "1000000").trim());
            if (this.batchDeleteSize < 0) {
                this.batchDeleteSize = 5000;
            }
            if (this.maxObjects < 0) {
                this.maxObjects = 1000000;
            }
            this.saveOriginalData4Encryption = Boolean.getBoolean("orm_encryptedstorage_keeporiginaldata");
            this.enableUpdateModifierNew = DynamicObjectParamUtils.isEnableUpdateModifierNew();
            this.enableUpdateModifierAudit = DynamicObjectParamUtils.isEnableUpdateModifierAudit();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    @Override
    public void setCurrentUserId(Object id) {
        this.currentUserId = id;
    }

    @Override
    public void setSelectHeadOnly(boolean selectHeadOnly) {
        this.selectHeadOnly = selectHeadOnly;
    }

    private void checkDBRoute(IDataEntityType dt) {
        if (this.dbRoute.getRouteKey() == null || this.dbRoute.getRouteKey().trim().length() == 0) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_0", (String)"ORM:\u5143\u6570\u636e{0} routeKey\u4e3a\u7a7a!", (Object[])new Object[]{dt.getName()}));
        }
    }

    @Override
    public boolean delete(Object oid) {
        Object[] objectArray;
        if (oid == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = oid;
        }
        return this.delete(objectArray) > 0;
    }

    @Override
    public int delete(List<? extends Object> oids) {
        return this.delete(oids.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Object[] oids) {
        int i;
        if (oids == null) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_2", (String)"ORM: \u5220\u9664\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", null));
        }
        if (oids.length == 0) {
            return 0;
        }
        if (PrivacyDataCenterManager.isEnable()) {
            PrivacyDataCenterManager.getStoreService().deletePrivacyData(this.dbRoute, (Object)this.getDataEntityType(), oids);
        }
        int c = 0;
        boolean isInTx = TX.inTX();
        try (DtsThreadContext dtsContext = null;){
            if (isInTx) {
                dtsContext = DtsThreadContext.create();
            }
            if (oids.length > this.batchDeleteSize) {
                int size;
                int n = oids.length;
                for (i = 0; i < n; i += size) {
                    size = Math.min(this.batchDeleteSize, n - i);
                    Object[] seg = new Object[size];
                    System.arraycopy(oids, i, seg, 0, size);
                    c += CRUDHelper.delete(this.dbRoute, (Iterable<DbMetadataTable>)this.getDatabase().getTables(), this.getDataEntityTypeMap().getDbTable(), seg);
                }
            } else {
                c = CRUDHelper.delete(this.dbRoute, (Iterable<DbMetadataTable>)this.getDatabase().getTables(), this.getDataEntityTypeMap().getDbTable(), oids);
            }
        }
        Object[] pkIds = new Object[oids.length];
        for (i = 0; i < oids.length; ++i) {
            pkIds[i] = oids[i] instanceof DynamicObject ? ((DynamicObject)oids[i]).getPkValue() : oids[i];
        }
        try {
            if (DtsAccountPower.isAccountDtsEnable() && isInTx) {
                String tableName = this.getDataEntityTypeMap().getDbTable().getName();
                String entityNumber = this.getDataEntityTypeMap().getName();
                if (DataSyncAgent.checkTable((String)tableName) && DataSyncAgent.checkEntity((String)entityNumber)) {
                    DeleteDataSyncValue value = new DeleteDataSyncValue(tableName, entityNumber);
                    value.setOids(pkIds);
                    value.setCount(pkIds.length);
                    DataSyncAgent.get().send(this.dbRoute, OperationType.DELETE, (DataSyncValue)value);
                }
            }
        }
        catch (Exception e) {
            log.error("Dts analyze error!type=delete,tables=" + this.getDatabase().getTables() + ",pkIds=" + pkIds, (Throwable)e);
        }
        this.eventService.sendDeleteEvent(pkIds, this.getDatabase(), this._dataEntityType);
        return c;
    }

    @Override
    public boolean tryGetTableMaping(String path, RefObject<DbMetadataTable> table, RefObject<String> errorMessage) {
        Object mapping = null;
        DataEntityTypeSelector start = new DataEntityTypeSelector(this.getDataEntityTypeMap());
        RefObject tempRef_mapping = new RefObject(mapping);
        boolean tempVar = PathSelector.TryGetMaping(start, path, (RefObject<Object>)tempRef_mapping, errorMessage);
        mapping = tempRef_mapping.argvalue;
        if (tempVar) {
            table.argvalue = (DbMetadataTable)(mapping instanceof DbMetadataTable ? mapping : null);
            if (table.argvalue == null) {
                errorMessage.argvalue = "TODO";
                return false;
            }
            return true;
        }
        table.argvalue = null;
        return false;
    }

    @Override
    public boolean tryGetColumnMaping(String path, RefObject<DbMetadataColumn> column, RefObject<String> errorMessage) {
        Object mapping = null;
        DataEntityTypeSelector start = new DataEntityTypeSelector(this.getDataEntityTypeMap());
        RefObject tempRef_mapping = new RefObject(mapping);
        boolean tempVar = PathSelector.TryGetMaping(start, path, (RefObject<Object>)tempRef_mapping, errorMessage);
        mapping = tempRef_mapping.argvalue;
        if (tempVar) {
            column.argvalue = (DbMetadataColumn)(mapping instanceof DbMetadataColumn ? mapping : null);
            if (column.argvalue == null) {
                errorMessage.argvalue = "TODO";
                return false;
            }
            return true;
        }
        column.argvalue = null;
        return false;
    }

    @Override
    public void save(Object dataEntity) {
        this.save(new Object[]{dataEntity});
    }

    @Override
    public void save(Object[] dataEntities) {
        this.save(dataEntities, true);
    }

    @Override
    public void save(final Object[] dataEntities, boolean commitSnapData) {
        if (dataEntities == null) {
            throw new IllegalArgumentException("dataEntities");
        }
        if (dataEntities.length > this.maxObjects) {
            throw new OrmException("DataManagerImplement.save", BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_3", (String)"\u5355\u6b21\u4fdd\u5b58\u7684\u6570\u636e\u91cf\u8d85\u8fc7\u7cfb\u7edf\u53c2\u6570'orm_maxobjects'\u5b9a\u4e49\u7684\u6700\u5927\u9650\u5236\uff0c\u9650\u5236\u6570\u91cf{0}", (Object[])new Object[]{this.maxObjects}));
        }
        this.checkDataLoaded(dataEntities);
        try (TXHandle h = TX.required((String)(this.getDataEntityType().getExtendName() + ".save"));){
            try {
                boolean enableLimit = this.enableLimit();
                if (commitSnapData) {
                    if (enableLimit) {
                        DataEntityPkSnapshotCommitListener.registerNewCommitListener(dataEntities, this);
                    } else {
                        TX.addCommitListener((CommitListener)new CommitListener(){

                            public void onCommitted() {
                                DataManagerImplement.this.commitSnapData(dataEntities);
                            }
                        });
                    }
                }
                this.AutoBatchExecute(dataEntities, new IFunction<Object[], Object[]>(){

                    public Object[] apply(Object[] idsPart) {
                        return DataManagerImplement.this.SavePrivate(idsPart);
                    }
                });
                this.eventService.sendSaveEvent(this.totalSds, this._dataEntityType);
                if (commitSnapData && enableLimit && dataEntities.length > 1 && this.totalSds != null) {
                    this.onCommitRuntimeSets = this.covert2PkSnapshot(this.totalSds);
                    if (this.onCommitRuntimeSets != null) {
                        this.totalSds = null;
                    }
                }
            }
            catch (Exception e) {
                h.markRollback();
                if (e instanceof KDException) {
                    throw (KDException)e;
                }
                if (e instanceof OrmException) {
                    throw (OrmException)e;
                }
                if (e instanceof SQLException) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s. sql:%s", e.getMessage(), ((SQLException)e).getSQLState())});
                }
                throw e;
            }
        }
    }

    private boolean enableLimit() {
        try {
            String v = System.getProperty("orm.datamanager.txlimit.enable", "true");
            return Boolean.parseBoolean(v);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return true;
        }
    }

    @Override
    public void update(Object[] dataEntities) {
        if (dataEntities == null) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_4", (String)"ORM: \u4fdd\u5b58\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
        }
        if (dataEntities.length == 0) {
            return;
        }
        this.checkDataLoaded(dataEntities);
        this.setEntityFromDB(dataEntities, this.getDataEntityTypeMap());
        SaveDataSet dataSet = new SaveDataSet();
        this.entitiesToPrivacyData(dataEntities, this.getDataEntityTypeMap());
        this.EntitiesToDataSet(this.AddNewSaveTable(dataEntities, null, this.getDataEntityTypeMap(), dataSet), dataEntities, dataSet, this.getDataEntityTypeMap(), false);
        this.SetEntitySnapshotSave(dataEntities, dataSet);
        PkSnapshotSet snapshotSet = this.EntitiesToSnapshot(dataEntities, this.getDatabase(), this.getDataEntityTypeMap());
        dataSet.analyseRows(snapshotSet);
        this.SaveDataSet(dataSet);
        this.eventService.sendSaveEvent(this.totalSds, this.getDataEntityType());
    }

    void checkDataLoaded(Object[] dataEntities) {
        String config = System.getProperty("orm.checkdataload.enable", "true");
        if (!"true".equals(config)) {
            return;
        }
        if (dataEntities.length == 0 || !(dataEntities[0] instanceof DynamicObject)) {
            return;
        }
        DynamicObject data = (DynamicObject)dataEntities[0];
        PkSnapshotSet pkSnapshotSet = data.getDataEntityState().getPkSnapshotSet();
        if (pkSnapshotSet == null) {
            return;
        }
        HashMap<String, IDataEntityProperty> colTypes = new HashMap<String, IDataEntityProperty>(16);
        for (IDataEntityProperty property : this._dataEntityType.getProperties()) {
            DynamicObjectType itemPropertyType;
            if (!(property instanceof DynamicCollectionProperty) || !StringUtils.isNotBlank((CharSequence)(itemPropertyType = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType()).getAlias())) continue;
            colTypes.put(itemPropertyType.getAlias().toLowerCase(), property);
        }
        List snapshots = pkSnapshotSet.Snapshots;
        if (snapshots != null && !snapshots.isEmpty()) {
            for (PkSnapshot snapshot : snapshots) {
                DynamicObjectCollection rows;
                IDataEntityProperty property;
                if (snapshot.Oids == null || snapshot.Oids.length <= 0 || snapshot.isLoaded() || (property = (IDataEntityProperty)colTypes.get(snapshot.TableName.toLowerCase())) == null || (rows = (DynamicObjectCollection)property.getValueFast((Object)data)) != null && !rows.isEmpty()) continue;
                throw new OrmException("checkDataLoaded", BosRes.get((String)"bos-ormengine", (String)"SaveDataTable_2", (String)"\u4fa6\u6d4b\u5230\u6570\u636e{0}\u4e0d\u5b8c\u6574,\u8bf7\u4f7f\u7528getModel().getDataEntity(true)\u52a0\u8f7d\u5b8c\u6574\u6570\u636e\u540e\u518d\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (Object[])new Object[]{snapshot.TableName}));
            }
        }
    }

    private void setEntityFromDB(Object[] dataEntities, DataEntityTypeMap dataEntityTypeMap) {
        Object dataEntity;
        IDataEntityType dtType = dataEntityTypeMap.getDataEntityType();
        ISimpleProperty primaryKey = dtType.getPrimaryKey();
        for (int i = 0; i < dataEntities.length; ++i) {
            if (dataEntities[i] == null) continue;
            dataEntity = dataEntities[i];
            dtType.setFromDatabase(dataEntity, false);
            primaryKey.setDirty(dataEntity, false);
        }
        for (ComplexPropertyMap cpxMap : dataEntityTypeMap.getComplexProperties()) {
            Object[] newDataEntities = new Object[dataEntities.length];
            IComplexProperty cpx = (IComplexProperty)cpxMap.getDataEntityProperty();
            for (int i = 0; i < dataEntities.length; ++i) {
                dataEntity = dataEntities[i];
                if (dataEntity == null) continue;
                newDataEntities[i] = cpx.getValueFast(dataEntity);
            }
            this.setEntityFromDB(newDataEntities, cpxMap.getComplexPropertyTypeMap());
        }
        for (CollectionPropertyMap colpMap : dataEntityTypeMap.getCollectionProperties()) {
            ArrayList newEntitiesList = new ArrayList(16);
            ICollectionProperty colp = (ICollectionProperty)colpMap.getDataEntityProperty();
            for (int i = 0; i < dataEntities.length; ++i) {
                List olist;
                dataEntity = dataEntities[i];
                if (dataEntity == null || (olist = (List)colp.getValueFast(dataEntity)) == null) continue;
                newEntitiesList.addAll(olist);
            }
            this.setEntityFromDB(newEntitiesList.toArray(), colpMap.getCollectionItemPropertyTypeMap());
        }
    }

    private Object[] SavePrivate(Object[] dataEntities) {
        if (dataEntities == null) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_4", (String)"ORM: \u4fdd\u5b58\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
        }
        if (dataEntities.length == 0) {
            return EmptyObjectArray;
        }
        SaveDataSet dataSet = new SaveDataSet();
        PkSnapshotSet snapshotSet = this.EntitiesToSnapshot(dataEntities, this.getDatabase(), this.getDataEntityTypeMap());
        this.entitiesToPrivacyData(dataEntities, this.getDataEntityTypeMap());
        this.EntitiesToDataSet(this.AddNewSaveTable(dataEntities, null, this.getDataEntityTypeMap(), dataSet), dataEntities, dataSet, this.getDataEntityTypeMap(), false);
        dataSet.analyseRows(snapshotSet);
        this.SaveDataSet(dataSet);
        if (this.totalSds == null) {
            this.totalSds = dataSet;
        } else {
            this.totalSds.append(dataSet);
        }
        return EmptyObjectArray;
    }

    @Override
    public void commitSnapData(Object[] dataEntities) {
        if (dataEntities == null) {
            return;
        }
        this.ClearEntityDirty(dataEntities, this.getDataEntityTypeMap());
        if (this.onCommitRuntimeSets != null && this.onCommitRuntimeSets.length == dataEntities.length) {
            IDataEntityType dt = this.getDataEntityTypeMap().getDataEntityType();
            for (int rowIndex = 0; rowIndex < this.onCommitRuntimeSets.length; ++rowIndex) {
                dt.setPkSnapshot(dataEntities[rowIndex], this.onCommitRuntimeSets[rowIndex].PkSnapshotSet);
            }
            this.onCommitRuntimeSets = null;
        } else {
            SaveDataSet dataSet;
            if (this.totalSds == null) {
                dataSet = new SaveDataSet();
                this.EntitiesToDataSet(this.AddNewSaveTable(dataEntities, null, this.getDataEntityTypeMap(), dataSet), dataEntities, dataSet, this.getDataEntityTypeMap(), true);
            } else {
                dataSet = this.totalSds;
            }
            this.SetEntitySnapshotSave(dataEntities, dataSet);
        }
    }

    private PkSnapshotSet EntitiesToSnapshot(Object[] dataEntities, DbMetadataDatabase Database, DataEntityTypeMap DataEntityTypeMap2) {
        IDataEntityType dt = DataEntityTypeMap2.getDataEntityType();
        if (dataEntities.length == 1) {
            return dt.getPkSnapshot(dataEntities[0]);
        }
        int tableCount = Database.getTables().size();
        RuntimePkSnapshotSet tempVar = new RuntimePkSnapshotSet();
        tempVar.PkSnapshotSet = new PkSnapshotSet();
        tempVar.Tables = new RuntimePkSnapshot[tableCount];
        RuntimePkSnapshotSet runtimeSet = tempVar;
        PkSnapshotSet snapshotSetTemp = null;
        for (int i = 0; i < tableCount; ++i) {
            PkSnapshot tempVar2 = new PkSnapshot();
            tempVar2.TableName = ((DbMetadataTable)Database.getTables().get(i)).getName();
            PkSnapshot pkSnap = tempVar2;
            runtimeSet.PkSnapshotSet.Snapshots.add(pkSnap);
            runtimeSet.Tables[i] = new RuntimePkSnapshot(pkSnap);
        }
        for (int rowIndex = 0; rowIndex < dataEntities.length; ++rowIndex) {
            Object dataentity = dataEntities[rowIndex];
            Object pk = dt.getPrimaryKey().getValue(dataentity);
            snapshotSetTemp = dt.getPkSnapshot(dataentity);
            if (snapshotSetTemp == null) continue;
            if (dt.isQueryObj(dataentity)) {
                throw new OrmException("DataManagerImplement.save", BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_5", (String)"\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u67e5\u8be2\u5bf9\u8c61\uff0c\u4e0d\u652f\u6301\u4fdd\u5b58\u64cd\u4f5c!", (Object[])new Object[0]));
            }
            for (PkSnapshot item : snapshotSetTemp.Snapshots) {
                if (item.Oids == null) continue;
                int index = this.FindIndexOfDatabase(Database, item.TableName);
                for (Object id : item.Oids) {
                    runtimeSet.Tables[index].Oids.add(id);
                }
                DbMetadataTable tableScheme = (DbMetadataTable)Database.getTables().getItem(item.TableName);
                if (tableScheme.getSeq() == null) continue;
                for (Object id : item.Oids) {
                    runtimeSet.Tables[index].parentIds.add(pk);
                }
            }
        }
        runtimeSet.complete();
        return runtimeSet.PkSnapshotSet;
    }

    private int FindIndexOfDatabase(DbMetadataDatabase Database, String tableName) {
        DbMetadataTableCollection tables = Database.getTables();
        for (int i = 0; i < tables.size(); ++i) {
            if (!((DbMetadataTable)tables.get(i)).getName().equals(tableName)) continue;
            return i;
        }
        throw new ORMDesignException("01", BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_6", (String)"ORM\u5f15\u64ce\u4fdd\u5b58\u5b9e\u4f53\u65f6,\u4ece\u8868\u7ed3\u6784[{0}]\u4e2d\u67e5\u627e\u8868[{1}]\u5931\u8d25\uff0c\u8868[{1}]\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{Database.getName(), tableName}));
    }

    private void entitiesToPrivacyData(Object[] dataEntities, DataEntityTypeMap dataEntityTypeMap) {
        if (dataEntities.length == 0) {
            return;
        }
        IDataEntityType dt = dataEntityTypeMap.getDataEntityType();
        ArrayList<IPrivacyProperty> privacyProperties = new ArrayList<IPrivacyProperty>(16);
        for (SimplePropertyMap splMap : dataEntityTypeMap.getSimpleProperties()) {
            IDataEntityProperty sp = splMap.getDataEntityProperty();
            if (!(sp instanceof IPrivacyProperty)) continue;
            privacyProperties.add((IPrivacyProperty)sp);
        }
        for (ComplexPropertyMap cpxPropMap : dataEntityTypeMap.getComplexProperties()) {
            ArrayList<Object> list = new ArrayList<Object>(16);
            Object[] cpxPropType = cpxPropMap.getDataEntityProperty();
            Object[] objectArray = dataEntities;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object obj = objectArray[i];
                list.add(cpxPropType.getValue(obj));
            }
            this.entitiesToPrivacyData(list.toArray(new Object[list.size()]), cpxPropMap.getComplexPropertyTypeMap());
        }
        for (CollectionPropertyMap colPropMap : dataEntityTypeMap.getCollectionProperties()) {
            ICollectionProperty colp = (ICollectionProperty)colPropMap.getDataEntityProperty();
            for (Object obj : dataEntities) {
                List list = (List)colp.getValue(obj);
                this.entitiesToPrivacyData(list.toArray(new Object[list.size()]), colPropMap.getCollectionItemPropertyTypeMap());
            }
        }
        DataEntityPropertyCollection properties = dt.getProperties();
        HashMap<String, IDataEntityProperty> simpleProperties = new HashMap<String, IDataEntityProperty>(16);
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof ISimpleProperty)) continue;
            simpleProperties.put(prop.getName(), prop);
        }
        for (IPrivacyProperty privacyProperty : privacyProperties) {
            String controlFieldKey = privacyProperty.getOriginalPropKey();
            IDataEntityProperty originalProperty = (IDataEntityProperty)simpleProperties.get(controlFieldKey);
            IPrivacyDataService pds = privacyProperty.getPrivacyDataService();
            if (pds == null) continue;
            pds.savePrivacyData(originalProperty, privacyProperty, dataEntities);
        }
    }

    private SaveDataTable AddNewSaveTable(Object[] dataEntities, IColumnValuePair[] parentOids, DataEntityTypeMap dataEntityTypeMap, SaveDataSet dataSet) {
        int i;
        DbMetadataTable tableSchema = dataEntityTypeMap.getDbTable();
        DbMetadataColumn pkColumn = tableSchema.getPrimaryKey();
        SimplePropertyMap versionMap = dataEntityTypeMap.getVersionProperty();
        SaveDataTable result = new SaveDataTable(tableSchema, dataEntities.length);
        ISimpleProperty pk = dataEntityTypeMap.getDataEntityType().getPrimaryKey();
        ISaveMetaRow[] rows = result.getSaveRows();
        for (i = 0; i < dataEntities.length; ++i) {
            SaveRow tempVar = new SaveRow();
            if (pk != null) {
                tempVar.setOid(new SyncColumnValuePair(pkColumn, (IDataEntityProperty)pk, dataEntities[i]));
            }
            rows[i] = tempVar;
        }
        if (tableSchema.isLocale()) {
            IDataEntityProperty localeProp = (IDataEntityProperty)dataEntityTypeMap.getDataEntityType().getProperties().get((Object)"localeid");
            for (int i2 = 0; i2 < dataEntities.length; ++i2) {
                rows[i2].setLocale((IColumnValuePair)new SimpleColumnValuePair(tableSchema.getLocaleColumn(), localeProp.getValueFast(dataEntities[i2])));
            }
        }
        if (versionMap != null) {
            DbMetadataColumn versionColumn = versionMap.getDbColumn();
            ISimpleProperty versionProperty = (ISimpleProperty)versionMap.getDataEntityProperty();
            for (int i3 = 0; i3 < dataEntities.length; ++i3) {
                rows[i3].setVersion((IColumnValuePair)new SyncColumnValuePair(versionColumn, (IDataEntityProperty)versionProperty, dataEntities[i3]));
            }
        }
        if (parentOids != null && parentOids.length > 0) {
            if (parentOids.length == 1) {
                for (i = 0; i < dataEntities.length; ++i) {
                    rows[i].setParentOid(parentOids[0]);
                }
                result.setParentOid(parentOids[0]);
            } else {
                for (i = 0; i < dataEntities.length; ++i) {
                    rows[i].setParentOid(parentOids[i]);
                }
            }
        }
        dataSet.getTables().add((Object)result);
        return result;
    }

    private void EntitiesToDataSet(SaveDataTable table, Object[] dataEntities, SaveDataSet dataSet, DataEntityTypeMap dataEntityTypeMap, boolean includeDefaultValue) {
        SaveDataTable newTable;
        Object dataEntity;
        for (ComplexPropertyMap cpxMap : dataEntityTypeMap.getComplexProperties()) {
            Object[] newDataEntities = new Object[dataEntities.length];
            IComplexProperty cpx = (IComplexProperty)cpxMap.getDataEntityProperty();
            for (int i = 0; i < dataEntities.length; ++i) {
                dataEntity = dataEntities[i];
                if (dataEntity == null) continue;
                newDataEntities[i] = cpx.getValueFast(dataEntity);
                if (newDataEntities[i] == null || cpxMap.getRefIdProperty() == null) continue;
                cpxMap.getRefIdProperty().setValueFast(dataEntity, cpx.getComplexType().getPrimaryKey().getValueFast(newDataEntities[i]));
            }
            newTable = this.AddNewSaveTable(newDataEntities, null, cpxMap.getComplexPropertyTypeMap(), dataSet);
            this.EntitiesToDataSet(newTable, newDataEntities, dataSet, cpxMap.getComplexPropertyTypeMap(), includeDefaultValue);
        }
        this.EntitiesToDataSetForSimpleProperty(table, dataEntities, dataSet, dataEntityTypeMap, includeDefaultValue);
        for (CollectionPropertyMap colpMap : dataEntityTypeMap.getCollectionProperties()) {
            ArrayList newEntitiesList = new ArrayList(16);
            ArrayList<IColumnValuePair> parentOidList = new ArrayList<IColumnValuePair>(2);
            ICollectionProperty colp = (ICollectionProperty)colpMap.getDataEntityProperty();
            HashMap<Object, EntryInfo> mapEntryInfo = new HashMap<Object, EntryInfo>();
            for (int i = 0; i < dataEntities.length; ++i) {
                dataEntity = dataEntities[i];
                if (dataEntity == null) continue;
                IColumnValuePair oid = table.getSaveRows()[i].getOid();
                List list = (List)colp.getValueFast(dataEntity);
                if (list == null) continue;
                EntryInfo entryInfo = colp.getEntryInfo(dataEntity);
                if (entryInfo != null && entryInfo.getRowCount() != null && entryInfo.getRowCount() > entryInfo.getPageSize()) {
                    if (entryInfo.getStartRowIndex() + entryInfo.getPageSize() >= entryInfo.getRowCount()) {
                        entryInfo.setRowCount(entryInfo.getStartRowIndex() + list.size());
                    } else {
                        entryInfo.setRowCount(entryInfo.getRowCount() + list.size() - entryInfo.getPageSize());
                    }
                    entryInfo.setPageSize(list.size());
                    mapEntryInfo.put(oid.getValue(), entryInfo);
                }
                newEntitiesList.addAll(list);
                if (dataEntities.length == 1) {
                    parentOidList.add(oid);
                    continue;
                }
                for (Object obj : list) {
                    parentOidList.add(oid);
                }
            }
            newTable = this.AddNewSaveTable(newEntitiesList.toArray(), parentOidList.toArray(new IColumnValuePair[0]), colpMap.getCollectionItemPropertyTypeMap(), dataSet);
            if (mapEntryInfo.size() > 0) {
                newTable.setEntryInfo(mapEntryInfo);
            }
            this.EntitiesToDataSet(newTable, newEntitiesList.toArray(), dataSet, colpMap.getCollectionItemPropertyTypeMap(), includeDefaultValue);
        }
    }

    private void EntitiesToDataSetForSimpleProperty(SaveDataTable table, Object[] dataEntities, SaveDataSet dataSet, DataEntityTypeMap dataEntityTypeMap, boolean includeDefaultValue) {
        IDataEntityType dtType = dataEntityTypeMap.getDataEntityType();
        ArrayList<Tuple<DbMetadataColumn, ISimpleProperty>> outputList = this.GetOutputList(dataEntityTypeMap);
        ISaveMetaRow[] saveRows = table.getSaveRows();
        for (int i = 0; i < dataEntities.length; ++i) {
            Object dataEntity = dataEntities[i];
            if (dataEntity == null) continue;
            boolean hasDirtyProperty = false;
            List dirtyValues = saveRows[i].getDirtyValues();
            boolean includehasDefault = includeDefaultValue;
            boolean isNewObj = false;
            DynamicObject obj = (DynamicObject)(dataEntity instanceof DynamicObject ? dataEntity : null);
            if (obj != null && !obj.getDataEntityState().getFromDatabase()) {
                includehasDefault = true;
                isNewObj = true;
            }
            List listProperty = dtType.getDirtyProperties(dataEntity, includehasDefault);
            HashSet<String> pset = new HashSet<String>(listProperty.size());
            for (IDataEntityProperty dp : listProperty) {
                pset.add(dp.getName().toLowerCase());
            }
            this.addModifyProps(dtType, listProperty, pset, isNewObj);
            for (IDataEntityProperty dp : listProperty) {
                SimpleColumnValuePair dirtyValue;
                DbMetadataColumn dbColumn;
                int ordinal;
                Object propertyMap;
                boolean ignore = ORMUtil.isDbIgnoreForSave(dp);
                if (ignore) {
                    String refId;
                    if (dp instanceof IComplexProperty && pset.add(refId = dp.getName().toLowerCase() + "_id") && dtType.getProperties().containsKey((Object)refId)) {
                        ignore = false;
                        Object value = dp.getValue(dataEntity);
                        if (value instanceof DynamicObject) {
                            value = ((DynamicObject)value).getPkValue();
                        }
                        dp = (IDataEntityProperty)dtType.getProperties().get((Object)refId);
                        dp.setValueFast(dataEntity, value);
                    }
                } else if (dp instanceof ISimpleProperty && ((ISimpleProperty)dp).getPrivacyType() != 0L) {
                    ignore = true;
                }
                if (ignore || (propertyMap = dataEntityTypeMap.GetPropertyMapByOrdinal(ordinal = dp.getOrdinal())) == null) continue;
                hasDirtyProperty = true;
                if (dp instanceof ILocaleProperty) {
                    dbColumn = ((SimplePropertyMap)propertyMap).getDbColumn();
                    Object lc = ((ILocaleString)dp.getValueFast(dataEntity)).get((Object)"GLang");
                    dirtyValue = new SimpleColumnValuePair(dbColumn, lc);
                    dirtyValues.add(dirtyValue);
                    continue;
                }
                if (dp instanceof ISimpleProperty) {
                    dbColumn = ((SimplePropertyMap)propertyMap).getDbColumn();
                    Object v = ((ISimpleProperty)dp).getSaveValue(dataEntity, this.option, saveRows[i].getOperate());
                    dirtyValue = new SimpleColumnValuePair(dbColumn, v);
                    dirtyValues.add(dirtyValue);
                    if (!((ISimpleProperty)dp).isEncrypt() || !this.saveOriginalData4Encryption) continue;
                    String originName = dbColumn.getName().substring(0, dbColumn.getName().lastIndexOf("_enp"));
                    DbMetadataColumn originDbColumn = dbColumn.clone(originName, dbColumn.getEnableNull());
                    originDbColumn.setEncrypt(false);
                    SimpleColumnValuePair originDirtyValue = new SimpleColumnValuePair(originDbColumn, v);
                    dirtyValues.add(originDirtyValue);
                    continue;
                }
                if (!(dp instanceof IComplexProperty)) continue;
                Object cpxEntity = dp.getValueFast(dataEntity);
                ComplexPropertyMap cpxMap = (ComplexPropertyMap)propertyMap;
                if (((IComplexProperty)cpxMap.getDataEntityProperty()).getReadOnly() || cpxEntity == null) continue;
                cpxMap.getComplexPropertyTypeMap().getDataEntityType().setDirty(cpxEntity, true);
            }
            if (!hasDirtyProperty || outputList.size() <= 0) continue;
            ArrayList<SyncColumnValuePair> list = new ArrayList<SyncColumnValuePair>(outputList.size());
            saveRows[i].setOutputValues(list);
            for (Tuple<DbMetadataColumn, ISimpleProperty> outputItem : outputList) {
                list.add(new SyncColumnValuePair((DbMetadataColumn)outputItem.item1, (IDataEntityProperty)outputItem.item2, dataEntity));
            }
        }
    }

    private void addModifyProps(IDataEntityType dtType, List<IDataEntityProperty> listProperty, Set<String> pset, boolean isNewObj) {
        if (DynamicObjectParamUtils.isEnableUpdateModify() && this.updateModify) {
            IModifierProperty mp;
            IModifyTimeProperty mtp;
            boolean isAddModifyTime = this.isAddModifyTime(dtType, listProperty);
            boolean isAddmodifier = this.isAddModifier(dtType, listProperty, isNewObj);
            if (isAddModifyTime && (mtp = dtType.getModifyTimeProperty()) != null && !pset.contains(mtp.getName().toLowerCase())) {
                listProperty.add((IDataEntityProperty)mtp);
            }
            if (isAddmodifier && (mp = dtType.getModifierProperty()) != null && mp.getName() != null && !pset.contains(mp.getName().toLowerCase())) {
                listProperty.add((IDataEntityProperty)mp);
                pset.add(mp.getName().toLowerCase());
            }
        }
    }

    private boolean isAddModifyTime(IDataEntityType dtType, List<IDataEntityProperty> listProperty) {
        boolean isAdd = false;
        if (dtType == null || dtType.getParent() == null) {
            isAdd = true;
        } else if (!listProperty.isEmpty()) {
            isAdd = true;
        }
        return isAdd;
    }

    private boolean isAddModifier(IDataEntityType dtType, List<IDataEntityProperty> listProperty, boolean isNewObj) {
        boolean isAdd = false;
        if (isNewObj && !this.enableUpdateModifierNew) {
            return isAdd;
        }
        if (StringUtils.isNotBlank((CharSequence)this.operateKey) && "audit".equals(this.operateKey) && !this.enableUpdateModifierAudit) {
            return isAdd;
        }
        if (dtType.getParent() == null) {
            if (dtType.isForceUpdateModifier().booleanValue()) {
                isAdd = true;
            } else if (!listProperty.isEmpty()) {
                isAdd = true;
            }
        } else if (!listProperty.isEmpty()) {
            isAdd = true;
        }
        return isAdd;
    }

    private ArrayList<Tuple<DbMetadataColumn, ISimpleProperty>> GetOutputList(DataEntityTypeMap dataEntityTypeMap) {
        ArrayList<Tuple<DbMetadataColumn, ISimpleProperty>> outputList = new ArrayList<Tuple<DbMetadataColumn, ISimpleProperty>>(dataEntityTypeMap.getSimpleProperties().size());
        for (SimplePropertyMap dp : dataEntityTypeMap.getSimpleProperties()) {
            if (dp.getDbColumn().getAutoSync() == AutoSync.Never) continue;
            outputList.add((Tuple<DbMetadataColumn, ISimpleProperty>)Tuple.create((Object)dp.getDbColumn(), (Object)dp.getDataEntityProperty()));
        }
        return outputList;
    }

    private Map<String, Object> clearPrivacyColumnValue(SaveDataSet dataSet) {
        if (!PrivacyDataCenterManager.isEnable()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isMultilanguage = false;
        HashSet encryptFields = null;
        String tableName = "";
        for (ISaveDataTable table : dataSet.getTables()) {
            DbMetadataTable tableInfo = table.getSchema();
            IDataEntityType dataEntityType = tableInfo.getDataEntityTypeMap().getDataEntityType();
            if (dataEntityType.getParent() != null) {
                isMultilanguage = ORMConfiguration.isMultiLangDataEntityType(dataEntityType);
            }
            if (isMultilanguage) {
                tableName = dataEntityType.getParent().getAlias();
                encryptFields = new HashSet(PrivacyDataCenterManager.getEncryptService().getEncryptFields(tableName));
            } else {
                tableName = table.getSchema().getName();
                encryptFields = new HashSet(PrivacyDataCenterManager.getEncryptService().getEncryptFields(tableName));
                for (Tuple tuple : table.getSchema().getColumnsByTableGroup()) {
                    Set tmpSet;
                    if (kd.bos.util.StringUtils.isEmpty((String)((String)tuple.item1)) || (tmpSet = PrivacyDataCenterManager.getEncryptService().getEncryptFields(tableName + "_" + (String)tuple.item1)) == null || tmpSet.size() <= 0) continue;
                    if (encryptFields.isEmpty()) {
                        encryptFields = Sets.newHashSet();
                    }
                    encryptFields.addAll(tmpSet);
                }
            }
            if (encryptFields.isEmpty()) continue;
            if (table.getSaveRows() != null) {
                for (int i = 0; i < table.getSaveRows().length; ++i) {
                    ISaveMetaRow saveRow = table.getSaveRows()[i];
                    List dirtyVals = saveRow.getDirtyValues();
                    ListIterator<SimpleColumnValuePair> it = dirtyVals.listIterator();
                    IColumnValuePair OidPair = null;
                    String localeId = null;
                    if (isMultilanguage) {
                        OidPair = saveRow.getParentOid();
                        localeId = ((SyncColumnValuePair)saveRow.getOid()).getDataEntity().getString("localeId");
                    } else {
                        OidPair = saveRow.getOid();
                    }
                    while (it.hasNext()) {
                        String columnName;
                        IColumnValuePair valuePair = (IColumnValuePair)it.next();
                        DbMetadataColumn column = valuePair.getColumn();
                        if (column.getName() == null || !encryptFields.contains(columnName = column.getName().toLowerCase(Locale.ENGLISH))) continue;
                        Object val = valuePair.getValue();
                        String valKey = OidPair.getValue() + "$$" + columnName;
                        if (isMultilanguage) {
                            valKey = valKey + "$$" + localeId;
                        }
                        result.put(valKey, valuePair.getValue());
                        if (valuePair instanceof SimpleColumnValuePair) {
                            it.set(new SimpleColumnValuePair(column, column.getDefaultValue()));
                            continue;
                        }
                        valuePair.setValue(column.getDefaultValue());
                    }
                }
            }
            if (!isMultilanguage || table.getDeleteRows() == null || table.getDeleteRows().length <= 0) continue;
            ArrayList<Object> oids = new ArrayList<Object>(table.getDeleteRows().length);
            for (int i = 0; i < table.getDeleteRows().length; ++i) {
                IDeleteMetaRow row = table.getDeleteRows()[i];
                oids.add(row.getOid());
            }
            SqlBuilder sb = new SqlBuilder();
            String fpkid = table.getSchema().getPrimaryKey().getName();
            String fbizid = table.getSchema().getParentRelation().getChildColumn().getName();
            sb.append(String.format("select %s ,flocaleid,%s from %s where ", fbizid, fpkid, table.getSchema().getName()), new Object[0]);
            sb.appendIn(fpkid, oids);
            DataSet rs = DB.queryDataSet((String)"_savePrivacyData", (DBRoute)this.dbRoute, (SqlBuilder)sb);
            Throwable throwable = null;
            try {
                if (rs == null) continue;
                while (rs.hasNext()) {
                    Row row = rs.next();
                    PrivacyDataModel info = new PrivacyDataModel();
                    info.setTableName(tableName);
                    info.setBizId(row.get(fbizid));
                    info.setLocaleId(row.getString("flocaleid"));
                    result.put(row.getString(fpkid), info);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        return result;
    }

    private void SaveDataSet(SaveDataSet dataSet) {
        Map<String, Object> result = this.clearPrivacyColumnValue(dataSet);
        OrmDBTasks tasks = new OrmDBTasks(true, this.dbRoute);
        for (ISaveDataTable table : dataSet.getTables()) {
            List changeRows;
            if (table.getSaveRows() != null) {
                for (int i = 0; i < table.getSaveRows().length; ++i) {
                    ISaveMetaRow saveRow = table.getSaveRows()[i];
                    if (saveRow.getOperate() == RowOperateType.Insert) {
                        tasks.insert(table.getSchema(), saveRow.getDirtyValues().toArray(new IColumnValuePair[0]), saveRow.getOutputValues() == null ? EmptyColumnValuePairArray : saveRow.getOutputValues().toArray(new IColumnValuePair[0]), saveRow.getOid());
                        continue;
                    }
                    if (saveRow.getOperate() != RowOperateType.Update) continue;
                    tasks.update(table, saveRow);
                }
            }
            if (table.getDeleteRows() != null) {
                Object[] oids = new Object[table.getDeleteRows().length];
                for (int i = 0; i < table.getDeleteRows().length; ++i) {
                    oids[i] = table.getDeleteRows()[i].getOid();
                }
                List<SqlTask> ts = tasks.delete(table.getSchema(), oids, null);
                ShardingHintContext ctx = null;
                IColumnValuePair parentOid = ((SaveDataTable)table).getParentOid();
                if (parentOid != null) {
                    ctx = ShardingHinter.tryHint(parentOid);
                } else {
                    ISaveDataTable rootTable = (ISaveDataTable)dataSet.getTables().get(0);
                    ISaveMetaRow[] rootSaveRows = rootTable.getSaveRows();
                    if (rootSaveRows != null && rootSaveRows.length > 0) {
                        ctx = ShardingHinter.tryHint(rootTable.getSchema().getName(), rootSaveRows);
                    }
                }
                if (ctx != null) {
                    for (SqlTask t : ts) {
                        t.setShardingHintContext(ctx);
                    }
                }
            }
            if (((changeRows = table.getChangeRows()) == null || changeRows.size() <= 0) && (table.getDeleteRows() == null || table.getDeleteRows().length <= 0)) continue;
            BatchUpdateSeqTask t = null;
            SyncFormModelTableTask sortSeqTask = null;
            String formmodeltable = this.option.getVariableValue("orm_formmodeltable_" + table.getSchema().getName(), "");
            if (StringUtils.isNotBlank((CharSequence)formmodeltable)) {
                sortSeqTask = tasks.syncFormModelTable(table.getSchema(), formmodeltable, changeRows);
            } else if (changeRows != null && changeRows.size() > 0) {
                t = tasks.updateSeq(table.getSchema(), changeRows);
            }
            ShardingHinter.todoTest();
            ShardingHintContext ctx = ShardingHinter.tryHint(((SaveDataTable)table).getParentOid());
            if (ctx == null) continue;
            if (t != null) {
                t.setShardingHintContext(ctx);
            }
            if (sortSeqTask == null) continue;
            sortSeqTask.setShardingHintContext(ctx);
        }
        tasks.commitDbTask();
        this.beforeSaveDataSet(dataSet, result);
    }

    private void beforeSaveDataSet(SaveDataSet dataSet, Map<String, Object> initValues) {
        this.saveDataSetToPrivacyData(dataSet, initValues);
    }

    private void saveDataSetToPrivacyData(SaveDataSet dataSet, Map<String, Object> initValues) {
        if (!PrivacyDataCenterManager.isEnable()) {
            return;
        }
        Map<String, Object> sharding = this.genShardingIds(dataSet);
        Map shardingConfig = (Map)sharding.get("shardingConfig");
        List shardingIds = (List)sharding.get("shardingIds");
        for (ISaveDataTable table : dataSet.getTables()) {
            PrivacyDataCenterManager.getStoreService().savePrivacyData(this.dbRoute, (Object)table, (String)shardingConfig.get("tableName"), (String)shardingConfig.get("fieldName"), shardingIds, initValues);
        }
    }

    private Map<String, Object> genShardingIds(SaveDataSet dataSet) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, String> shardingConfig = new HashMap<String, String>();
        ArrayList<Object> shardingIds = new ArrayList<Object>();
        result.put("shardingConfig", shardingConfig);
        result.put("shardingIds", shardingIds);
        for (ISaveDataTable table : dataSet.getTables()) {
            if (table.getSchema().getParentRelation() != null) continue;
            shardingConfig.put("tableName", table.getSchema().getName());
            shardingConfig.put("fieldName", table.getSchema().getPrimaryKey().getName());
            try {
                for (ISaveMetaRow row : ((SaveDataTable)table).getSaveRows()) {
                    Object id;
                    DynamicObject dj;
                    if (row.getOid() == null || !(row.getOid() instanceof SyncColumnValuePair) || (dj = ((SyncColumnValuePair)row.getOid()).getDataEntity()) == null || shardingIds.contains(id = dj.getPkValue())) continue;
                    shardingIds.add(id);
                }
            }
            catch (Exception e) {
                log.error("shardingids error", (Throwable)e);
            }
        }
        return result;
    }

    private void SetEntitySnapshotSave(Object[] entities, ISaveDataSet dataSet) {
        if (entities.length == 0) {
            return;
        }
        if (entities.length == 1) {
            IDataEntityType dt = this.getDataEntityTypeMap().getDataEntityType();
            if (dt.getPrimaryKey() != null) {
                PkSnapshotSet pkSnapshotSet = new PkSnapshotSet(dataSet.getTables().size());
                List lstPksnapshot = pkSnapshotSet.Snapshots;
                Object[] Oids = null;
                for (ISaveDataTable itable : dataSet.getTables()) {
                    SaveDataTable table = (SaveDataTable)itable;
                    if (table.getSaveRows().length > 0) {
                        Oids = new Object[table.getSaveRows().length];
                        for (int i = 0; i < table.getSaveRows().length; ++i) {
                            Oids[i] = table.getSaveRows()[i].getOid().getValue();
                        }
                    } else {
                        Oids = null;
                    }
                    PkSnapshot tempVar = new PkSnapshot();
                    tempVar.TableName = table.getSchema().getName();
                    tempVar.Oids = Oids;
                    lstPksnapshot.add(tempVar);
                }
                dt.setPkSnapshot(entities[0], pkSnapshotSet);
            }
        } else {
            IDataEntityType dt = this.getDataEntityTypeMap().getDataEntityType();
            if (dt.getPrimaryKey() != null) {
                String rootTableName = this.getDataEntityTypeMap().getDbTable().getName();
                ISaveDataTable table = (ISaveDataTable)dataSet.getTables().get((Object)rootTableName);
                ISaveMetaRow[] rows = table.getSaveRows();
                RuntimePkSnapshotSet[] runtimeSets = this.covert2PkSnapshot(dataSet);
                if (runtimeSets != null) {
                    for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
                        dt.setPkSnapshot(entities[rowIndex], runtimeSets[rowIndex].PkSnapshotSet);
                    }
                }
            }
        }
    }

    private RuntimePkSnapshotSet[] covert2PkSnapshot(ISaveDataSet dataSet) {
        IDataEntityType dt = this.getDataEntityTypeMap().getDataEntityType();
        RuntimePkSnapshotSet[] runtimeSets = null;
        if (dt.getPrimaryKey() != null && dataSet != null) {
            RuntimePkSnapshotSet runtimeSet;
            String rootTableName = this.getDataEntityTypeMap().getDbTable().getName();
            ISaveDataTable table = (ISaveDataTable)dataSet.getTables().get((Object)rootTableName);
            ISaveMetaRow[] rows = table.getSaveRows();
            PkSnapshot pkSnap = null;
            runtimeSets = new RuntimePkSnapshotSet[rows.length];
            int tableCount = dataSet.getTables().size();
            HashMap<Object, RuntimePkSnapshotSet> dict = new HashMap<Object, RuntimePkSnapshotSet>();
            for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
                runtimeSet = new RuntimePkSnapshotSet();
                runtimeSet.PkSnapshotSet = new PkSnapshotSet();
                runtimeSet.Tables = new RuntimePkSnapshot[tableCount];
                for (int j = 0; j < tableCount; ++j) {
                    PkSnapshot tempVar2 = new PkSnapshot();
                    tempVar2.TableName = ((ISaveDataTable)dataSet.getTables().get(j)).getSchema().getName();
                    pkSnap = tempVar2;
                    runtimeSet.PkSnapshotSet.Snapshots.add(pkSnap);
                    runtimeSet.Tables[j] = new RuntimePkSnapshot(pkSnap);
                }
                Object pkOid = rows[rowIndex].getOid().getValue();
                runtimeSet.Tables[0].Oids.add(pkOid);
                dict.put(pkOid, runtimeSet);
                runtimeSets[rowIndex] = runtimeSet;
            }
            for (DbMetadataTable childTable : table.getSchema().getChildTables()) {
                this.SetEntitySnapshotSaveEx(dataSet, (ISaveDataTable)dataSet.getTables().get((Object)childTable.getName()), dict);
            }
            for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
                runtimeSet = runtimeSets[rowIndex];
                for (int j = 0; j < tableCount; ++j) {
                    runtimeSet.Tables[j].Snapshot.Oids = runtimeSet.Tables[j].Oids.toArray();
                }
            }
        }
        return runtimeSets;
    }

    private void SetEntitySnapshotSaveEx(ISaveDataSet dataSet, ISaveDataTable currentTable, HashMap<Object, RuntimePkSnapshotSet> pkDict) {
        int tableIndex = this.FindIndexSave(dataSet, currentTable);
        HashMap<Object, RuntimePkSnapshotSet> newPkDict = new HashMap<Object, RuntimePkSnapshotSet>(currentTable.getSaveRows().length);
        for (ISaveMetaRow row : currentTable.getSaveRows()) {
            Object parentOid = row.getParentOid().getValue();
            Object pkOid = row.getOid().getValue();
            RuntimePkSnapshotSet snapshotSet = pkDict.get(parentOid);
            if (snapshotSet == null) continue;
            snapshotSet.Tables[tableIndex].Oids.add(pkOid);
            newPkDict.put(pkOid, snapshotSet);
        }
        for (DbMetadataTable childTable : currentTable.getSchema().getChildTables()) {
            this.SetEntitySnapshotSaveEx(dataSet, (ISaveDataTable)dataSet.getTables().get((Object)childTable.getName()), newPkDict);
        }
    }

    private int FindIndexSave(ISaveDataSet dataSet, ISaveDataTable currentTable) {
        for (int i = 0; i < dataSet.getTables().size(); ++i) {
            if (dataSet.getTables().get(i) != currentTable) continue;
            return i;
        }
        throw new ORMDesignException("02", BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_7", (String)"ORM\u5f15\u64ce\u4fdd\u5b58\u5b9e\u4f53\u65f6,\u4ece\u8868\u7ed3\u6784\u4e2d\u67e5\u627e\u8868[{0}]\u5931\u8d25\uff0c\u8868[{0}]\u4e0d\u5b58\u5728\uff01", (Object[])new Object[]{currentTable.getSchema().getName()}));
    }

    private void ClearEntityDirty(Object[] dataEntities, DataEntityTypeMap dataEntityTypeMap) {
        Object dataEntity;
        IDataEntityType dtType = dataEntityTypeMap.getDataEntityType();
        for (int i = 0; i < dataEntities.length; ++i) {
            if (dataEntities[i] == null) continue;
            dataEntity = dataEntities[i];
            dtType.setFromDatabase(dataEntity);
        }
        for (ComplexPropertyMap cpxMap : dataEntityTypeMap.getComplexProperties()) {
            Object[] newDataEntities = new Object[dataEntities.length];
            IComplexProperty cpx = (IComplexProperty)cpxMap.getDataEntityProperty();
            for (int i = 0; i < dataEntities.length; ++i) {
                dataEntity = dataEntities[i];
                if (dataEntity == null) continue;
                newDataEntities[i] = cpx.getValueFast(dataEntity);
            }
            this.ClearEntityDirty(newDataEntities, cpxMap.getComplexPropertyTypeMap());
        }
        for (CollectionPropertyMap colpMap : dataEntityTypeMap.getCollectionProperties()) {
            ArrayList newEntitiesList = new ArrayList(16);
            ICollectionProperty colp = (ICollectionProperty)colpMap.getDataEntityProperty();
            for (int i = 0; i < dataEntities.length; ++i) {
                List olist;
                dataEntity = dataEntities[i];
                if (dataEntity == null || (olist = (List)colp.getValueFast(dataEntity)) == null) continue;
                if (DynamicObjectCollection.class.isInstance(olist)) {
                    ((DynamicObjectCollection)olist).getDeleteRows().clear();
                }
                newEntitiesList.addAll(olist);
            }
            this.ClearEntityDirty(newEntitiesList.toArray(), colpMap.getCollectionItemPropertyTypeMap());
        }
    }

    private void DeleteCollectionWithSnapshot(DataEntityCollectionWithSnapshot<Object> colWithSnapshot) {
        if (colWithSnapshot == null) {
            return;
        }
        PkSnapshot snapshot = colWithSnapshot.getPkSnapshot();
        if (snapshot != null && snapshot.Oids != null && snapshot.Oids.length > 0) {
            HashSet<Object> currentOids = new HashSet<Object>();
            ISimpleProperty pk = this.getDataEntityType().getPrimaryKey();
            for (int i = 0; i < colWithSnapshot.size(); ++i) {
                currentOids.add(pk.getValueFast(colWithSnapshot.get(i)));
            }
            ArrayList<Object> deleteOids = new ArrayList<Object>();
            Object[] oldOids = snapshot.Oids;
            for (int i = 0; i < oldOids.length; ++i) {
                if (currentOids.contains(oldOids[i])) continue;
                deleteOids.add(oldOids[i]);
            }
            if (deleteOids.size() > 0) {
                this.delete(deleteOids);
            }
        }
    }

    @Override
    public IDataEntityType getDataEntityType() {
        return this._dataEntityType;
    }

    @Override
    public void setDataEntityType(final IDataEntityType value) {
        Tuple temp;
        if (this.dbRoute == null) {
            this.dbRoute = DBRoute.of((String)value.getDBRouteKey());
        }
        this.checkDBRoute(value);
        if (value == null) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_8", (String)"\u8bbe\u7f6e\u6570\u636e\u7ba1\u7406\u5668\u5b9e\u4f53\u7c7b\u578b\u5931\u8d25\uff0c\u5b9e\u4f53\u7c7b\u578bDataEntityType\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
        }
        this._dataEntityType = value;
        boolean cacheMetadata = DataManagerUtils.getCacheMetadata();
        if (cacheMetadata) {
            IFunction<IDataEntityType, Tuple<DataEntityTypeMap, DbMetadataDatabase>> addHandle = new IFunction<IDataEntityType, Tuple<DataEntityTypeMap, DbMetadataDatabase>>(){

                public Tuple<DataEntityTypeMap, DbMetadataDatabase> apply(IDataEntityType key) {
                    DbMetadataDatabase db = null;
                    RefObject tempRef_db = new RefObject(db);
                    DataEntityTypeMap map = DataEntityTypeMap.Build((IDataEntityType)value, (RefObject)tempRef_db);
                    db = (DbMetadataDatabase)tempRef_db.argvalue;
                    return Tuple.create((Object)map, (Object)db);
                }
            };
            temp = this._cache.getOrAdd(value, addHandle);
        } else {
            DbMetadataDatabase db = null;
            RefObject tempRef_db2 = new RefObject(db);
            DataEntityTypeMap map = DataEntityTypeMap.Build((IDataEntityType)value, (RefObject)tempRef_db2);
            db = (DbMetadataDatabase)tempRef_db2.argvalue;
            temp = Tuple.create((Object)map, (Object)db);
        }
        this.setDataEntityTypeMap((DataEntityTypeMap)temp.item1);
        this.setDatabase((DbMetadataDatabase)temp.item2);
    }

    @Override
    public DataEntityTypeMap getDataEntityTypeMap() {
        return this.privateDataEntityTypeMap;
    }

    private void setDataEntityTypeMap(DataEntityTypeMap value) {
        this.privateDataEntityTypeMap = value;
    }

    public DbMetadataDatabase getDatabase() {
        return this.privateDatabase;
    }

    private void setDatabase(DbMetadataDatabase value) {
        this.privateDatabase = value;
    }

    public Object create() {
        return this.getDataEntityType().createInstance();
    }

    private Object[] AutoBatchExecute(Object[] ids, IFunction<Object[], Object[]> func) {
        int batchSize = DataManagerUtils.getBatchSize();
        int realLen = ids.length;
        for (int i = realLen - 1; i >= 0 && ids[i] == null; --i) {
            --realLen;
        }
        if (realLen == 0) {
            return EmptyObjectArray;
        }
        if (realLen <= batchSize) {
            if (realLen != ids.length) {
                Object[] idsArray = ids;
                ids = new Object[realLen];
                System.arraycopy(idsArray, 0, ids, 0, realLen);
            }
            return (Object[])func.apply((Object)ids);
        }
        LinkedList<Object[]> ls = null;
        Object[] batch = new Object[batchSize];
        int mod = realLen % batchSize;
        int count = realLen / batchSize + (mod == 0 ? 0 : 1);
        for (int i = 0; i < count; ++i) {
            if (i == count - 1 && mod != 0) {
                batch = new Object[mod];
                System.arraycopy(ids, i * batchSize, batch, 0, mod);
            } else {
                System.arraycopy(ids, i * batchSize, batch, 0, batchSize);
            }
            Object[] values = (Object[])func.apply((Object)batch);
            if (values == null) continue;
            if (ls == null) {
                ls = new LinkedList<Object[]>();
            }
            ls.add(values);
        }
        if (ls == null) {
            return null;
        }
        int c = 0;
        Iterator iter = ls.iterator();
        while (iter.hasNext()) {
            c += ((Object[])iter.next()).length;
        }
        Object[] result = new Object[c];
        int i = 0;
        for (Object[] values : ls) {
            System.arraycopy(values, 0, result, i, values.length);
            i += values.length;
        }
        return result;
    }

    public ISaveDataSet getSaveDataSet(Object[] dataEntities) {
        return this.getSaveDataSet(dataEntities, true);
    }

    @Override
    public ISaveDataSet getSaveDataSet(Object[] dataEntities, boolean includeDefaultValue) {
        if (dataEntities == null) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_9", (String)"ORM\u5f15\u64ce\u4fdd\u5b58\u5b9e\u4f53\u5931\u8d25\uff0c\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
        }
        if (dataEntities.length == 0) {
            return null;
        }
        SaveDataSet dataSet = new SaveDataSet();
        PkSnapshotSet snapshotSet = this.EntitiesToSnapshot(dataEntities, this.getDatabase(), this.getDataEntityTypeMap());
        this.EntitiesToDataSet(this.AddNewSaveTable(dataEntities, null, this.getDataEntityTypeMap(), dataSet), dataEntities, dataSet, this.getDataEntityTypeMap(), includeDefaultValue);
        dataSet.analyseRows(snapshotSet);
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(Object oid) {
        Object[] result;
        if (oid == null) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_10", (String)"ORM\u5f15\u64ce\u8bfb\u53d6\u6570\u636e\u5931\u8d25\uff0c\u67e5\u8be2\u4e3b\u952e\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (Object[])new Object[0]));
        }
        ReadWhere where = new ReadWhere(new Object[]{oid});
        ShardingHintContext ctx = ShardingHinter.tryHint(this._dataEntityType, new Object[]{oid});
        if (ctx != null) {
            ctx.set();
            try {
                result = this.read(where);
            }
            finally {
                ctx.close();
            }
        } else {
            result = this.read(where);
        }
        if (result == null || result.length == 0) {
            if (DataManagerUtils.getThrowExceptionWhenNotFind()) {
                throw new KDException(new ErrorCode("bos.orm.read.dataNotExist", BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_11", (String)"%s\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (Object[])new Object[]{this._dataEntityType.getDisplayName().toString()})), new Object[0]);
            }
            return null;
        }
        return result[0];
    }

    @Override
    public Object[] read(List<Object> ids) {
        if (ids == null) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_12", (String)"ORM\u5f15\u64ce\u8bfb\u53d6\u6570\u636e\u5931\u8d25\uff0cOID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (Object[])new Object[0]));
        }
        IFunction<Object[], Object[]> idsHandle = new IFunction<Object[], Object[]>(){

            public Object[] apply(Object[] idsPart) {
                return DataManagerImplement.this.read(idsPart);
            }
        };
        Object[] result = this.AutoBatchExecute(ids.toArray(), idsHandle);
        return result;
    }

    public Object[] read(String whereSql) {
        List<SqlParameter> sqlParam = null;
        ReadWhere where = new ReadWhere(whereSql, sqlParam);
        return this.read(where);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] read(Object[] ids) {
        if (ids.length == 0) {
            if (this._dataEntityType instanceof DynamicObjectType) {
                return EmptyDynmaicObjects;
            }
            return EmptyObjects;
        }
        ReadWhere where = new ReadWhere(ids);
        ShardingHintContext ctx = ShardingHinter.tryHint(this._dataEntityType, ids);
        if (ctx != null) {
            ctx.set();
            try {
                Object[] objectArray = this.read(where);
                return objectArray;
            }
            finally {
                ctx.close();
            }
        }
        return this.read(where);
    }

    @Override
    public Object[] fetchEntryRows(DynamicObjectCollection coll, int startRowIndex, int pageSize) {
        Object[] dataEntites;
        DbMetadataTableCollection tables = this.getDatabase().getTables();
        DynamicObjectType entryType = coll.getDynamicObjectType();
        DbMetadataTable entryTable = (DbMetadataTable)this.getDatabase().getTables().get(entryType.getAlias());
        DynamicObject rootEntity = coll.getRootEntity();
        Object parentPk = rootEntity.get("id");
        ReadWhere where = new ReadWhere(new Object[]{parentPk});
        ArrayList<DbMetadataTable> queryTables = new ArrayList<DbMetadataTable>();
        for (DbMetadataTable tableSchema : tables) {
            if (tableSchema == entryTable) {
                queryTables.add(tableSchema);
                this.createEntryPageInfo(startRowIndex, pageSize, tableSchema);
                continue;
            }
            if (!this.isRootParent(tableSchema, entryTable)) continue;
            queryTables.add(tableSchema);
            this.createEntryPageInfo(0, pageSize, tableSchema);
        }
        QuickDataSet dataSet = this.select(queryTables, this.getDataEntityTypeMap().getDbTable(), where);
        QuickDataTable entryDataTable = (QuickDataTable)dataSet.Tables.get(entryTable.getName());
        coll.clear();
        for (Object dataEnity : dataEntites = this.dataSetToEntities(null, entryDataTable, dataSet, entryTable.getDataEntityTypeMap())) {
            coll.add((Object)((DynamicObject)dataEnity));
        }
        coll.setStartRowIndex(startRowIndex);
        this.setEntryEntitySnapshot(rootEntity, dataSet);
        return dataEntites;
    }

    private void setEntryEntitySnapshot(Object rootDataEntity, QuickDataSet dataSet) {
        IDataEntityType dt = this.getDataEntityType();
        PkSnapshotSet pkSnapshotSet = dt.getPkSnapshot(rootDataEntity);
        for (PkSnapshot pkSnapshot : pkSnapshotSet.Snapshots) {
            QuickDataTable table = (QuickDataTable)dataSet.Tables.get(pkSnapshot.TableName);
            if (table == null) continue;
            int primaryColumnIndex = table.Schema.getPrimaryKey().getColumnIndex();
            QuickRow[] rows = table.Rows;
            pkSnapshot.Oids = new Object[rows.length];
            for (int j = 0; j < table.Rows.length; ++j) {
                pkSnapshot.Oids[j] = rows[j].Values[primaryColumnIndex];
            }
        }
    }

    private void createEntryPageInfo(int startRowIndex, int pageSize, DbMetadataTable tableSchema) {
        if (this.entryPageInfo == null) {
            this.entryPageInfo = new HashMap<DbMetadataTable, EntryInfo>();
        }
        EntryInfo pageInfo = new EntryInfo();
        pageInfo.setPageSize(pageSize);
        pageInfo.setStartRowIndex(startRowIndex);
        this.entryPageInfo.put(tableSchema, pageInfo);
    }

    private boolean isRootParent(DbMetadataTable tableSchema, DbMetadataTable parentableSchema) {
        DbMetadataRelation parentRelation = tableSchema.getParentRelation();
        while (parentRelation != null) {
            DbMetadataTable parentTable = parentRelation.getParentTable();
            if (parentTable == parentableSchema) {
                return true;
            }
            parentRelation = parentTable.getParentRelation();
        }
        return false;
    }

    @Override
    public List<Object> select(String where) {
        Object[] dataEntities = this.read(where);
        return this.createSnapshotCollection(dataEntities);
    }

    @Override
    public List<Object> select(List<Object> oids) {
        Object[] dataEntities = this.read(oids);
        return this.createSnapshotCollection(dataEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] read(ReadWhere where) {
        try {
            assert (where != null);
            QuickDataSet dataSet = this.readToDataSet(this.getDatabase(), this.getDataEntityTypeMap().getDbTable(), where);
            Object[] entities = this.dataSetToEntities(dataSet);
            this.privacyDataToEntities(entities, this.getDataEntityTypeMap());
            this.handlePrivacyDataEntities(entities, this.getDataEntityTypeMap());
            this.SetEntitySnapshot(entities, dataSet);
            Object[] objectArray = entities;
            return objectArray;
        }
        finally {
            this.releasePKTempTables(this.innerTempTableList);
        }
    }

    private void handlePrivacyDataEntities(Object[] dataEntities, DataEntityTypeMap dataEntityTypeMap) {
        if (!PrivacyDataCenterManager.isEnable() || dataEntities == null || dataEntities.length == 0) {
            return;
        }
        PrivacyDataCenterManager.getQueryService().read(this.dbRoute, (Object)dataEntityTypeMap, dataEntities);
    }

    private void privacyDataToEntities(Object[] dataEntities, DataEntityTypeMap dataEntityTypeMap) {
        IDataEntityType dt = dataEntityTypeMap.getDataEntityType();
        for (ComplexPropertyMap cpxPropMap : dataEntityTypeMap.getComplexProperties()) {
            ArrayList<Object> list = new ArrayList<Object>(16);
            Object[] cpxPropType = cpxPropMap.getDataEntityProperty();
            Object[] objectArray = dataEntities;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object obj = objectArray[i];
                list.add(cpxPropType.getValue(obj));
            }
            this.privacyDataToEntities(list.toArray(new Object[list.size()]), cpxPropMap.getComplexPropertyTypeMap());
        }
        for (Object colPropMap : dataEntityTypeMap.getCollectionProperties()) {
            ICollectionProperty colp = (ICollectionProperty)colPropMap.getDataEntityProperty();
            for (Object obj : dataEntities) {
                List list = (List)colp.getValue(obj);
                this.privacyDataToEntities(list.toArray(new Object[list.size()]), colPropMap.getCollectionItemPropertyTypeMap());
            }
        }
        ArrayList<IPrivacyProperty> privacyProperties = new ArrayList<IPrivacyProperty>(16);
        for (SimplePropertyMap splMap : dataEntityTypeMap.getSimpleProperties()) {
            IDataEntityProperty sp = splMap.getDataEntityProperty();
            if (!(sp instanceof IPrivacyProperty)) continue;
            privacyProperties.add((IPrivacyProperty)sp);
        }
        DataEntityPropertyCollection properties = dt.getProperties();
        HashMap<String, IDataEntityProperty> simpleProperties = new HashMap<String, IDataEntityProperty>(16);
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof ISimpleProperty)) continue;
            simpleProperties.put(prop.getName(), prop);
        }
        for (IPrivacyProperty privacyProperty : privacyProperties) {
            String controlFieldKey = privacyProperty.getOriginalPropKey();
            IDataEntityProperty originalProperty = (IDataEntityProperty)simpleProperties.get(controlFieldKey);
            IPrivacyDataService pds = privacyProperty.getPrivacyDataService();
            if (pds == null) continue;
            pds.loadPrivacyData(originalProperty, privacyProperty, dataEntities);
        }
    }

    private void SetEntitySnapshot(Object[] entities, QuickDataSet dataSet) {
        if (entities.length == 0) {
            return;
        }
        if (entities.length == 1) {
            this.SetSingleEntitySnapshot(entities, dataSet);
        } else {
            this.SetMoreEntitySnapshot(entities, dataSet);
        }
    }

    private void SetMoreEntitySnapshot(Object[] entities, QuickDataSet dataSet) {
        IDataEntityType dt = this.getDataEntityTypeMap().getDataEntityType();
        String rootTableName = this.getDataEntityTypeMap().getDbTable().getName();
        QuickDataTable rootTable = (QuickDataTable)dataSet.Tables.get(rootTableName);
        QuickRow[] rows = rootTable.Rows;
        int rowCount = rows.length;
        PkSnapshot pkSnap = null;
        RuntimePkSnapshotSet[] runtimeSets = new RuntimePkSnapshotSet[rowCount];
        int tableCount = dataSet.Tables.size();
        HashMap<Object, RuntimePkSnapshotSet> dict = new HashMap<Object, RuntimePkSnapshotSet>(rowCount);
        int primaryColumnIndex = rootTable.Schema.getPrimaryKey().getColumnIndex();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            RuntimePkSnapshotSet runtimeSet = new RuntimePkSnapshotSet();
            runtimeSet.PkSnapshotSet = new PkSnapshotSet(tableCount);
            runtimeSet.Tables = new RuntimePkSnapshot[tableCount];
            List snapshots = runtimeSet.PkSnapshotSet.Snapshots;
            for (int j = 0; j < tableCount; ++j) {
                PkSnapshot tempVar = new PkSnapshot();
                tempVar.TableName = ((QuickDataTable)dataSet.Tables.get((int)j)).Schema.getName();
                pkSnap = tempVar;
                snapshots.add(pkSnap);
                runtimeSet.Tables[j] = new RuntimePkSnapshot(pkSnap);
            }
            Object pkOid = rows[rowIndex].Values[primaryColumnIndex];
            runtimeSet.Tables[0].Oids.add(pkOid);
            try {
                dict.put(pkOid, runtimeSet);
            }
            catch (IllegalArgumentException e) {
                throw new ORMDesignException("03", BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_13", (String)"\u8868%1$s\u4e2d\u8bfb\u53d6\u51fa\u7684\u6570\u636e\uff0c\u51fa\u73b0\u91cd\u590d\u7684\u4e3b\u952e\u201c%2$s\u201d\u6570\u636e\uff1a%3$s\u3002", (Object[])new Object[]{rootTableName, rootTable.Schema.getPrimaryKey().getName(), pkOid}), (RuntimeException)e);
            }
            runtimeSets[rowIndex] = runtimeSet;
        }
        for (DbMetadataTable childTable : rootTable.Schema.getChildTables()) {
            this.SetEntitySnapshotEx(dataSet, (QuickDataTable)dataSet.Tables.get(childTable.getName()), dict);
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            runtimeSets[rowIndex].complete();
            dt.setPkSnapshot(entities[rowIndex], runtimeSets[rowIndex].PkSnapshotSet);
        }
    }

    private void SetSingleEntitySnapshot(Object[] entities, QuickDataSet dataSet) {
        PkSnapshotSet pkSnapshotSet = new PkSnapshotSet();
        Iterator iterator = dataSet.Tables.iterator();
        while (iterator.hasNext()) {
            EntryInfo entryInfo;
            QuickDataTable table = (QuickDataTable)iterator.next();
            int primaryColumnIndex = table.Schema.getPrimaryKey().getColumnIndex();
            QuickRow[] rows = table.Rows;
            PkSnapshot pkSnapshot = new PkSnapshot();
            pkSnapshot.TableName = table.Schema.getName();
            pkSnapshot.Oids = new Object[rows.length];
            for (int j = 0; j < table.Rows.length; ++j) {
                pkSnapshot.Oids[j] = rows[j].Values[primaryColumnIndex];
            }
            if (this.entryPageInfo != null && table.Schema.isSubEntry() && (entryInfo = this.entryPageInfo.get(table.Schema)) != null && pkSnapshot.Oids.length >= entryInfo.getPageSize()) {
                pkSnapshot.Opids = new Object[rows.length];
                int parentColumnIndex = table.Schema.getParentRelation().getChildColumn().getColumnIndex();
                for (int j = 0; j < table.Rows.length; ++j) {
                    pkSnapshot.Opids[j] = rows[j].Values[parentColumnIndex];
                }
            }
            pkSnapshotSet.Snapshots.add(pkSnapshot);
        }
        IDataEntityType dt = this.getDataEntityTypeMap().getDataEntityType();
        dt.setPkSnapshot(entities[0], pkSnapshotSet);
    }

    private void SetEntitySnapshotEx(QuickDataSet dataSet, QuickDataTable currentTable, HashMap<Object, RuntimePkSnapshotSet> pkDict) {
        EntryInfo entryInfo;
        RuntimePkSnapshotSet snapshotSet;
        int tableIndex = dataSet.findIndex(currentTable);
        DbMetadataTable tableSchema = currentTable.Schema;
        int parentColumnId = tableSchema.getParentRelation().getChildColumn().getColumnIndex();
        int pkColumnId = tableSchema.getPrimaryKey().getColumnIndex();
        DbMetadataTableCollection childTables = tableSchema.getChildTables();
        HashMap<Object, RuntimePkSnapshotSet> newPkDict = null;
        if (childTables.size() > 0) {
            newPkDict = new HashMap<Object, RuntimePkSnapshotSet>(currentTable.Rows.length);
        }
        for (QuickRow row : currentTable.Rows) {
            Object parentOid = row.Values[parentColumnId];
            Object pkOid = row.Values[pkColumnId];
            snapshotSet = pkDict.get(parentOid);
            if (snapshotSet == null) continue;
            snapshotSet.Tables[tableIndex].Oids.add(pkOid);
            if (newPkDict == null) continue;
            try {
                newPkDict.put(pkOid, snapshotSet);
            }
            catch (IllegalArgumentException e) {
                throw new ORMDesignException("04", BosRes.get((String)"bos-ormengine", (String)"DataManagerImplement_13", (String)"\u8868%1$s\u4e2d\u8bfb\u53d6\u51fa\u7684\u6570\u636e\uff0c\u51fa\u73b0\u91cd\u590d\u7684\u4e3b\u952e\u201c%2$s\u201d\u6570\u636e\uff1a%3$s\u3002", (Object[])new Object[]{currentTable.Schema.getName(), currentTable.Schema.getPrimaryKey().getName(), pkOid}), (RuntimeException)e);
            }
        }
        if (this.entryPageInfo != null && currentTable.Schema.isSubEntry() && (entryInfo = this.entryPageInfo.get(currentTable.Schema)) != null) {
            for (QuickRow row : currentTable.Rows) {
                Object parentOid = row.Values[parentColumnId];
                snapshotSet = pkDict.get(parentOid);
                RuntimePkSnapshot snapshot = snapshotSet.Tables[tableIndex];
                if (snapshot.Oids.size() < entryInfo.getPageSize()) continue;
                snapshot.parentIds.add(row.Values[parentColumnId]);
            }
        }
        if (newPkDict != null) {
            for (DbMetadataTable childTable : childTables) {
                this.SetEntitySnapshotEx(dataSet, (QuickDataTable)dataSet.Tables.get(childTable.getName()), newPkDict);
            }
        }
    }

    private DataEntityCollectionWithSnapshot<Object> createSnapshotCollection(Object[] dataEntities) {
        DataEntityCollectionWithSnapshot objs = new DataEntityCollectionWithSnapshot(null, Arrays.asList(dataEntities));
        objs.setPkSnapshot(this.createDataEntitiesSnapshot(dataEntities));
        return objs;
    }

    private PkSnapshot createDataEntitiesSnapshot(Object[] dataEntities) {
        PkSnapshot tempVar = new PkSnapshot();
        tempVar.TableName = this.getDataEntityTypeMap().getDbTable().getName();
        PkSnapshot snapshot = tempVar;
        ISimpleProperty pk = this.getDataEntityType().getPrimaryKey();
        Object[] oids = new Object[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            oids[i] = pk.getValueFast(dataEntities[i]);
        }
        snapshot.Oids = oids;
        return snapshot;
    }

    private Object[] dataSetToEntities(QuickDataSet dataSet) {
        Object[] entities = null;
        String rootTableName = this.getDataEntityTypeMap().getDbTable().getName();
        QuickDataTable rootTable = (QuickDataTable)dataSet.Tables.get(rootTableName);
        return this.dataSetToEntities(entities, rootTable, dataSet, this.getDataEntityTypeMap());
    }

    private Object[] dataSetToEntities(Object[] entities, QuickDataTable table, QuickDataSet dataSet, DataEntityTypeMap dtMap) {
        Object dataEntity;
        QuickRow[] rows = table.Rows;
        boolean isSupportInitialize = false;
        IDataEntityType dt = dtMap.getDataEntityType();
        if (entities == null) {
            entities = dt instanceof DynamicObjectType ? new DynamicObject[rows.length] : new Object[rows.length];
            for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
                entities[rowIndex] = dt.createInstance();
            }
        }
        if (entities.length == 0) {
            return entities;
        }
        boolean isFirstData = true;
        for (int i = 0; i < entities.length; ++i) {
            dataEntity = entities[i];
            if (dataEntity == null) continue;
            if (isFirstData) {
                if (!(dataEntity instanceof ISupportInitialize)) break;
                isSupportInitialize = true;
                isFirstData = false;
            }
            ((ISupportInitialize)dataEntity).beginInit();
        }
        for (SimplePropertyMap spMap : dtMap.getSimpleProperties()) {
            this.setSimplePropertyValues(entities, dtMap, rows, spMap);
        }
        for (CollectionPropertyMap colMap : dtMap.getCollectionProperties()) {
            this.setCollectionPropertyValues(entities, table, dataSet, colMap);
        }
        if (isSupportInitialize) {
            for (int i = 0; i < entities.length; ++i) {
                dataEntity = entities[i];
                if (dataEntity == null) continue;
                ((ISupportInitialize)dataEntity).endInit();
                dt.setFromDatabase(dataEntity);
            }
        } else {
            for (int i = 0; i < entities.length; ++i) {
                dataEntity = entities[i];
                if (dataEntity == null) continue;
                dt.setFromDatabase(dataEntity);
            }
        }
        return entities;
    }

    private void setCollectionPropertyValues(Object[] entities, QuickDataTable table, QuickDataSet dataSet, CollectionPropertyMap colMap) {
        int i;
        EntryInfo info;
        Object[] newEntities = null;
        DataEntityTypeMap newDtMap = colMap.getCollectionItemPropertyTypeMap();
        QuickDataTable newTable = (QuickDataTable)dataSet.Tables.get(newDtMap.getDbTable().getName());
        newEntities = this.dataSetToEntities(newEntities, newTable, dataSet, newDtMap);
        ICollectionProperty colp = (ICollectionProperty)colMap.getDataEntityProperty();
        boolean isSupportInitialize = false;
        boolean isFirstData = true;
        ISupportInitialize[] itemsList = new ISupportInitialize[entities.length];
        for (int i2 = 0; i2 < entities.length; ++i2) {
            ISupportInitialize spObject;
            Object dataEntity = entities[i2];
            if (dataEntity == null) continue;
            Object items = colp.getValueFast(dataEntity);
            if (isFirstData) {
                spObject = (ISupportInitialize)(items instanceof ISupportInitialize ? items : null);
                if (spObject == null) break;
                isSupportInitialize = true;
                isFirstData = false;
            }
            spObject = (ISupportInitialize)items;
            spObject.beginInit();
            itemsList[i2] = spObject;
        }
        IDataEntityType newDt = colp.getItemType();
        int parentColumnIndex = colMap.getParentColumn().getColumnIndex();
        QuickRow[] newRows = newTable.Rows;
        Map<Object, Integer> rowCountMap = newTable.getEntryRowCount();
        if (rowCountMap != null) {
            for (Map.Entry<Object, Integer> rowCount : rowCountMap.entrySet()) {
                Integer parentRowIndex = table.getRowIndexByParmaryKey(rowCount.getKey());
                if (parentRowIndex == null) continue;
                DataEntityBase parentObj = (DataEntityBase)entities[parentRowIndex];
                parentObj.getDataEntityState().setEntryRowCount(newDt.getName(), rowCount.getValue().intValue());
            }
        }
        if (this.entryPageInfo != null && (info = this.entryPageInfo.get(colMap.getCollectionItemPropertyTypeMap().getDbTable())) != null) {
            for (int i3 = 0; i3 < entities.length; ++i3) {
                DataEntityBase parentObj = (DataEntityBase)entities[i3];
                parentObj.getDataEntityState().setEntryPageSize(newDt.getName(), info.getPageSize());
                parentObj.getDataEntityState().setEntryStartRowIndex(newDt.getName(), info.getStartRowIndex());
            }
        }
        Object lastParentPKValue = null;
        List<Object> lastParentList = new ArrayList<Object>(16);
        for (i = 0; i < newEntities.length; ++i) {
            Object parentPKValue = newRows[i].Values[parentColumnIndex];
            if (parentPKValue == null) {
                log.error("parentPKValue is null");
            }
            if (parentPKValue != null && !parentPKValue.equals(lastParentPKValue)) {
                Integer parentRowIndex = table.getRowIndexByParmaryKey(parentPKValue);
                if (parentRowIndex == null) continue;
                lastParentList = (List)colp.getValue(entities[parentRowIndex]);
                lastParentPKValue = parentPKValue;
            }
            lastParentList.add(newEntities[i]);
        }
        if (isSupportInitialize) {
            for (i = 0; i < itemsList.length; ++i) {
                ISupportInitialize item = itemsList[i];
                if (item == null) continue;
                item.endInit();
            }
        }
    }

    private void setSimplePropertyValues(Object[] entities, DataEntityTypeMap dtMap, QuickRow[] rows, SimplePropertyMap spMap) {
        ISimpleProperty sp = (ISimpleProperty)spMap.getDataEntityProperty();
        int columnIndex = spMap.getDbColumn().getColumnIndex();
        for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
            QuickRow row = rows[rowIndex];
            Object entity = entities[rowIndex];
            Object value = row.Values[columnIndex];
            if (entity == null || value == null) continue;
            if (sp instanceof ILocaleProperty) {
                ((ILocaleProperty)sp).setGlangValue(entity, value);
                continue;
            }
            sp.setValueFast(entity, value);
        }
    }

    private QuickDataSet readToDataSet(DbMetadataDatabase database, DbMetadataTable rootTable, ReadWhere where) {
        DbMetadataTableCollection tables = database.getTables();
        if (this.pageSize != null) {
            this.entryPageInfo = new HashMap<DbMetadataTable, EntryInfo>();
            for (DbMetadataTable tableSchema : tables) {
                if (this.pageSize == null || tableSchema.getSeq() == null) continue;
                int startRow = this.startRowIndex;
                if (tableSchema.getParentRelation() != null && tableSchema.getParentRelation().getParentTable() != rootTable) {
                    startRow = 0;
                }
                this.createEntryPageInfo(startRow, this.pageSize, tableSchema);
            }
        }
        return this.select((Iterable<DbMetadataTable>)tables, rootTable, where);
    }

    protected SelectSql getSelectSQL(DbMetadataTable tableSchema, DbMetadataTable stopJoinTable) {
        return this.getSelectSQL(tableSchema, false, stopJoinTable);
    }

    protected String getSortSQL(DbMetadataTable tableSchema) {
        if (tableSchema.getSortColumns() == null) {
            return " ";
        }
        if (tableSchema.getSortColumns().size() == 0) {
            return " ";
        }
        StringBuilder sb = new StringBuilder(" ORDER BY ");
        for (String field : tableSchema.getSortColumns()) {
            sb.append(this.getColumnNameSql(tableSchema.getName(), field)).append(',');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public SelectSql getSelectSQL(DbMetadataTable tableSchema, boolean isAccess) {
        return this.getSelectSQL(tableSchema, isAccess, null);
    }

    public SelectSql getSelectSQL(DbMetadataTable currentTable, boolean isAccess, DbMetadataTable stopJoinTable) {
        DbMetadataColumn seq;
        String sqlFrom = this.getTableNameSql(currentTable.getName(), true);
        StringBuilder sqlWhere = new StringBuilder();
        StringBuilder sqlCount = new StringBuilder();
        StringBuilder sqlJoinWhere = new StringBuilder();
        ArrayList<SqlParameter> parameters = new ArrayList<SqlParameter>(2);
        ArrayList<SqlParameter> Joinparameters = new ArrayList<SqlParameter>(2);
        DbMetadataRelation parentRelation = currentTable.getParentRelation();
        DbMetadataTable childTable = currentTable;
        String parentField = null;
        if (this.entryPageInfo != null && (seq = currentTable.getSeq()) != null) {
            EntryInfo pageInfo = this.entryPageInfo.get(currentTable);
            if (pageInfo.getStartRowIndex() == 0) {
                parentField = this.getColumnNameSql(childTable.getName(), parentRelation.getChildColumn().getName());
                sqlCount.append(" SELECT ").append(parentField).append(", Count(*)   FROM ");
            }
            sqlWhere.append(this.getColumnNameSql(currentTable.getName(), seq.getName())).append(" BETWEEN ? AND ? ");
            parameters.add(new SqlParameter(4, (Object)(pageInfo.getStartRowIndex() + 1)));
            parameters.add(new SqlParameter(4, (Object)(pageInfo.getStartRowIndex() + pageInfo.getPageSize())));
        }
        StringBuilder sbFrom = new StringBuilder(sqlFrom);
        while (parentRelation != null) {
            DbMetadataColumn seq2;
            DbMetadataTable parentTable = parentRelation.getParentTable();
            if (parentTable != stopJoinTable) {
                sbFrom.insert(0, isAccess ? "(" : " ").append(" INNER JOIN ").append(this.getTableNameSql(parentTable.getName(), true)).append(" ON ").append(this.getColumnNameSql(childTable.getName(), parentRelation.getChildColumn().getName())).append(" = ").append(this.getColumnNameSql(parentTable.getName(), parentTable.getPrimaryKey().getName())).append(isAccess ? ")" : " ");
            }
            if (this.entryPageInfo != null && (seq2 = parentTable.getSeq()) != null) {
                EntryInfo pageInfo = this.entryPageInfo.get(parentTable);
                if (sqlJoinWhere.length() > 0) {
                    sqlJoinWhere.append(AND);
                }
                sqlJoinWhere.append(this.getColumnNameSql(parentTable.getName(), seq2.getName())).append(" BETWEEN ? AND ? ");
                Joinparameters.add(new SqlParameter(4, (Object)(pageInfo.getStartRowIndex() + 1)));
                Joinparameters.add(new SqlParameter(4, (Object)(pageInfo.getStartRowIndex() + pageInfo.getPageSize())));
            }
            childTable = parentRelation.getParentTable();
            parentRelation = childTable.getParentRelation();
        }
        ArrayList<String> tableGroups = this.getTableGroups(currentTable);
        if (tableGroups.size() > 0) {
            String temp = " ON " + this.getColumnNameSql(currentTable.getName(), currentTable.getPrimaryKey().getName()) + " = ";
            for (String tableGroup : tableGroups) {
                String exTableName = currentTable.getName() + "_" + tableGroup;
                sbFrom.insert(0, isAccess ? "(" : " ").append(" LEFT JOIN ").append(this.getTableNameSql(exTableName, true)).append(temp).append(this.getColumnNameSql(exTableName, currentTable.getPrimaryKey().getName())).append(isAccess ? ")" : " ");
            }
        }
        StringBuilder sqlColumns = new StringBuilder(currentTable.getColumns().size() * 40);
        sqlColumns.append("SELECT ");
        boolean isFirst = true;
        for (DbMetadataColumn column : currentTable.getColumns()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sqlColumns.append(',');
            }
            sqlColumns.append(this.getColumnNameSql(currentTable, column));
        }
        sqlColumns.append(" FROM ");
        sqlColumns.append((CharSequence)sbFrom);
        SelectSql selectSql = new SelectSql();
        if (parentField != null) {
            sqlCount.append((CharSequence)sbFrom).append(" %s ");
            selectSql.CountGroupBySqlpart = " GROUP BY " + parentField + " ";
        }
        selectSql.SelectSqlStr = sqlColumns.toString();
        if (sqlJoinWhere.length() > 0) {
            if (sqlWhere.length() > 0) {
                sqlWhere.append(AND).append((CharSequence)sqlJoinWhere);
            } else {
                sqlWhere.append((CharSequence)sqlJoinWhere);
            }
        }
        selectSql.SelectWhere = sqlWhere.toString();
        parameters.addAll(Joinparameters);
        selectSql.SelectParams = parameters;
        selectSql.CountSql = sqlCount.toString();
        selectSql.CountWhere = sqlJoinWhere.toString();
        selectSql.CountParams = Joinparameters;
        return selectSql;
    }

    public String getTableNameSql(String name, boolean withAlias) {
        return this.aliasGenner.getTableName(name, withAlias);
    }

    public String getColumnNameSql(String tableName, String columnName) {
        return this.aliasGenner.getAlias(tableName) + '.' + columnName;
    }

    public String getColumnNameSql(DbMetadataTable currentTable, DbMetadataColumn column) {
        if (StringUtils.isEmpty((CharSequence)column.getTableGroup())) {
            return this.getColumnNameSql(currentTable.getName(), column.getName());
        }
        return this.getColumnNameSql(currentTable.getName() + '_' + column.getTableGroup(), column.getName());
    }

    private ArrayList<String> getTableGroups(DbMetadataTable currentTable) {
        ArrayList<String> result = new ArrayList<String>();
        for (DbMetadataColumn column : currentTable.getColumns()) {
            if (!StringUtils.isNotEmpty((CharSequence)column.getTableGroup()) || result.contains(column.getTableGroup())) continue;
            result.add(column.getTableGroup());
        }
        return result;
    }

    public final QuickDataSet select(List<DbMetadataTable> queryTables, DbMetadataTable entryTable, ReadWhere where, DataEntityTypeMap dataEntityTypeMap) {
        return this.select(queryTables, entryTable, where);
    }

    public final QuickDataSet select(Iterable<DbMetadataTable> tablesSchema, DbMetadataTable rootTable, ReadWhere where) {
        try (TemptableFacadeContext temptableContext = TemptableFacadeContexts.create((String)"DataManagerImplement.select");){
            Collection tables = (Collection)tablesSchema;
            ArrayList<SelectSql> selectSQLAll = new ArrayList<SelectSql>(tables.size());
            ArrayList<String> rootJoinTempTableStrList = new ArrayList<String>(2);
            SqlBuilder whereSql = this.getRootTableWhereSQl(rootTable, where, rootJoinTempTableStrList);
            for (DbMetadataTable tableSchema : tablesSchema) {
                DbMetadataTable stopJoinTable = null;
                ArrayList<String> joinTempTableStrList = new ArrayList<String>(2);
                if (tableSchema != rootTable) {
                    SqlBuilder whereSqlChild = this.getChildTableWhereSQl(tableSchema, rootTable, where, whereSql, joinTempTableStrList);
                    if (whereSqlChild != whereSql) {
                        stopJoinTable = rootTable;
                        whereSql = whereSqlChild;
                    } else {
                        joinTempTableStrList.addAll(rootJoinTempTableStrList);
                    }
                } else {
                    joinTempTableStrList.addAll(rootJoinTempTableStrList);
                }
                SelectSql tupSQL = this.getSelectSQL(tableSchema, stopJoinTable);
                SqlBuilder selectSql = new SqlBuilder();
                selectSql.append("/*ORM*/ ", new Object[0]).append(tupSQL.SelectSqlStr, new Object[0]);
                for (String join : joinTempTableStrList) {
                    selectSql.append(join, new Object[0]);
                }
                if (!whereSql.isEmpty()) {
                    selectSql.append(" WHERE ", new Object[0]);
                    selectSql.appendSqlBuilder(whereSql);
                    if (tupSQL.SelectWhere.length() > 0) {
                        selectSql.append(AND, new Object[0]).append(tupSQL.SelectWhere, tupSQL.SelectParams != null ? tupSQL.SelectParams.toArray() : null);
                    }
                } else if (tupSQL.SelectWhere.length() > 0) {
                    selectSql.append(" WHERE ", new Object[0]).append(tupSQL.SelectWhere, tupSQL.SelectParams != null ? tupSQL.SelectParams.toArray() : null);
                }
                String sqlCount = tupSQL.CountSql;
                SqlBuilder countBuild = new SqlBuilder();
                if (sqlCount.length() > 0 && !whereSql.isEmpty()) {
                    sqlCount = String.format(sqlCount, " WHERE ");
                    countBuild.append("/*ORM*/ ", new Object[0]).append(sqlCount, new Object[0]).appendSqlBuilder(whereSql).append(tupSQL.CountWhere.length() > 0 ? AND + tupSQL.CountWhere : " ", tupSQL.CountParams != null ? tupSQL.CountParams.toArray() : null).append(StringUtils.isBlank((CharSequence)tupSQL.CountGroupBySqlpart) ? " " : tupSQL.CountGroupBySqlpart, new Object[0]);
                }
                selectSql.append(this.getSortSQL(tableSchema), new Object[0]);
                tupSQL.SelectSqlBuild = selectSql;
                tupSQL.CountSqlBuild = countBuild;
                selectSQLAll.add(tupSQL);
            }
            QuickDataSet quickDataSet = this.executeReader(tablesSchema, rootTable, selectSQLAll, where, this.innerTempTableList);
            return quickDataSet;
        }
    }

    private SqlBuilder getRootTableWhereSQl(DbMetadataTable rootTable, ReadWhere where, List<String> joinTempTableStrList) {
        SqlBuilder build = new SqlBuilder();
        String pk = this.getColumnNameSql(rootTable.getName(), rootTable.getPrimaryKey().getName());
        if (where.getIsSingleValue()) {
            SqlParameter pkValueParameter = new SqlParameter(":PKValue", rootTable.getPrimaryKey().getDbType(), where.getReadOids()[0]);
            build.append(pk + "= ?", new Object[]{pkValueParameter});
        } else if (where.getReadOids() != null) {
            build.appendSqlBuilder(this.GetIdsWhereSql(rootTable.getPrimaryKey().getDbType(), rootTable.getName(), pk, where, joinTempTableStrList));
        }
        if (!StringUtils.isBlank((CharSequence)where.getWhereSql())) {
            if (!build.isEmpty()) {
                build.append(AND, new Object[0]);
            }
            build.append(where.getWhereSql(), where.getSqlParams() != null ? where.getSqlParams().toArray() : null);
        }
        return build;
    }

    private SqlBuilder getChildTableWhereSQl(DbMetadataTable childTable, DbMetadataTable rootTable, ReadWhere where, SqlBuilder rootwhereSql, List<String> joinTempTableStrList) {
        if (!StringUtils.isBlank((CharSequence)where.getWhereSql())) {
            return rootwhereSql;
        }
        SqlBuilder whereSql = new SqlBuilder();
        DbMetadataTable table = childTable;
        while (rootTable != table.getParentRelation().getParentTable()) {
            table = table.getParentRelation().getParentTable();
        }
        String pk = this.getColumnNameSql(table.getName(), table.getParentRelation().getChildColumn().getName());
        if (where.getIsSingleValue()) {
            SqlParameter pkValueParameter = new SqlParameter(":PKValue", rootTable.getPrimaryKey().getDbType(), where.getReadOids()[0]);
            whereSql.append(pk + "= ?", new Object[]{pkValueParameter});
        } else if (where.getReadOids() != null) {
            whereSql.appendSqlBuilder(this.GetIdsWhereSql(table.getParentRelation().getChildColumn().getDbType(), table.getName(), pk, where, joinTempTableStrList));
        }
        return whereSql;
    }

    private SqlBuilder GetIdsWhereSql(int pkDbType, String tableName, String fieldName, ReadWhere where, List<String> joinTempTableStrList) {
        Object[] ids = where.getReadOids();
        SqlBuilder build = new SqlBuilder();
        if (ids == null || ids.length == 0) {
            build.append(S_NO_DATA_FILTER, new Object[0]);
            return build;
        }
        String str = System.getProperty("orm.dataentitymanager.idjoin.enable");
        boolean enableInnerJoin = false;
        if (str == null || "true".equals(str)) {
            enableInnerJoin = StringUtils.isBlank((CharSequence)where.getWhereSql());
        }
        if (!ThreadReadWriteContext.isAllowUseTempTable()) {
            enableInnerJoin = false;
        }
        if (HugeInConfig.isEnableOpt() && ids.length > HugeInConfig.inThreshold() && enableInnerJoin) {
            ThreadReadWriteContext.forceSetWriteMode();
            List<Object> tempIdDatas = Arrays.asList(ids);
            List insertDatas = tempIdDatas.stream().distinct().collect(Collectors.toList());
            HugeInConfig.limitInSize(insertDatas.size());
            TemptableFacade temptableFacade = ids[0] instanceof String ? TemptableFacades.create((TemptableType)TemptableType.BIG_STRING) : TemptableFacades.create((TemptableType)TemptableType.PK_LONG);
            this.innerTempTableList.add(temptableFacade);
            TemptableFacadeContexts.get().add(temptableFacade);
            temptableFacade.insert(insertDatas);
            String tempTableAlias = this.aliasGenner.getAlias(temptableFacade.getName());
            String joinSQL = "INNER JOIN " + temptableFacade.getName() + ' ' + tempTableAlias + " ON " + tempTableAlias + ".FID =" + fieldName + " ";
            joinTempTableStrList.add(joinSQL);
            build.append(" 1=1 ", new Object[0]);
        } else {
            build.appendIn(fieldName, ids);
        }
        return build;
    }

    public String getConnectionString() {
        return this.privateConnectionString;
    }

    public void setConnectionString(String value) {
        this.privateConnectionString = value;
    }

    protected QuickDataSet executeReader(Iterable<DbMetadataTable> tablesSchema, DbMetadataTable rootTable, List<SelectSql> selectSqls, ReadWhere where, List<TemptableFacade> tempTableList) {
        int idx = 0;
        QuickDataSet ds = new QuickDataSet();
        for (DbMetadataTable tableSchema : tablesSchema) {
            QuickDataTable table = new QuickDataTable(tableSchema);
            if (!(!this.selectHeadOnly || tableSchema == rootTable || tableSchema.isLocale() && StringUtils.equalsIgnoreCase((CharSequence)tableSchema.getName(), (CharSequence)(rootTable.getName() + "_l")))) {
                table.Rows = new QuickRow[0];
            } else {
                EntryInfo entryInfo;
                QuickRowSetCallBack action = new QuickRowSetCallBack(tableSchema);
                SelectSql selectInfo = selectSqls.get(idx);
                List<QuickRow> rows = this.doExecute(selectInfo.SelectSqlBuild, where, tableSchema, rootTable, action);
                table.Rows = rows.toArray(new QuickRow[rows.size()]);
                if (this.entryPageInfo != null && (entryInfo = this.entryPageInfo.get(tableSchema)) != null && table.Rows.length >= entryInfo.getPageSize() && !selectInfo.CountSqlBuild.isEmpty()) {
                    table.setEntryRowCount(this.doExecute(selectInfo.CountSqlBuild, where, tableSchema, rootTable, new RowCountSetCallBack()));
                }
            }
            ds.Tables.add(table);
            ++idx;
        }
        this.releasePKTempTables(tempTableList);
        return ds;
    }

    private void releasePKTempTables(List<TemptableFacade> tempTableList) {
        if (tempTableList == null || tempTableList.isEmpty()) {
            return;
        }
        ORMUtil.__releaseTemptable(tempTableList);
        tempTableList.clear();
    }

    private <T> T doExecute(SqlBuilder builder, ReadWhere where, DbMetadataTable tableSchema, DbMetadataTable rootTable, ResultSetHandler<T> action) {
        return (T)DB.query((DBRoute)this.dbRoute, (SqlBuilder)builder, action);
    }

    private Object toArray(int dbType, Object[] value) {
        Object[] ids;
        switch (dbType) {
            case -9: 
            case 12: {
                String[] idsStr = new String[value.length];
                for (int i = 0; i < value.length; ++i) {
                    idsStr[i] = String.valueOf(value[i]);
                }
                ids = idsStr;
                break;
            }
            case 5: {
                short[] idsInt16 = new short[value.length];
                for (int i = 0; i < value.length; ++i) {
                    idsInt16[i] = (Short)value[i];
                }
                ids = idsInt16;
                break;
            }
            case 4: {
                int[] idsInt32 = new int[value.length];
                for (int i = 0; i < value.length; ++i) {
                    idsInt32[i] = (Integer)value[i];
                }
                ids = idsInt32;
                break;
            }
            case -5: {
                long[] idsInt64 = new long[value.length];
                for (int i = 0; i < value.length; ++i) {
                    idsInt64[i] = (Long)value[i];
                }
                ids = idsInt64;
                break;
            }
            default: {
                ids = value;
            }
        }
        return ids;
    }

    @Override
    public void setStartRowIndex(int start) {
        this.startRowIndex = start;
    }

    @Override
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void setOption(OperateOption value) {
        this.option = value;
        if (this.currentUserId != null) {
            this.option.setVariableValue("currentUserId", this.currentUserId.toString());
        }
        if (this.option != null) {
            this.updateModify = Boolean.parseBoolean(this.option.getVariableValue("updateModifyDate", "true"));
            this.operateKey = this.option.getVariableValue("operateKey", "");
            this.option.setVariableValue("enableUpdateModifierNew", String.valueOf(this.enableUpdateModifierNew));
            this.option.setVariableValue("enableUpdateModifierAudit", String.valueOf(this.enableUpdateModifierAudit));
        }
    }
}

