/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IDeleteMetaRow;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.metadata.RowOperateType;
import kd.bos.dataentity.metadata.database.DbMetadataDatabase;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.IEventService;
import kd.bos.orm.datamanager.SaveDataSet;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.JSONUtils;

public class EventServiceImpl
implements IEventService {
    private static final String TABLE_NAME = "tablename";
    private static final String INSERT = "insert";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String TYPE = "type";
    private static final String DATA = "data";
    private static final Log logger = LogFactory.getLog(EventServiceImpl.class);
    private static Class<?> eventServiceClass;
    private static Method triggerEventSubscribeMethod;
    private static boolean enable;

    private static void initEventServiceClass() {
        try {
            eventServiceClass = Class.forName("kd.bos.servicehelper.workflow.EventServiceHelper");
            triggerEventSubscribeMethod = eventServiceClass.getMethod("triggerEventSubscribe", String.class, String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            logger.warn("get EventServiceHelper class error ", (Throwable)ex);
            enable = false;
        }
    }

    @Override
    public void sendSaveEvent(SaveDataSet sds, IDataEntityType dataEntityType) {
        if (!this.isEnable()) {
            return;
        }
        if (sds == null) {
            return;
        }
        if (this.disableDBRecord(dataEntityType)) {
            return;
        }
        ArrayList list = new ArrayList(16);
        for (ISaveDataTable table : sds.getTables()) {
            ISaveMetaRow[] saveRows = table.getSaveRows();
            ArrayList<Object> insertList = new ArrayList<Object>(16);
            ArrayList<Object> updateList = new ArrayList<Object>(16);
            if (saveRows != null) {
                for (ISaveMetaRow saveRow : saveRows) {
                    if (saveRow.getOperate() == RowOperateType.Insert) {
                        insertList.add(saveRow.getOid().getValue());
                        continue;
                    }
                    updateList.add(saveRow.getOid().getValue());
                }
            }
            ArrayList<Object> deleteList = new ArrayList<Object>(16);
            IDeleteMetaRow[] deleteRows = table.getDeleteRows();
            if (deleteRows != null) {
                for (IDeleteMetaRow deleteRow : deleteRows) {
                    deleteList.add(deleteRow.getOid());
                }
            }
            String tableName = table.getSchema().getName();
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put(TABLE_NAME, tableName);
            map.put(INSERT, insertList.toArray());
            map.put(UPDATE, updateList.toArray());
            map.put(DELETE, deleteList.toArray());
            list.add(map);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(ENTITY_NUMBER, dataEntityType.getName());
        map.put(TYPE, "save");
        map.put(DATA, list);
        try {
            this.triggerEventSubscribe("ormsave", JSONUtils.toString(map));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean disableDBRecord(IDataEntityType dataEntityType) {
        if (dataEntityType == null) {
            return true;
        }
        if (dataEntityType.getDBRouteKey().equals(DBRoute.meta.getRouteKey()) || dataEntityType.getDBRouteKey().equals(DBRoute.workflow.getRouteKey()) || dataEntityType.getDBRouteKey().equals("wfs")) {
            return true;
        }
        return !dataEntityType.isTriggerDBRecord();
    }

    @Override
    public void sendDeleteEvent(Object[] ids, DbMetadataDatabase database, IDataEntityType dataEntityType) {
        if (!this.isEnable()) {
            return;
        }
        if (ids == null || ids.length == 0) {
            return;
        }
        if (this.disableDBRecord(dataEntityType)) {
            return;
        }
        ArrayList list = new ArrayList(database.getTables().size());
        for (DbMetadataTable table : database.getTables()) {
            HashMap<String, String> mapData = new HashMap<String, String>(16);
            mapData.put(TABLE_NAME, table.getName());
            list.add(mapData);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(ENTITY_NUMBER, dataEntityType.getName());
        map.put(TYPE, DELETE);
        map.put("ids", ids);
        map.put(DATA, list);
        try {
            this.triggerEventSubscribe("ormsave", JSONUtils.toString(map));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEnable() {
        return enable;
    }

    private void triggerEventSubscribe(String eventNumber, String json) {
        if (!enable) {
            return;
        }
        try {
            triggerEventSubscribeMethod.invoke(null, eventNumber, json);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        String notifysave = System.getProperty("orm.notifysave", "false");
        if ("true".equalsIgnoreCase(notifysave)) {
            enable = true;
            EventServiceImpl.initEventServiceClass();
        } else {
            enable = false;
        }
        ConfigurationUtil.observeBoolean((String)"orm.notifysave", (boolean)false, value -> {
            enable = value;
            if (enable) {
                EventServiceImpl.initEventServiceClass();
            }
        });
    }
}

