/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.db.DBRoute;
import kd.bos.orm.dataentity.BatchInsertTaskContainer;
import kd.bos.orm.dataentity.BatchUpdateSeqTask;
import kd.bos.orm.dataentity.BatchUpdateTaskContainer;
import kd.bos.orm.dataentity.CRUDHelper;
import kd.bos.orm.dataentity.IDatabaseTask;
import kd.bos.orm.dataentity.SqlTask;
import kd.bos.orm.dataentity.SyncFormModelTableTask;

class OrmDBTasks {
    private List<IDatabaseTask> lstSqlObj = new ArrayList<IDatabaseTask>();
    private DBRoute dbRoute;
    private BatchInsertTaskContainer batchInsertTaskContainer;
    private BatchUpdateTaskContainer batchUpdateTaskContainer;
    private boolean isBatch;

    public OrmDBTasks(boolean isBatch, DBRoute dbRoute) {
        this.isBatch = isBatch;
        this.dbRoute = dbRoute;
        if (isBatch) {
            this.batchInsertTaskContainer = new BatchInsertTaskContainer(dbRoute);
            this.batchUpdateTaskContainer = new BatchUpdateTaskContainer(dbRoute);
        }
    }

    public void insert(DbMetadataTable table, IColumnValuePair[] inputValues, IColumnValuePair[] outputValues, IColumnValuePair oid) {
        if (this.isBatch) {
            this.batchInsertTaskContainer.insert(table, inputValues, oid);
        } else {
            this.addDbTasks(CRUDHelper.insert(this.dbRoute, table, inputValues, outputValues, oid));
        }
    }

    public void update(ISaveDataTable table, ISaveMetaRow saveRow) {
        if (this.isBatch) {
            this.batchUpdateTaskContainer.update(table, saveRow);
        } else {
            this.addDbTasks(CRUDHelper.update(this.dbRoute, table.getSchema(), saveRow.getDirtyValues().toArray(new IColumnValuePair[0]), saveRow.getOid(), saveRow.getVersion()));
        }
    }

    public List<SqlTask> delete(DbMetadataTable table, Object[] oids, Object[] originalVersions) {
        List<SqlTask> tasks = CRUDHelper.delete(this.dbRoute, table, oids, originalVersions);
        this.addDbTasks(tasks);
        return tasks;
    }

    public void commitDbTask() {
        if (this.batchInsertTaskContainer != null) {
            for (IDatabaseTask dbTask : this.batchInsertTaskContainer.createTasks()) {
                this.addDbTask(dbTask);
            }
            this.batchInsertTaskContainer = null;
        }
        if (this.batchUpdateTaskContainer != null) {
            for (IDatabaseTask dbTask : this.batchUpdateTaskContainer.createTasks()) {
                this.addDbTask(dbTask);
            }
            this.batchUpdateTaskContainer = null;
        }
        this.executeDbTasks(this.lstSqlObj);
    }

    private void executeDbTasks(List<IDatabaseTask> tasks) {
        Collections.sort(tasks, new Comparator<IDatabaseTask>(){

            @Override
            public int compare(IDatabaseTask o1, IDatabaseTask o2) {
                return Integer.compare(o1.getLevel(), o2.getLevel());
            }
        });
        for (IDatabaseTask item : tasks) {
            item.execute();
        }
    }

    private void addDbTasks(Collection<SqlTask> dbTasks) {
        for (SqlTask task : dbTasks) {
            this.addDbTask(task);
        }
    }

    private void addDbTask(IDatabaseTask dbTask) {
        this.lstSqlObj.add(dbTask);
    }

    public BatchUpdateSeqTask updateSeq(DbMetadataTable table, List<ThreeTuple<Object, Object, Integer>> list) {
        BatchUpdateSeqTask dbTask = new BatchUpdateSeqTask(this.dbRoute, table, list);
        this.addDbTask(dbTask);
        return dbTask;
    }

    public SyncFormModelTableTask syncFormModelTable(DbMetadataTable table, String formmodeltable, List<ThreeTuple<Object, Object, Integer>> list) {
        SyncFormModelTableTask dbTask = new SyncFormModelTableTask(this.dbRoute, table, formmodeltable, list);
        this.addDbTask(dbTask);
        return dbTask;
    }
}

