/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.db.ResultSetHandler;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.dataentity.FieldReaders;
import kd.bos.orm.dataentity.IFieldReader;
import kd.bos.orm.datamanager.QuickRow;

public class QuickRowSetCallBack
implements ResultSetHandler<List<QuickRow>> {
    private ConverterPair[] converters;

    public QuickRowSetCallBack(DbMetadataTable tableSchema) {
        this.converters = this.getConverters(tableSchema);
    }

    public List<QuickRow> handle(ResultSet rs) throws SQLException {
        ArrayList<QuickRow> rows = new ArrayList<QuickRow>();
        try {
            int columnCount = this.converters.length;
            while (rs.next()) {
                QuickRow row = new QuickRow();
                row.Values = new Object[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    row.Values[i - 1] = this.converters[i - 1].get(rs, i);
                }
                rows.add(row);
            }
        }
        catch (SQLException e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
        }
        return rows;
    }

    private ConverterPair[] getConverters(DbMetadataTable tableSchema) {
        ConverterPair[] pairs = new ConverterPair[tableSchema.getColumns().size()];
        int i = 0;
        for (DbMetadataColumn column : tableSchema.getColumns()) {
            ConverterPair pair = new ConverterPair();
            pair.column = column;
            pair.fieldReader = FieldReaders.get(column.getClrType());
            pairs[i] = pair;
            ++i;
        }
        return pairs;
    }

    private static final class ConverterPair {
        private DbMetadataColumn column;
        private IFieldReader fieldReader;

        private ConverterPair() {
        }

        public Object get(ResultSet rs, int colIndex) {
            try {
                if (this.column.getEncrypt()) {
                    Object value = this.column.getEnableNull() ? this.fieldReader.get(rs, this.column, colIndex) : this.fieldReader.get(rs, this.column.getDbType(), colIndex);
                    return value == null ? null : Encrypters.decode((String)String.valueOf(value));
                }
                if (this.column.getEnableNull()) {
                    return this.fieldReader.get(rs, this.column, colIndex);
                }
                return this.fieldReader.get(rs, this.column.getDbType(), colIndex);
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{BosRes.get((String)"bos-ormengine", (String)"QuickRowSetCallBack_0", (String)"\u5b57\u6bb5\u503c\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u5b57\u6bb5\u540d\uff1a%1$s\uff0c%2$s\u3002", (Object[])new Object[]{this.column.getName(), e.getMessage()})});
            }
        }
    }
}

