/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.orm.dataentity.BatchUpdateSeqTask;
import kd.bos.orm.dataentity.IDatabaseTask;
import kd.bos.xdb.hint.ShardingHintContext;

public class SyncFormModelTableTask
implements IDatabaseTask {
    private static final String PAGEID = "pageid";
    private static final String ENTRYKEY = "entrykey";
    private static final String TEMPTABLE = "temptable";
    private static final String EPKFIELD = "epkfield";
    private static final String FSEQ = "fseq";
    private static final String FOLD_SEQ = "fold_seq";
    private static final String FENTRYID = "fentryid";
    private static final String FENTRYID1 = "fentryid1";
    private static final String FENTRYID2 = "fentryid2";
    private static final int batchSize = 5000;
    private DBRoute dbRoute;
    private DbMetadataTable table;
    private ShardingHintContext ctx;
    private List<ThreeTuple<Object, Object, Integer>> changeRows;
    private BatchUpdateSeqTask updateSeqTask;
    private String formModelTableParma;
    private Map<String, String> params = null;

    public SyncFormModelTableTask(DBRoute dbRoute, DbMetadataTable table, String formModelTableParma, List<ThreeTuple<Object, Object, Integer>> changeRows) {
        this.dbRoute = dbRoute;
        this.table = table;
        this.formModelTableParma = formModelTableParma;
        this.changeRows = changeRows;
        this.parasParams();
    }

    private void parasParams() {
        if (StringUtils.isBlank((CharSequence)this.formModelTableParma)) {
            if (this.changeRows != null && this.changeRows.size() > 0) {
                this.updateSeqTask = new BatchUpdateSeqTask(this.dbRoute, this.table, this.changeRows);
            }
            return;
        }
        Map tempTableParams = (Map)SerializationUtils.fromJsonString((String)this.formModelTableParma, Map.class);
        String pageId = (String)tempTableParams.get(PAGEID);
        String entryKey = (String)tempTableParams.get(ENTRYKEY);
        String tempTableName = (String)tempTableParams.get(TEMPTABLE);
        String entryPkField = (String)tempTableParams.get(EPKFIELD);
        if (pageId == null || entryKey == null || tempTableName == null || entryPkField == null) {
            if (this.changeRows != null && this.changeRows.size() > 0) {
                this.updateSeqTask = new BatchUpdateSeqTask(this.dbRoute, this.table, this.changeRows);
            }
        } else {
            this.params = tempTableParams;
        }
    }

    @Override
    public int execute() {
        if (this.updateSeqTask != null) {
            return this.updateSeqTask.execute();
        }
        if (this.params == null) {
            return 0;
        }
        String pageId = this.params.get(PAGEID);
        String entryKey = this.params.get(ENTRYKEY);
        String tempTableName = this.params.get(TEMPTABLE);
        String entryPkField = this.params.get(EPKFIELD);
        if (pageId == null || entryKey == null || tempTableName == null || entryPkField == null) {
            return 0;
        }
        String delSql = String.format("DELETE FROM %s WHERE fpageid = ? and fentrykey = ? and fisdel = ?", tempTableName);
        SqlParameter[] delParams = new SqlParameter[]{new SqlParameter(PAGEID, 12, (Object)pageId), new SqlParameter(ENTRYKEY, 12, (Object)entryKey), new SqlParameter("fisdel", 12, (Object)"1")};
        this.executeSql(delSql, delParams);
        DbMetadataColumn pkcol = this.table.getPrimaryKey();
        if (pkcol.getDbType() == -5) {
            this.executeForLongPK(tempTableName, pageId, entryKey, entryPkField);
        } else {
            this.executeForVarcharPK(tempTableName, pageId, entryKey, entryPkField);
        }
        return 0;
    }

    private void executeForLongPK(String tempTableName, String pageId, String entryKey, String entryPkField) {
        DbMetadataColumn pkcol = this.table.getPrimaryKey();
        DbMetadataColumn seqCol = this.table.getSeq();
        String updateByEntryId = String.format("UPDATE %s SET %s = ? WHERE %s = ?", this.table.getName(), seqCol.getName(), pkcol.getName());
        ArrayList<Object> updateByEntryIdParams = new ArrayList<Object[]>(5000);
        String updateByRange = String.format("UPDATE %s SET %s = %s + ? WHERE %s >= ? and %s <= ?", this.table.getName(), seqCol.getName(), seqCol.getName(), pkcol.getName(), pkcol.getName());
        ArrayList<Object> updateByRangeParams = new ArrayList<Object[]>(5000);
        String selectSeq = String.format("SELECT A.%s, A.%s as %s, B.fseq   FROM %s A INNER JOIN %s B on A.%s = B.%s  WHERE B.fpageid = ? and B.fentrykey = ? and B.fseq != A.%s  ORDER BY A.%s", pkcol.getName(), seqCol.getName(), FOLD_SEQ, this.table.getName(), tempTableName, pkcol.getName(), entryPkField, seqCol.getName(), pkcol.getName());
        Object[] selectSeqParams = new SqlParameter[]{new SqlParameter(PAGEID, 12, (Object)pageId), new SqlParameter(ENTRYKEY, 12, (Object)entryKey)};
        Long beginEntryId = null;
        Long preEntryId = null;
        int preSeq = 0;
        int preSeqDiff = 0;
        try (DataSet dataSet = DB.queryDataSet((String)(this.getClass().getName() + ".executeForLongPK"), (DBRoute)this.dbRoute, (String)selectSeq, (Object[])selectSeqParams);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long entryId = row.getLong(pkcol.getName());
                int oldSeq = row.getInteger(FOLD_SEQ);
                int seq = row.getInteger(FSEQ);
                if (preEntryId == null) {
                    beginEntryId = entryId;
                    preEntryId = entryId;
                    preSeq = seq;
                    preSeqDiff = seq - oldSeq;
                } else {
                    int seqDiff = seq - oldSeq;
                    if (Long.compare(preEntryId, entryId - 1L) != 0 || preSeqDiff != seqDiff) {
                        if (Long.compare(preEntryId, beginEntryId) == 0) {
                            updateByEntryIdParams.add(this.buildUpdateParamsByEntryId(preEntryId, preSeq));
                        } else {
                            updateByRangeParams.add(this.buildUpdateParamsRange(beginEntryId, preEntryId, preSeqDiff));
                        }
                        beginEntryId = entryId;
                    }
                    preEntryId = entryId;
                    preSeq = seq;
                    preSeqDiff = seq - oldSeq;
                }
                if (updateByEntryIdParams.size() >= 5000) {
                    this.executeBatchSql(updateByEntryId, updateByEntryIdParams);
                    updateByEntryIdParams = new ArrayList(5000);
                }
                if (updateByRangeParams.size() < 5000) continue;
                this.executeBatchSql(updateByRange, updateByRangeParams);
                updateByRangeParams = new ArrayList(5000);
            }
        }
        if (preEntryId != null) {
            if (Long.compare(preEntryId, beginEntryId) == 0) {
                updateByEntryIdParams.add(this.buildUpdateParamsByEntryId(preEntryId, preSeq));
            } else {
                updateByRangeParams.add(this.buildUpdateParamsRange(beginEntryId, preEntryId, preSeqDiff));
            }
        }
        if (!updateByEntryIdParams.isEmpty()) {
            this.executeBatchSql(updateByEntryId, updateByEntryIdParams);
        }
        if (!updateByRangeParams.isEmpty()) {
            this.executeBatchSql(updateByRange, updateByRangeParams);
        }
    }

    private Object[] buildUpdateParamsRange(long beginEntryId, long endEntryId, int seqDiff) {
        Object[] params = new SqlParameter[]{new SqlParameter(FSEQ, 4, (Object)seqDiff), new SqlParameter(FENTRYID1, -5, (Object)beginEntryId), new SqlParameter(FENTRYID2, -5, (Object)endEntryId)};
        return params;
    }

    private Object[] buildUpdateParamsByEntryId(long entryId, int seq) {
        Object[] params = new SqlParameter[]{new SqlParameter(FSEQ, 4, (Object)seq), new SqlParameter(FENTRYID1, -5, (Object)entryId)};
        return params;
    }

    private void executeForVarcharPK(String tempTableName, String pageId, String entryKey, String entryPkField) {
        DbMetadataColumn pkcol = this.table.getPrimaryKey();
        DbMetadataColumn seqCol = this.table.getSeq();
        String selectSeq = String.format("SELECT B.%s, B.fseq   FROM %s A INNER JOIN %s B on A.%s = B.%s  WHERE B.fpageid = ? and B.fentrykey = ? and B.fseq != A.%s ", entryPkField, this.table.getName(), tempTableName, pkcol.getName(), entryPkField, seqCol.getName());
        Object[] selectSeqParams = new SqlParameter[]{new SqlParameter(PAGEID, 12, (Object)pageId), new SqlParameter(ENTRYKEY, 12, (Object)entryKey)};
        String updateSeq = String.format("UPDATE %s SET %s = ? WHERE %s = ?", this.table.getName(), seqCol.getName(), pkcol.getName());
        ArrayList<Object> updateParams = new ArrayList<Object[]>(5000);
        try (DataSet dataSet = DB.queryDataSet((String)(this.getClass().getName() + ".buildUpdateParamsRange"), (DBRoute)this.dbRoute, (String)selectSeq, (Object[])selectSeqParams);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                SqlParameter[] params = new SqlParameter[]{new SqlParameter(FSEQ, 4, (Object)row.getInteger(FSEQ)), pkcol.getDbType() == -5 ? new SqlParameter(FENTRYID, pkcol.getDbType(), (Object)row.getLong(entryPkField)) : new SqlParameter(FENTRYID, pkcol.getDbType(), row.get(entryPkField))};
                updateParams.add(params);
                if (updateParams.size() < 5000) continue;
                this.executeBatchSql(updateSeq, updateParams);
                updateParams = new ArrayList(5000);
            }
        }
        if (!updateParams.isEmpty()) {
            this.executeBatchSql(updateSeq, updateParams);
        }
    }

    private void executeSql(String sql, SqlParameter[] params) {
        if (this.ctx != null) {
            this.ctx.set();
            try {
                DB.execute((DBRoute)this.dbRoute, (String)("/*ORM*/ " + sql), (Object[])params);
            }
            finally {
                this.ctx.close();
            }
        } else {
            DB.execute((DBRoute)this.dbRoute, (String)("/*ORM*/ " + sql), (Object[])params);
        }
    }

    private void executeBatchSql(String sql, List<Object[]> batchParams) {
        if (this.ctx != null) {
            this.ctx.set();
            try {
                DB.executeBatch((DBRoute)this.dbRoute, (String)("/*ORM*/ " + sql), batchParams);
            }
            finally {
                this.ctx.close();
            }
        } else {
            DB.executeBatch((DBRoute)this.dbRoute, (String)("/*ORM*/ " + sql), batchParams);
        }
    }

    @Override
    public int getLevel() {
        return -1;
    }

    public void setShardingHintContext(ShardingHintContext ctx) {
        this.ctx = ctx;
    }
}

