/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DataEntityDeserializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityLocalCacheManager;
import kd.bos.orm.datamanager.IDataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DataEntityCacheManager
implements IDataEntityCacheManager {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("dataentity", new DistributeCacheHAPolicy());
    private static Log logger = LogFactory.getLog(DataEntityCacheManager.class);
    private IDataEntityType dt;
    private String regionKey;
    private String rootType;
    private String numberRegionKey;
    private static int localcacheSingleSize = 0;
    private static int rediscacheSingleSize = 0;
    private static final String BASEDATA_LOCALCACHE_SINGLESIZE = "basedata.localcache.singlesize";
    private static final String BASEDATA_REDISCACHE_SINGLESIZE = "basedata.rediscache.singlesize";
    private static final String SPAN_TYPE_DATAENTITYCACHEMANAGER = "DataEntityCacheManager";

    public DataEntityCacheManager(String tableName) {
        this.rootType = tableName.toLowerCase();
    }

    public DataEntityCacheManager(IDataEntityType dt) {
        try {
            if (dt == null) {
                throw new IllegalArgumentException("dt");
            }
            if (dt.getPrimaryKey() == null) {
                throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"DataEntityCacheManager_0", (String)"\u5b9e\u4f53\u7f3a\u4e4f\u4e3b\u952e\uff0c\u65e0\u6cd5\u7f13\u5b58\u5904\u7406\u3002", (Object[])new Object[0]));
            }
            this.dt = dt;
            this.rootType = dt.getAlias().toLowerCase();
            this.regionKey = this.getSubType();
            this.numberRegionKey = this.regionKey + "_number";
        }
        catch (RuntimeException e) {
            if (dt == null) {
                EntityTracer.addLocaleTag((String)"dt", (String)"");
            } else {
                EntityTracer.addLocaleTag((String)"dt", (Object)dt);
                EntityTracer.addLocaleTag((String)"dtVersion", (String)(dt.getVersion() == null ? "" : dt.getVersion()));
            }
            EntityTracer.throwException((Throwable)e);
            throw e;
        }
    }

    public Object[] getCachePks(QFilter[] filters) {
        DataEntityLocalCacheManager localCacheManager = new DataEntityLocalCacheManager(this.dt);
        return localCacheManager.getCachePks(filters);
    }

    public void putCachePks(QFilter[] filters, Object[] pks) {
        DataEntityLocalCacheManager localCacheManager = new DataEntityLocalCacheManager(this.dt);
        localCacheManager.putCachePks(filters, pks);
    }

    private Map<Object, Object> get(String[] pks) {
        Map<Object, Object> cacheMap;
        if (pks.length > 0) {
            DataEntityLocalCacheManager localCacheManager = new DataEntityLocalCacheManager(this.dt);
            ArrayList<String> notFindpks = new ArrayList<String>();
            cacheMap = localCacheManager.get((Object[])pks, notFindpks);
            if (notFindpks.size() > 0) {
                HashMap<Object, Object> redisCacheMap = new HashMap<Object, Object>();
                List strs = cache.get(this.regionKey, notFindpks.toArray(new String[0]));
                ISimpleProperty pkProp = this.dt.getPrimaryKey();
                for (String strObj : strs) {
                    if (!StringUtils.isNotBlank((CharSequence)strObj)) continue;
                    try {
                        Map mapObject = (Map)SerializationUtils.fromJsonString((String)strObj, Map.class);
                        DataEntityDeserializerOption option = new DataEntityDeserializerOption();
                        option.setIncludeDataEntityState(true);
                        Object obj = DataEntitySerializer.convertMapToDataEntity((IDataEntityType)this.dt, (Map)mapObject, (DataEntityDeserializerOption)option);
                        redisCacheMap.put(pkProp.getValueFast(obj), obj);
                    }
                    catch (Exception e) {
                        logger.error("\u8bfb\u53d6\u7f13\u5b58\u5931\u8d25" + this.dt.getName() + this.regionKey, (Throwable)e);
                    }
                }
                cacheMap.putAll(redisCacheMap);
                localCacheManager.put(redisCacheMap.values().toArray());
            }
        } else {
            cacheMap = new HashMap<Object, Object>();
        }
        return cacheMap;
    }

    public void put(Object[] dataEntities) {
        this.putType();
        HashMap<String, String> cacheMap = new HashMap<String, String>(dataEntities.length);
        ISimpleProperty pkProp = this.dt.getPrimaryKey();
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeDataEntityState(true);
        HashMap<Object, Object> localMap = new HashMap<Object, Object>(dataEntities.length);
        for (Object obj : dataEntities) {
            String data = DataEntitySerializer.serializerToString((Object)obj, (DataEntitySerializerOption)option);
            if (data.length() < this.getRedisCacheSingleSize()) {
                String key = this.getKey(pkProp.getValueFast(obj));
                cacheMap.put(key, data);
                if (data.length() < this.getLocalCacheSingleSize()) {
                    localMap.put(key, obj);
                    continue;
                }
                logger.info("data size > localcacheSingleSize. dt:={},pk:={},size:={}. If there are too many logs, adjust the MC parameters 'basedata.cache.localsinglesize'.", new Object[]{this.dt.getExtendName(), pkProp.getValueFast(obj), data.length()});
                continue;
            }
            logger.info("data size > rediscacheSingleSize.  dt:={},pk:={},size:={}. If there are too many logs, adjust the MC parameters 'basedata.cache.redissinglesize'.", new Object[]{this.dt.getExtendName(), pkProp.getValueFast(obj), data.length()});
        }
        if (cacheMap.size() > 0) {
            cache.put(this.regionKey, cacheMap, this.getDefaultTimeout());
        }
        DataEntityLocalCacheManager lCacheManager = new DataEntityLocalCacheManager(this.dt);
        lCacheManager.put(localMap);
    }

    public void putNotExistPKs(Object[] oids, Object[] dataEntities) {
        DataEntityLocalCacheManager localCacheManager = new DataEntityLocalCacheManager(this.dt);
        localCacheManager.putNotExistPKs(oids, dataEntities);
    }

    public void putNotExistPKs(Object[] notExistPKs) {
        DataEntityLocalCacheManager localCacheManager = new DataEntityLocalCacheManager(this.dt);
        localCacheManager.putNotExistPKs(notExistPKs);
    }

    @Override
    public boolean isNotExistPK(Object pk) {
        DataEntityLocalCacheManager localCacheManager = new DataEntityLocalCacheManager(this.dt);
        return localCacheManager.isNotExistPK(pk);
    }

    public void removeByPrimaryKey(Object ... pks) {
        if (pks == null) {
            return;
        }
        ArrayList<String> listPk = new ArrayList<String>();
        for (Object pk : pks) {
            if (pk == null) continue;
            listPk.add(pk.toString());
        }
        if (listPk.size() > 0) {
            String[] keys = listPk.toArray(new String[0]);
            Collection<String> subTypes = this.getTypes();
            for (String subType : subTypes) {
                cache.remove(subType, keys);
            }
        }
        DataEntityLocalCacheManager lCacheManager = new DataEntityLocalCacheManager(this.rootType);
        lCacheManager.removeByDt();
    }

    public void removeByDt() {
        Collection<String> subTypes = this.getTypes();
        cache.remove(subTypes.toArray(new String[0]));
        if (StringUtils.isNotBlank((CharSequence)this.numberRegionKey)) {
            cache.remove(this.numberRegionKey);
        }
        DataEntityLocalCacheManager lCacheManager = new DataEntityLocalCacheManager(this.rootType);
        lCacheManager.removeByDt();
    }

    public void removeByFilterDt() {
        DataEntityLocalCacheManager lCacheManager = new DataEntityLocalCacheManager(this.rootType);
        lCacheManager.removeByFilterDt();
    }

    private void putType() {
        HashMap<String, String> subtype = new HashMap<String, String>();
        subtype.put(this.getSubType(), "1");
        cache.put(this.getRootType(), subtype, this.getDefaultTimeout());
    }

    private Collection<String> getTypes() {
        Map subTypes = cache.getAll(this.getRootType());
        return subTypes.keySet();
    }

    private String getRootType() {
        RequestContext context = RequestContext.get();
        return context.getAccountId() + "." + this.rootType.toLowerCase();
    }

    private String getSubType() {
        String region = this.dt instanceof DynamicObjectType ? ((DynamicObjectType)this.dt).getExtendName() : this.dt.getName();
        RequestContext context = RequestContext.get();
        return context.getAccountId() + "." + region;
    }

    private String getKey(Object id) {
        return id.toString();
    }

    @Override
    public Map<Object, Object> get(Object[] pkArray) {
        String[] pks = new String[pkArray.length];
        for (int i = 0; i < pkArray.length; ++i) {
            pks[i] = pkArray[i].toString();
        }
        return this.get(pks);
    }

    @Override
    public IDataEntityType getDataEntityType() {
        return this.dt;
    }

    public Map<Object, Object> getByNumbers(String ... numbers) {
        String pk;
        HashMap<String, String> pkNumberMap = new HashMap<String, String>();
        for (String num : numbers) {
            if (!StringUtils.isNotBlank((CharSequence)num) || !StringUtils.isNotBlank((CharSequence)(pk = (String)cache.get(this.numberRegionKey, num)))) continue;
            pkNumberMap.put(pk, num);
        }
        Map<Object, Object> pkObjs = this.get(pkNumberMap.keySet().toArray(new String[0]));
        HashMap<Object, Object> map = new HashMap<Object, Object>(pkNumberMap.size());
        for (Map.Entry<Object, Object> entry : pkObjs.entrySet()) {
            pk = entry.getKey().toString();
            String number = (String)pkNumberMap.get(pk);
            map.put(number, entry.getValue());
        }
        return map;
    }

    public void putByNumbers(String numberPropKey, Object[] dataEntities) {
        HashMap<String, String> cacheMap = new HashMap<String, String>(dataEntities.length);
        String[] pks = new String[dataEntities.length];
        ISimpleProperty pkProp = this.dt.getPrimaryKey();
        IDataEntityProperty numberProp = (IDataEntityProperty)this.dt.getProperties().get((Object)numberPropKey);
        int i = 0;
        for (Object obj : dataEntities) {
            String pk = this.getKey(pkProp.getValueFast(obj));
            pks[i++] = pk;
            cacheMap.put(this.getKey(numberProp.getValueFast(obj)), this.getKey(pkProp.getValueFast(obj)));
        }
        if (cacheMap.size() > 0) {
            cache.put(this.numberRegionKey, cacheMap, this.getDefaultTimeout());
        }
        this.put(dataEntities);
    }

    private int getDefaultTimeout() {
        String s = System.getProperty("redis.defaulttimeout.dataentity");
        if (s != null) {
            return Integer.parseInt(s.trim());
        }
        return 3600;
    }

    private int getLocalCacheSingleSize() {
        if (localcacheSingleSize == 0) {
            localcacheSingleSize = Integer.getInteger(BASEDATA_LOCALCACHE_SINGLESIZE, 307200);
        }
        return localcacheSingleSize;
    }

    private int getRedisCacheSingleSize() {
        if (rediscacheSingleSize == 0) {
            rediscacheSingleSize = Integer.getInteger(BASEDATA_REDISCACHE_SINGLESIZE, 307200);
        }
        return rediscacheSingleSize;
    }

    static {
        ConfigurationUtil.observeChange((String)BASEDATA_LOCALCACHE_SINGLESIZE, (key, newValue) -> {
            localcacheSingleSize = Integer.getInteger(BASEDATA_LOCALCACHE_SINGLESIZE, 307200);
        });
        ConfigurationUtil.observeChange((String)BASEDATA_REDISCACHE_SINGLESIZE, (key, newValue) -> {
            rediscacheSingleSize = Integer.getInteger(BASEDATA_REDISCACHE_SINGLESIZE, 307200);
        });
    }
}

