/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.entity.PropertyStockNode;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.datamanager.DataEntityReferenceSchemaItem;

public final class DataEntityReferenceSchema {
    private HashMap<String, HashMap<ISimpleProperty, DataEntityReferenceSchemaItem>> _dict = new HashMap();
    private static final DataEntityReferenceSchema _empty = new DataEntityReferenceSchema();

    public void add(DataEntityReferenceSchemaItem item) {
        if (item == null) {
            throw new ORMArgInvalidException("01", BosRes.get((String)"bos-ormengine", (String)"DataEntityReferenceSchema_0", (String)"\u626b\u63cf\u5b9e\u4f53\u5f15\u7528\u5c5e\u6027\u5b9a\u4e49\u60c5\u51b5\u65f6\u6dfb\u52a0\u5143\u7d20\u5931\u8d25\uff0c\u626b\u63cf\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
        }
        if (item.getPropertyPath() == null) {
            item.setPropertyPath("");
        }
        if (item.getReferenceOidProperty() == null) {
            throw new ORMArgInvalidException("02", BosRes.get((String)"bos-ormengine", (String)"DataEntityReferenceSchema_1", (String)"\u626b\u63cf\u5b9e\u4f53\u5f15\u7528\u5c5e\u6027\u5b9a\u4e49\u60c5\u51b5\u65f6\u6dfb\u52a0\u5143\u7d20\u5931\u8d25\uff0c\u5f15\u7528\u5c5e\u6027[ReferenceOidProperty]\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)item.getReferenceTo())) {
            throw new ORMArgInvalidException("03", BosRes.get((String)"bos-ormengine", (String)"DataEntityReferenceSchema_2", (String)"\u626b\u63cf\u5b9e\u4f53\u5f15\u7528\u5c5e\u6027\u5b9a\u4e49\u60c5\u51b5\u65f6\u6dfb\u52a0\u5143\u7d20\u5931\u8d25\uff0c\u5f15\u7528\u5c5e\u6027\u6307\u5411[ReferenceTo]\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
        }
        if (item.getReferenceObjectProperty() != null && item.getReferenceObjectProperty().getComplexType() != null) {
            if (item.getReferenceObjectProperty().getComplexType().getPrimaryKey() == null) {
                throw new ORMDesignException("04", BosRes.get((String)"bos-ormengine", (String)"DataEntityReferenceSchema_3", (String)"\u626b\u63cf\u5b9e\u4f53\u5f15\u7528\u5c5e\u6027\u5b9a\u4e49\u60c5\u51b5\u65f6\u6dfb\u52a0\u5143\u7d20\u5931\u8d25\uff0c\u643a\u5e26\u503c\u7684\u590d\u6742\u5c5e\u6027[{0}]\u5fc5\u987b\u5305\u542b\u4e3b\u952e\uff0c\u5426\u5219\u5728\u52a0\u8f7d\u65f6\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u5173\u7cfb\uff01", (Object[])new Object[]{item.getReferenceObjectProperty().getName()}));
            }
            if (item.getReferenceObjectProperty().getComplexType().getPrimaryKey().getPropertyType() != item.getReferenceOidProperty().getPropertyType()) {
                throw new ORMDesignException("05", BosRes.get((String)"bos-ormengine", (String)"DataEntityReferenceSchema_4", (String)"\u626b\u63cf\u5b9e\u4f53\u5f15\u7528\u5c5e\u6027\u5b9a\u4e49\u60c5\u51b5\u65f6\u6dfb\u52a0\u5143\u7d20\u5931\u8d25\uff0c\u643a\u5e26\u503c\u7684\u590d\u6742\u5c5e\u6027[{0}]\u4e3b\u952e\u7c7b\u578b\u548c\u5f15\u7528\u7684\u7c7b\u578b\u4e0d\u4e00\u81f4\uff01", (Object[])new Object[]{item.getReferenceObjectProperty().getName()}));
            }
        }
        HashMap<Object, DataEntityReferenceSchemaItem> d1 = null;
        d1 = this._dict.get(item.getPropertyPath());
        if (d1 == null) {
            d1 = new HashMap();
            this._dict.put(item.getPropertyPath(), d1);
        }
        if (d1.get(item.getReferenceOidProperty()) != null) {
            throw new ORMDesignException("06", BosRes.get((String)"bos-ormengine", (String)"DataEntityReferenceSchema_5", (String)"\u626b\u63cf\u5b9e\u4f53\u5f15\u7528\u5c5e\u6027\u5b9a\u4e49\u60c5\u51b5\u65f6\u6dfb\u52a0\u5143\u7d20\u5931\u8d25\uff0c\u8981\u6dfb\u52a0\u7684\u5c5e\u6027[{0}]\u5df2\u7ecf\u6dfb\u52a0\u8fc7\u4e86\uff01", (Object[])new Object[]{item.getReferenceOidProperty().getName()}));
        }
        d1.put(item.getReferenceOidProperty(), item);
    }

    public Iterable<DataEntityReferenceSchemaItem> getItemsByPropertyPath(String propertyPath) {
        return this.getItemsByPropertyPath(propertyPath, false);
    }

    public Iterable<DataEntityReferenceSchemaItem> getItemsByPropertyPath(String propertyPath, boolean mustHaveReferenceObjectProperty) {
        if (propertyPath == null) {
            propertyPath = "";
        }
        Map d1 = null;
        ArrayList<DataEntityReferenceSchemaItem> items = new ArrayList<DataEntityReferenceSchemaItem>();
        d1 = this._dict.get(propertyPath);
        if (d1 != null) {
            for (DataEntityReferenceSchemaItem item : d1.values()) {
                if (mustHaveReferenceObjectProperty && item.getReferenceObjectProperty() == null) continue;
                items.add(item);
            }
        }
        return items;
    }

    public DataEntityReferenceSchema getReferenceSchema(IDataEntityType dt, boolean onlyDbProperty) {
        if (dt == null) {
            throw new ORMArgInvalidException("07", BosRes.get((String)"bos-ormengine", (String)"DataEntityReferenceSchema_6", (String)"\u5206\u6790\u4e00\u4e2a\u6307\u5b9a\u7684\u5b9e\u4f53\u7c7b\u578b\u83b7\u53d6\u5176\u5f15\u7528\u5b9a\u4e49\u60c5\u51b5\u5931\u8d25\uff0c\u8981\u5206\u6790\u7684\u5b9e\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
        }
        DataEntityReferenceSchema result = (DataEntityReferenceSchema)dt.getDataEntityReferenceSchema();
        if (result == null) {
            result = this.create(dt, onlyDbProperty);
            dt.setDataEntityReferenceSchema((Object)result);
        }
        if (result._dict.size() == 0) {
            return null;
        }
        return result;
    }

    private DataEntityReferenceSchema create(IDataEntityType dt, boolean onlyDbProperty) {
        DataEntityReferenceSchema schema = new DataEntityReferenceSchema();
        PropertyStockNode stack = new PropertyStockNode(dt);
        DataEntityReferenceSchema.searchDataEntityReferenceSchema(dt, schema, stack, onlyDbProperty);
        if (schema._dict.isEmpty()) {
            return _empty;
        }
        return schema;
    }

    private static void searchDataEntityReferenceSchema(IDataEntityType dt, DataEntityReferenceSchema schema, PropertyStockNode stock, boolean onlyDbProperty) {
        for (IComplexProperty cp : dt.getProperties().getComplexProperties(false)) {
            DataEntityReferenceSchemaItem schemaItem = new DataEntityReferenceSchemaItem();
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dt.getProperties().get((Object)cp.getRefIdPropName());
            if (dataEntityProperty == null) continue;
            ISimpleProperty sp = (ISimpleProperty)dataEntityProperty;
            schemaItem.setReferenceOidProperty(sp);
            schemaItem.setReferenceTo(cp.getName());
            schemaItem.setPropertyPath(stock.getPropertyPath());
            schemaItem.setReferenceObjectProperty(cp);
            schema.add(schemaItem);
        }
        for (ICollectionProperty colp : dt.getProperties().getCollectionProperties(onlyDbProperty)) {
            DataEntityReferenceSchema.searchDataEntityReferenceSchema(colp.getItemType(), schema, stock.CreateNextNode(colp), onlyDbProperty);
        }
    }
}

