/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityReference;
import kd.bos.dataentity.entity.DataEntityReferenceList;
import kd.bos.dataentity.entity.DataEntityWalkerEventArgs;
import kd.bos.dataentity.entity.DataEntityWalkerListner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.metadata.DataEntityCacheType;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityReferenceSchema;
import kd.bos.orm.datamanager.DataEntityReferenceSchemaItem;
import kd.bos.orm.datamanager.ReadWhere;
import kd.bos.orm.impl.DataManager;

public class LoadReferenceObjectManager {
    private static final Log logger = LogFactory.getLog(LoadReferenceObjectManager.class);
    private IDataEntityType _dt;
    private DataEntityReferenceSchema _refSchema;
    private Map<String, DataEntityReferenceList> _loadTasks;
    private boolean _onlyDbProperty;
    private static final List<DataEntityReferenceList> _emptyTasks = new ArrayList<DataEntityReferenceList>();

    protected LoadReferenceObjectManager(IDataEntityType dt) {
        this(dt, true);
    }

    public LoadReferenceObjectManager(IDataEntityType dt, boolean onlyDbProperty) {
        if (dt == null) {
            throw new ORMArgInvalidException("??????", BosRes.get((String)"bos-ormengine", (String)"LoadReferenceObjectManager_0", (String)"\u521b\u5efa\u5ef6\u8fdf\u8bfb\u53d6\u672a\u586b\u5145\u5f15\u7528\u5c5e\u6027\u5668LoadReferenceObjectManager\u5931\u8d25\uff0c\u53c2\u6570\u5b9e\u4f53\u7c7b\u578b[IDataEntityType]\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]));
        }
        this._onlyDbProperty = onlyDbProperty;
        this._dt = dt;
        DataEntityReferenceSchema referenceSchema = new DataEntityReferenceSchema();
        this._refSchema = referenceSchema.getReferenceSchema(this._dt, this.getOnlyDbProperty());
        this._loadTasks = new ConcurrentHashMap<String, DataEntityReferenceList>();
    }

    public final boolean getOnlyDbProperty() {
        return this._onlyDbProperty;
    }

    public final void Load(Object[] dataEntities) {
        this.DoTasks(this.GetTasks(dataEntities));
    }

    public final void Load(Object[] dataEntities, HashMap<String, String> dictReferenceWhere) {
        this.DoTasks(this.GetTasks(dataEntities), dictReferenceWhere);
    }

    protected Collection<DataEntityReferenceList> GetTasks(Object[] dataEntities) {
        if (this._refSchema == null || dataEntities == null || dataEntities.length == 0) {
            return _emptyTasks;
        }
        DataEntityWalkerListner listner = new DataEntityWalkerListner(){

            public void callback(DataEntityWalkerEventArgs e) {
                for (DataEntityReferenceSchemaItem item : LoadReferenceObjectManager.this._refSchema.getItemsByPropertyPath(e.getPropertyStock().getPropertyPath(), true)) {
                    String lastKey = "";
                    DataEntityReferenceList list = null;
                    for (Object dataEntity : e.getDataEntities()) {
                        AutoDataEntityReference entityRef;
                        IDataEntityType refDT;
                        Object oid;
                        try {
                            oid = item.getReferenceOidProperty().getValueFast(dataEntity);
                        }
                        catch (RuntimeException exc) {
                            EntityTracer.addLocaleTag((String)"err.prop", (Object)item.getReferenceOidProperty());
                            EntityTracer.addLocaleTag((String)"err.prop.stock", (String)e.getPropertyStock().getPropertyPath());
                            EntityTracer.addLocaleTag((String)"err.data", dataEntity);
                            EntityTracer.throwException((Throwable)exc);
                            throw exc;
                        }
                        if (LoadReferenceObjectManager.IsDbNull(oid) || (refDT = item.getReferenceObjectProperty().getComplexType(dataEntity)) == null) continue;
                        String taskKey = refDT.getExtendName();
                        if (!taskKey.equals(lastKey)) {
                            lastKey = taskKey;
                            list = (DataEntityReferenceList)LoadReferenceObjectManager.this._loadTasks.get(taskKey);
                            if (list == null) {
                                list = new DataEntityReferenceList(item.getReferenceObjectProperty().getComplexType(dataEntity));
                                LoadReferenceObjectManager.this._loadTasks.put(taskKey, list);
                            }
                        }
                        RefObject ref_obj = new RefObject(null);
                        if (list == null) {
                            throw new KDException(BosErrorCode.bOS, new Object[]{"loadReferenceObject error,can not find refDT task"});
                        }
                        if (list.TryGet(oid, ref_obj)) {
                            entityRef = (AutoDataEntityReference)((Object)ref_obj.argvalue);
                        } else {
                            entityRef = new AutoDataEntityReference(oid);
                            list.add((DataEntityReference)entityRef);
                        }
                        entityRef.setReferencePropertyName(item.getReferenceObjectProperty().getName());
                        entityRef.list.add((Tuple<IComplexProperty, Object>)Tuple.create((Object)item.getReferenceObjectProperty(), dataEntity));
                    }
                }
            }
        };
        OrmUtils.DataEntityWalker(Arrays.asList(dataEntities), (IDataEntityType)this._dt, (DataEntityWalkerListner)listner, (boolean)this._onlyDbProperty);
        return this._loadTasks.values();
    }

    private static boolean IsDbNull(Object oid) {
        if (oid == null) {
            return true;
        }
        if (oid instanceof Integer) {
            return (Integer)oid == 0;
        }
        if (oid instanceof Long) {
            return (Long)oid == 0L;
        }
        if (oid instanceof String) {
            return StringUtils.isBlank((CharSequence)((String)oid));
        }
        return false;
    }

    protected void DoTasks(Collection<DataEntityReferenceList> tasks) {
        this.DoTasks(tasks, new HashMap<String, String>());
    }

    protected void DoTasks(Collection<DataEntityReferenceList> tasks, HashMap<String, String> dictReferenceWhere) {
        if (tasks == null || tasks.size() == 0) {
            return;
        }
        for (DataEntityReferenceList task : tasks) {
            Object[] dataEntities;
            Object[] oids = task.GetNotLoadedOids();
            if (oids.length <= 0) continue;
            String sql = "";
            RefObject ref_obj = new RefObject(null);
            AutoDataEntityReference item = null;
            if (task.TryGet(oids[0], ref_obj)) {
                item = (AutoDataEntityReference)((Object)ref_obj.argvalue);
            } else {
                item = new AutoDataEntityReference(oids[0]);
                task.add((DataEntityReference)item);
            }
            if (dictReferenceWhere.size() > 0 && (sql = dictReferenceWhere.get(item.getReferencePropertyName())) != null) {
                ReadWhere where = new ReadWhere(oids);
                where.setWhereSql(sql);
                dataEntities = this.Read(task.getDataEntityType(), where);
            } else {
                dataEntities = this.Read(task.getDataEntityType(), oids);
            }
            LoadReferenceObjectManager.Map(task, dataEntities);
        }
    }

    private static void Map(DataEntityReferenceList task, Object[] dataEntities) {
        if (dataEntities == null) {
            return;
        }
        ISimpleProperty pk = task.getDataEntityType().getPrimaryKey();
        assert (pk != null);
        DataEntityReference refItem = null;
        for (Object item : dataEntities) {
            Object oid = pk.getValue(item);
            RefObject tempRef_refItem = new RefObject(refItem);
            boolean tempVar = task.TryGet(oid, tempRef_refItem);
            refItem = (DataEntityReference)tempRef_refItem.argvalue;
            if (!tempVar) continue;
            refItem.setDataEntity(item);
        }
    }

    protected Object[] Read(IDataEntityType dt, Object[] oids) {
        try {
            return new DataManager(dt).read(oids);
        }
        catch (Exception e) {
            this.logErrDt(dt, e);
            throw e;
        }
    }

    protected Object[] Read(IDataEntityType dt, ReadWhere where) {
        try {
            return new DataManager(dt).read(where);
        }
        catch (Exception e) {
            this.logErrDt(dt, e);
            throw e;
        }
    }

    private void logErrDt(IDataEntityType dt, Exception exp) {
        try {
            logger.error("##LoadReferenceObjectManager.Read ERROR##: " + dt.toPlainString(), (Throwable)exp);
        }
        catch (Throwable e) {
            logger.error("IDataEntityType.toPlainString error,msg:" + e.getMessage(), e);
        }
    }

    private static final class AutoDataEntityReference
    extends DataEntityReference {
        private String privateReferencePropertyName;
        public ArrayList<Tuple<IComplexProperty, Object>> list = new ArrayList();

        public String getReferencePropertyName() {
            return this.privateReferencePropertyName;
        }

        public void setReferencePropertyName(String value) {
            this.privateReferencePropertyName = value;
        }

        public AutoDataEntityReference(Object oid) {
            super(oid);
        }

        public Object getDataEntity() {
            return super.getDataEntity();
        }

        public void setDataEntity(Object value) {
            block5: {
                boolean bShare;
                block4: {
                    if (value != null) break block4;
                    super.setDataEntity(value);
                    break block5;
                }
                if (super.getDataEntity() == value) break block5;
                super.setDataEntity(value);
                IDataEntityType dt = ((IComplexProperty)this.list.get((int)0).item1).getComplexType();
                boolean bl = dt == null ? true : (bShare = dt.getCacheType() == DataEntityCacheType.Share);
                if (bShare) {
                    for (Tuple<IComplexProperty, Object> item : this.list) {
                        IComplexProperty prop = (IComplexProperty)item.item1;
                        if (value == null && !prop.isDbIgnore()) continue;
                        prop.loadValue(item.item2, value);
                    }
                } else {
                    for (Tuple<IComplexProperty, Object> item : this.list) {
                        ((IComplexProperty)item.item1).loadValue(item.item2, OrmUtils.clone((IDataEntityBase)((DynamicObject)value), (boolean)false, (boolean)false));
                    }
                }
            }
        }
    }
}

