/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager.refstrategy;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.datamanager.refstrategy.BasedataRefShareStrategy;
import kd.bos.orm.datamanager.refstrategy.DefaultRefShareStrategy;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasedataRefShareFactory {
    private static final Logger logger = LoggerFactory.getLogger(BasedataRefShareFactory.class);
    static BasedataRefShareFactory factory = BasedataRefShareFactory.initFactory();

    public static BasedataRefShareStrategy createRefShareStrategy() {
        return factory.getRefShareStrategy();
    }

    protected abstract BasedataRefShareStrategy getRefShareStrategy();

    private static BasedataRefShareFactory initFactory() {
        String className = BasedataRefShareFactory.getRefShareFactoryClassName();
        BasedataRefShareFactory factory = null;
        if (StringUtils.isNotEmpty((CharSequence)className)) {
            factory = BasedataRefShareFactory.createByClassName(className);
        }
        if (factory == null) {
            factory = new DefaultRefShareFactory();
        }
        return factory;
    }

    private static String getRefShareFactoryClassName() {
        return ConfigurationUtil.getString((String)"basedata.refshare.factory.className");
    }

    private static BasedataRefShareFactory createByClassName(String className) {
        BasedataRefShareFactory refShareFactory = null;
        try {
            Class<?> clazz = Class.forName(className);
            refShareFactory = (BasedataRefShareFactory)clazz.newInstance();
        }
        catch (Exception var3) {
            logger.error("Error: Can't create BasedataRefShareFactory by class:" + className, (Throwable)var3);
        }
        return refShareFactory;
    }

    private static class DefaultRefShareFactory
    extends BasedataRefShareFactory {
        private static String REF_SHARE_CLASS = "basedata.refshare.classname";
        private static String refShareClass = ConfigurationUtil.getString((String)REF_SHARE_CLASS);
        static BasedataRefShareStrategy refShareStrategy;

        private DefaultRefShareFactory() {
        }

        @Override
        protected BasedataRefShareStrategy getRefShareStrategy() {
            if (refShareStrategy == null) {
                refShareStrategy = DefaultRefShareFactory.initStrategy();
            }
            return refShareStrategy;
        }

        private static BasedataRefShareStrategy initStrategy() {
            BasedataRefShareStrategy refShareStrategy = null;
            if (StringUtils.isBlank((CharSequence)refShareClass)) {
                return new DefaultRefShareStrategy();
            }
            if (StringUtils.isNotBlank((CharSequence)refShareClass)) {
                try {
                    Class<?> clazz = Class.forName(refShareClass);
                    refShareStrategy = (BasedataRefShareStrategy)clazz.newInstance();
                }
                catch (Exception e) {
                    logger.error("Error: BasedataRefShareStrategy init Error. Can't create class:" + refShareClass, (Throwable)e);
                }
            }
            if (refShareStrategy == null) {
                refShareStrategy = new DefaultRefShareStrategy();
            }
            return refShareStrategy;
        }

        static {
            ConfigurationUtil.observeChange((String)REF_SHARE_CLASS, (ConfigurationChangeListener)new ConfigurationChangeListener(){

                public void onChange(Object key, Object newValue) {
                    refShareClass = ConfigurationUtil.getString((String)REF_SHARE_CLASS);
                    refShareStrategy = null;
                }
            });
            refShareStrategy = DefaultRefShareFactory.initStrategy();
        }
    }
}

