/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.impl;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMOptimization;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.SqlTreeNode;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.orm.query.crud.read.DynamicObjectParser;
import kd.bos.orm.query.multi.MultiQuery;
import kd.bos.orm.query.multi.OrderByInfo;
import kd.bos.orm.query.multi.QueryConfig;
import kd.bos.orm.query.oql.g.expr.OrderBys;
import kd.bos.orm.query.oql.g.expr.WhereQFilters;
import kd.bos.orm.query.oql.q.expr.QInfo;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;

public abstract class ORMImplBase {
    private static final Log log = LogFactory.getLog(ORMImplBase.class);
    protected final Map<String, IDataEntityType> entityTypeCache;
    protected final SequenceReader sequenceReader = new SequenceReader();
    protected final ORMHint ormHint;
    protected final ORMOptimization optimization;

    protected ORMImplBase(Map<String, IDataEntityType> entityTypeCache, ORMHint ormHint, ORMOptimization optimization) {
        this.entityTypeCache = entityTypeCache;
        this.ormHint = ormHint;
        this.optimization = optimization;
    }

    public abstract DynamicObjectCollection getByFilter(String var1, QFilter[] var2, String var3, int var4);

    public abstract List<Object> insert(List<DynamicObject> var1);

    public abstract List<Object> save(List<DynamicObject> var1);

    public abstract int update(List<DynamicObject> var1);

    public abstract int delete(String var1, List<Object> var2);

    public abstract int count(String var1, String var2, String var3, QFilter[] var4, Distinctable var5);

    public abstract int count(String var1, String var2, String var3, QFilter[] var4, Distinctable var5, int var6);

    public abstract Object[] aggregate(String var1, String var2, String[] var3, QFilter[] var4);

    public abstract DataSet aggregate(String var1, String var2, String[] var3, QFilter[] var4, String[] var5);

    public abstract RowMeta genRowMeta(String var1, String var2);

    protected abstract DataSet queryDataSet(String var1, String var2, String var3, boolean var4, QFilter[] var5, String var6, QFilter[] var7, String var8, int var9, int var10, Distinctable var11);

    protected abstract SqlTreeNode getQuerySql(String var1, String var2, boolean var3, QFilter[] var4, String var5, QFilter[] var6, String var7, int var8, int var9, Distinctable var10);

    protected abstract boolean isQueryInSameDB(String var1, String var2, QFilter[] var3);

    protected abstract int getMaxQueryJoinTableCount(String var1, String var2, QFilter[] var3, String var4);

    protected abstract MultiQuery $createMultiQuery(String var1, String var2, QFilter[] var3);

    DataSet queryDataSet(String algoKey, QInfo qInfo, Object[] params) {
        int havingUsedParamCount = 0;
        String having = qInfo.getHaving();
        QFilter[] havingFilters = null;
        if (having != null && having.trim().length() > 0) {
            WhereQFilters wq = WhereQFilters.parseFrom(having);
            havingFilters = new QFilter[]{wq.createQFilter(params)};
            havingUsedParamCount = wq.usedParamCount();
        }
        String filters = qInfo.getFilters();
        QFilter[] whereFilters = null;
        if (filters != null && filters.trim().length() > 0) {
            Object[] whereFilterParams = params;
            if (whereFilterParams != null && whereFilterParams.length > 0 && havingUsedParamCount > 0) {
                whereFilterParams = new Object[params.length - havingUsedParamCount];
                System.arraycopy(params, havingUsedParamCount, whereFilterParams, 0, whereFilterParams.length);
            }
            whereFilters = QFilter.of(filters, whereFilterParams).toArray();
        }
        WithDistinctable distinctable = qInfo.isDistinct() ? WithDistinctable.get() : null;
        return this.queryDataSet(algoKey, qInfo.getEntityName(), qInfo.getSelectFields(), qInfo.isShouldSelectPK(), whereFilters, qInfo.getGroupBys(), havingFilters, qInfo.getOrderBys(), 0, qInfo.getTop(), distinctable);
    }

    SqlTreeNode getQuerySql(QInfo qInfo, Object[] params) {
        int havingUsedParamCount = 0;
        String having = qInfo.getHaving();
        QFilter[] havingFilters = null;
        if (having != null && having.trim().length() > 0) {
            WhereQFilters wq = WhereQFilters.parseFrom(having);
            havingFilters = new QFilter[]{wq.createQFilter(params)};
            havingUsedParamCount = wq.usedParamCount();
        }
        String filters = qInfo.getFilters();
        QFilter[] whereFilters = null;
        if (filters != null && filters.trim().length() > 0) {
            Object[] whereFilterParams = params;
            if (whereFilterParams != null && whereFilterParams.length > 0 && havingUsedParamCount > 0) {
                whereFilterParams = new Object[params.length - havingUsedParamCount];
                System.arraycopy(params, havingUsedParamCount, whereFilterParams, 0, whereFilterParams.length);
            }
            whereFilters = QFilter.of(filters, whereFilterParams).toArray();
        }
        WithDistinctable distinctable = qInfo.isDistinct() ? WithDistinctable.get() : null;
        return this.getQuerySql(qInfo.getEntityName(), qInfo.getSelectFields(), qInfo.isShouldSelectPK(), whereFilters, qInfo.getGroupBys(), havingFilters, qInfo.getOrderBys(), 0, qInfo.getTop(), distinctable);
    }

    public DynamicObjectCollection getByIds(String entityName, List<Object> ids) {
        IDataEntityType dt = ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache);
        if (dt instanceof DataEntityType) {
            throw new IllegalArgumentException(String.format("DataEntityType '%s' that is not using the getByIds method.", entityName));
        }
        ISimpleProperty pkProperty = dt.getPrimaryKey();
        QFilter filter = new QFilter(pkProperty.getName(), "in", ids);
        DynamicObjectCollection list = this.getByFilter(entityName, new QFilter[]{filter}, null, -1);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(list.size());
        for (DynamicObject obj : list) {
            map.put(String.valueOf(pkProperty.getValueFast((Object)obj)), obj);
        }
        DynamicObjectCollection cc = new DynamicObjectCollection((DynamicObjectType)dt, null);
        for (Object id : ids) {
            DynamicObject obj = (DynamicObject)map.get(String.valueOf(id));
            if (obj == null) continue;
            cc.add((Object)obj);
        }
        return cc;
    }

    public int deleteFetched(String entityName, QFilter[] filters) {
        IDataEntityType dt = ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache);
        String queryEntityName = entityName;
        String pkProperty = dt.getPrimaryKey().getName();
        if (ORMConfiguration.isEntryEntityType(dt)) {
            pkProperty = dt.getName() + "." + pkProperty;
            queryEntityName = entityName.substring(0, entityName.lastIndexOf(46));
        }
        int size = 0;
        try (DataSet ds = this.queryDataSet("ORM", queryEntityName, pkProperty, false, filters, null, null, null, 0, -1, null);){
            ArrayList<Object> pks = new ArrayList<Object>();
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                pks.add(((Row)iter.next()).get(0));
                ++size;
            }
            this.delete(entityName, pks);
        }
        return size;
    }

    public boolean exists(String entityName, Object id) {
        String s;
        if (id == null) {
            return false;
        }
        DynamicObjectType dt = (DynamicObjectType)ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache);
        if (String.class == dt.getPrimaryKey().getPropertyType()) {
            if (!(id instanceof String)) {
                id = String.valueOf(id);
            }
        } else if (!Number.class.isAssignableFrom(id.getClass()) && (s = String.valueOf(id)).matches("\\d+")) {
            id = Long.valueOf(s);
        }
        return this.exists(entityName, new QFilter(dt.getPrimaryKey().getName(), "=", id).toArray());
    }

    public boolean exists(String entityName, QFilter[] filters) {
        DynamicObjectType dt = (DynamicObjectType)ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache);
        String pkName = dt.getPrimaryKey().getName();
        try (DataSet ds = this.queryDataSet("ORM", entityName, pkName, false, filters, null, null, null, 0, 1, null);){
            boolean bl = !ds.isEmpty();
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public DynamicObjectCollection query(String entityName, String selectFields, QFilter[] filters, String orderBys, int top) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DynamicObjectCollection query0(String entityName, String selectFields, QFilter[] filters, String orderBys, int top) {
        StringBuilder idFields;
        Set<String> list;
        String entryEntityName;
        StringBuilder idFields2;
        Object sub;
        Set<String> list2;
        String entryEntityName2;
        String[] selectFieldArr;
        if (!ORMUtil.isAllAndFilter(filters) && !QueryConfig.isQueryOptimizeEnable()) {
            log.info("query0 filter not all and condition or query opt disable, call the original method");
            return this.query(entityName, selectFields, filters, orderBys, top);
        }
        SubQuery mainQuery = null;
        SubQuery firstOrderQuery = null;
        HashMap<String, Object> allSubQueryMap = new HashMap<String, Object>(8);
        for (String selectField : selectFieldArr = selectFields.split(",")) {
            entryEntityName2 = ORMUtil.getEntryEntity(entityName, selectField = selectField.trim(), this.entityTypeCache);
            if (Objects.nonNull(entryEntityName2)) {
                list2 = ORMUtil.allEntryIdProperty(entityName, entryEntityName2, this.entityTypeCache);
                sub = (SubQuery)allSubQueryMap.get(entryEntityName2);
                if (sub == null) {
                    idFields2 = new StringBuilder();
                    idFields2.append("id,");
                    list2.forEach(s -> idFields2.append((String)s).append(","));
                    idFields2.append(selectField);
                    sub = new SubQuery(idFields2.toString());
                    allSubQueryMap.put(entryEntityName2, sub);
                    continue;
                }
                ((SubQuery)sub).setSelectFileds(((SubQuery)sub).getSelectFileds() + "," + selectField);
                continue;
            }
            if (mainQuery == null) {
                mainQuery = new SubQuery(selectField);
                continue;
            }
            mainQuery.setSelectFileds(mainQuery.getSelectFileds() + "," + selectField);
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        this.getFlatFilters(filters, filterList);
        for (QFilter filter : filterList) {
            entryEntityName = ORMUtil.getEntryEntity(entityName, filter.getProperty(), this.entityTypeCache);
            if (Objects.nonNull(entryEntityName)) {
                list = ORMUtil.allEntryIdProperty(entityName, entryEntityName, this.entityTypeCache);
                SubQuery sub2 = (SubQuery)allSubQueryMap.get(entryEntityName = entryEntityName.trim());
                if (sub2 == null) {
                    idFields = new StringBuilder();
                    idFields.append("id,");
                    list.forEach(s -> idFields.append((String)s).append(","));
                    sub2 = new SubQuery(idFields.toString(), filter);
                    allSubQueryMap.put(entryEntityName, sub2);
                    continue;
                }
                sub2.setFilter(filter);
                continue;
            }
            if (mainQuery == null) {
                mainQuery = new SubQuery("id", filter);
                continue;
            }
            mainQuery.setFilter(filter);
        }
        if (orderBys != null && orderBys.trim().length() > 0) {
            List<OrderByInfo> orderByInfos = OrderBys.parseFrom(orderBys).createOrderInfos(entityName);
            if (!CollectionUtils.isEmpty(orderByInfos)) {
                OrderByInfo firstOrderByInfo = orderByInfos.remove(0);
                entryEntityName = ORMUtil.getEntryEntity(entityName, firstOrderByInfo.getFullObjectName(), this.entityTypeCache);
                if (Objects.nonNull(entryEntityName)) {
                    list = ORMUtil.allEntryIdProperty(entityName, entryEntityName, this.entityTypeCache);
                    SubQuery first = (SubQuery)allSubQueryMap.get(entryEntityName = entryEntityName.trim());
                    if (first == null) {
                        idFields = new StringBuilder();
                        list.forEach(s -> idFields.append((String)s).append(","));
                        first = new SubQuery(idFields.toString(), firstOrderByInfo.toString());
                        allSubQueryMap.put(entryEntityName, first);
                    } else {
                        first.setOrderBys(firstOrderByInfo.toString());
                    }
                    firstOrderQuery = first;
                    firstOrderQuery.setFirst(true);
                } else if (mainQuery == null) {
                    mainQuery = new SubQuery("id", firstOrderByInfo.toString());
                } else {
                    mainQuery.setOrderBys(firstOrderByInfo.toString());
                }
            }
            for (OrderByInfo orderByInfo : orderByInfos) {
                entryEntityName2 = ORMUtil.getEntryEntity(entityName, orderByInfo.getFullObjectName(), this.entityTypeCache);
                if (Objects.nonNull(entryEntityName2)) {
                    list2 = ORMUtil.allEntryIdProperty(entityName, entryEntityName2, this.entityTypeCache);
                    sub = (SubQuery)allSubQueryMap.get(entryEntityName2 = entryEntityName2.trim());
                    if (sub == null) {
                        idFields2 = new StringBuilder();
                        idFields2.append("id,");
                        list2.forEach(s -> idFields2.append((String)s).append(","));
                        sub = new SubQuery(idFields2.toString(), orderByInfo.toString());
                        allSubQueryMap.put(entryEntityName2, sub);
                        continue;
                    }
                    ((SubQuery)sub).setOrderBys(orderByInfo.toString());
                    continue;
                }
                if (mainQuery == null) {
                    mainQuery = new SubQuery("id", orderByInfo.toString());
                    continue;
                }
                mainQuery.setOrderBys(orderByInfo.toString());
            }
        }
        if (allSubQueryMap.size() <= 1) {
            return this.query(entityName, selectFields, filters, orderBys, top);
        }
        try (AlgoContext ctx = Algo.newContext();){
            DataSet mainDataSet;
            if (Objects.isNull(mainQuery)) {
                throw new IllegalArgumentException(String.format("the query %s properties not contain bills property.", entityName));
            }
            if (Objects.nonNull(firstOrderQuery)) {
                firstOrderQuery.setSelectFileds(mainQuery.getSelectFileds() + firstOrderQuery.getSelectFileds());
                firstOrderQuery.setFilter(mainQuery.getFilter());
                mainDataSet = this.queryDataSet("ORM", entityName, firstOrderQuery.selectFields, true, firstOrderQuery.filter == null ? null : firstOrderQuery.filter.toArray(), null, null, firstOrderQuery.orderBys, 0, -1, null);
            } else {
                mainDataSet = this.queryDataSet("ORM", entityName, mainQuery.selectFields, true, mainQuery.filter == null ? null : mainQuery.filter.toArray(), null, null, mainQuery.orderBys, 0, -1, null);
            }
            DataSet copy = mainDataSet.copy();
            ArrayList<Object> ids = new ArrayList<Object>();
            for (Row row : copy) {
                ids.add(row.get("id"));
            }
            DynamicObjectParser parser = new DynamicObjectParser(mainDataSet, entityName, this.entityTypeCache, this.optimization, this.ormHint, this.getMulti(filters));
            DynamicObjectCollection mainCollection = parser.parse(top);
            HashMap<String, DynamicObjectCollection> subObjectsMap = new HashMap<String, DynamicObjectCollection>();
            allSubQueryMap.forEach((k, v) -> {
                if (!((SubQuery)v).first) {
                    QFilter mainQFilter = new QFilter("id", "in", ids.toArray());
                    ((SubQuery)v).filter = ((SubQuery)v).filter == null ? mainQFilter : mainQFilter.and(((SubQuery)v).filter);
                    DataSet ds = this.queryDataSet("ORM", entityName, ((SubQuery)v).selectFields, true, ((SubQuery)v).filter.toArray(), null, null, ((SubQuery)v).orderBys, 0, -1, null);
                    DynamicObjectParser subParser = new DynamicObjectParser(ds, entityName, this.entityTypeCache, this.optimization, this.ormHint, this.getMulti(((SubQuery)v).filter.toArray()));
                    DynamicObjectCollection subCollection = subParser.parse(-1);
                    subObjectsMap.put((String)k, subCollection);
                }
            });
            this.mergeCollection(entityName, mainCollection, subObjectsMap);
            DynamicObjectCollection dynamicObjectCollection = mainCollection;
            return dynamicObjectCollection;
        }
    }

    public DynamicObjectCollection query00(String entityName, String selectFields, QFilter[] filters, String orderBys, int top) {
        LayerQuery query2;
        String objPath;
        String[] selectFieldArr;
        if (!ORMUtil.isAllAndFilter(filters) && !QueryConfig.isQueryOptimizeEnable()) {
            log.info("query00 filter not all and condition or query opt disable, call the original method");
            return this.query(entityName, selectFields, filters, orderBys, top);
        }
        LayerQuery rootQuery = new LayerQuery(entityName, entityName, "root");
        HashMap<String, LayerQuery> allSubQuery = new HashMap<String, LayerQuery>(8);
        HashMap<String, QFilter> subQueryQFilterMap = new HashMap<String, QFilter>();
        for (String selectField : selectFieldArr = selectFields.split(",")) {
            objPath = ORMUtil.getOneToMoreEntityPath(entityName, selectField = selectField.trim(), this.entityTypeCache);
            if (Objects.nonNull(objPath)) {
                query2 = ORMImplBase.putIfAbsentAndGet(allSubQuery, objPath, new LayerQuery(entityName, objPath, "select"));
                query2.selectFields.add(selectField);
                Set<String> fullPathIds = ORMUtil.allOneToMoreIdProperty(entityName, objPath, this.entityTypeCache);
                fullPathIds.forEach(id -> {
                    if (!query2.selectFields.contains(id)) {
                        query2.selectFields.add(id);
                    }
                });
                continue;
            }
            rootQuery.selectFields.add(selectField);
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        this.getFlatFilters(filters, filterList);
        for (QFilter filter : filterList) {
            String objPath2 = ORMUtil.getOneToMoreEntityPath(entityName, filter.getProperty(), this.entityTypeCache);
            if (Objects.nonNull(objPath2)) {
                LayerQuery query3 = ORMImplBase.putIfAbsentAndGet(allSubQuery, objPath2, new LayerQuery(entityName, objPath2, "filter"));
                subQueryQFilterMap.put(query3.entityPath, filter.copy());
                Set<String> ids = ORMUtil.allOneToMoreIdProperty(entityName, objPath2, this.entityTypeCache);
                ids.forEach(id -> {
                    if (!query3.selectFields.contains(id)) {
                        query3.selectFields.add(id);
                    }
                });
                continue;
            }
            rootQuery.filters.add(filter);
        }
        if (orderBys != null && orderBys.trim().length() > 0) {
            List<OrderByInfo> orderByInfoList = OrderBys.parseFrom(orderBys).createOrderInfos(entityName);
            for (OrderByInfo orderByInfo : orderByInfoList) {
                objPath = ORMUtil.getOneToMoreEntityPath(entityName, orderByInfo.getPropertySegExpress().toString(), this.entityTypeCache);
                if (Objects.nonNull(objPath)) {
                    query2 = ORMImplBase.putIfAbsentAndGet(allSubQuery, objPath, new LayerQuery(entityName, objPath, "orderBy"));
                    query2.orderBys.add(orderByInfo.toString());
                    Set<String> ids = ORMUtil.allOneToMoreIdProperty(entityName, objPath, this.entityTypeCache);
                    ids.forEach(id -> {
                        if (!query2.selectFields.contains(id)) {
                            query2.selectFields.add(id);
                        }
                    });
                    continue;
                }
                rootQuery.orderBys.add(orderByInfo.toString());
            }
        }
        if (allSubQuery.size() <= 1) {
            return this.query(entityName, selectFields, filters, orderBys, top);
        }
        allSubQuery.forEach((key, query) -> {
            if (!((LayerQuery)query).selectFields.contains("id")) {
                ((LayerQuery)query).selectFields.add("id");
            }
            subQueryQFilterMap.forEach((k, filter) -> {
                if (k.contains((CharSequence)key)) {
                    ((LayerQuery)query).filters.add(filter.copy());
                }
            });
        });
        ArrayList<Object> ids = new ArrayList<Object>();
        try (AlgoContext ctx = Algo.newContext();){
            String usedSelectFields = "id";
            if (orderBys != null) {
                usedSelectFields = this.getSelectFields(selectFields, orderBys);
            }
            DataSet ds = this.queryDataSet("ORM", entityName, usedSelectFields, true, filters, null, null, orderBys, 0, top, WithEntityEntryDistinctable.get());
            for (Row row : ds) {
                ids.add(row.get("id"));
                if (ids.size() != top) continue;
                break;
            }
        }
        ctx = Algo.newContext();
        var13_17 = null;
        try {
            QFilter mainQFilter = new QFilter("id", "in", ids.toArray());
            rootQuery.filters.add(mainQFilter);
            DataSet mainDataSet = this.queryDataSet("ORM", entityName, String.join((CharSequence)",", rootQuery.selectFields), true, rootQuery.filters.size() == 0 ? null : rootQuery.filters.toArray(new QFilter[0]), null, null, String.join((CharSequence)",", rootQuery.orderBys), 0, -1, null);
            DynamicObjectParser parser = new DynamicObjectParser(mainDataSet, entityName, this.entityTypeCache, this.optimization, this.ormHint, this.getMulti(filters));
            DynamicObjectCollection mainCollection = parser.parse(top);
            HashMap<String, DynamicObjectCollection> subObjectsMap = new HashMap<String, DynamicObjectCollection>();
            allSubQuery.forEach((k, v) -> {
                QFilter idsFilter = new QFilter("id", "in", ids.toArray());
                ((LayerQuery)v).filters.add(idsFilter);
                DataSet ds = this.queryDataSet("ORM", entityName, String.join((CharSequence)",", ((LayerQuery)v).selectFields), true, ((LayerQuery)v).filters.toArray(new QFilter[0]), null, null, String.join((CharSequence)",", ((LayerQuery)v).orderBys), 0, -1, null);
                DynamicObjectParser subParser = new DynamicObjectParser(ds, entityName, this.entityTypeCache, this.optimization, this.ormHint, this.getMulti(((LayerQuery)v).filters.toArray(new QFilter[0])));
                DynamicObjectCollection subCollection = subParser.parse(-1);
                subObjectsMap.put((String)k, subCollection);
            });
            this.mergeCollection(entityName, mainCollection, subObjectsMap);
            DynamicObjectCollection dynamicObjectCollection = mainCollection;
            return dynamicObjectCollection;
        }
        catch (Throwable throwable) {
            var13_17 = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (var13_17 != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        var13_17.addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
    }

    private static Map<String, DynamicObjectCollection> sortSubCollection(String rootName, Map<String, DynamicObjectCollection> subCollection) {
        LinkedHashMap<String, DynamicObjectCollection> ret = new LinkedHashMap<String, DynamicObjectCollection>();
        boolean flag = true;
        int i = 0;
        while (flag) {
            int num = i;
            subCollection.forEach((k, v) -> {
                String temp = k;
                if (temp.startsWith(rootName)) {
                    temp = temp.substring(k.indexOf(".") + 1);
                }
                for (int j = 0; j < num; ++j) {
                    int index = temp.indexOf(".");
                    temp = temp.substring(index + 1);
                }
                int index = temp.indexOf(".");
                if (index == -1) {
                    ret.put((String)k, (DynamicObjectCollection)v);
                }
            });
            flag = ret.size() != subCollection.size();
            ++i;
        }
        return ret;
    }

    private DynamicObjectCollection mergeCollection(String rootName, DynamicObjectCollection mainCollection, Map<String, DynamicObjectCollection> subCollection) {
        Map<String, DynamicObjectCollection> subC = ORMImplBase.sortSubCollection(rootName, subCollection);
        mainCollection.forEach(main -> subC.forEach((entryPath, collection) -> {
            for (DynamicObject sub : collection) {
                if (!sub.get("id").equals(main.get("id"))) continue;
                if (entryPath.startsWith(rootName)) {
                    entryPath = entryPath.substring(entryPath.indexOf(".") + 1);
                }
                this.dfsMerge((DynamicObject)main, (String)entryPath, sub);
            }
        }));
        return mainCollection;
    }

    private void dfsMerge(DynamicObject main, String entryPath, DynamicObject sub) {
        int index = entryPath.indexOf(".");
        String propertyName = entryPath;
        if (index != -1) {
            propertyName = entryPath.substring(0, index);
        }
        if (main.get(propertyName) == null) {
            main.set(propertyName, sub.get(propertyName));
        } else if (main.get(propertyName) instanceof DynamicObject) {
            this.dfsMerge((DynamicObject)main.get(propertyName), entryPath.substring(index + 1), (DynamicObject)sub.get(propertyName));
        } else if (main.get(propertyName) instanceof DynamicObjectCollection) {
            DynamicObjectCollection mainC = (DynamicObjectCollection)main.get(propertyName);
            DynamicObjectCollection sourceC = (DynamicObjectCollection)sub.get(propertyName);
            if (mainC == null || mainC.isEmpty()) {
                main.set(propertyName, (Object)sourceC);
                return;
            }
            if (index == -1) {
                ArrayList beRemoved = new ArrayList();
                sourceC.forEach(s -> {
                    for (DynamicObject obj : mainC) {
                        if (ORMConfiguration.isMulBasedata(s.getDataEntityType())) {
                            if (!s.get("pkid").equals(obj.get("pkid"))) continue;
                            beRemoved.add(obj);
                            continue;
                        }
                        if (!s.get("id").equals(obj.get("id"))) continue;
                        beRemoved.add(obj);
                    }
                });
                mainC.removeAll(beRemoved);
                mainC.addAll((Collection)sourceC);
                return;
            }
            mainC.forEach(s -> {
                for (DynamicObject obj : sourceC) {
                    if (ORMConfiguration.isMulBasedata(s.getDataEntityType())) {
                        if (!s.get("pkid").equals(obj.get("pkid"))) continue;
                        this.dfsMerge((DynamicObject)s, entryPath.substring(index + 1), obj);
                        continue;
                    }
                    if (!s.get("id").equals(obj.get("id"))) continue;
                    this.dfsMerge((DynamicObject)s, entryPath.substring(index + 1), obj);
                }
            });
        }
    }

    public static <K, V> V putIfAbsentAndGet(Map<K, V> map, K key, V value) {
        V existingValue = map.putIfAbsent(key, value);
        return existingValue != null ? existingValue : value;
    }

    /*
     * Exception decompiling
     */
    public DynamicObjectCollection query(String oql, Object[] params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DataSet queryDataSet(String algoKey, String entityName, String selectFields, boolean shouldSelectPK, QFilter[] filters, String orderBys) {
        return this.queryDataSet(algoKey, entityName, selectFields, shouldSelectPK, filters, null, null, orderBys, 0, -1, null);
    }

    public Object setPrimaryKey(DynamicObject obj) {
        IDataEntityType dt = obj.getDataEntityType();
        this.sequenceReader.autoSetPrimaryKey(new Object[]{obj}, dt);
        return obj.getPkValue();
    }

    private MultiBaseDataFilterValue getMulti(QFilter[] filters) {
        ArrayList<QFilter> filerList = new ArrayList<QFilter>();
        this.getFilters(filters, filerList);
        if (!CollectionUtils.isEmpty(filerList)) {
            for (QFilter filter : filerList) {
                Object value;
                if (filter == null || !((value = filter.getValue()) instanceof MultiBaseDataFilterValue)) continue;
                return (MultiBaseDataFilterValue)value;
            }
        }
        return null;
    }

    private void getFilters(QFilter[] filterArray, List<QFilter> filtes) {
        if (filterArray == null || filterArray.length == 0) {
            return;
        }
        for (QFilter filter : filterArray) {
            if (filter == null) continue;
            filtes.add(filter);
            List<QFilter.QFilterNest> nests = filter.getNests(true);
            if (CollectionUtils.isEmpty(nests)) continue;
            for (QFilter.QFilterNest nest : nests) {
                if (nest == null) continue;
                filtes.add(nest.getFilter());
            }
        }
    }

    private String getSelectFields(String selectFields, String orderBys) {
        HashSet<String> selectFieldSet = new HashSet<String>(16);
        selectFieldSet.addAll(Arrays.stream(selectFields.split(",")).map(String::trim).collect(Collectors.toList()));
        if (!StringUtil.isEmpty((String)orderBys)) {
            String[] tempStrs;
            for (String temp : tempStrs = orderBys.trim().split(",")) {
                selectFieldSet.add(temp.trim().split(" ")[0].toLowerCase().trim());
            }
        }
        return Joiner.on((char)',').join(selectFieldSet);
    }

    private void getFlatFilters(QFilter[] filterArray, List<QFilter> filters) {
        if (filterArray == null || filterArray.length == 0) {
            return;
        }
        for (QFilter filter : filterArray) {
            if (filter == null) continue;
            filters.add(filter.__copy(false));
            List<QFilter.QFilterNest> nests = filter.getNests(true);
            if (CollectionUtils.isEmpty(nests)) continue;
            for (QFilter.QFilterNest nest : nests) {
                if (nest == null) continue;
                filters.add(nest.getFilter().__copy(false));
            }
        }
    }

    private static class LayerQuery {
        private String rootObjName;
        private String entityPath;
        private String origin;
        private List<String> selectFields;
        private List<QFilter> filters;
        private List<String> orderBys;

        public LayerQuery(String rootObjName, String entityPath, String origin) {
            this.rootObjName = rootObjName;
            this.entityPath = entityPath;
            this.origin = origin;
            this.selectFields = new ArrayList<String>();
            this.filters = new ArrayList<QFilter>();
            this.orderBys = new ArrayList<String>();
        }
    }

    private static class SubQuery {
        private String selectFields;
        private QFilter filter;
        private String orderBys;
        private DataSet dataSet;
        private boolean first;

        public SubQuery(String selectFields) {
            this.selectFields = selectFields;
        }

        public SubQuery(String selectFields, QFilter filter) {
            this.selectFields = selectFields;
            this.filter = filter;
        }

        public SubQuery(String selectFields, String orderBys) {
            this.selectFields = selectFields;
            this.orderBys = orderBys;
        }

        public String getSelectFileds() {
            return this.selectFields;
        }

        public void setSelectFileds(String selectFields) {
            this.selectFields = selectFields;
        }

        public QFilter getFilter() {
            return this.filter;
        }

        public void setFilter(QFilter filter) {
            this.filter = Objects.nonNull(this.filter) ? this.filter.and(filter) : filter;
        }

        public String getOrderBys() {
            return this.orderBys;
        }

        public void setOrderBys(String orderBys) {
            this.orderBys = !StringUtils.isEmpty(this.orderBys) ? this.orderBys + "," + orderBys : orderBys;
        }

        public DataSet getDataSet() {
            return this.dataSet;
        }

        public void setDataSet(DataSet dataSet) {
            this.dataSet = dataSet;
        }

        public boolean isFirst() {
            return this.first;
        }

        public void setFirst(boolean first) {
            this.first = first;
        }
    }
}

