/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.ORMHint;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.impl.DataManager;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMImplStandard;
import kd.bos.orm.impl.ORMOptimization;
import kd.bos.orm.query.QFilter;

public class ORMImplSnapshot
extends ORMImplStandard {
    public ORMImplSnapshot(Map<String, IDataEntityType> entityTypeCache, ORMHint ormHint, ORMOptimization optimization) {
        super(entityTypeCache, ormHint, optimization);
    }

    @Override
    public List<Object> insert(List<DynamicObject> objs) {
        for (DynamicObject obj : objs) {
            if (obj.getDataEntityState().getPkSnapshotSet() == null) continue;
            Object id = obj.getPkValue();
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"ORMImplSnapshot_0", (String)"The Object is exists.(PrimaryKey:{0})", (Object[])new Object[]{id}));
        }
        return this.save(objs);
    }

    @Override
    public List<Object> save(List<DynamicObject> objs) {
        ArrayList<Object> ids = new ArrayList<Object>(objs.size());
        if (objs.size() > 0) {
            IDataEntityType dt = objs.get(0).getDataEntityType();
            DBRoute dbRoute = new DBRoute(dt.getDBRouteKey());
            Object[] array = objs.toArray(new Object[objs.size()]);
            this.sequenceReader.autoSetPrimaryKey(array, dt);
            DataManager domainORM = new DataManager(dt, dbRoute);
            TXHandle h = TX.required((String)"save");
            Object object = null;
            try {
                domainORM.save(array);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (h != null) {
                    if (object != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
            }
            ISimpleProperty pkProperty = dt.getPrimaryKey();
            for (DynamicObject obj : objs) {
                ids.add(pkProperty.getValueFast((Object)obj));
            }
        }
        return ids;
    }

    @Override
    public int update(List<DynamicObject> objs) {
        int c = 0;
        if (objs.size() > 0) {
            IDataEntityType dt = objs.get(0).getDataEntityType();
            DBRoute dbRoute = new DBRoute(dt.getDBRouteKey());
            String entityName = dt.getName();
            dt = ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache);
            ISimpleProperty pk = dt.getPrimaryKey();
            DataManager domainORM = new DataManager(dt, dbRoute);
            ArrayList<DynamicObject> stubs = new ArrayList<DynamicObject>(objs.size());
            for (DynamicObject obj : objs) {
                if (obj.getDataEntityState().getPkSnapshotSet() == null) {
                    DynamicObject stub = (DynamicObject)domainORM.read(pk.getValueFast((Object)obj));
                    if (stub == null) continue;
                    this.copyDirtyValue(obj, stub, dt);
                    stubs.add(stub);
                    ++c;
                    continue;
                }
                if (!this.exists(entityName, pk.getValueFast((Object)obj))) continue;
                stubs.add(obj);
                ++c;
            }
            Object[] stubObjects = stubs.toArray(new Object[stubs.size()]);
            this.sequenceReader.autoSetPrimaryKey(stubObjects, dt);
            try (TXHandle h = TX.required((String)"update");){
                domainORM.save(stubObjects);
            }
        }
        return c;
    }

    private void copyDirtyValue(DynamicObject dirtyObj, DynamicObject newObj, IDataEntityType entityType) {
        for (IDataEntityProperty p : dirtyObj.getDataEntityState().GetDirtyProperties()) {
            if (p instanceof ICollectionProperty || !entityType.getProperties().containsKey((Object)p.getName())) continue;
            newObj.set(p, dirtyObj.get(p));
        }
        List collectionPS = entityType.getProperties().stream().filter(cp -> cp instanceof ICollectionProperty).collect(Collectors.toList());
        for (IDataEntityProperty cp2 : collectionPS) {
            Map<Object, DynamicObject> stubRowMap;
            DynamicObjectCollection cc = (DynamicObjectCollection)dirtyObj.get(cp2);
            if (cc == null) continue;
            DynamicCollectionProperty ccp = (DynamicCollectionProperty)cp2;
            DynamicObjectType ccdt = ccp.getDynamicCollectionItemPropertyType();
            DynamicObjectCollection stubCC = newObj.getDynamicObjectCollection(cp2);
            if (cc instanceof LocaleDynamicObjectCollection) {
                if (stubCC.size() == 0) {
                    stubCC.addAll((Collection)cc.getInsertRows());
                    continue;
                }
                stubRowMap = stubCC.stream().collect(Collectors.toMap(obj -> obj.getString("localeid"), row -> row));
                for (DynamicObject row2 : cc) {
                    DynamicObject stubRow = stubRowMap.get(row2.getString("localeid"));
                    if (stubRow != null) {
                        this.copyDirtyValue(row2, stubRow, (IDataEntityType)ccdt);
                        continue;
                    }
                    stubCC.add((Object)stubRow);
                }
                for (DynamicObject row2 : cc.getDeleteRows()) {
                    stubCC.remove((Object)stubRowMap.get(row2.getPkValue()));
                }
                continue;
            }
            stubRowMap = stubCC.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, row -> row));
            for (DynamicObject row2 : cc.getUpdateRows()) {
                this.copyDirtyValue(row2, stubRowMap.get(row2.getPkValue()), (IDataEntityType)ccdt);
            }
            for (DynamicObject row2 : cc.getDeleteRows()) {
                stubCC.remove((Object)stubRowMap.get(row2.getPkValue()));
            }
            for (DynamicObject row2 : cc.getInsertRows()) {
                stubCC.add((Object)row2);
            }
        }
    }

    @Override
    public int delete(String entityName, List<Object> ids) {
        if (ids != null && ids.size() > 0) {
            try (TXHandle h = TX.required((String)"delete");){
                int n = new DataManager(ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache)).delete(ids);
                return n;
            }
        }
        return 0;
    }

    @Override
    public DynamicObjectCollection getByFilter(String entityName, QFilter[] filters, String orderBys, int top) {
        String pk;
        IDataEntityType dt = ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache);
        if (dt instanceof DataEntityType) {
            throw new IllegalArgumentException(String.format("DataEntityType '%s' that is not using the getByFilter method.", entityName));
        }
        String selectFields = pk = dt.getPrimaryKey().getName();
        DataManager domainORM = new DataManager(dt);
        ArrayList<Object> ids = new ArrayList<Object>();
        try (DataSet ds = this.queryDataSet("ORM", entityName, selectFields, false, filters, null, null, orderBys, 0, top, null);){
            for (Row row : ds) {
                ids.add(row.get(0));
            }
        }
        Object[] objs = domainORM.read(ids);
        CachedLoadReferenceObjectManager manager = new CachedLoadReferenceObjectManager(dt, false);
        manager.Load(objs);
        DynamicObjectCollection cc = new DynamicObjectCollection((DynamicObjectType)dt, null);
        for (Object obj : objs) {
            cc.add((Object)((DynamicObject)obj));
        }
        return cc;
    }
}

