/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.impl;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.HashJoinDataSet;
import kd.bos.algo.HashTable;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.hashjoin.SmartHashTable;
import kd.bos.bdsync.BDSyncFactory;
import kd.bos.bundle.BosRes;
import kd.bos.bundle.Resources;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DataSetDataType;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.db.pktemptable.manager.impl.TemptableCleaner;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.dataentity.AggregateFuncs;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.EntityItemJoinProperty;
import kd.bos.orm.query.EntityItemProperty;
import kd.bos.orm.query.EntityNotExistsException;
import kd.bos.orm.query.FTLikeHint;
import kd.bos.orm.query.LikeHint;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.NotLikeHint;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.crossdb.TenantAccountCrossDBRuntime;
import kd.bos.orm.query.hugein.AutoRelease;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.query.multi.OrderByInfo;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.PropertySegExpress;
import kd.bos.orm.query.multi.QueryUtils;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.query.oql.g.expr.SelectFields;
import kd.bos.orm.sequence.DBType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.temptable.facade.TemptableFacade;
import kd.bos.xdb.temptable.facade.TemptableFacadeContext;
import kd.bos.xdb.temptable.facade.TemptableFacadeContexts;

public class ORMUtil {
    static final String[] AGGREGATE_FUNCTION_NAMES = new String[]{"count", "max", "min", "avg", "sum"};
    private static final Log logger = LogFactory.getLog(ORMUtil.class);
    private static final Map<String, DBType> dbTypeCache = new ConcurrentHashMap<String, DBType>(8);
    private static final Map<String, String> entityNameToRouteKey = new ConcurrentHashMap<String, String>(8);
    private static final Class<?> entryProp;
    private static Map<String, Object> systemParmHelperInstance;
    private static final ThreadLocal<Map<String, String>> params;

    public static boolean isEmptyId(Object id) {
        if (id == null) {
            return true;
        }
        if (id instanceof String) {
            return ((String)id).length() == 0;
        }
        if (id instanceof Number) {
            return ((Number)id).intValue() == 0;
        }
        return false;
    }

    public static String getParentObjectName(String objName) {
        int dot = objName.lastIndexOf(46);
        return dot == -1 ? "" : objName.substring(0, dot);
    }

    public static boolean isDbIgnoreForSave(IDataEntityProperty dp) {
        String alias = dp.getAlias();
        if (alias == null || alias.length() == 0) {
            return true;
        }
        return dp.isDbIgnore();
    }

    public static boolean isDbIgnore(IDataEntityProperty dp) {
        if (dp instanceof ILocaleProperty) {
            return true;
        }
        String alias = dp.getAlias();
        if (alias == null || alias.length() == 0) {
            return true;
        }
        return dp.isDbIgnore();
    }

    public static boolean isDbIgnoreRefBaseData(IDataEntityProperty dp) {
        String alias = dp.getAlias();
        return alias == null || alias.length() == 0;
    }

    public static void setDirty(DynamicObject obj, boolean dirty) {
        obj.getDataEntityState().setDirty(dirty);
        obj.getDataEntityState().setFromDatabase(!dirty);
        DataEntityPropertyCollection ps = obj.getDataEntityType().getProperties();
        int n = ps.size();
        for (int i = 0; i < n; ++i) {
            Object value;
            IDataEntityProperty cp = (IDataEntityProperty)ps.get(i);
            if (cp instanceof ICollectionProperty) {
                DynamicObjectCollection subCC = (DynamicObjectCollection)cp.getValueFast((Object)obj);
                if (subCC == null) continue;
                ORMUtil.setDirty(subCC, dirty);
                continue;
            }
            if (!(cp instanceof IComplexProperty) || !((value = cp.getValueFast((Object)obj)) instanceof DynamicObject)) continue;
            ORMUtil.setDirty((DynamicObject)value, dirty);
        }
    }

    public static void setDirty(DynamicObjectCollection cc, boolean dirty) {
        cc.getDeleteRows().clear();
        if (cc.size() == 0) {
            return;
        }
        ArrayList<IDataEntityProperty> collectionPS = new ArrayList<IDataEntityProperty>();
        DataEntityPropertyCollection ps = cc.getDynamicObjectType().getProperties();
        int n = ps.size();
        for (int i = 0; i < n; ++i) {
            IDataEntityProperty cp = (IDataEntityProperty)ps.get(i);
            if (!(cp instanceof ICollectionProperty) && !(cp instanceof IComplexProperty)) continue;
            collectionPS.add(cp);
        }
        for (DynamicObject obj : cc) {
            obj.getDataEntityState().setDirty(dirty);
            obj.getDataEntityState().setFromDatabase(!dirty);
            for (IDataEntityProperty cp : collectionPS) {
                Object value;
                if (cp instanceof ICollectionProperty) {
                    DynamicObjectCollection subCC = (DynamicObjectCollection)cp.getValueFast((Object)obj);
                    if (subCC == null) continue;
                    ORMUtil.setDirty(subCC, dirty);
                    continue;
                }
                if (!(cp instanceof IComplexProperty) || !((value = cp.getValueFast((Object)obj)) instanceof DynamicObject)) continue;
                ORMUtil.setDirty((DynamicObject)value, dirty);
            }
        }
    }

    public static void clearDirty(DynamicObject obj) {
        ORMUtil.setDirty(obj, false);
    }

    public static void clearDirty(DynamicObjectCollection cc) {
        ORMUtil.setDirty(cc, false);
    }

    public static DBType getDBType(String routeKey) {
        RequestContext requestContext = RequestContext.get();
        try (TXHandle txh = null;){
            if (requestContext == null) {
                IllegalThreadStateException e = new IllegalThreadStateException(Resources.get((String)"bos-ormengine", (String)"ORMUtil_1", (String)"RequestContext is null\u3002", (Object[])new Object[0]));
                throw e;
            }
            String key = requestContext.getTenantId() + "_" + requestContext.getAccountId() + "_" + routeKey;
            DBType caheDBType = dbTypeCache.get(key);
            if (caheDBType != null) {
                DBType dBType = caheDBType;
                return dBType;
            }
            if (!TX.inTX()) {
                txh = TX.requiresNew((String)"getDBType");
            }
            Connection con = TX.__getConnectionSkipWriteArchiveCheck((String)routeKey, (boolean)false);
            kd.bos.xdb.datasource.DBType dbType = ((DelegateConnection)con).getDBType();
            switch (dbType) {
                case dm: {
                    dbTypeCache.putIfAbsent(key, DBType.DM);
                    DBType dBType = DBType.DM;
                    return dBType;
                }
                case sqlserver: {
                    dbTypeCache.putIfAbsent(key, DBType.SQLServer);
                    DBType dBType = DBType.SQLServer;
                    return dBType;
                }
                case oracle: {
                    dbTypeCache.putIfAbsent(key, DBType.Oracle);
                    DBType dBType = DBType.Oracle;
                    return dBType;
                }
                case postgresql: {
                    dbTypeCache.putIfAbsent(key, DBType.Postgres);
                    DBType dBType = DBType.Postgres;
                    return dBType;
                }
                case mysql: {
                    dbTypeCache.putIfAbsent(key, DBType.MySQL);
                    DBType dBType = DBType.MySQL;
                    return dBType;
                }
            }
            dbTypeCache.putIfAbsent(key, DBType.UNKNOWN);
            DBType dBType = DBType.UNKNOWN;
            return dBType;
        }
    }

    public static Class<?> getPropertyType(DataType dataType) {
        return dataType.getJavaType();
    }

    public static String getRootObjName(String fullObjName) {
        int dot = fullObjName.indexOf(46);
        if (dot != -1) {
            return fullObjName.substring(0, dot);
        }
        return fullObjName;
    }

    public static String getFullObjNameWithoutRoot(String fullObjName) {
        int dot = fullObjName.indexOf(46);
        if (dot != -1) {
            return fullObjName.substring(dot + 1);
        }
        return "";
    }

    public static DataSet toDataSet(final DynamicObjectCollection cc) {
        DynamicObjectType dt = cc.getDynamicObjectType();
        DataEntityPropertyCollection ps = dt.getProperties();
        ArrayList<Field> fields = new ArrayList<Field>(ps.size());
        int n = ps.size();
        for (int i = 0; i < n; ++i) {
            IDataEntityProperty p = (IDataEntityProperty)ps.get(i);
            Field field = new Field(p.getName(), DataSetDataType.getDataType((Class)p.getPropertyType()));
            fields.add(field);
        }
        final RowMeta rowType = new RowMeta(fields.toArray(new Field[fields.size()]));
        return Algo.create((String)"ORM").createDataSet((Iterator)new Iterator<Object[]>(){
            private final int n;
            private final int c;
            private int i;
            {
                this.n = cc.size();
                this.c = rowType.getFieldCount();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.n;
            }

            @Override
            public Object[] next() {
                if (this.i >= this.n) {
                    return null;
                }
                DynamicObject obj = (DynamicObject)cc.get(this.i++);
                Object[] values = new Object[this.c];
                for (int j = 0; j < this.c; ++j) {
                    values[j] = obj.get(j);
                }
                return values;
            }

            @Override
            public void remove() {
                cc.remove(this.i);
            }
        }, rowType);
    }

    public static DynamicObjectCollection toDynamicObjectCollection(DataSet ds, DynamicObjectType dt) {
        try {
            DynamicObjectCollection dynamicObjectCollection = ORMUtil.toDynamicObjectCollection(ds.iterator(), dt);
            return dynamicObjectCollection;
        }
        finally {
            ds.close();
        }
    }

    public static DynamicObjectCollection toDynamicObjectCollection(Iterator<Row> iter, DynamicObjectType dt) {
        DynamicObjectCollection ret = new DynamicObjectCollection(dt, null);
        int n = -1;
        while (iter.hasNext()) {
            DynamicObject obj = new DynamicObject(dt, true);
            obj.beginInit();
            Row row = iter.next();
            if (n == -1) {
                n = row.size();
            }
            for (int i = 0; i < n; ++i) {
                obj.set(i, row.get(i));
            }
            obj.endInit();
            ret.add((Object)obj);
        }
        return ret;
    }

    public static DynamicObjectCollection toDynamicObjectCollection(DataSet ds, String entityName) {
        try {
            DynamicObjectCollection dynamicObjectCollection = ORMUtil.toDynamicObjectCollection((Iterator<Row>)ds.iterator(), ds.getRowMeta(), entityName);
            return dynamicObjectCollection;
        }
        finally {
            ds.close();
        }
    }

    public static DynamicObjectCollection toDynamicObjectCollection(Iterator<Row> iter, RowMeta rowMeta, String entityName) {
        DynamicObjectType dt = new DynamicObjectType(entityName);
        int fieldCount = rowMeta.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            Field field = rowMeta.getField(i);
            String fieldName = field.getAlias();
            if (fieldName.isEmpty() || dt.getProperties().containsKey((Object)fieldName)) {
                fieldName = "Property" + i;
            }
            Class<?> propertyType = ORMUtil.getPropertyType(field.getDataType());
            DynamicSimpleProperty property = new DynamicSimpleProperty(fieldName, propertyType, null);
            property.setEnableNull(field.isNullable());
            dt.registerSimpleProperty(property);
        }
        DynamicSimpleProperty[] properties = (DynamicSimpleProperty[])dt.getProperties().toArray((Object[])new DynamicSimpleProperty[0]);
        return ORMUtil.toDynamicObjectCollection(iter, properties, dt);
    }

    private static DynamicObjectCollection toDynamicObjectCollection(Iterator<Row> iter, DynamicSimpleProperty[] properties, DynamicObjectType dt) {
        DynamicObjectCollection ret = new DynamicObjectCollection(dt, null);
        while (iter.hasNext()) {
            DynamicObject obj = new DynamicObject(dt, true);
            obj.beginInit();
            Row row = iter.next();
            for (int i = 0; i < properties.length; ++i) {
                properties[i].setValueFast((Object)obj, row.get(i));
            }
            obj.endInit();
            ret.add((Object)obj);
        }
        return ret;
    }

    public static DataSet hashJoins(DataSet root, SingleQuery rootNodeQuery, String[] rootFields, List<DataSet> joinedDSList, List<SingleQuery> joinedNodeQueries) {
        return ORMUtil.hashJoins(root, rootNodeQuery, rootFields, joinedDSList, joinedNodeQueries, false);
    }

    public static DataSet hashJoins(DataSet root, SingleQuery rootNodeQuery, String[] rootFields, List<DataSet> joinedDSList, List<SingleQuery> joinedNodeQueries, boolean isChildDSHasMultiRows) {
        HashJoinDataSet hashJoinDataSet = null;
        if (Boolean.parseBoolean(System.getProperty("orm.multibasedata.selfjoin", "true"))) {
            boolean distinct = false;
            ArrayList<String> parentFKField = new ArrayList<String>();
            int n = joinedDSList.size();
            for (int i = 0; i < n; ++i) {
                boolean isSingleFieldMultiBasedata;
                String[] joinDataSet = joinedDSList.get(i);
                SingleQuery joinQuery = joinedNodeQueries.get(i);
                String parentFK = joinQuery.getParentFK();
                boolean bl = isSingleFieldMultiBasedata = joinQuery.getFullObjName().toLowerCase(Locale.ENGLISH).endsWith(".fbasedataid") && joinDataSet.getRowMeta().getFieldCount() == 1 && parentFK.toLowerCase(Locale.ENGLISH).endsWith("_fbasedataid");
                if (isSingleFieldMultiBasedata) {
                    for (String s : rootFields) {
                        if (!parentFK.equals(s)) continue;
                        parentFKField.add(s);
                    }
                    distinct = true;
                }
                hashJoinDataSet = ORMUtil.doHashJoinDataSet(root, rootNodeQuery, hashJoinDataSet, (DataSet)joinDataSet, joinQuery, isChildDSHasMultiRows);
            }
            if (distinct) {
                DataSet ret = hashJoinDataSet.selectLeftFields(rootFields).finish();
                if (parentFKField.size() > 0) {
                    ArrayList<String> selectFields = new ArrayList<String>(rootFields.length - parentFKField.size());
                    for (String fieldName : ret.getRowMeta().getFieldNames()) {
                        if (parentFKField.contains(fieldName)) continue;
                        selectFields.add(fieldName);
                    }
                    String[] fieldArray = selectFields.toArray(new String[0]);
                    if (fieldArray.length > 0) {
                        ret = ret.select(false, fieldArray);
                    }
                }
                RowMeta rowMeta = ret.getRowMeta();
                DataSetBuilder builder = Algo.create((String)"orm_join").createDataSetBuilder(rowMeta);
                int cols = ret.getRowMeta().getFieldCount();
                String[] fields = new String[cols];
                List<OrderByInfo> orderByInfos = rootNodeQuery.getAllOrderByList();
                int curfilledIndex = 0;
                ArrayList<Integer> filledColIndex = new ArrayList<Integer>();
                for (OrderByInfo orderByInfo : orderByInfos) {
                    String express = orderByInfo.toString();
                    int colIndex = ORMUtil.containField(express, rowMeta);
                    if (colIndex == -1) continue;
                    fields[curfilledIndex++] = express;
                    filledColIndex.add(colIndex);
                }
                for (int i = 0; i < cols; ++i) {
                    if (filledColIndex.contains(i)) continue;
                    fields[curfilledIndex++] = rowMeta.getFieldName(i);
                }
                DataSet order = ret.orderBy(fields);
                Object[] preRowObjects = null;
                while (order.hasNext()) {
                    Row row = order.next();
                    Object[] values = ORMUtil.toObjects(row);
                    if (preRowObjects != null && Arrays.equals(values, preRowObjects)) continue;
                    preRowObjects = values;
                    builder.append(values);
                }
                return builder.build();
            }
        } else {
            int n = joinedDSList.size();
            for (int i = 0; i < n; ++i) {
                hashJoinDataSet = ORMUtil.doHashJoinDataSet(root, rootNodeQuery, hashJoinDataSet, joinedDSList.get(i), joinedNodeQueries.get(i), isChildDSHasMultiRows);
            }
        }
        return hashJoinDataSet == null ? root : hashJoinDataSet.selectLeftFields(rootFields).finish();
    }

    private static int containField(String express, RowMeta rowMeta) {
        int index = -1;
        for (int i = 0; i < rowMeta.getFieldCount(); ++i) {
            if (!express.contains(rowMeta.getFieldName(i))) continue;
            return i;
        }
        return index;
    }

    private static Object[] toObjects(Row row) {
        Object[] values = new Object[row.size()];
        for (int i = 0; i < row.size(); ++i) {
            values[i] = row.get(i);
        }
        return values;
    }

    private static HashJoinDataSet doHashJoinDataSet(DataSet root, SingleQuery rootNodeQuery, HashJoinDataSet rootHashJoinDataSet, DataSet joinedDS, SingleQuery joinedNodeQuery, boolean isChildDSHasMultiRows) {
        DataType rightType;
        Field[] joinedRightFields = joinedDS.getRowMeta().getFields();
        String[] rightFields = new String[joinedRightFields.length];
        int n = joinedRightFields.length;
        for (int i = 0; i < n; ++i) {
            rightFields[i] = joinedRightFields[i].getAlias();
        }
        EntityItemJoinProperty jp = joinedNodeQuery.getAllCtx().getEntityItem((String)joinedNodeQuery.getFullObjName()).joinProperty;
        String rightField = jp.getSubJoinPropertyType().getName();
        String leftFieldAlias = null;
        for (PropertyField sf : joinedNodeQuery.getSelectFields()) {
            if (!ORMUtil.equalsDataEntityProperty(jp.getSubJoinPropertyType(), sf.getPeropertyType())) continue;
            rightField = sf.getAlias().toLowerCase();
            break;
        }
        for (PropertyField sf : rootNodeQuery.getSelectFields()) {
            if (ORMUtil.equalsDataEntityProperty(jp.getParentJoinPropertyType(), sf.getPeropertyType()) && (leftFieldAlias = sf.getAlias().toLowerCase(Locale.ENGLISH)).equals(joinedNodeQuery.getParentFK().toLowerCase(Locale.ENGLISH))) break;
        }
        ArrayList<String> rightFieldList = new ArrayList<String>(Arrays.asList(rightFields));
        for (int i = 0; i < rightFieldList.size(); ++i) {
            if (!((String)rightFieldList.get(i)).startsWith("INNER_")) continue;
            rightFieldList.remove(i);
            --i;
        }
        rightFields = rightFieldList.toArray(new String[rightFieldList.size()]);
        String joinEntityPath = ORMUtil.getFullObjNameWithoutRoot(joinedNodeQuery.getFullObjName());
        ORMHint ormHint = joinedNodeQuery.getAllCtx().getORMHint();
        ORMHint.JoinHint joinHint = ormHint.joinHint(joinEntityPath, joinedNodeQuery.isInnerJoin() ? ORMHint.JoinHint.INNER : ORMHint.JoinHint.DEFAULT);
        boolean innerJoin = joinHint == ORMHint.JoinHint.INNER;
        DataType leftType = root.getRowMeta().getField(leftFieldAlias).getDataType();
        if (leftType != (rightType = joinedDS.getRowMeta().getField(rightField).getDataType()) && leftType != DataType.LongType && leftType != DataType.IntegerType && rightType != DataType.LongType && rightType != DataType.IntegerType) {
            String msg = BosRes.get((String)"bos-ormengine", (String)"ORMUtil_0", (String)"dataset join field type mismatch\uff1a%s\u3002", (Object[])new Object[]{leftType + "=" + rightType + ", " + rootNodeQuery.getFullObjName() + "." + leftFieldAlias + "=" + joinedNodeQuery.getFullObjName() + "." + rightField});
            throw new RuntimeException(msg);
        }
        HashTable hashTable = null;
        if (isChildDSHasMultiRows) {
            RowMeta rowMeta = joinedDS.getRowMeta();
            int keyIndex = rowMeta.getFieldIndex(rightField);
            hashTable = new SmartHashTable(joinedDS, keyIndex, 1);
        } else {
            hashTable = joinedDS.toHashTable(rightField);
        }
        rootHashJoinDataSet = rootHashJoinDataSet == null ? root.hashJoin(hashTable, leftFieldAlias, rightFields, !innerJoin) : rootHashJoinDataSet.addHashTable(hashTable, leftFieldAlias, rightFields, !innerJoin);
        return rootHashJoinDataSet;
    }

    private static boolean equalsDataEntityProperty(IDataEntityProperty p1, IDataEntityProperty p2) {
        if (p1 == null && p2 != null || p1 != null && p2 == null) {
            return false;
        }
        if (p1 == p2) {
            return true;
        }
        IDataEntityType pp1 = p1.getParent();
        boolean same = true;
        int size = 0;
        for (IDataEntityType pp2 = p2.getParent(); ++size <= 100 && (pp1 != null || pp2 != null); pp1 = pp1.getParent(), pp2 = pp2.getParent()) {
            if (pp1 == null && pp2 != null || pp1 != null && pp2 == null) {
                same = false;
                break;
            }
            same = pp1.getName().equals(pp2.getName());
            if (!same) break;
        }
        if (same) {
            return Objects.equals(p1.getAlias(), p2.getAlias());
        }
        return false;
    }

    public static void dumpDataSet(DataSet ds) {
        int cols = ds.getRowMeta().getFieldCount();
        for (int i = 0; i < cols; ++i) {
        }
        for (Row row : ds) {
            for (int i = 0; i < cols; ++i) {
                Object object = row.get(i);
            }
        }
    }

    public static List<PropertyField> parseQueryFieldInfo(String selectFields, String rootObjName, IDataEntityType dt) {
        List<PropertyField> pfs;
        try {
            pfs = SelectFields.parseFrom(selectFields).createPropertyFields(rootObjName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(rootObjName + " select field error: " + selectFields, e);
        }
        ArrayList<String> newFields = new ArrayList<String>();
        HashMap<String, EntityTypeItem> entityTypeMap = new HashMap<String, EntityTypeItem>();
        HashMap<String, IDataEntityType> entityTypeCache = new HashMap<String, IDataEntityType>();
        entityTypeMap.put(dt.getName().toLowerCase(), new EntityTypeItem(dt));
        for (PropertyField field : new ArrayList<PropertyField>(pfs)) {
            if (!"*".equals(field.getName())) continue;
            String aliasPrefix = field.getAlias();
            if (aliasPrefix.indexOf(42) != -1) {
                aliasPrefix = null;
            }
            EntityTypeItem eti = ORMUtil.getEntityType(field.getFullObjectName(), dt, entityTypeMap, entityTypeCache);
            String addedObjPrefix = field.getFullObjectName().length() == 0 ? rootObjName + "." : rootObjName + "." + field.getFullObjectName().toLowerCase() + ".";
            DataEntityPropertyCollection ps = eti.type.getProperties();
            ORMUtil.collectAutoSelectFields(addedObjPrefix, aliasPrefix, ps, newFields);
            pfs.remove(field);
        }
        for (String newField : newFields) {
            PropertyField pf = new PropertyField(newField.trim());
            pfs.add(pf);
        }
        return pfs;
    }

    public static String escapeSpecialChar(String value) {
        StringBuffer sb = new StringBuffer();
        char[] chs = value.toCharArray();
        for (int i = 0; i < chs.length - 1; ++i) {
            if (chs[i] == '\\') {
                if (chs[i + 1] == '%') {
                    sb.append("\\");
                    continue;
                }
                sb.append("\\\\");
                continue;
            }
            sb.append(chs[i]);
        }
        sb.append(chs[chs.length - 1]);
        return sb.toString().replace("_", "\\_");
    }

    public static String escapeSpecialChar(IDataEntityType dataEntityType, String value) {
        if (ORMUtil.isEffective(dataEntityType)) {
            StringBuilder sb = new StringBuilder();
            char[] chs = value.toCharArray();
            for (int i = 0; i < chs.length - 1; ++i) {
                if (chs[i] == '\\') {
                    if (chs[i + 1] == '%') {
                        sb.append("\\");
                        continue;
                    }
                    sb.append("\\\\");
                    continue;
                }
                sb.append(chs[i]);
            }
            sb.append(chs[chs.length - 1]);
            return sb.toString().replace("_", "\\_");
        }
        return value;
    }

    public static boolean isEffective(IDataEntityType dataEntityType) {
        String dbRoute = dataEntityType.getDBRouteKey();
        DBType dbType = ORMUtil.getDBType(dbRoute);
        boolean supportSpecialChar = ORMConfig.FUZZY_QUERY_SUPPORT_SPECIAL_CHAR.getBoolean();
        return supportSpecialChar && (dbType == DBType.MySQL || dbType == DBType.Postgres);
    }

    private static void collectAutoSelectFields(String addedObjPrefix, String aliasPrefix, DataEntityPropertyCollection ps, List<String> newFields) {
        int n = ps.size();
        for (int j = 0; j < n; ++j) {
            String name;
            IDataEntityProperty dp = (IDataEntityProperty)ps.get(j);
            if (dp instanceof ICollectionProperty) {
                if (!(dp instanceof DynamicLocaleProperty)) continue;
                DataEntityPropertyCollection localePs = ((DynamicLocaleProperty)dp).getDynamicCollectionItemPropertyType().getProperties();
                DataEntityPropertyCollection selectPs = new DataEntityPropertyCollection(new ArrayList(localePs.size() - 2), localePs.getParent(), true);
                for (IDataEntityProperty p : localePs) {
                    String name2 = p.getName().toLowerCase();
                    if (name2.equals("pkid") || name2.equals("localeid")) continue;
                    selectPs.add((Object)p);
                }
                ORMUtil.collectAutoSelectFields(addedObjPrefix, aliasPrefix, selectPs, newFields);
                continue;
            }
            if (dp instanceof IComplexProperty || ORMUtil.isDbIgnore(dp) || (name = dp.getName().toLowerCase()).endsWith("_id") && ps.containsKey((Object)name.substring(0, name.length() - 3))) continue;
            String added = addedObjPrefix + dp.getName();
            if (aliasPrefix != null && aliasPrefix.length() > 0) {
                added = added + " " + aliasPrefix + dp.getName();
            }
            if (newFields.indexOf(added) != -1) continue;
            newFields.add(added);
        }
    }

    private static EntityTypeItem getEntityType(String objName, IDataEntityType dt, Map<String, EntityTypeItem> entityTypeMap, Map<String, IDataEntityType> entityTypeCache) {
        EntityTypeItem typeItem;
        if (objName.length() == 0) {
            objName = dt.getName();
        }
        if ((typeItem = entityTypeMap.get(objName = objName.toLowerCase())) == null) {
            String subObj;
            String parentObjName;
            int pos = objName.lastIndexOf(46);
            if (pos != -1) {
                parentObjName = objName.substring(0, pos);
                subObj = objName.substring(pos + 1);
            } else {
                parentObjName = dt.getName().toLowerCase();
                subObj = objName;
            }
            IDataEntityType parentType = ORMUtil.getEntityType(parentObjName, dt, entityTypeMap, entityTypeCache).type;
            IDataEntityProperty fk = ORMUtil.getProperty(parentType, subObj);
            if (fk instanceof ICollectionProperty) {
                IDataEntityType type = ((ICollectionProperty)fk).getItemType();
                typeItem = new EntityTypeItem(type);
                entityTypeMap.put(objName, typeItem);
            } else if (fk instanceof IComplexProperty) {
                IDataEntityType type = ORMConfiguration.innerGetBaseDataEntityType((IComplexProperty)fk, entityTypeCache);
                typeItem = new EntityTypeItem(type);
                entityTypeMap.put(objName, typeItem);
            } else {
                try {
                    IDataEntityType type = ORMConfiguration.innerGetDataEntityType(subObj, entityTypeCache);
                    typeItem = new EntityTypeItem(type);
                    entityTypeMap.put(objName, typeItem);
                }
                catch (EntityNotExistsException e) {
                    throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"MultiQueryBuilder_0", (String)"Entity %1$s's property %2$s is not exists;Or the property's db field is not configured.", (Object[])new Object[]{parentType.getName(), subObj}), e);
                }
            }
        }
        return typeItem;
    }

    private static IDataEntityProperty getProperty(IDataEntityType type, String property) {
        IDataEntityProperty ret = (IDataEntityProperty)type.getProperties().get((Object)property);
        if (ret == null) {
            property = property.toLowerCase(Locale.ENGLISH);
            DataEntityPropertyCollection cc = type.getProperties();
            int n = cc.size();
            for (int i = 0; i < n; ++i) {
                IDataEntityProperty p = (IDataEntityProperty)cc.get(i);
                String name = p.getName().toLowerCase(Locale.ENGLISH);
                if (!property.equals(name)) continue;
                return p;
            }
        }
        return ret;
    }

    public static String getTableName(QContext ctx, String rootName, String propertyName) {
        String tableGroup;
        IDataEntityProperty propertyType;
        EntityItemProperty propertyItem;
        String fullObjectName = ORMUtil.getFullObjectName(rootName, propertyName);
        EntityItem entityItem = ctx.getEntityItem(fullObjectName);
        if (entityItem == null) {
            return "";
        }
        IDataEntityType entityType = entityItem.entityType;
        if (entityType == null) {
            return "";
        }
        String table = entityType.getAlias();
        int index = propertyName.lastIndexOf(".");
        if (index != -1) {
            propertyName = propertyName.substring(index + 1);
        }
        if ((propertyItem = entityItem.getPropertyItem(propertyName)) != null && (propertyType = propertyItem.getPropertyType()) != null && (tableGroup = propertyType.getTableGroup()) != null && tableGroup.length() > 0) {
            table = table + "_" + tableGroup;
        }
        return table;
    }

    public static String getColumnName(QContext ctx, String rootName, String propertyName) {
        if ("1".equals(propertyName)) {
            return null;
        }
        String fullObjectName = ORMUtil.getFullObjectName(rootName, propertyName);
        EntityItem entityItem = ctx.getEntityItem(fullObjectName);
        if (entityItem == null) {
            return null;
        }
        IDataEntityType entityType = entityItem.entityType;
        int index = propertyName.lastIndexOf(".");
        if (index == -1) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)entityType.getProperties().get((Object)propertyName);
            return iDataEntityProperty == null ? null : iDataEntityProperty.getAlias();
        }
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)entityType.getProperties().get((Object)propertyName.substring(index + 1));
        return iDataEntityProperty == null ? null : iDataEntityProperty.getAlias();
    }

    public static String getTableName(Map<String, IDataEntityType> cache, String rootName, String propertyName) {
        String fullObjectName = ORMUtil.getFullObjectName(rootName, propertyName);
        IDataEntityType iDataEntityType = cache.get(fullObjectName);
        if (iDataEntityType == null) {
            iDataEntityType = ORMConfiguration.innerGetDataEntityType(fullObjectName, cache);
        }
        if (iDataEntityType == null) {
            return null;
        }
        cache.put(fullObjectName, iDataEntityType);
        return iDataEntityType.getAlias();
    }

    public static String getColumnName(Map<String, IDataEntityType> cache, String rootName, String propertyName) {
        if ("1".equals(propertyName)) {
            return null;
        }
        String fullObjectName = ORMUtil.getFullObjectName(rootName, propertyName);
        IDataEntityType iDataEntityType = cache.get(fullObjectName);
        if (iDataEntityType == null) {
            iDataEntityType = ORMConfiguration.innerGetDataEntityType(fullObjectName, cache);
        }
        cache.put(fullObjectName, iDataEntityType);
        int index = propertyName.lastIndexOf(".");
        if (index == -1) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)iDataEntityType.getProperties().get((Object)propertyName);
            return iDataEntityProperty == null ? null : iDataEntityProperty.getAlias();
        }
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)iDataEntityType.getProperties().get((Object)propertyName.substring(index + 1));
        return iDataEntityProperty == null ? null : iDataEntityProperty.getAlias();
    }

    public static String getFullObjectName(String rootName, String propertyName) {
        int index = propertyName.lastIndexOf(".");
        if (index == -1) {
            return rootName;
        }
        String fullObjectName = propertyName.substring(0, index);
        if (fullObjectName.equals(rootName)) {
            return rootName;
        }
        if (!fullObjectName.startsWith(rootName + ".")) {
            fullObjectName = rootName + "." + fullObjectName;
        }
        return fullObjectName;
    }

    public static String getFullObjectName(String rootName, PropertyField propertyField) {
        List<String> fullPropertyNames;
        if (propertyField != null && propertyField.isExpress() && !(fullPropertyNames = propertyField.getPropertySegExpress().getFullPropertyNames()).isEmpty()) {
            return fullPropertyNames.get(0);
        }
        return rootName;
    }

    public static boolean isAllAndFilter(QFilter[] filters) {
        if (filters == null || filters.length == 0) {
            return true;
        }
        for (QFilter filter : filters) {
            if (filter == null) continue;
            List<QFilter.QFilterNest> nests = filter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                if (nest.isAnd()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containEntryEntity(String entityNamePath, Map<String, IDataEntityType> entityTypeCache) {
        String fullObjectName = entityNamePath;
        IDataEntityType entityType;
        while ((entityType = ORMConfiguration.innerGetDataEntityType(fullObjectName, entityTypeCache)) != null) {
            if (ORMConfiguration.isEntryEntityType(entityType)) {
                return true;
            }
            int index = fullObjectName.lastIndexOf(".");
            if (index == -1) {
                return false;
            }
            fullObjectName = fullObjectName.substring(0, index);
        }
        return false;
    }

    public static String getEntryEntity(String rootName, String entityNamePath, Map<String, IDataEntityType> entityTypeCache) {
        String fullObjectName = ORMUtil.getFullObjectName(rootName, entityNamePath);
        IDataEntityType entityType;
        while ((entityType = ORMConfiguration.innerGetDataEntityType(fullObjectName, entityTypeCache)) != null) {
            if (ORMConfiguration.isEntryEntityType(entityType) && !ORMConfiguration.isSubEntityType(entityType)) {
                return fullObjectName;
            }
            int index = fullObjectName.lastIndexOf(".");
            if (index == -1) {
                return null;
            }
            fullObjectName = fullObjectName.substring(0, index);
        }
        return null;
    }

    public static String getAllEntryEntity(String rootName, String entityNamePath, Map<String, IDataEntityType> entityTypeCache) {
        String fullObjectName = ORMUtil.getFullObjectName(rootName, entityNamePath);
        try {
            while (true) {
                IDataEntityType entityType;
                if ((entityType = ORMConfiguration.innerGetDataEntityType(fullObjectName, entityTypeCache)) == null) {
                    return null;
                }
                if (ORMConfiguration.isEntryEntityType(entityType)) {
                    return fullObjectName;
                }
                int index = fullObjectName.lastIndexOf(".");
                if (index == -1) {
                    return null;
                }
                fullObjectName = fullObjectName.substring(0, index);
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getOneToMoreEntityPath(String rootObjName, String path, Map<String, IDataEntityType> entityTypeCache) {
        String fullObjectName = ORMUtil.getFullObjectName(rootObjName, path);
        IDataEntityType entityType;
        while ((entityType = ORMConfiguration.innerGetDataEntityType(fullObjectName, entityTypeCache)) != null) {
            if (entityType != null && (ORMConfiguration.isEntryEntityType(entityType) || ORMConfiguration.isMulBasedata(entityType))) {
                return fullObjectName;
            }
            int index = fullObjectName.lastIndexOf(".");
            if (index == -1) {
                return null;
            }
            fullObjectName = fullObjectName.substring(0, index);
        }
        return null;
    }

    public static void getRightMostDataEntityType(String rootName, String entityNamePath, Map<String, IDataEntityType> ret, Map<String, IDataEntityType> entityTypeCache) {
        String fullObjectName = ORMUtil.getFullObjectName(rootName, entityNamePath);
        while (true) {
            IDataEntityType entityType = ORMConfiguration.innerGetDataEntityType(fullObjectName, entityTypeCache);
            if (fullObjectName.equals(rootName)) {
                ret.put(fullObjectName, entityType);
                return;
            }
            if (entityType == null) {
                return;
            }
            if (ORMConfiguration.isEntryEntityType(entityType) || ORMConfiguration.isSubEntityType(entityType)) {
                ret.put(fullObjectName, entityType);
                return;
            }
            int index = fullObjectName.lastIndexOf(".");
            if (index == -1) {
                return;
            }
            fullObjectName = fullObjectName.substring(0, index);
        }
    }

    public static EntityItem getMulBaseDataEntityItem(EntityItem curEi) {
        if (curEi == null) {
            return null;
        }
        IDataEntityType entityType = curEi.entityType;
        EntityItem parentEi = curEi.getParentEntityItem();
        EntityItem retEi = curEi;
        while (!ORMConfiguration.isMulBasedata(entityType)) {
            if (parentEi == null) {
                return null;
            }
            entityType = parentEi.entityType;
            retEi = parentEi;
            parentEi = parentEi.getParentEntityItem();
        }
        return retEi;
    }

    public static List<EntityItem> getAllMulBaseDataEntityItem(EntityItem curEi) {
        LinkedList<EntityItem> ret = new LinkedList<EntityItem>();
        if (curEi == null) {
            return ret;
        }
        IDataEntityType entityType = curEi.entityType;
        EntityItem parentEi = curEi.getParentEntityItem();
        EntityItem retEi = curEi;
        while (true) {
            if (ORMConfiguration.isMulBasedata(entityType)) {
                ret.add(retEi);
            }
            if (parentEi == null) {
                return ret;
            }
            entityType = parentEi.entityType;
            retEi = parentEi;
            parentEi = parentEi.getParentEntityItem();
        }
    }

    public static String getLikeCP(IDataEntityType dataEntityType) {
        String cp = "like";
        if (ORMUtil.isIgnoreCase(dataEntityType, false)) {
            cp = "ilike";
        }
        return cp;
    }

    public static String getNotLikeCP(IDataEntityType dataEntityType) {
        String cp = "not like";
        if (ORMUtil.isIgnoreCase(dataEntityType, false)) {
            cp = "not ilike";
        }
        return cp;
    }

    public static String getFullName(PropertyField field) {
        String fieldName;
        if (field.isExpress()) {
            Collection<PropertyField> propertyFields = field.getPropertySegExpress().getPropertyFields();
            if (propertyFields == null || propertyFields.size() == 0) {
                fieldName = field.getFullObjectName() + "." + field.getAlias();
            } else {
                PropertyField propertyField = propertyFields.iterator().next();
                fieldName = propertyField.getFullName();
            }
        } else {
            fieldName = field.getFullName();
        }
        return fieldName;
    }

    public static String getFullName(String rootName, String propertyName) {
        int index = propertyName.lastIndexOf(".");
        if (index == -1) {
            return rootName + "." + propertyName;
        }
        String lastName = propertyName.substring(index + 1, propertyName.length());
        String fullObjectName = propertyName.substring(0, index);
        if (fullObjectName.equals(rootName)) {
            return rootName + "." + lastName;
        }
        if (!fullObjectName.startsWith(rootName + ".")) {
            fullObjectName = rootName + "." + fullObjectName;
        }
        return fullObjectName + "." + lastName;
    }

    public static int getValueSize(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof QParameter) {
            return ((QParameter)value).getParameters().length;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            int count = 0;
            for (Object item : iterable) {
                ++count;
            }
            return count;
        }
        if (value instanceof MultiBaseDataFilterValue) {
            Object originValue = ((MultiBaseDataFilterValue)value).getValue();
            if (originValue instanceof Collection) {
                return ((Collection)originValue).size();
            }
            return 1;
        }
        return 1;
    }

    public static boolean isHasAggregate(List<PropertyField> pfs) {
        for (PropertyField field : new ArrayList<PropertyField>(pfs)) {
            if (!field.isExpress()) continue;
            PropertySegExpress propertySegExpress = field.getPropertySegExpress();
            for (String nonProperty : propertySegExpress.getFullStringNames()) {
                for (String s : AGGREGATE_FUNCTION_NAMES) {
                    if (!s.equalsIgnoreCase(nonProperty)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Set<String> allEntryIdProperty(String rootName, String fullObjName, Map<String, IDataEntityType> entityTypeCache) {
        HashSet<String> ret = new HashSet<String>(2);
        while (true) {
            int index;
            String entryEntityName;
            IDataEntityType entityType;
            boolean isMulBasedata;
            if (isMulBasedata = ORMConfiguration.isMulBasedata(entityType = ORMConfiguration.innerGetDataEntityType(fullObjName, entityTypeCache))) {
                ret.add(fullObjName + ".pkid");
            }
            if ((entryEntityName = ORMUtil.getAllEntryEntity(rootName, fullObjName, entityTypeCache)) != null) {
                ret.add(entryEntityName + ".id");
            }
            if ((index = fullObjName.lastIndexOf(".")) == -1) {
                return ret;
            }
            fullObjName = fullObjName.substring(0, index);
        }
    }

    public static Set<String> allOneToMoreIdProperty(String rootName, String fulObjName, Map<String, IDataEntityType> entityTypeCache) {
        HashSet<String> ret = new HashSet<String>(2);
        while (true) {
            int index;
            String entryEntityName;
            if ((entryEntityName = ORMUtil.getOneToMoreEntityPath(rootName, fulObjName, entityTypeCache)) != null) {
                IDataEntityType entityType = ORMConfiguration.innerGetDataEntityType(entryEntityName, entityTypeCache);
                boolean isMulBasedata = ORMConfiguration.isMulBasedata(entityType);
                if (isMulBasedata) {
                    ret.add(entryEntityName + ".pkid");
                } else {
                    ret.add(entryEntityName + ".id");
                }
            }
            if ((index = fulObjName.lastIndexOf(".")) == -1) {
                return ret;
            }
            fulObjName = fulObjName.substring(0, index);
        }
    }

    public static String addEscapeClause(IDataEntityType dataEntityType) {
        return " ";
    }

    public static boolean isFuzzyQuery(QFilterHint qFilterHint) {
        return qFilterHint != null && (qFilterHint instanceof LikeHint || qFilterHint instanceof NotLikeHint);
    }

    public static boolean isContains(QFilterHint qFilterHint) {
        if (qFilterHint instanceof LikeHint) {
            LikeHint likeHint = (LikeHint)qFilterHint;
            return likeHint.isAppendRightPercent() && likeHint.isAppendLeftPercent();
        }
        return false;
    }

    public static boolean isNotContains(QFilterHint qFilterHint) {
        if (qFilterHint instanceof NotLikeHint) {
            NotLikeHint notLikeHint = (NotLikeHint)qFilterHint;
            return notLikeHint.isAppendRightPercent() && notLikeHint.isAppendLeftPercent();
        }
        return false;
    }

    public static boolean isStartWith(QFilterHint qFilterHint) {
        if (qFilterHint instanceof LikeHint) {
            LikeHint likeHint = (LikeHint)qFilterHint;
            return likeHint.isAppendRightPercent() && !likeHint.isAppendLeftPercent();
        }
        return false;
    }

    public static boolean isEndWith(QFilterHint qFilterHint) {
        if (qFilterHint instanceof LikeHint) {
            LikeHint likeHint = (LikeHint)qFilterHint;
            return !likeHint.isAppendRightPercent() && likeHint.isAppendLeftPercent();
        }
        return false;
    }

    public static boolean isFtlikeStartWith(QFilterHint qFilterHint) {
        if (qFilterHint instanceof FTLikeHint) {
            FTLikeHint ftLikeHint = (FTLikeHint)qFilterHint;
            return ftLikeHint.isAppendRightPercent() && !ftLikeHint.isAppendLeftPercent();
        }
        return false;
    }

    public static boolean isFtlikeContains(QFilterHint qFilterHint) {
        if (qFilterHint instanceof FTLikeHint) {
            FTLikeHint ftLikeHint = (FTLikeHint)qFilterHint;
            return ftLikeHint.isAppendRightPercent() && ftLikeHint.isAppendLeftPercent();
        }
        return false;
    }

    public static String transferAndAppendPercent(QFilterHint qFilterHint, String value, IDataEntityType entityType) {
        boolean appenRight;
        boolean appendLeft;
        boolean escape;
        if (qFilterHint == null) {
            return value;
        }
        if (!(qFilterHint instanceof LikeHint) && !(qFilterHint instanceof NotLikeHint)) {
            return value;
        }
        if (qFilterHint instanceof LikeHint) {
            LikeHint likeHint = (LikeHint)qFilterHint;
            escape = likeHint.isEscape();
            appendLeft = likeHint.isAppendLeftPercent();
            appenRight = likeHint.isAppendRightPercent();
        } else {
            NotLikeHint notLikeHint = (NotLikeHint)qFilterHint;
            escape = notLikeHint.isEscape();
            appendLeft = notLikeHint.isAppendLeftPercent();
            appenRight = notLikeHint.isAppendRightPercent();
        }
        String tranfserValue = value;
        if (escape) {
            tranfserValue = ORMUtil.escapeChars(value, entityType);
        }
        if (appendLeft) {
            tranfserValue = "%" + tranfserValue;
        }
        if (appenRight) {
            tranfserValue = tranfserValue + "%";
        }
        return tranfserValue;
    }

    public static String escapeChars(String value, IDataEntityType entityType) {
        DBType dbType = ORMUtil.getDBType(entityType == null ? DBRoute.base.getRouteKey() : entityType.getDBRouteKey());
        if (dbType != DBType.Postgres && dbType != DBType.MySQL) {
            return value;
        }
        String escapeValue = value.replace("\\", "\\\\").replace("_", "\\_").replace("%", "\\%");
        String escapeChars = ORMConfig.ESCAPE_CHARS.getString();
        String[] escapeCharArray = escapeChars.split(",");
        if (escapeChars != null && escapeChars.trim().length() > 0) {
            for (String escapeChar : escapeCharArray) {
                escapeValue = escapeValue.replace(escapeChar, "\\" + escapeChar);
            }
        }
        return escapeValue;
    }

    public static Map<String, List<Integer>> groupBy(AggregateFuncs aggregateFuncs) {
        String[] fields = aggregateFuncs.getFields();
        HashMap<String, List<Integer>> indexMap = new HashMap<String, List<Integer>>();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            int lastIndex = field.lastIndexOf(".");
            if (lastIndex == -1) {
                ArrayList<Integer> indexList = (ArrayList<Integer>)indexMap.get("id");
                if (indexList == null) {
                    indexList = new ArrayList<Integer>(2);
                    indexMap.put("id", indexList);
                }
                indexList.add(i);
                continue;
            }
            String key = field.substring(0, lastIndex) + ".id";
            ArrayList<Integer> indexList = (ArrayList<Integer>)indexMap.get(key);
            if (indexList == null) {
                indexList = new ArrayList<Integer>(2);
                indexMap.put(key, indexList);
            }
            indexList.add(i);
        }
        return indexMap;
    }

    public static AggregateFuncs rebuildFuncs(List<Integer> funcIndexs, String[] funcs) {
        String[] newFuncs = new String[funcIndexs.size()];
        for (int i = 0; i < funcIndexs.size(); ++i) {
            newFuncs[i] = funcs[funcIndexs.get(i)];
        }
        return new AggregateFuncs(newFuncs);
    }

    public static String generateSelectFields(AggregateFuncs aggFunc) {
        String queryFields = ORMUtil.generateIds(aggFunc);
        queryFields = StringUtil.isEmpty((String)queryFields) ? aggFunc.getSelectFields() : queryFields + "," + aggFunc.getSelectFields();
        return queryFields;
    }

    public static String generateIds(AggregateFuncs aggregateFuncs) {
        String[] fieldArray = aggregateFuncs.getFields();
        if (fieldArray == null || fieldArray.length <= 0) {
            return "id";
        }
        HashMap<String, Boolean> existsIDs = new HashMap<String, Boolean>();
        for (String field : fieldArray) {
            if (field == null) continue;
            int lastDotIndex = field.lastIndexOf(".");
            if (lastDotIndex == -1) {
                Boolean root = (Boolean)existsIDs.get("id");
                boolean equlasResult = "id".equalsIgnoreCase(field);
                if (root != null) {
                    if (!equlasResult) continue;
                    existsIDs.put("id", true);
                    continue;
                }
                existsIDs.put("id", equlasResult);
                continue;
            }
            String suffix = field.substring(lastDotIndex + 1);
            String prefix = field.substring(0, lastDotIndex);
            boolean equlasResult = "id".equalsIgnoreCase(suffix);
            Boolean pk = (Boolean)existsIDs.get(prefix + ".id");
            if (pk != null) {
                if (!equlasResult) continue;
                existsIDs.put(prefix + ".id", true);
                continue;
            }
            existsIDs.put(prefix + ".id", equlasResult);
        }
        StringBuilder fieldsBuilder = new StringBuilder();
        for (Map.Entry next : existsIDs.entrySet()) {
            String id = (String)next.getKey();
            Boolean exists = (Boolean)next.getValue();
            if (exists.booleanValue()) continue;
            fieldsBuilder.append(id);
            fieldsBuilder.append(",");
        }
        if (fieldsBuilder.length() > 1) {
            return fieldsBuilder.substring(0, fieldsBuilder.length() - 1);
        }
        return fieldsBuilder.toString();
    }

    public static Object[] aggregateBySql(String algoKey, SingleQuery singleQuery, AggregateFuncs aggregateFuncs, QFilter[] filters) {
        String[] funcs = aggregateFuncs.getFuncs();
        int len = funcs.length;
        StringBuilder sqlBuilder = new StringBuilder(128);
        ORMUtil.appendMainQuerySelectFields(singleQuery, aggregateFuncs, sqlBuilder);
        return ORMUtil.queryResult(algoKey, singleQuery, len, sqlBuilder, filters, aggregateFuncs);
    }

    public static void __releaseTemptable(List<TemptableFacade> temptableFacades) {
        if (temptableFacades == null || temptableFacades.isEmpty()) {
            return;
        }
        ArrayList<TemptableFacade> temptableFacadeList = new ArrayList<TemptableFacade>(temptableFacades);
        TemptableCleaner cleaner = new TemptableCleaner(temptableFacadeList);
        cleaner.cleanData();
        if (TX.inTX()) {
            TX.addCommitListener((CommitListener)cleaner);
        } else {
            cleaner.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] queryResult(String algoKey, SingleQuery singleQuery, int len, StringBuilder sqlBuilder, QFilter[] filters, AggregateFuncs aggregateFuncs) {
        try (TemptableFacadeContext temptableContext = TemptableFacadeContexts.create((String)"ORMUtil.queryResult");){
            String qpSql;
            String oldSql;
            final AutoRelease autoRelease = singleQuery.optInFilter();
            singleQuery.removeInnerField(true, true);
            List<String> fields = Arrays.asList(ORMUtil.generateSelectFields(aggregateFuncs).split(","));
            for (int i = 0; i < fields.size(); ++i) {
                fields.set(i, ORMUtil.getFullName(singleQuery.getFullObjName(), fields.get(i).split(" ")[0]));
            }
            singleQuery.rebuildSelectFields(fields);
            SingleQuery.QueryParameter qp = singleQuery.getQueryParameter();
            SingleQuery query = null;
            if (QueryUtils.containsExists(singleQuery.getGenQueryParameterWhereQFilter())) {
                query = singleQuery.optResetFilter(singleQuery.getGenQueryParameterWhereQFilter());
                qp = query.getQueryParameter();
            }
            if (!CollectionUtils.isEmpty(singleQuery.getSubQueryNodes())) {
                if (query == null) {
                    query = singleQuery;
                }
                query = QueryUtils.rebuildQuery(algoKey, query);
                qp = query.getQueryParameter();
            }
            if (!(oldSql = (qpSql = qp.getSql().trim()).toUpperCase(Locale.ENGLISH)).startsWith("SELECT DISTINCT") && ORMUtil.needDistinct(singleQuery.getSelectFields(), singleQuery.getAllCtx(), filters, singleQuery.getAllJoinFilterMap())) {
                qpSql = "SELECT DISTINCT " + qpSql.substring("SELECT".length());
            }
            sqlBuilder.append(" FROM (").append(qpSql).append(") C");
            Object[] params = qp.getParams();
            Object[] result = new Object[len];
            try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)singleQuery.getDBRoute(), (String)sqlBuilder.toString(), (Object[])params);){
                if (autoRelease != null) {
                    ds.addListener(new DataSet.Listener(){

                        public void beforeClosed() {
                            autoRelease.close();
                        }
                    });
                }
                Row row = (Row)ds.iterator().next();
                for (int i = 0; i < len; ++i) {
                    result[i] = row.get(i);
                }
            }
            finally {
                ORMUtil.__releaseTemptable(temptableContext.getTableList());
            }
            Object[] objectArray = result;
            return objectArray;
        }
    }

    private static void appendMainQuerySelectFields(SingleQuery singleQuery, AggregateFuncs aggregateFuncs, StringBuilder sql) {
        String[] funcs = aggregateFuncs.getFuncs();
        int len = funcs.length;
        String[] aliasFields = aggregateFuncs.getAliasFields();
        HashMap<String, IDataEntityType> ret = new HashMap<String, IDataEntityType>();
        for (String field : aggregateFuncs.getFields()) {
            ORMUtil.getRightMostDataEntityType(singleQuery.getFullObjName(), field, ret, singleQuery.getAllCtx().getEntityTypeCache());
        }
        sql.append("SELECT ");
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sql.append(',');
            }
            sql.append(funcs[i]).append('(').append(aliasFields[i]).append(')');
        }
    }

    public static boolean needDistinct(PropertyField[] selectFields, QContext allCtx, QFilter[] filters) {
        int maxSelectFieldsType = 1;
        for (PropertyField field : selectFields) {
            maxSelectFieldsType = ORMUtil.getSelectFieldType(field, maxSelectFieldsType, allCtx);
        }
        if (maxSelectFieldsType == 4) {
            return true;
        }
        if (filters == null) {
            return false;
        }
        String fullObjectName = allCtx.getMainEntityItem().getFullObjectName();
        int maxQFilterFieldsType = 1;
        for (QFilter filter : filters) {
            int currentFilterType = ORMUtil.getQFilterFildsType(filter, fullObjectName, allCtx);
            if (currentFilterType <= maxQFilterFieldsType) continue;
            maxQFilterFieldsType = currentFilterType;
        }
        return maxQFilterFieldsType == 4 || maxQFilterFieldsType > maxSelectFieldsType;
    }

    public static boolean needDistinct(PropertyField[] selectFields, QContext allCtx, QFilter[] whereFilters, Map<String, QFilter> allJoinFilterMap) {
        boolean needDistinct_withWhereFilters = ORMUtil.needDistinct(selectFields, allCtx, whereFilters);
        if (needDistinct_withWhereFilters) {
            return true;
        }
        if (!ORMConfig.AGGREGATE_NEEDDISTINCT_WITH_JOINFILTER.getBoolean(RequestContext.get().getTenantId())) {
            return false;
        }
        if (allJoinFilterMap == null || allJoinFilterMap.isEmpty()) {
            return false;
        }
        QFilter[] joinFilters = new QFilter[allJoinFilterMap.size()];
        int joinFilterIndex = 0;
        Set<Map.Entry<String, QFilter>> mapEntries = allJoinFilterMap.entrySet();
        for (Map.Entry<String, QFilter> entry : mapEntries) {
            joinFilters[joinFilterIndex] = entry.getValue();
            ++joinFilterIndex;
        }
        int maxSelectFieldsType = 1;
        for (PropertyField field : selectFields) {
            maxSelectFieldsType = ORMUtil.getSelectFieldType(field, maxSelectFieldsType, allCtx);
        }
        String string = allCtx.getMainEntityItem().getFullObjectName();
        int maxQFilterFieldsType = 1;
        for (QFilter filter : joinFilters) {
            int currentFilterType = ORMUtil.getJoinQFilterFildsType(filter, string, allCtx);
            if (currentFilterType <= maxQFilterFieldsType) continue;
            maxQFilterFieldsType = currentFilterType;
        }
        return maxQFilterFieldsType == 4 || maxQFilterFieldsType > maxSelectFieldsType;
    }

    private static Integer getSelectFieldType(PropertyField field, int maxSelectFieldsType, QContext allCtx) {
        String fullName = field.getFullName();
        if (field.isExpress()) {
            Collection<PropertyField> propertyFields = field.getPropertySegExpress().getPropertyFields();
            for (PropertyField propertyField : propertyFields) {
                int selectFieldsType = ORMUtil.getType(propertyField.getFullName(), allCtx);
                if (selectFieldsType <= maxSelectFieldsType) continue;
                maxSelectFieldsType = selectFieldsType;
            }
        } else {
            int selectFieldsType = ORMUtil.getType(fullName, allCtx);
            if (selectFieldsType > maxSelectFieldsType) {
                maxSelectFieldsType = selectFieldsType;
            }
        }
        return maxSelectFieldsType;
    }

    private static int getQFilterFildsType(QFilter qFilter, String rootObjectName, QContext allCtx) {
        if (qFilter != null) {
            int type = 1;
            if (!qFilter.isJoinFilter() && !qFilter.isJoinSQLFilter()) {
                type = ORMUtil.getQFilterType(qFilter, allCtx, type, rootObjectName);
            }
            List<QFilter.QFilterNest> nests = qFilter.getNests(true);
            int nestQFilterType = 1;
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = nest.getFilter();
                if (nestFilter.isJoinFilter() || nestFilter.isJoinSQLFilter()) continue;
                nestQFilterType = ORMUtil.getQFilterType(nestFilter, allCtx, nestQFilterType, rootObjectName);
            }
            if (nestQFilterType > type) {
                type = nestQFilterType;
            }
            return type;
        }
        return 1;
    }

    private static int getJoinQFilterFildsType(QFilter qFilter, String rootObjectName, QContext allCtx) {
        if (qFilter != null) {
            int type = 1;
            if (!qFilter.isJoinSQLFilter()) {
                type = ORMUtil.getQFilterType(qFilter, allCtx, type, rootObjectName);
            }
            List<QFilter.QFilterNest> nests = qFilter.getNests(true);
            int nestQFilterType = 1;
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = nest.getFilter();
                if (nestFilter.isJoinSQLFilter()) continue;
                nestQFilterType = ORMUtil.getQFilterType(nestFilter, allCtx, nestQFilterType, rootObjectName);
            }
            if (nestQFilterType > type) {
                type = nestQFilterType;
            }
            return type;
        }
        return 1;
    }

    private static Integer getQFilterType(QFilter qFilter, QContext allCtx, int type, String rootObjectName) {
        PropertyField field;
        String propertyName = qFilter.getProperty();
        Object value = qFilter.getValue();
        if (value instanceof MultiBaseDataFilterValue) {
            MultiBaseDataFilterValue multiBaseDataFilterValue = (MultiBaseDataFilterValue)value;
            propertyName = multiBaseDataFilterValue.getJoinProperty();
        }
        try {
            String fullObjectName = allCtx.getMainEntityItem().getFullObjectName();
            String rootObjName = ORMUtil.getRootObjName(fullObjectName);
            field = SelectFields.parseFrom(propertyName).createPropertyFields(rootObjName).get(0);
            return ORMUtil.getQFilterType(allCtx, field, qFilter, rootObjectName, propertyName, type);
        }
        catch (Exception e) {
            field = qFilter.__copy(false).__getParsedProperty(allCtx);
            return ORMUtil.getQFilterType(allCtx, field, qFilter, rootObjectName, propertyName, type);
        }
    }

    private static Integer getQFilterType(QContext allCtx, PropertyField field, QFilter qFilter, String rootObjectName, String propertyName, int type) {
        int currentType = 1;
        if ((qFilter.getCP().equalsIgnoreCase("ftlike") || qFilter.getCP().equalsIgnoreCase("match")) && (qFilter.getProperty().equalsIgnoreCase("1") || qFilter.getProperty().equalsIgnoreCase("2"))) {
            currentType = ORMUtil.getFtlikeType(rootObjectName, (String)qFilter.getValue(), allCtx);
        } else if (field.isExpress()) {
            Collection<PropertyField> propertyFields = field.getPropertySegExpress().getPropertyFields();
            for (PropertyField propertyField : propertyFields) {
                int expressFieldType = ORMUtil.getType(propertyField.getFullName(), allCtx);
                if (expressFieldType <= type) continue;
                type = expressFieldType;
            }
        } else if (!propertyName.startsWith(rootObjectName + ".")) {
            propertyName = rootObjectName + "." + propertyName;
            currentType = ORMUtil.getType(propertyName, allCtx);
        }
        if (currentType > type) {
            type = currentType;
        }
        return type;
    }

    private static int getFtlikeType(String rootObjectName, String filterValue, QContext allCtx) {
        if (StringUtils.isEmpty((String)filterValue)) {
            return 1;
        }
        int splitIndex = filterValue.indexOf("#");
        if (splitIndex == -1) {
            return 1;
        }
        String[] properties = filterValue.substring(0, splitIndex).split(",");
        if (properties == null || properties.length <= 0) {
            return 1;
        }
        int maxtType = 1;
        for (String property : properties) {
            int type;
            if (!property.startsWith(rootObjectName + ".")) {
                property = rootObjectName + "." + property;
            }
            if ((type = ORMUtil.getType(property, allCtx)) <= maxtType) continue;
            maxtType = type;
        }
        return maxtType;
    }

    private static int getType(String propertyName, QContext allCtx) {
        int currentType = 1;
        if (propertyName.contains(".")) {
            try {
                EntityItem propertyItem = allCtx.getEntityItem(propertyName);
                if (propertyItem != null) {
                    IDataEntityType propertyEntityType = propertyItem.entityType;
                    if (ORMConfiguration.isSubEntityType(propertyEntityType)) {
                        return 3;
                    }
                    if (ORMConfiguration.isEntryEntityType(propertyEntityType)) {
                        return 2;
                    }
                }
            }
            catch (Exception propertyItem) {
                // empty catch block
            }
            int index = propertyName.lastIndexOf(".");
            String subEntityName = propertyName.substring(0, index);
            EntityItem entityItem = allCtx.getEntityItem(subEntityName);
            if (entityItem == null) {
                return currentType;
            }
            IDataEntityType entityType = entityItem.entityType;
            EntityItem parentEntityItem = entityItem.getParentEntityItem();
            while (entityType != null) {
                if (ORMConfiguration.isSubEntityType(entityType)) {
                    currentType = 3;
                    break;
                }
                if (ORMConfiguration.isEntryEntityType(entityType)) {
                    currentType = 2;
                    break;
                }
                if (ORMConfiguration.isMulBasedata(entityType)) {
                    currentType = 4;
                    break;
                }
                if (parentEntityItem == null) break;
                entityType = parentEntityItem.entityType;
                parentEntityItem = parentEntityItem.getParentEntityItem();
            }
        }
        return currentType;
    }

    public static DataType getDataTypeByValue(Object value) {
        if (value == null) {
            return DataType.UnknownType;
        }
        if (value instanceof BigDecimal) {
            return DataType.BigDecimalType;
        }
        if (value instanceof Integer) {
            return DataType.IntegerType;
        }
        if (value instanceof Long) {
            return DataType.LongType;
        }
        if (value instanceof String) {
            return DataType.StringType;
        }
        if (value instanceof Boolean) {
            return DataType.BooleanType;
        }
        if (value instanceof Date) {
            return DataType.DateType;
        }
        if (value instanceof Timestamp) {
            return DataType.TimestampType;
        }
        if (value instanceof Double) {
            return DataType.DoubleType;
        }
        return DataType.UnknownType;
    }

    public static String getFilterProperty(QContext ctx, QFilter filter, String rootName) {
        try {
            PropertyField propertyField = SelectFields.parseFrom(filter.getProperty()).createPropertyFields(rootName).get(0);
            return ORMUtil.getFullObjectName(propertyField, rootName, filter);
        }
        catch (Exception e) {
            logger.error("getFilterProperty error", (Throwable)e);
            PropertyField propertyField = filter.__getParsedProperty(ctx);
            return ORMUtil.getFullObjectName(propertyField, rootName, filter);
        }
    }

    private static String getFullObjectName(PropertyField propertyField, String rootName, QFilter filter) {
        String fullObjectName = ORMUtil.getFullObjectName(rootName, propertyField);
        if (rootName.equals(fullObjectName)) {
            fullObjectName = filter.getProperty();
        }
        return fullObjectName;
    }

    public static boolean isExistsCrossDB(QContext ctx, String rootObjectName, Map<String, Set<DBConfig>> configs, Set<String> allFullOjbectNames) {
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        HashMap<String, EntityItem> items = new HashMap<String, EntityItem>(4);
        HashMap<String, DBRoute> routes = new HashMap<String, DBRoute>(4);
        Iterator<String> iterator = allFullOjbectNames.iterator();
        while (iterator.hasNext()) {
            String talbe;
            EntityItem entityItem;
            String fullObjectName;
            String oldFullObjectName = fullObjectName = iterator.next();
            if (!fullObjectName.equals(rootObjectName) && !fullObjectName.startsWith(rootObjectName + ".")) {
                fullObjectName = rootObjectName + "." + fullObjectName;
            }
            if ((entityItem = ctx.getEntityItem(fullObjectName)) != null) {
                talbe = entityItem.entityType.getAlias();
            } else {
                entityItem = ctx.getEntityItem(oldFullObjectName);
                if (entityItem == null) {
                    throw new IllegalArgumentException(rootObjectName + "." + oldFullObjectName + " not exists entity");
                }
                talbe = entityItem.entityType.getAlias();
                fullObjectName = oldFullObjectName;
            }
            IDataEntityType dt = entityItem.entityType;
            DBRoute dbRoute = new DBRoute(dt.getDBRouteKey());
            Set dbConfigs = DataSourceFactory.getDBConfigs((String)tenantId, (String)dbRoute.getRouteKey(), (String)accountId, (String[])new String[]{talbe});
            configs.put(fullObjectName, dbConfigs);
            items.put(fullObjectName, entityItem);
            routes.put(fullObjectName, dbRoute);
        }
        ORMUtil.isDBSync(routes, configs, ctx, tenantId, accountId, items);
        boolean result = false;
        Iterator<Map.Entry<String, Set<DBConfig>>> iterator2 = configs.entrySet().iterator();
        String entityName = null;
        String entityName1 = null;
        block1: while (iterator2.hasNext()) {
            Map.Entry<String, Set<DBConfig>> next = iterator2.next();
            entityName = next.getKey();
            Set<DBConfig> entityConfigs = next.getValue();
            for (Map.Entry<String, Set<DBConfig>> next1 : configs.entrySet()) {
                entityName1 = next1.getKey();
                Set<DBConfig> entityConfigs1 = next1.getValue();
                for (DBConfig config : entityConfigs) {
                    for (DBConfig config1 : entityConfigs1) {
                        if (config.canSharing(config1)) continue;
                        if (ORMConfig.ENALBE_CROSSDB_OR.getBoolean()) {
                            result = true;
                            break block1;
                        }
                        throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"CrossDBORQuery_0", (String)"Entity{0} and entity {1} exists cross db or,cannot support.Please set the MC parameter orm.enable.crossdbor=true.", (Object[])new Object[]{entityName, entityName1}));
                    }
                }
            }
        }
        if (result) {
            result = ORMUtil.canNotCrossSchemaJoin(rootObjectName, entityName, entityName1, ctx, items);
        }
        return result;
    }

    private static void isDBSync(Map<String, DBRoute> routes, Map<String, Set<DBConfig>> configs, QContext ctx, String tenantId, String accountId, Map<String, EntityItem> items) {
        Iterator<String> iterator = configs.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                boolean isBDSync;
                EntityItem entityItem;
                String fullObjectName = iterator.next();
                int index = fullObjectName.lastIndexOf(".");
                if (index <= 0 || (entityItem = ORMUtil.getEntityItem(ctx, items, fullObjectName)) == null) continue;
                String entityName = entityItem.entityType.getName();
                String parentFullObjectName = fullObjectName.substring(0, index);
                DBRoute parentBbRoute = routes.get(parentFullObjectName);
                EntityItem parentEntityItem = ORMUtil.getEntityItem(ctx, items, parentFullObjectName);
                if (parentBbRoute == null) {
                    if (parentEntityItem == null) continue;
                    parentBbRoute = new DBRoute(parentEntityItem.entityType.getDBRouteKey());
                }
                if (!(isBDSync = BDSyncFactory.getBDSync().isAvailable(entityName, parentBbRoute))) continue;
                Set dbConfigs = configs.get(parentFullObjectName);
                if (dbConfigs == null) {
                    dbConfigs = DataSourceFactory.getDBConfigs((String)tenantId, (String)parentBbRoute.getRouteKey(), (String)accountId, (String[])new String[]{parentEntityItem.entityType.getAlias()});
                }
                configs.put(fullObjectName, dbConfigs);
            }
            catch (Exception e) {
                logger.error("judge db sync error:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static boolean canNotCrossSchemaJoin(String rootName, String entityName, String entityName1, QContext ctx, Map<String, EntityItem> items) {
        try {
            if (!ORMConfig.CROSSDBOR_CROSSSCHEMA.getBoolean()) {
                return true;
            }
            HashSet<String> entityNames = new HashSet<String>();
            entityNames.add(entityName);
            entityNames.add(entityName1);
            entityNames.add(rootName);
            for (String name : entityNames) {
                if (name == null) continue;
                IDataEntityType entityType = items.get((Object)name).entityType;
                TenantAccountCrossDBRuntime.parseEntityTables(entityType, ctx.getEntityTypeCache());
                String crossToRouteKey = entityType.getDBRouteKey();
                for (String name1 : entityNames) {
                    IDataEntityType entityType1 = items.get((Object)name1).entityType;
                    String table = entityType1.getAlias().toLowerCase();
                    TenantAccountCrossDBRuntime.parseEntityTables(entityType1, ctx.getEntityTypeCache());
                    String crossDBTable = TenantAccountCrossDBRuntime.getCrossDBTable(entityType1.getDBRouteKey(), table, crossToRouteKey, true);
                    if (table.equals(crossDBTable)) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.info("judge cross join error,rootName:{},entityName:{},entityName1:{},items:{},error message:{}", new Object[]{rootName, entityName, entityName1, items, e.getMessage()});
        }
        return true;
    }

    private static EntityItem getEntityItem(QContext ctx, Map<String, EntityItem> items, String fullObjectName) {
        EntityItem entityItem = items.get(fullObjectName);
        if (entityItem != null) {
            return entityItem;
        }
        return ctx.getEntityItem(fullObjectName);
    }

    public static String getField(IDataEntityProperty dp) {
        if (entryProp.isAssignableFrom(dp.getClass())) {
            return dp.getParent().getPrimaryKey().getAlias();
        }
        return dp.getAlias();
    }

    public static String getPrimaryKey(IDataEntityType dt) {
        String pk = ORMConfiguration.isEntryEntityType(dt) ? dt.getParent().getPrimaryKey().getAlias() : (ORMConfiguration.isMulBasedata(dt) ? ORMUtil.getMultiPrimaryKey(dt) : dt.getPrimaryKey().getAlias());
        return pk;
    }

    public static String getRelationKey(IDataEntityType dt, EntityItem entityItem) {
        String relKey = ORMConfiguration.isEntryEntityType(dt) ? entityItem.getFkFieldName() : (ORMConfiguration.isMulBasedata(dt) ? ORMUtil.getMultiPrimaryKey(dt) : dt.getPrimaryKey().getAlias());
        return relKey;
    }

    private static String getMultiPrimaryKey(IDataEntityType dt) {
        IDataEntityType parent;
        String primaryKey = dt.getPrimaryKey().getAlias();
        while ((parent = dt.getParent()) != null) {
            if (ORMConfiguration.isMulBasedata(parent)) continue;
            primaryKey = parent.getPrimaryKey().getAlias();
            break;
        }
        return primaryKey;
    }

    public static boolean isCpExpectedAndCrossDB(QFilter filter, Map<String, Set<DBConfig>> configs, Set<String> allFullOjbectNames, QContext ctx, String rootObjectName) {
        if (filter == null) {
            return false;
        }
        if (!ORMUtil.isExpectedCp(filter.getCP(), Lists.newArrayList((Object[])new String[]{"!=", "<>", "not in", "not like", "is not null"}))) {
            return false;
        }
        return ORMUtil.isCrossDB(filter, configs, allFullOjbectNames, ctx, rootObjectName);
    }

    public static boolean isNotEqualsAndCrossDB(QFilter filter, Map<String, Set<DBConfig>> configs, Set<String> allFullOjbectNames, QContext ctx, String rootObjectName) {
        return ORMUtil.isCpExpectedAndCrossDB(filter, configs, allFullOjbectNames, ctx, rootObjectName);
    }

    private static boolean isExpectedCp(String cp, List<String> expectedCps) {
        return expectedCps.contains(cp);
    }

    private static boolean isCrossDB(QFilter filter, Map<String, Set<DBConfig>> configs, Set<String> allFullOjbectNames, QContext ctx, String rootObjName) {
        String filterProperty = ORMUtil.getFilterProperty(ctx, filter, rootObjName);
        int dotIndex = filterProperty.lastIndexOf(".");
        if (dotIndex == -1) {
            return false;
        }
        String fullObject = filterProperty.substring(0, dotIndex);
        if (fullObject.equalsIgnoreCase(rootObjName)) {
            return false;
        }
        while (true) {
            allFullOjbectNames.add(fullObject);
            int index = fullObject.lastIndexOf(".");
            if (index == -1) break;
            fullObject = fullObject.substring(0, index);
        }
        allFullOjbectNames.add(rootObjName);
        return ORMUtil.isExistsCrossDB(ctx, rootObjName, configs, allFullOjbectNames);
    }

    public static boolean isMulTypeBasedata(String property, EntityItem ei) {
        try {
            EntityItem entityItem = ei.joinProperty.getParentEntityItem();
            if (entityItem == null) {
                return false;
            }
            EntityItemProperty propertyItem = entityItem.getPropertyItem(property);
            if (propertyItem == null) {
                return false;
            }
            IDataEntityProperty propertyType = propertyItem.getPropertyType();
            if (propertyType == null) {
                return false;
            }
            if (propertyType.getClass().getName().equalsIgnoreCase("kd.bos.entity.property.ItemClassProp")) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("isMultiType erro:", (Throwable)e);
        }
        return false;
    }

    public static String[] getIds(String[] fields) {
        String[] ids = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            int dotIndex = fields[i].lastIndexOf(".");
            ids[i] = dotIndex == -1 ? "id" : fields[i].substring(0, dotIndex) + ".id";
        }
        return ids;
    }

    public static boolean hasOrderFields(QueryTreeNode node) {
        if (node == null) {
            return false;
        }
        SingleQuery query = node.getQuery();
        if (query == null) {
            return false;
        }
        QContext allCtx = query.getAllCtx();
        if (allCtx == null) {
            return false;
        }
        return allCtx.isHasOrderField();
    }

    public static boolean optimizeOnCostEnable(QContext ctx) {
        if (ctx != null && ctx.getORMHint() != null && ctx.getORMHint().isOrmOptOnCost() != null) {
            return ctx.getORMHint().isOrmOptOnCost();
        }
        String tenantId = RequestContext.get().getTenantId();
        return ORMConfig.OPTIMIZE_ON_COST.getBoolean(tenantId);
    }

    public static String getFullTypeName(IDataEntityProperty propertyType, String itemclassfieldFullObjName, QContext ctx) throws Exception {
        Class<?> aClass = Class.forName("kd.bos.entity.property.ItemClassProp");
        Method getTypePropName = aClass.getDeclaredMethod("getTypePropName", new Class[0]);
        String typeName = (String)getTypePropName.invoke((Object)propertyType, new Object[0]);
        typeName = ORMUtil.getFullTypeNameRecursively(typeName, itemclassfieldFullObjName, ctx);
        return typeName;
    }

    private static String getFullTypeNameRecursively(String typeName, String fullObjectName, QContext ctx) {
        if (StringUtils.isEmpty((String)typeName) || StringUtils.isEmpty((String)fullObjectName)) {
            return typeName;
        }
        EntityItem entityItem = ctx.getEntityItem(fullObjectName);
        if (entityItem != null && entityItem.entityType.getProperties().containsKey((Object)typeName)) {
            int index = fullObjectName.indexOf(".");
            if (index != -1) {
                typeName = fullObjectName.substring(index + 1) + "." + typeName;
            }
            return typeName;
        }
        int lastDotIndex = fullObjectName.lastIndexOf(".");
        if (lastDotIndex != -1) {
            return ORMUtil.getFullTypeNameRecursively(typeName, fullObjectName.substring(0, lastDotIndex), ctx);
        }
        return typeName;
    }

    public static boolean isIgnoreCase(IDataEntityType entityType, boolean isEs) {
        return ORMUtil.isIgnoreCase(isEs, entityType.getDBRouteKey());
    }

    public static boolean isIgnoreCase(String entityName, boolean isEs) {
        RequestContext requestContext = RequestContext.get();
        String key = requestContext.getTenantId() + "_" + requestContext.getAccountId() + "_" + entityName;
        String routeKey = entityNameToRouteKey.computeIfAbsent(key, k -> ORMConfiguration.innerGetDataEntityType(entityName, new HashMap<String, IDataEntityType>()).getDBRouteKey());
        return ORMUtil.isIgnoreCase(isEs, routeKey);
    }

    public static Boolean isQuickSearchFromES() {
        String systemParam = ORMUtil.getSystemParam("orm_quicksearch_enable");
        if (systemParam != null && systemParam.trim().length() > 0) {
            return "true".equals(systemParam.trim().toLowerCase(Locale.ENGLISH));
        }
        return null;
    }

    private static String getSystemParam(String key) {
        Object cacheInstance;
        if (key == null || key.trim().length() == 0) {
            return null;
        }
        Map<String, String> paramMap = params.get();
        String result = paramMap.get(key);
        if (result != null) {
            if (result.equals("withoutValue")) {
                return null;
            }
            return result;
        }
        Method cacheMethod = (Method)systemParmHelperInstance.computeIfAbsent("SystemParamServiceHelper", v -> {
            try {
                Method[] declaredMethods;
                Class<?> aClass = Class.forName("kd.bos.servicehelper.parameter.SystemParamServiceHelper");
                for (Method method : declaredMethods = aClass.getDeclaredMethods()) {
                    String name = method.getName();
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (!name.equalsIgnoreCase("loadCustomParameterFromCache") || parameterTypes.length != 1 || !parameterTypes[0].getSimpleName().equalsIgnoreCase("CustomParam")) continue;
                    return method;
                }
            }
            catch (Throwable e) {
                logger.error("get Method error:{}", (Object)e.getMessage());
                paramMap.put(key, "withoutValue");
            }
            return null;
        });
        if (cacheMethod != null && (cacheInstance = systemParmHelperInstance.computeIfAbsent(key + "_CustomParam", v -> {
            try {
                Class<?> aClass = Class.forName("kd.bos.entity.param.CustomParam");
                Constructor<?> declaredConstructor = aClass.getDeclaredConstructor(Set.class);
                HashSet<String> set = new HashSet<String>();
                set.add(key);
                set.add(key.toUpperCase(Locale.ENGLISH));
                set.add(key.toLowerCase(Locale.ENGLISH));
                Object instance = declaredConstructor.newInstance(set);
                return instance;
            }
            catch (Throwable e) {
                logger.error("new CustomParam error:{}", (Object)e.getMessage());
                paramMap.put(key, "withoutValue");
                return null;
            }
        })) != null) {
            try {
                Map resultMap = (Map)cacheMethod.invoke(null, cacheInstance);
                result = (String)resultMap.get(key);
                if (result != null) {
                    paramMap.put(key, result);
                } else {
                    result = (String)resultMap.get(key.toUpperCase(Locale.ENGLISH));
                    if (result != null) {
                        paramMap.put(key, result);
                    } else {
                        result = (String)resultMap.get(key.toLowerCase(Locale.ENGLISH));
                        if (result != null) {
                            paramMap.put(key, result);
                        } else {
                            paramMap.put(key, "withoutValue");
                        }
                    }
                }
                return result;
            }
            catch (Throwable e) {
                logger.error("invoke method error:{}", (Object)e.getMessage());
                paramMap.put(key, "withoutValue");
            }
        }
        return null;
    }

    public static boolean isIgnoreCase(QFilter filter, IDataEntityType entityType) {
        if ((filter.getCP().trim().toLowerCase(Locale.ENGLISH).equals("like") || filter.getCP().trim().toLowerCase(Locale.ENGLISH).equals("not like")) && filter.getQFilterHint() != null) {
            return ORMUtil.isIgnoreCase(entityType, false);
        }
        return false;
    }

    public static boolean isMainExtOptOpen(Boolean ormHintOpen) {
        if (ormHintOpen != null) {
            return ormHintOpen;
        }
        String tenantId = RequestContext.get().getTenantId();
        Boolean booleanExt = ORMConfig.ENABLE_OPTIMIZE_EXTEND_MAINTABLE.getBoolean(tenantId);
        return booleanExt == null ? false : booleanExt;
    }

    public static boolean useInnerJoin(ORMHint ormHint) {
        if (ORMUtil.isMainExtOptOpen(ormHint == null ? null : ormHint.isOptMainExtJoin())) {
            return false;
        }
        if (ormHint != null && ormHint.isUseInnerJoinOpt() != null) {
            return ormHint.isUseInnerJoinOpt();
        }
        return ORMConfig.ENABLE_INNERJOIN.getBoolean();
    }

    public static int toTempTableSize(ORMHint ormHint) {
        if (ormHint != null && ormHint.getToTempTableSize() != null) {
            return ormHint.getToTempTableSize();
        }
        return HugeInConfig.inThreshold();
    }

    private static boolean isIgnoreCase(boolean isEs, String routeKey) {
        String ignorecaseSystemParam = ORMUtil.getSystemParam("orm_opt_ignorecase");
        boolean ignoreCase = false;
        if (ignorecaseSystemParam != null && ignorecaseSystemParam.trim().length() > 0 && !(ignoreCase = "true".equals(ignorecaseSystemParam.trim().toLowerCase(Locale.ENGLISH)))) {
            return false;
        }
        DBType dbType = ORMUtil.getDBType(routeKey);
        String tenantId = RequestContext.get().getTenantId();
        String oldIgnoreCase = SystemPropertyUtils.getProptyByTenant((String)"orm.opt.pg.ignorecase", (String)tenantId);
        String newIgnoreCase = SystemPropertyUtils.getProptyByTenant((String)"orm.opt.ignorecase", (String)tenantId);
        if (ignoreCase || "true".equalsIgnoreCase(oldIgnoreCase) || "true".equalsIgnoreCase(newIgnoreCase)) {
            switch (dbType) {
                case Oracle: 
                case Postgres: 
                case MySQL: 
                case DM: {
                    return true;
                }
            }
            return isEs;
        }
        switch (dbType) {
            case MySQL: {
                return true;
            }
        }
        return false;
    }

    static {
        systemParmHelperInstance = new ConcurrentHashMap<String, Object>(1);
        params = ThreadLocals.create(() -> new ConcurrentHashMap(2));
        try {
            entryProp = Class.forName("kd.bos.entity.property.EntryProp");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class EntityTypeItem {
        private IDataEntityType type;

        private EntityTypeItem(IDataEntityType type) {
            this.type = type;
        }
    }
}

