/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.orm.ORMHint;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItemJoinProperty;
import kd.bos.orm.query.EntityItemProperty;
import kd.bos.orm.query.MultiSelectProperty;
import kd.bos.orm.query.NoSuchPropertyException;

public class EntityItem {
    private String fullObjectName;
    public IDataEntityType entityType;
    private boolean withFullProperties = false;
    private Map<String, EntityItemProperty> propertyMap;
    private EntityItem locale;
    EntityItem parentItem;
    public EntityItemJoinProperty joinProperty;
    List<EntityItem> subItems;
    private Map<String, IDataEntityType> entityTypeCache;
    private ORMHint hint;

    private EntityItem() {
    }

    static EntityItem from(IDataEntityType entityType, String objectName, int maxLevel, Map<String, IDataEntityType> entityTypeCache, ORMHint hint) {
        return EntityItem.from(null, null, entityType, true, objectName.toLowerCase(), 1, maxLevel, entityTypeCache, hint);
    }

    static EntityItem from(EntityItem parentItem, EntityItemJoinProperty joinProperty, IDataEntityType entityType, boolean withFullProperties, String fullObjectName, int curLevel, int maxLevel, Map<String, IDataEntityType> entityTypeCache, ORMHint hint) {
        EntityItem item = new EntityItem();
        item.fullObjectName = fullObjectName;
        item.entityType = entityType;
        item.withFullProperties = withFullProperties;
        item.parentItem = parentItem;
        item.joinProperty = joinProperty;
        item.propertyMap = new HashMap<String, EntityItemProperty>(16);
        item.subItems = new ArrayList<EntityItem>();
        item.entityTypeCache = entityTypeCache;
        item.hint = hint;
        if (parentItem != null) {
            parentItem.subItems.add(item);
        }
        HashMap<String, EntityItemProperty> map = new HashMap<String, EntityItemProperty>();
        DataEntityPropertyCollection ps = entityType.getProperties();
        int n = ps.size();
        for (int i = 0; i < n; ++i) {
            EntityItemJoinProperty joinP;
            ICollectionProperty cp;
            IDataEntityProperty p = (IDataEntityProperty)ps.get(i);
            String fullname = fullObjectName.length() > 0 ? new StringBuilder(fullObjectName.length() + 10).append(fullObjectName).append('.').append(p.getName()).toString() : p.getName();
            EntityItemProperty pi = new EntityItemProperty(item, p, entityTypeCache);
            if (p instanceof ICollectionProperty) {
                String entryAliasName;
                map.put(fullname, pi);
                cp = (ICollectionProperty)p;
                joinP = new EntityItemJoinProperty(item, p, entityTypeCache);
                if (p instanceof DynamicLocaleProperty) {
                    EntityItem locale;
                    entryAliasName = fullObjectName;
                    item.locale = locale = EntityItem.from(item, joinP, cp.getItemType(), false, entryAliasName, curLevel, maxLevel, entityTypeCache, hint);
                    item.subItems.remove(locale);
                    continue;
                }
                entryAliasName = fullObjectName.length() > 0 ? new StringBuilder(fullObjectName.length() + 10).append(fullObjectName).append('.').append(cp.getItemType().getName()).toString() : cp.getItemType().getName();
                EntityItem.from(item, joinP, cp.getItemType(), false, entryAliasName, curLevel, maxLevel, entityTypeCache, hint);
                continue;
            }
            if (p instanceof IComplexProperty) {
                if (ORMUtil.isDbIgnoreRefBaseData(p)) continue;
                map.put(fullname, pi);
                if (curLevel >= maxLevel) continue;
                cp = (IComplexProperty)p;
                joinP = new EntityItemJoinProperty(item, p, entityTypeCache);
                IDataEntityType type = ORMConfiguration.innerGetBaseDataEntityType((IComplexProperty)cp, entityTypeCache);
                EntityItem.from(item, joinP, type, false, new StringBuilder(fullObjectName.length() + 10).append(fullObjectName).append('.').append(cp.getName().toLowerCase()).toString(), curLevel + 1, maxLevel, entityTypeCache, hint);
                continue;
            }
            if (ORMUtil.isDbIgnore(p)) continue;
            map.put(fullname, pi);
        }
        for (EntityItemProperty eip : map.values()) {
            item.propertyMap.put(eip.getPropertyName().toLowerCase(), eip);
        }
        if (ORMConfiguration.isMulBasedata(entityType)) {
            IDataEntityType mulbdMainEntityType = entityType.getParent();
            ISimpleProperty pkProperty = mulbdMainEntityType.getPrimaryKey();
            DynamicSimpleProperty fakeProperty = new DynamicSimpleProperty(pkProperty.getName(), pkProperty.getClass(), null);
            fakeProperty.setAlias(pkProperty.getAlias());
            item.propertyMap.put(pkProperty.getName().toLowerCase(), new EntityItemProperty(item, (IDataEntityProperty)fakeProperty, entityTypeCache));
        }
        return item;
    }

    Map<String, EntityItem> toEntityItemMap() {
        HashMap<String, EntityItem> entityItemMap = new HashMap<String, EntityItem>(5);
        entityItemMap.put(this.fullObjectName, this);
        for (EntityItem subItem : this.subItems) {
            Map<String, EntityItem> subMap = subItem.toEntityItemMap();
            for (Map.Entry<String, EntityItem> entry : subMap.entrySet()) {
                if (entityItemMap.containsKey(entry.getKey())) continue;
                entityItemMap.put(entry.getKey(), entry.getValue());
            }
        }
        return entityItemMap;
    }

    public EntityItemProperty getPropertyItem(String propertyName) {
        return this.getPropertyItem(propertyName.toLowerCase(), false);
    }

    private EntityItemProperty getPropertyItem(String propertyName, boolean isLocale) {
        EntityItemProperty ret = this.propertyMap.get(propertyName);
        if (ret != null) {
            return ret;
        }
        if (this.locale != null && (ret = this.locale.getPropertyItem(propertyName, true)) != null) {
            return ret;
        }
        if (!this.withFullProperties && ORMConfiguration.isBasedata(this.entityType)) {
            this.replaceFullProperties();
            return this.getPropertyItem(propertyName);
        }
        if (isLocale) {
            return null;
        }
        if (this.hint.isSelectNullIfNotExistsProperty()) {
            DynamicSimpleProperty property = new DynamicSimpleProperty(propertyName, String.class, null);
            property.setAlias("__NULL_FIELD");
            return new EntityItemProperty(this, (IDataEntityProperty)property, null);
        }
        if (ORMConfiguration.isMulBasedata(this.entityType)) {
            String name = this.entityType.getParent().getPrimaryKey().getAlias();
            MultiSelectProperty property = "java.lang.Long".equalsIgnoreCase(this.entityType.getPrimaryKey().getPropertyType().getName()) ? new MultiSelectProperty(name, Long.class, null, this.entityType.getParent()) : new MultiSelectProperty(name, String.class, null, this.entityType.getParent());
            property.setAlias(name);
            return new EntityItemProperty(this, (IDataEntityProperty)property, null);
        }
        throw new NoSuchPropertyException(BosRes.get((String)"bos-ormengine", (String)"EntityItem_0", (String)"Entity %1$s's property %2$s is not exists;Or the property's db field is not configured.", (Object[])new Object[]{this.fullObjectName, propertyName}));
    }

    void replaceFullProperties() {
        this.withFullProperties = true;
        this.entityType = ORMConfiguration.innerGetDataEntityType(this.entityType.getName(), this.entityTypeCache);
        EntityItem fullEI = EntityItem.from(this.entityType, this.fullObjectName, 1, this.entityTypeCache, this.hint);
        this.locale = fullEI.locale;
        this.subItems.addAll(fullEI.subItems);
        for (Map.Entry<String, EntityItemProperty> entry : fullEI.propertyMap.entrySet()) {
            if (this.propertyMap.containsKey(entry.getKey())) continue;
            this.propertyMap.put(entry.getKey(), entry.getValue());
            entry.getValue().replaceFullPropertiesEntityItem(this);
        }
    }

    public String getFullObjectName() {
        return this.fullObjectName;
    }

    public EntityItem getParentEntityItem() {
        return this.parentItem;
    }

    public String getFkFieldName() {
        String fkFieldName = null;
        if (this.joinProperty.getParentJoinPropertyType() instanceof ICollectionProperty) {
            fkFieldName = ((ICollectionProperty)this.joinProperty.getParentJoinPropertyType()).getFkFieldName();
        }
        if (fkFieldName == null) {
            fkFieldName = this.parentItem.entityType.getPrimaryKey().getAlias();
        }
        return fkFieldName;
    }

    public String toString() {
        return this.fullObjectName;
    }
}

