/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query;

import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IJoinProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.MultiSelectProperty;

public class EntityItemJoinProperty {
    private EntityItem parentEntityItem;
    private IDataEntityProperty parentOriginProperty;
    private IDataEntityProperty parentJoinProperty;
    private IDataEntityProperty subJoinProperty;
    private boolean iJoinProperty = false;

    EntityItemJoinProperty(EntityItem parentEntityItem, IDataEntityProperty parentJoinProperty, IDataEntityProperty subJoinProperty) {
        this.parentEntityItem = parentEntityItem;
        this.parentOriginProperty = parentJoinProperty;
        this.parentJoinProperty = parentJoinProperty;
        this.subJoinProperty = subJoinProperty;
    }

    EntityItemJoinProperty(EntityItem parentEntityItem, IDataEntityProperty property, Map<String, IDataEntityType> entityTypeCache) {
        this.parentEntityItem = parentEntityItem;
        this.parentOriginProperty = property;
        if (property instanceof IJoinProperty) {
            this.parentJoinProperty = ((IJoinProperty)property).getFKProperty();
            this.subJoinProperty = ((IJoinProperty)property).getJoinProperty();
            this.iJoinProperty = true;
        } else {
            this.parentJoinProperty = property;
            if (property instanceof DynamicLocaleProperty) {
                this.subJoinProperty = parentEntityItem.entityType.getPrimaryKey();
            } else if (property instanceof ICollectionProperty) {
                if (ORMConfiguration.isMulBasedataProp(property)) {
                    String name = parentEntityItem.entityType.getPrimaryKey().getAlias();
                    MultiSelectProperty type = "java.lang.Long".equalsIgnoreCase(parentEntityItem.entityType.getPrimaryKey().getPropertyType().getName()) ? new MultiSelectProperty(name, Long.class, null, parentEntityItem.entityType) : new MultiSelectProperty(name, String.class, null, parentEntityItem.entityType);
                    type.setAlias(name);
                    this.subJoinProperty = type;
                } else {
                    this.subJoinProperty = parentEntityItem.entityType.getPrimaryKey();
                }
            } else if (property instanceof IComplexProperty) {
                IComplexProperty cp = (IComplexProperty)property;
                IDataEntityType type = cp.getComplexType();
                if (cp.getComplexType() == null) {
                    type = ORMConfiguration.innerGetBaseDataEntityType(cp, entityTypeCache);
                }
                this.subJoinProperty = type.getPrimaryKey();
            } else {
                throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"EntityItemJoinProperty_0", (String)"Not support join property\uff1a%1$s\u3002", (Object[])new Object[]{property}));
            }
        }
        while (ORMConfiguration.isEntryEntityType(this.subJoinProperty.getParent())) {
            this.subJoinProperty = this.subJoinProperty.getParent().getParent().getPrimaryKey();
        }
    }

    public String toString() {
        return this.parentJoinProperty.getName() + ":" + this.subJoinProperty.getName();
    }

    void replaceFullPropertiesEntityItem(EntityItem entityItem) {
        this.parentEntityItem = entityItem;
    }

    public EntityItem getParentEntityItem() {
        return this.parentEntityItem;
    }

    public IDataEntityProperty getSubJoinPropertyType() {
        return this.subJoinProperty;
    }

    public IDataEntityProperty getParentJoinPropertyType() {
        return this.parentJoinProperty;
    }

    public IDataEntityProperty getParentOriginProperty() {
        return this.parentOriginProperty;
    }

    public boolean isIJoinProperty() {
        return this.iJoinProperty;
    }
}

