/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.ORMHint;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.EntityItemJoinProperty;
import kd.bos.orm.query.EntityNotExistsException;
import kd.bos.orm.query.NoSuchPropertyException;
import kd.bos.orm.query.QContext;

public class EntityItemLazyLoader {
    private final ORMHint hint;
    private final Map<String, EntityItem> entityItemMap;
    private final Map<String, IDataEntityType> entityTypeCache;

    public EntityItemLazyLoader(ORMHint hint, QContext allCtx, Map<String, IDataEntityType> entityTypeCache) {
        this.hint = hint;
        this.entityItemMap = allCtx == null ? new HashMap() : allCtx.entityItemLoader.entityItemMap;
        this.entityTypeCache = entityTypeCache;
    }

    public EntityItem load(IDataEntityType entityType, String asObjectName) {
        EntityItem ei = this.load(asObjectName);
        if (ei == null) {
            ei = EntityItem.from(entityType, asObjectName, 1, this.entityTypeCache, this.hint);
            this.entityItemMap.putAll(ei.toEntityItemMap());
        }
        return ei;
    }

    public EntityItem load(String fullObjectName) {
        EntityItem ei = this.entityItemMap.get(fullObjectName);
        if (ei == null) {
            int p = fullObjectName.lastIndexOf(46);
            if (p == -1) {
                try {
                    IDataEntityType entityType = ORMConfiguration.innerGetDataEntityType(fullObjectName, this.entityTypeCache);
                    ei = EntityItem.from(entityType, fullObjectName, 1, this.entityTypeCache, this.hint);
                    this.entityItemMap.putAll(ei.toEntityItemMap());
                    return ei;
                }
                catch (EntityNotExistsException e) {
                    return null;
                }
            }
            String parentFullObjectName = fullObjectName.substring(0, p);
            EntityItem parentEI = this.load(parentFullObjectName);
            if (parentEI == null) {
                return null;
            }
            ei = this.entityItemMap.get(fullObjectName);
            if (ei != null) {
                return ei;
            }
            String propertyName = fullObjectName.substring(p + 1);
            IDataEntityProperty property = (IDataEntityProperty)parentEI.entityType.getProperties().get((Object)propertyName);
            if (property == null) {
                if (ORMConfiguration.isEntryEntityType(parentEI.entityType)) {
                    throw new NoSuchPropertyException(BosRes.get((String)"bos-ormengine", (String)"EntityItemLazyLoader_0", (String)"Entity {0}'s property {1} is not exists;Or the property's db field is not configured.", (Object[])new Object[]{parentFullObjectName, propertyName}));
                }
                parentEI.replaceFullProperties();
                property = (IDataEntityProperty)parentEI.entityType.getProperties().get((Object)propertyName);
            }
            if (property instanceof IComplexProperty) {
                IDataEntityType entityType = ORMConfiguration.innerGetBaseDataEntityType((IComplexProperty)property, this.entityTypeCache);
                ei = EntityItem.from(parentEI, null, entityType, false, fullObjectName, 1, 1, this.entityTypeCache, this.hint);
                ei.joinProperty = new EntityItemJoinProperty(parentEI, property, this.entityTypeCache);
                this.entityItemMap.putAll(ei.toEntityItemMap());
            } else {
                for (EntityItem subItem : parentEI.subItems) {
                    if (!subItem.getFullObjectName().equals(fullObjectName)) continue;
                    ei = subItem;
                    break;
                }
            }
        }
        return ei;
    }
}

