/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.orm.query.SqlRequest;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.QueryTreeNode;

public class SqlTreeNode {
    private SqlTreeNode parent;
    private SqlRequest value;
    private List<SqlTreeNode> children = new ArrayList<SqlTreeNode>();

    public static SqlTreeNode create(SingleQuery[] queries) {
        QueryTreeNode queryRootNode = QueryTreeNode.create(queries);
        int len = queries.length;
        SqlTreeNode root = new SqlTreeNode(queryRootNode.getQuery().getQuerySql());
        if (len == 1) {
            return root;
        }
        LinkedList<QueryTreeNode> queryNodes = new LinkedList<QueryTreeNode>();
        queryNodes.add(queryRootNode);
        LinkedList<SqlTreeNode> sqlNodes = new LinkedList<SqlTreeNode>();
        sqlNodes.add(root);
        while (!queryNodes.isEmpty()) {
            QueryTreeNode queryNode = (QueryTreeNode)queryNodes.getFirst();
            SqlTreeNode node = (SqlTreeNode)sqlNodes.getFirst();
            List<QueryTreeNode> queryChildren = queryNode.getChildren();
            if (!queryChildren.isEmpty()) {
                for (QueryTreeNode queryChild : queryChildren) {
                    node.addChild(new SqlTreeNode(queryChild.getQuery().getQuerySql()));
                    if (queryChild.isLeaf()) continue;
                    queryNodes.add(queryChild);
                    sqlNodes.add(new SqlTreeNode(queryChild.getQuery().getQuerySql()));
                }
            }
            queryNodes.remove(queryNode);
            sqlNodes.remove(node);
        }
        return root;
    }

    public SqlTreeNode(SqlRequest value) {
        this.value = value;
    }

    public SqlTreeNode getParent() {
        return this.parent;
    }

    public SqlRequest getValue() {
        return this.value;
    }

    public void setValue(SqlRequest value) {
        this.value = value;
    }

    public List<SqlTreeNode> getChildren() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public void addChild(SqlTreeNode child) {
        this.children.add(child);
        child.parent = this;
    }

    public void addChildren(List<SqlTreeNode> children) {
        for (SqlTreeNode child : children) {
            this.addChild(child);
        }
    }
}

