/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.crossdb;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.DBType;
import kd.bos.orm.query.crossdb.CorssDBType;
import kd.bos.orm.query.crossdb.CrossDBPattern;
import kd.bos.orm.query.crossdb.TenantAccountCrossDBRuntime;
import kd.bos.util.ConfigurationUtil;

class CrossDBConfig {
    private static final String cross_db_all_entity = "*";
    private static final String cross_db_enable = "orm.crossdb.enable";
    private static final String cross_db_logchange = "orm.crossdb.logchange";
    private static final String cross_db_only_effective_or_filter_enable = "orm.crossdb.enable.only_or_filter";
    private static final String cross_db_type = "orm.crossdb.type";
    private static final String cross_db_entities = "orm.crossdb.entities";
    private static final String cross_db_pattern = "orm.crossdb.{dbtype}.pattern";
    private static Set<String> crossDBEntitySet;
    private static final Map<DBType, CrossDBPattern> crossDBPatternMap;
    private static final Map<String, CrossDBPattern> crossDBPatternCache;
    private static CorssDBType corssDBType;
    private static boolean crossDBEnable;
    private static boolean crossDBLogChange;
    private static boolean crossDBEnableOnlyOrFilter;
    private static boolean allEntity;

    CrossDBConfig() {
    }

    private static void onCrossDBEntitiesChanged(String entities) {
        HashSet<String> set = new HashSet<String>();
        if (entities != null) {
            String[] es;
            for (String e : es = entities.split(",")) {
                if ((e = e.trim().toLowerCase()).length() <= 0) continue;
                set.add(e);
            }
        }
        crossDBEntitySet = set;
        allEntity = crossDBEntitySet.contains(cross_db_all_entity);
        CrossDBConfig.onSettingChanged();
    }

    private static void onCrossDBPatternChanged(String pattern, DBType dbType) {
        crossDBPatternMap.computeIfAbsent(dbType, type -> crossDBPatternCache.computeIfAbsent(pattern, p -> new CrossDBPattern(pattern)));
        CrossDBConfig.onSettingChanged();
    }

    private static void onSettingChanged() {
        TenantAccountCrossDBRuntime.clearRuntime();
    }

    static boolean isCrossDBEnable() {
        return crossDBEnable;
    }

    static boolean isCrossDBLogChange() {
        return crossDBLogChange;
    }

    static boolean isCrossDBEnableOnlyOrFilter() {
        return crossDBEnableOnlyOrFilter;
    }

    static boolean isAllEntity() {
        return allEntity;
    }

    static Set<String> getCrossDBEntitySet() {
        return crossDBEntitySet;
    }

    static CrossDBPattern getCorssDBPattern(DBType dbType) {
        return crossDBPatternMap.get(dbType);
    }

    static CorssDBType getCorssDBType() {
        return corssDBType;
    }

    static {
        DBType[] dbTypes;
        crossDBPatternMap = new ConcurrentHashMap<DBType, CrossDBPattern>();
        crossDBPatternCache = new ConcurrentHashMap<String, CrossDBPattern>();
        corssDBType = CorssDBType.schema;
        crossDBEnable = false;
        crossDBLogChange = false;
        crossDBEnableOnlyOrFilter = false;
        allEntity = true;
        ConfigurationUtil.observeString((String)cross_db_type, (String)corssDBType.name(), v -> {
            corssDBType = CorssDBType.valueOf(v);
        });
        ConfigurationUtil.observeString((String)cross_db_entities, (String)(allEntity ? cross_db_all_entity : ""), v -> CrossDBConfig.onCrossDBEntitiesChanged(v));
        ConfigurationUtil.observeBoolean((String)cross_db_enable, (boolean)crossDBEnable, v -> {
            crossDBEnable = v;
        });
        ConfigurationUtil.observeBoolean((String)cross_db_logchange, (boolean)crossDBLogChange, v -> {
            crossDBLogChange = v;
        });
        ConfigurationUtil.observeBoolean((String)cross_db_only_effective_or_filter_enable, (boolean)crossDBEnableOnlyOrFilter, v -> {
            crossDBEnableOnlyOrFilter = v;
        });
        for (DBType dbType : dbTypes = DBType.values()) {
            String defaultPattern;
            switch (dbType) {
                case MySQL: 
                case SQLServer: 
                case PostgreSQL: 
                case GS: {
                    defaultPattern = "{database}.{table}";
                    break;
                }
                default: {
                    defaultPattern = "{user}.{table}";
                }
            }
            String configKey = cross_db_pattern.replace("{dbtype}", dbType.name().toLowerCase());
            DBType type = dbType;
            ConfigurationUtil.observeString((String)configKey, (String)defaultPattern, v -> CrossDBConfig.onCrossDBPatternChanged(v, type));
        }
    }
}

