/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.crossdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CrossDBPattern {
    private static final String var_user = "user";
    private static final String var_database = "database";
    private static final String var_table = "table";
    static final String db_table = "{database}.{table}";
    static final String user_table = "{user}.{table}";
    private final List<Object> compiledSegs;
    private int bufLength = 32;

    CrossDBPattern(String pattern) {
        this.compiledSegs = this.compilePattern(pattern);
    }

    private List<Object> compilePattern(String pattern) {
        char[] chs = pattern.toCharArray();
        ArrayList<Object> list = new ArrayList<Object>();
        StringBuilder buf = new StringBuilder();
        boolean inVar = false;
        for (char ch : chs) {
            if (ch == '{') {
                if (buf.length() > 0) {
                    list.add(buf.toString());
                    buf.setLength(0);
                }
                inVar = true;
                continue;
            }
            if (ch == '}') {
                if (inVar) {
                    String var = buf.toString().trim();
                    if (var.length() > 0) {
                        list.add(new Var(var));
                    }
                    buf.setLength(0);
                    inVar = false;
                    continue;
                }
                buf.append(ch);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            list.add(buf.toString());
        }
        return list;
    }

    String genCrossDBTable(String user, String database, String table) {
        HashMap<String, String> varSupplierMap = new HashMap<String, String>();
        varSupplierMap.put(var_user, user);
        varSupplierMap.put(var_database, database);
        varSupplierMap.put(var_table, table);
        StringBuilder s = new StringBuilder(this.bufLength);
        for (Object seg : this.compiledSegs) {
            if (seg instanceof Var) {
                String name = ((Var)seg).name;
                String value = (String)varSupplierMap.get(name);
                if (value == null) {
                    throw new IllegalArgumentException("Cross db pattern variable not supplied: " + name + "@" + varSupplierMap);
                }
                s.append(value);
                continue;
            }
            s.append(seg);
        }
        if (this.bufLength < s.length()) {
            this.bufLength = s.length();
        }
        return s.toString();
    }

    private static class Var {
        private String name;
        private String value;

        private Var(String name) {
            this.name = name;
        }

        private void setSupplier(Map<String, String> map) {
            this.value = map.get(this.name);
            if (this.value == null) {
                throw new IllegalArgumentException("Cross db pattern variable not supplied: " + this.name + "@" + map);
            }
        }

        public String toString() {
            return this.value;
        }
    }
}

