/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.crud.read;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.lang.Lang;
import kd.bos.orm.impl.ORMOptimization;
import kd.bos.orm.query.crud.read.DynamicObjectParser;
import kd.bos.orm.query.multi.ReuseDBRoute;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

class BatchLocaleValueQuery {
    private static final int lang_length = Lang.values().length;

    BatchLocaleValueQuery() {
    }

    void batchQueryAndSet(List<DynamicObjectParser.SetLangHandler> handlers, DBRoute dbRoute, int top, ORMOptimization optimization) {
        try (TraceSpan ts = Tracer.create((String)"ORM", (String)"BatchLocaleValueQuery_batchQueryAndSet");){
            int batchSize = optimization.getPageSize();
            LinkedList<QueryInfo> qiList = new LinkedList<QueryInfo>();
            HashMap<IDataEntityType, QueryInfo> queryMap = new HashMap<IDataEntityType, QueryInfo>();
            for (DynamicObjectParser.SetLangHandler handler : handlers) {
                DynamicObjectParser.LangField lf = handler.getLangField();
                IDataEntityType dt = lf.fieldItem.dp.getParent();
                QueryInfo qi = (QueryInfo)queryMap.get(dt);
                if (qi == null) {
                    qi = new QueryInfo(dt, dbRoute);
                    queryMap.put(dt, qi);
                }
                qi.properties.add(lf.fieldItem.dp);
                qi.fkIds.add(lf.id);
                qi.handles.add(handler);
                if (qi.fkIds.size() != batchSize) continue;
                qiList.add(qi);
                queryMap.remove(dt);
            }
            qiList.addAll(queryMap.values());
            for (QueryInfo qi : qiList) {
                this.queryAndSet(qi);
            }
        }
    }

    private void queryAndSet(QueryInfo qi) {
        SqlObject sql = new SqlObject();
        sql.appendSql("SELECT ");
        int i = 0;
        IDataEntityType dt = null;
        String firstAias = "";
        for (IDataEntityProperty dp : qi.properties) {
            if (i == 0) {
                firstAias = dp.getAlias();
                dt = dp.getParent();
                sql.appendSql(dt.getPrimaryKey().getAlias());
                sql.appendSql(',');
                sql.appendSql("FPkId");
                sql.appendSql(',');
                sql.appendSql("FLocaleId");
            }
            sql.appendSql(',');
            sql.appendSql(dp.getAlias());
            ++i;
        }
        if (dt == null) {
            throw new IllegalArgumentException("the property " + firstAias + "'s parent is null");
        }
        sql.appendSql(" FROM ");
        sql.appendSql(dt.getAlias() + "_L");
        sql.appendSql(" WHERE ");
        sql.appendSql(dt.getPrimaryKey().getAlias());
        Class idCls = dt.getPrimaryKey().getPropertyType();
        int type = idCls == Long.TYPE || idCls == Long.class ? -5 : (idCls == Integer.TYPE || idCls == Integer.class ? 4 : 12);
        if (qi.fkIds.size() == 1) {
            sql.appendSql("=?");
            sql.addParam(new SqlParameter(type, qi.fkIds.iterator().next()));
        } else {
            sql.appendSql(" IN(");
            for (Object value : qi.fkIds) {
                sql.appendSql("?,");
                sql.addParam(new SqlParameter(type, value));
            }
            sql.removeLast(1);
            sql.appendSql(')');
        }
        int preferredSize = qi.fkIds.size() + 1;
        try (TraceSpan ts = Tracer.create((String)"ORM", (String)"BatchLocaleValueQuery_queryAndSet");
             DataSet ds = DB.queryDataSet((String)"ORM", (DBRoute)qi.dbRoute, (String)("/*ORM*/ " + sql.getSql()), (Object[])sql.getParams());){
            HashMap<String, ILocaleString> localRowFieldMap = new HashMap<String, ILocaleString>(preferredSize);
            HashMap<String, String> pkMap = new HashMap<String, String>(preferredSize);
            RowMeta meta = ds.getRowMeta();
            int col = meta.getFieldCount();
            for (Row row : ds) {
                Object fkId = row.get(0);
                String pkId = row.getString(1);
                String localeId = row.getString(2);
                for (int j = 3; j < col; ++j) {
                    String rowKey = meta.getFieldAlias(j).toLowerCase() + "#" + fkId;
                    String value = (String)row.get(j);
                    ILocaleString localeString = (ILocaleString)localRowFieldMap.get(rowKey);
                    if (localeString == null) {
                        localeString = new LocaleString();
                        localRowFieldMap.put(rowKey, localeString);
                    }
                    localeString.setItem(localeId, (Object)value);
                    pkMap.put(rowKey + "#" + localeId, pkId);
                }
            }
            for (DynamicObjectParser.SetLangHandler handler : qi.handles) {
                DynamicObjectParser.LangField langField = handler.getLangField();
                String rowKey = langField.fieldItem.dp.getAlias().toLowerCase() + "#" + langField.id;
                ILocaleString localeString = (ILocaleString)localRowFieldMap.get(rowKey);
                if (localeString == null) continue;
                HashMap<String, String> localePkIdMap = new HashMap<String, String>(lang_length);
                for (String localeId : localeString.keySet()) {
                    localePkIdMap.put(localeId, (String)pkMap.get(rowKey + "#" + localeId));
                }
                handler.setValue(localePkIdMap, localeString);
            }
        }
    }

    private static class QueryInfo {
        IDataEntityType dt;
        DBRoute dbRoute;
        Set<IDataEntityProperty> properties = new HashSet<IDataEntityProperty>();
        Set<Object> fkIds = new HashSet<Object>();
        List<DynamicObjectParser.SetLangHandler> handles = new LinkedList<DynamicObjectParser.SetLangHandler>();

        QueryInfo(IDataEntityType dt, DBRoute dbRoute) {
            this.dt = dt;
            this.dbRoute = ReuseDBRoute.useDBRoute(dt, dbRoute);
        }

        public String toString() {
            return this.dt.getName() + ":" + this.properties;
        }
    }
}

