/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.crud.read;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDExceptionKit;
import kd.bos.orm.ORMHint;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMOptimization;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.crud.read.BatchLocaleValueQuery;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class DynamicObjectParser {
    private static final int parserMaxSize = 2000000;
    private final DBRoute dbRoute;
    private final Iterator<Object[]> rowIter;
    private final Map<String, List<FieldItem>> selectFieldMap = new TreeMap<String, List<FieldItem>>();
    private final Map<String, SelectEntityType> selectEntityTypeMap = new HashMap<String, SelectEntityType>();
    private final Map<String, Integer> colNameIndexMap = new HashMap<String, Integer>(16);
    private final ORMOptimization optimization;
    private final ORMHint hint;
    private final MultiBaseDataFilterValue multi;

    public DynamicObjectParser(DataSet ds, String entityName, Map<String, IDataEntityType> entityTypeCache, ORMOptimization optimization, ORMHint hint, MultiBaseDataFilterValue multi) {
        this(new DBRoute(ORMConfiguration.innerGetDataEntityType(entityName, entityTypeCache).getDBRouteKey()), ds.iterator(), ds.getRowMeta(), entityName, entityTypeCache, optimization, hint, multi);
    }

    public DynamicObjectParser(DataSet ds, String entityName, Map<String, IDataEntityType> entityTypeCache, ORMOptimization optimization, ORMHint hint) {
        this(new DBRoute(ORMConfiguration.innerGetDataEntityType(entityName, entityTypeCache).getDBRouteKey()), ds, entityName, entityTypeCache, optimization, hint);
    }

    public DynamicObjectParser(DBRoute dbRoute, DataSet ds, String entityName, Map<String, IDataEntityType> entityTypeCache, ORMOptimization optimization, ORMHint hint) {
        this(dbRoute, ds.iterator(), ds.getRowMeta(), entityName, entityTypeCache, optimization, hint);
    }

    public DynamicObjectParser(DBRoute dbRoute, Iterator<Row> iter, RowMeta rowMeta, String entityName, Map<String, IDataEntityType> entityTypeCache, ORMOptimization optimization, ORMHint hint) {
        this(dbRoute, iter, rowMeta, entityName, entityTypeCache, optimization, hint, null);
    }

    private DynamicObjectType createEntityType(IDataEntityType entityType, String entityName) {
        try {
            DynamicObjectType dt;
            if (ORMConfiguration.isEntryEntityType(entityType)) {
                IDataEntityType billDT;
                if (ORMConfiguration.isEntryEntityType(entityType.getParent())) {
                    billDT = ORMConfiguration.cloneDataEntityType(entityType.getParent().getParent());
                    DynamicObjectType entryDT = (DynamicObjectType)((ICollectionProperty)billDT.getProperties().get((Object)entityType.getParent().getName())).getItemType();
                    dt = (DynamicObjectType)((ICollectionProperty)entryDT.getProperties().get((Object)entityType.getName())).getItemType();
                } else {
                    billDT = ORMConfiguration.cloneDataEntityType(entityType.getParent());
                    dt = (DynamicObjectType)((ICollectionProperty)billDT.getProperties().get((Object)entityType.getName())).getItemType();
                }
            } else {
                dt = ORMConfiguration.isMulBasedata(entityType) ? (DynamicObjectType)entityType : (DynamicObjectType)ORMConfiguration.cloneDataEntityType(entityType);
            }
            dt.setName(entityName);
            for (IDataEntityProperty dp : dt.getProperties()) {
                IComplexProperty fullDP;
                if (!(dp instanceof IComplexProperty) || (fullDP = (IComplexProperty)entityType.getProperties().get((Object)dp.getName())) == null) continue;
                ((DynamicComplexProperty)dp).setComplexType(fullDP.getComplexType());
            }
            return dt;
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    private void initEntityType(String entityName, Map<String, IDataEntityType> entityTypeCache) {
        for (Map.Entry<String, List<FieldItem>> entry : this.selectFieldMap.entrySet()) {
            SelectEntityType set;
            String fullObjName = entry.getKey();
            List<FieldItem> fieldItems = entry.getValue();
            if (fullObjName.length() == 0) {
                set = new SelectEntityType();
                set.entityType = ORMConfiguration.innerGetDataEntityType(entityName, entityTypeCache);
                set.dt = this.createEntityType(set.entityType, entityName);
                this.selectEntityTypeMap.put("", set);
            } else {
                set = this.selectEntityTypeMap.get(fullObjName);
            }
            this.mergeSimpleProperty(fieldItems, set);
            for (String subFullObjName : this.getSubFullObjNameList(fullObjName)) {
                SelectEntityType subSET = new SelectEntityType();
                String propertyName = fullObjName.length() == 0 ? subFullObjName : subFullObjName.substring(fullObjName.length() + 1);
                IDataEntityProperty ptype = (IDataEntityProperty)set.entityType.getProperties().get((Object)propertyName);
                if (this.multi != null && subFullObjName.equalsIgnoreCase(this.multi.getJoinProperty())) {
                    IDataEntityType iDataEntityType;
                    propertyName = this.multi.getJoinProperty();
                    subSET.entityType = iDataEntityType = ORMConfiguration.innerGetDataEntityType(this.multi.getBaseDataName(), entityTypeCache);
                } else if (ptype instanceof ICollectionProperty) {
                    if (ORMConfiguration.isMulBasedataProp(ptype)) {
                        subSET.entityType = ORMConfiguration.getMulBasedataProp(ptype);
                    } else if (!(ptype instanceof DynamicLocaleProperty)) {
                        subSET.entityType = ((ICollectionProperty)ptype).getItemType();
                    }
                } else if (ptype instanceof IComplexProperty) {
                    IDataEntityType refEntityType;
                    subSET.entityType = refEntityType = ORMConfiguration.innerGetBaseDataEntityType((IComplexProperty)ptype, entityTypeCache);
                } else {
                    if (ptype != null) {
                        throw new IllegalArgumentException("Sub object not support type:" + ptype.getClass().getName());
                    }
                    throw new IllegalArgumentException("property '" + propertyName + "' not exists IDataEntityProperty");
                }
                subSET.dt = this.createEntityType(subSET.entityType, propertyName);
                this.selectEntityTypeMap.put(subFullObjName, subSET);
                if (!set.entityType.getName().equals(entityName) || this.multi == null || !subFullObjName.equalsIgnoreCase(this.multi.getJoinProperty())) continue;
                DynamicComplexProperty property = new DynamicComplexProperty(propertyName, propertyName, subSET.dt, false);
                set.dt.addProperty((DynamicProperty)property);
            }
        }
    }

    private void mergeSimpleProperty(List<FieldItem> fieldItems, SelectEntityType set) {
        try {
            set.dt.setAlias(set.entityType.getAlias());
            DataEntityPropertyCollection ps = set.entityType.getProperties();
            Map<String, FieldItem> fieldItemMap = fieldItems.stream().collect(Collectors.toMap(item -> item.propertyName, item -> item));
            HashSet<String> nameSet = new HashSet<String>(ps.size());
            int index = 0;
            for (IDataEntityProperty p : ps) {
                DynamicProperty dp = (DynamicProperty)p;
                String name = dp.getName().toLowerCase();
                nameSet.add(name);
                FieldItem fieldItem = fieldItemMap.get(name);
                if (fieldItem != null) {
                    fieldItem.index = index;
                    if (ILocaleString.class.isAssignableFrom(dp.getPropertyType())) {
                        fieldItem.setLang((IDataEntityProperty)dp);
                    }
                }
                ++index;
            }
            for (FieldItem fieldItem : fieldItems) {
                if (nameSet.contains(fieldItem.propertyName.toLowerCase())) continue;
                Class<?> propertyType = ORMUtil.getPropertyType(fieldItem.field.getDataType());
                DynamicSimpleProperty property = new DynamicSimpleProperty(fieldItem.propertyName, propertyType, null);
                set.dt.registerSimpleProperty(property);
                fieldItem.index = index++;
            }
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    private List<String> getSubFullObjNameList(String fullObjName) {
        ArrayList<String> ret = new ArrayList<String>(2);
        for (String subFullObjName : this.selectFieldMap.keySet()) {
            if (subFullObjName.equals(fullObjName)) continue;
            if (fullObjName.length() == 0) {
                if (this.getDotCount(subFullObjName) != 0) continue;
                ret.add(subFullObjName);
                continue;
            }
            if (!subFullObjName.startsWith(fullObjName + ".") || this.getDotCount(subFullObjName.substring(fullObjName.length())) != 1) continue;
            ret.add(subFullObjName);
        }
        return ret;
    }

    private int getDotCount(String s) {
        int c = 0;
        for (char ch : s.toCharArray()) {
            if (ch != '.') continue;
            ++c;
        }
        return c;
    }

    private void addSelectField(String fullObjName, String fieldName, Field field) {
        boolean exists = true;
        List<FieldItem> fields = this.selectFieldMap.get(fullObjName);
        if (fields == null) {
            fields = new ArrayList<FieldItem>();
            this.selectFieldMap.put(fullObjName, fields);
            exists = false;
        }
        if (field != null) {
            fields.add(new FieldItem(fieldName, fullObjName, field));
        }
        if (!exists) {
            while (true) {
                int dot;
                if ((dot = fullObjName.lastIndexOf(46)) == -1) {
                    this.addSelectField("", null, null);
                    break;
                }
                fullObjName = fullObjName.substring(0, dot);
                this.addSelectField(fullObjName, null, null);
            }
        }
    }

    public DynamicObjectCollection parse(int top) {
        boolean loadMultiLang = this.hint.isLoadMultiLang();
        return this.parse(top, loadMultiLang);
    }

    private DynamicObjectCollection parse(int top, boolean loadMultiLang) {
        int max = top > 0 ? top : (top == 0 ? 0 : -1);
        try (TraceSpan ts = Tracer.create((String)"ORM", (String)"DynamicObjectParser_parse");){
            LinkedList<SetLangHandler> handlers = new LinkedList<SetLangHandler>();
            DynamicObjectCollection ret = this.parse(this.rowIter, "", null, null, handlers, max, 1, loadMultiLang, this.hint);
            if (loadMultiLang) {
                new BatchLocaleValueQuery().batchQueryAndSet(handlers, this.dbRoute, top, this.optimization);
            }
            ORMUtil.clearDirty(ret);
            DynamicObjectCollection dynamicObjectCollection = ret;
            return dynamicObjectCollection;
        }
    }

    public Iterator<DynamicObjectCollection> parsePage() {
        return this.parsePage(this.optimization.getPageSize());
    }

    public Iterator<DynamicObjectCollection> parsePage(final int pageSize) {
        return new Iterator<DynamicObjectCollection>(){

            @Override
            public boolean hasNext() {
                return DynamicObjectParser.this.rowIter.hasNext();
            }

            @Override
            public DynamicObjectCollection next() {
                return DynamicObjectParser.this.parse(pageSize);
            }
        };
    }

    private DynamicObjectCollection parse(Iterator<Object[]> rowIter, String fullObjName, DynamicObjectCollection ret, DynamicObject parent, List<SetLangHandler> handlers, int max, int initLangRowSize, boolean loadMultiLang, ORMHint hint) {
        Integer pkIndex;
        SelectEntityType set = this.selectEntityTypeMap.get(fullObjName);
        if (ret == null) {
            ret = new DynamicObjectCollection(set.dt, (Object)parent);
        }
        if (max == 0) {
            return ret;
        }
        ret.beginInit();
        HashMap<Object, ObjectRowSet> addedRowObjMap = new HashMap<Object, ObjectRowSet>();
        String pkName = set.entityType.getPrimaryKey().getName().toLowerCase();
        if (fullObjName.length() > 0) {
            pkName = fullObjName + "." + pkName;
        }
        if ((pkIndex = this.colNameIndexMap.get(pkName)) == null) {
            throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"DynamicObjectParser_0", (String)"Missing primary key:{0}.", (Object[])new Object[]{pkName}));
        }
        String langId = hint.getLang().toString();
        int c = 0;
        FastLinkedList rootObjectRowSet = null;
        FastLinkedList<Object> curObjectRowSet = null;
        while (rowIter.hasNext()) {
            Object[] row = rowIter.next();
            Object rowKey = row[pkIndex];
            if (rowKey == null || (!(rowKey instanceof String) ? ((Number)rowKey).longValue() == 0L : ((String)rowKey).length() == 0)) continue;
            ObjectRowSet rs = (ObjectRowSet)addedRowObjMap.get(rowKey);
            if (rs != null) {
                if (rs.rows.size() > 2000000) {
                    throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"DynamicObjectParser_1", (String)"Single data exceeds threshold [2000000] from one-to-many associations.", (Object[])new Object[0]));
                }
                rs.rows.add(row);
                continue;
            }
            if (max != -1 && c == max) break;
            final DynamicObject obj = new DynamicObject(set.dt);
            obj.beginInit();
            List<FieldItem> fieldItems = this.selectFieldMap.get(fullObjName);
            for (final FieldItem fieldItem : fieldItems) {
                Object value = row[this.colNameIndexMap.get(fieldItem.fullName)];
                obj.set(fieldItem.index, value);
                if (!fieldItem.isLangField) continue;
                if (loadMultiLang) {
                    final Object langRowId = rowKey;
                    final int index = fieldItem.index;
                    handlers.add(new SetLangHandler(){

                        @Override
                        public LangField getLangField() {
                            return new LangField(langRowId, fieldItem);
                        }

                        @Override
                        public void setValue(Map<String, String> localePkIdMap, ILocaleString value) {
                            LocaleDynamicObjectCollection locale = (LocaleDynamicObjectCollection)obj.get("multilanguagetext");
                            locale.beginInit();
                            for (Map.Entry<String, String> entry : localePkIdMap.entrySet()) {
                                locale.getOrCreateItemByLocaleId(entry.getKey()).set("pkid", (Object)entry.getValue());
                            }
                            locale.endInit();
                            obj.set(index, (Object)value);
                        }
                    });
                    continue;
                }
                LocaleString localeString = new LocaleString();
                if (value != null) {
                    localeString.setItem(langId, (Object)String.valueOf(value));
                }
                obj.set(fieldItem.index, (Object)localeString);
            }
            obj.endInit();
            rs = new ObjectRowSet();
            rs.obj = obj;
            rs.rows = new ArrayList<Object[]>();
            rs.rows.add(row);
            ret.add((Object)obj);
            addedRowObjMap.put(rowKey, rs);
            if (curObjectRowSet == null) {
                rootObjectRowSet = curObjectRowSet = new FastLinkedList<ObjectRowSet>(rs);
            } else {
                curObjectRowSet = curObjectRowSet.next = new FastLinkedList<ObjectRowSet>(rs);
            }
            ++c;
        }
        for (String subFullObjName : this.getSubFullObjNameList(fullObjName)) {
            curObjectRowSet = rootObjectRowSet;
            while (curObjectRowSet != null) {
                ObjectRowSet rs = (ObjectRowSet)curObjectRowSet.value;
                String propertyName = fullObjName.length() == 0 ? subFullObjName : subFullObjName.substring(fullObjName.length() + 1);
                Object value = null;
                value = rs.obj.get(propertyName);
                DynamicObjectCollection cc = null;
                if (value instanceof DynamicObjectCollection) {
                    cc = (DynamicObjectCollection)value;
                }
                DynamicObjectCollection subObjs = this.parse(rs.rows.iterator(), subFullObjName, cc, rs.obj, handlers, -1, rs.rows.size(), loadMultiLang, hint);
                if (cc == null) {
                    if (ORMConfiguration.isMulBasedataProp((IDataEntityProperty)set.dt.getProperty(propertyName))) {
                        rs.obj.set(propertyName, (Object)subObjs);
                    } else {
                        rs.obj.set(propertyName, subObjs.isEmpty() ? null : subObjs.get(0));
                    }
                }
                curObjectRowSet = curObjectRowSet.next;
            }
        }
        ret.endInit();
        return ret;
    }

    private DynamicObjectParser(DBRoute dbRoute, final Iterator<Row> iter, RowMeta rowMeta, String entityName, Map<String, IDataEntityType> entityTypeCache, ORMOptimization optimization, ORMHint hint, MultiBaseDataFilterValue multi) {
        this.dbRoute = dbRoute;
        this.optimization = optimization;
        this.hint = hint;
        this.multi = multi;
        if (entityTypeCache == null) {
            entityTypeCache = new HashMap<String, IDataEntityType>();
        }
        final int cols = rowMeta.getFieldCount();
        this.rowIter = new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Object[] next() {
                Row row = (Row)iter.next();
                Object[] rowData = new Object[cols];
                for (int i = 0; i < cols; ++i) {
                    rowData[i] = row.get(i);
                }
                return rowData;
            }
        };
        int colIndex = 0;
        for (Field field : rowMeta.getFields()) {
            String alias = field.getAlias().toLowerCase();
            int dot = alias.lastIndexOf(46);
            if (dot == -1) {
                this.addSelectField("", alias, field);
            } else {
                this.addSelectField(alias.substring(0, dot), alias.substring(dot + 1), field);
            }
            this.colNameIndexMap.put(alias, colIndex++);
        }
        this.initEntityType(entityName, entityTypeCache);
    }

    static interface SetLangHandler {
        public LangField getLangField();

        public void setValue(Map<String, String> var1, ILocaleString var2);
    }

    private static class FastLinkedList<T> {
        T value;
        FastLinkedList<T> next;

        FastLinkedList(T value) {
            this.value = value;
        }
    }

    static class LangField {
        Object id;
        FieldItem fieldItem;

        LangField(Object id, FieldItem fieldItem) {
            this.id = id;
            this.fieldItem = fieldItem;
        }
    }

    private static class SelectEntityType {
        IDataEntityType entityType;
        DynamicObjectType dt;

        private SelectEntityType() {
        }
    }

    private static class ObjectRowSet {
        DynamicObject obj;
        List<Object[]> rows;

        private ObjectRowSet() {
        }
    }

    static class FieldItem {
        Field field;
        String fullName;
        String propertyName;
        boolean isLangField;
        IDataEntityProperty dp;
        int index = -1;

        FieldItem(String propertyName, String fullObjName, Field field) {
            this.propertyName = propertyName;
            this.field = field;
            this.fullName = fullObjName.length() == 0 ? propertyName : fullObjName + "." + propertyName;
        }

        void setLang(IDataEntityProperty dp) {
            this.isLangField = true;
            this.dp = dp;
        }

        public String toString() {
            return this.fullName;
        }
    }
}

