/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.fulltext;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;

class FullTextIndexCache {
    private FullTextIndexCache() {
    }

    private static String getAcctId() {
        return RequestContext.get().getAccountId();
    }

    private static LocalMemoryCache getLocalCache(String acctId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1200);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(acctId, "dynamicobjecttype", info);
    }

    public static void remove(String key) {
        LocalMemoryCache localCache = FullTextIndexCache.getLocalCache(FullTextIndexCache.getAcctId());
        localCache.remove(new String[]{key});
    }

    public static void cache(String key, Object value) {
        LocalMemoryCache localCache = FullTextIndexCache.getLocalCache(FullTextIndexCache.getAcctId());
        localCache.put(key, value);
    }

    public static <T> T getCacheData(String key) {
        LocalMemoryCache localCache = FullTextIndexCache.getLocalCache(FullTextIndexCache.getAcctId());
        return (T)localCache.get(key);
    }
}

