/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.fulltext;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.fulltext.FullTextIndex;

public class FullTextIndexQuery {
    private static final String ERROR_PATTERN1 = "Error: %s";
    private static final String ERROR_PATTERN2 = "Error: %s;  sql:%s";

    public boolean isFullTextIndexesExist() {
        String sql = "SELECT 1 FROM T_BAS_FULLTEXTINDEX WHERE FENTITYNUMBER='all_billno'";
        try {
            return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)"SELECT 1 FROM T_BAS_FULLTEXTINDEX WHERE FENTITYNUMBER='all_billno'", (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<Boolean>(){

                public Boolean handle(ResultSet rs) throws Exception {
                    return rs.next();
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_PATTERN2, e.getMessage(), "SELECT 1 FROM T_BAS_FULLTEXTINDEX WHERE FENTITYNUMBER='all_billno'");
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    public List<FullTextIndex> getFullTextIndexes() {
        String sql = "SELECT FID,FENTITYNUMBER,FFIELDNAME,FSYNCTIME FROM T_BAS_FULLTEXTINDEX";
        try {
            return (List)DB.query((DBRoute)DBRoute.basedata, (String)"SELECT FID,FENTITYNUMBER,FFIELDNAME,FSYNCTIME FROM T_BAS_FULLTEXTINDEX", (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<FullTextIndex>>(){

                public List<FullTextIndex> handle(ResultSet rs) throws Exception {
                    ArrayList<FullTextIndex> fullTextIndexes = new ArrayList<FullTextIndex>();
                    FullTextIndex fullTextIndex = null;
                    try {
                        while (rs.next()) {
                            fullTextIndex = new FullTextIndex();
                            fullTextIndex.setId(rs.getLong(1));
                            fullTextIndex.setEntityNumber(rs.getString(2));
                            fullTextIndex.setFieldName(rs.getString(3));
                            fullTextIndex.setSyncTime(rs.getTime(4));
                            fullTextIndexes.add(fullTextIndex);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(FullTextIndexQuery.ERROR_PATTERN1, e.getMessage())});
                    }
                    return fullTextIndexes;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_PATTERN2, e.getMessage(), "SELECT FID,FENTITYNUMBER,FFIELDNAME,FSYNCTIME FROM T_BAS_FULLTEXTINDEX");
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    public List<FullTextIndex> getFullTextIndexes(String[] entityNames) {
        String sql = "SELECT FID,FENTITYNUMBER,FFIELDNAME,FSYNCTIME FROM T_BAS_FULLTEXTINDEX  where FENTITYNAME in(?) ";
        try {
            return (List)DB.query((DBRoute)DBRoute.basedata, (String)"SELECT FID,FENTITYNUMBER,FFIELDNAME,FSYNCTIME FROM T_BAS_FULLTEXTINDEX  where FENTITYNAME in(?) ", (Object[])new Object[]{entityNames}, (ResultSetHandler)new ResultSetHandler<List<FullTextIndex>>(){

                public List<FullTextIndex> handle(ResultSet rs) throws Exception {
                    ArrayList<FullTextIndex> fullTextIndexes = new ArrayList<FullTextIndex>();
                    FullTextIndex fullTextIndex = null;
                    try {
                        while (rs.next()) {
                            fullTextIndex = new FullTextIndex();
                            fullTextIndex.setId(rs.getLong(1));
                            fullTextIndex.setEntityNumber(rs.getString(2));
                            fullTextIndex.setFieldName(rs.getString(3));
                            fullTextIndex.setSyncTime(rs.getTime(4));
                            fullTextIndexes.add(fullTextIndex);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(FullTextIndexQuery.ERROR_PATTERN1, e.getMessage())});
                    }
                    return fullTextIndexes;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_PATTERN2, e.getMessage(), "SELECT FID,FENTITYNUMBER,FFIELDNAME,FSYNCTIME FROM T_BAS_FULLTEXTINDEX  where FENTITYNAME in(?) ");
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    public List<String> getFullTextIndexes(String entityName) {
        String sql = "/*dialect*/SELECT FFIELDNAME FROM T_BAS_FULLTEXTINDEX WHERE FENTITYNUMBER = ? ";
        try {
            return (List)DB.query((DBRoute)DBRoute.basedata, (String)"/*dialect*/SELECT FFIELDNAME FROM T_BAS_FULLTEXTINDEX WHERE FENTITYNUMBER = ? ", (Object[])new Object[]{entityName}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> fullTextIndexes = new ArrayList<String>();
                    try {
                        while (rs.next()) {
                            fullTextIndexes.addAll(Arrays.asList(rs.getString(1).split("\\,")));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(FullTextIndexQuery.ERROR_PATTERN1, e.getMessage())});
                    }
                    return fullTextIndexes;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_PATTERN2, e.getMessage(), "/*dialect*/SELECT FFIELDNAME FROM T_BAS_FULLTEXTINDEX WHERE FENTITYNUMBER = ? ");
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    public Map<String, Object> getFullTextIndex(String entityName) {
        String sql = "/*dialect*/SELECT FFIELDNAME,FSYNCTIME FROM T_BAS_FULLTEXTINDEX WHERE FENTITYNUMBER = ? ";
        try {
            return (Map)DB.query((DBRoute)DBRoute.basedata, (String)"/*dialect*/SELECT FFIELDNAME,FSYNCTIME FROM T_BAS_FULLTEXTINDEX WHERE FENTITYNUMBER = ? ", (Object[])new Object[]{entityName}, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

                public Map<String, Object> handle(ResultSet rs) throws Exception {
                    HashMap<String, Object> fullTextIndexMap = new HashMap<String, Object>();
                    HashSet<String> fullTextIndexes = new HashSet<String>();
                    try {
                        while (rs.next()) {
                            for (String fieldName : rs.getString(1).split("\\,")) {
                                fullTextIndexes.add(fieldName.toLowerCase());
                            }
                            fullTextIndexMap.put("fieldName", fullTextIndexes);
                            fullTextIndexMap.put("syncTime", rs.getTime(2));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(FullTextIndexQuery.ERROR_PATTERN1, e.getMessage())});
                    }
                    return fullTextIndexMap;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(ERROR_PATTERN2, e.getMessage(), "/*dialect*/SELECT FFIELDNAME,FSYNCTIME FROM T_BAS_FULLTEXTINDEX WHERE FENTITYNUMBER = ? ");
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }
}

