/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.fulltext;

import java.util.ArrayList;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.query.fulltext.FullTextIndex;
import kd.bos.orm.query.fulltext.FullTextIndexCache;
import kd.bos.orm.sequence.SequenceReader;

public class FullTextIndexWriter {
    public boolean saveFullTextIndex(FullTextIndex fullTextIndex, StringBuilder errorMessage) {
        FullTextIndex[] filterSchemes = new FullTextIndex[]{fullTextIndex};
        return this.saveFullTextIndex(filterSchemes, errorMessage);
    }

    public static PkSnapshot createDataEntitiesSnapshot(DataEntityType dataEntityType, Object object) {
        PkSnapshot tempVar;
        PkSnapshot snapshot = tempVar = new PkSnapshot();
        tempVar.TableName = dataEntityType.getAlias();
        ISimpleProperty pk = dataEntityType.getPrimaryKey();
        Object[] oids = new Object[]{pk.getValue(object)};
        snapshot.Oids = oids;
        return snapshot;
    }

    private void save(FullTextIndex[] fullTextIndexs, DataEntityType dataEntityType) {
        DBRoute rt = new DBRoute(dataEntityType.getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey(fullTextIndexs, (IDataEntityType)dataEntityType);
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)dataEntityType);
        dataManager.save(fullTextIndexs);
        FullTextIndexWriter.removeFullTextIndexCache();
    }

    public static void removeFullTextIndexCache() {
        FullTextIndexCache.remove("fulltextindexmap");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveFullTextIndex(FullTextIndex[] fullTextIndexs, StringBuilder errorMessage) {
        try (TXHandle h = TX.requiresNew();){
            DataEntityType dataEntityType = (DataEntityType)OrmUtils.getDataEntityType(FullTextIndex.class);
            for (FullTextIndex fullTextIndex : fullTextIndexs) {
                PkSnapshotSet pkSnapshotSet = new PkSnapshotSet();
                pkSnapshotSet.Snapshots.add(FullTextIndexWriter.createDataEntitiesSnapshot(dataEntityType, fullTextIndex));
                dataEntityType.setPkSnapshot((Object)fullTextIndex, pkSnapshotSet);
            }
            this.save(fullTextIndexs, dataEntityType);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            errorMessage.append(e.getMessage());
            return false;
        }
    }

    private static Object[] getUpdatePks(IDataEntityType dt, Object[] dataEntities) {
        ArrayList<Object> pks = new ArrayList<Object>();
        block0: for (int rowIndex = 0; rowIndex < dataEntities.length; ++rowIndex) {
            PkSnapshotSet snapshotSetTemp = dt.getPkSnapshot(dataEntities[rowIndex]);
            if (snapshotSetTemp == null) continue;
            for (PkSnapshot item : snapshotSetTemp.Snapshots) {
                if (!item.TableName.equalsIgnoreCase(dt.getAlias())) continue;
                if (item.Oids == null) continue block0;
                for (Object id : item.Oids) {
                    pks.add(id);
                }
            }
        }
        return pks.toArray();
    }

    public void saveFullTextIndex(FullTextIndex[] fullTextIndexs) {
        DataEntityType dataEntityType = (DataEntityType)OrmUtils.getDataEntityType(FullTextIndex.class);
        for (FullTextIndex fullTextIndex : fullTextIndexs) {
            PkSnapshotSet pkSnapshotSet = new PkSnapshotSet();
            pkSnapshotSet.Snapshots.add(FullTextIndexWriter.createDataEntitiesSnapshot(dataEntityType, fullTextIndex));
            dataEntityType.setPkSnapshot((Object)fullTextIndex, pkSnapshotSet);
        }
        this.save(fullTextIndexs, dataEntityType);
    }
}

