/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.hugein;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.SqlParameter;
import kd.bos.db.pktemptable.PKTempTableHint;
import kd.bos.db.pktemptable.PKTempTableHints;
import kd.bos.db.pktemptable.utils.TableVariableUtil;
import kd.bos.db.splittingread.ThreadReadWriteContext;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterEvaluator;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.hugein.AutoRelease;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.QFilterJoinSQLTransFunction;
import kd.bos.orm.query.multi.QueryUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.temptable.facade.TemptableFacade;
import kd.bos.xdb.temptable.facade.TemptableFacadeContexts;
import kd.bos.xdb.temptable.facade.TemptableFacades;
import kd.bos.xdb.temptable.facade.TemptableType;
import kd.bos.xdb.util.Pair;
import org.apache.logging.log4j.util.Strings;

public class HugeInUtil {
    public static final Object REMOVED_PARAMETER = new Object(){

        public String toString() {
            return "REMOVED_PARAMETER";
        }
    };
    private static final int dm_max_in_count = 2000;

    public static List<QFilter> findOptInFilter(QFilter filter, DBRoute dbRoute, QContext ctx) {
        HugeInUtil.transFTLikeFilter(filter);
        List<QFilter.QFilterNest> nests = filter.getNests(true);
        ArrayList<QFilter> allFilters = new ArrayList<QFilter>(nests.size() + 1);
        allFilters.add(filter);
        HashMap<QFilter, QFilter.QFilterNest> parentMap = new HashMap<QFilter, QFilter.QFilterNest>(nests.size());
        for (QFilter.QFilterNest nest : nests) {
            parentMap.put(nest.getFilter(), nest);
            allFilters.add(nest.getFilter());
        }
        ArrayList<QFilter> ret = new ArrayList<QFilter>(allFilters.size());
        for (QFilter f : allFilters) {
            if (!HugeInUtil.__isOptInFilter(f, parentMap, dbRoute, ctx)) continue;
            ret.add(f);
        }
        return ret;
    }

    public static List<QFilter> findOptInFilter(QFilter filter, DBRoute dbRoute) {
        return HugeInUtil.findOptInFilter(filter, dbRoute, null);
    }

    private static void transFTLikeFilter(QFilter filter) {
        if (filter != null) {
            List<QFilter.QFilterNest> nests;
            QFilter q;
            QParameter qp = filter.__getSelfDefinedQParameter();
            QFilter qFilter = q = qp != null ? qp.getMatchTransferQFilter() : null;
            if ("ftlike".equalsIgnoreCase(filter.getCP()) && q != null && HugeInUtil.containsIn(q)) {
                filter.__setProperty(q.getProperty());
                filter.__setValue(q.getValue());
                filter.__setCP(q.getCP());
                HugeInUtil.tranferSelfParamterToNests(filter, qp.getMatchTransferQFilter());
                filter.__setSelfDefinedQParameter(null);
            }
            if (CollectionUtils.isEmpty(nests = filter.getNests(false))) {
                return;
            }
            for (QFilter.QFilterNest nest : nests) {
                HugeInUtil.transFTLikeFilter(nest.getFilter());
            }
        }
    }

    private static boolean containsIn(QFilter matchQFiler) {
        String cp = matchQFiler.getCP();
        if ("in".equalsIgnoreCase(cp)) {
            return true;
        }
        List<QFilter.QFilterNest> nests = matchQFiler.getNests(true);
        if (CollectionUtils.isEmpty(nests)) {
            return false;
        }
        for (QFilter.QFilterNest nest : nests) {
            QFilter filter = nest.getFilter();
            if (filter == null || !"in".equalsIgnoreCase(filter.getCP())) continue;
            return true;
        }
        return false;
    }

    private static void tranferSelfParamterToNests(QFilter filter, QFilter matchQFilter) {
        QFilter nestFilter;
        if (matchQFilter == null) {
            return;
        }
        List<QFilter.QFilterNest> nests = matchQFilter.getNests(false);
        if (CollectionUtils.isEmpty(nests)) {
            return;
        }
        List<QFilter.QFilterNest> filterNests = filter.getNests(false);
        filter.clearNests();
        for (QFilter.QFilterNest nest : nests) {
            nestFilter = nest.getFilter();
            if (nest.isAnd()) {
                filter.and(nestFilter);
                continue;
            }
            filter.or(nestFilter);
        }
        for (QFilter.QFilterNest nest : filterNests) {
            nestFilter = nest.getFilter();
            if (nest.isAnd()) {
                filter.and(nestFilter);
                continue;
            }
            filter.or(nestFilter);
        }
    }

    private static boolean __isOptInFilter(QFilter filter, Map<QFilter, QFilter.QFilterNest> parentMap, DBRoute dbRoute, QContext ctx) {
        if (!filter.isExpressValue() && filter.getCP() != null && filter.getCP().toLowerCase().indexOf("in") != -1) {
            Object value = filter.getValue();
            if (value != null) {
                Object[] params = QFilterUtil.getWithoutDuplicateInValues(value);
                filter.__setValue(params);
                int size = params.length;
                HugeInConfig.limitInSize(size);
                if (size >= 2000 && DB.getDBType((DBRoute)dbRoute) == DBType.DM) {
                    return true;
                }
                return size >= ORMUtil.toTempTableSize(ctx == null ? null : ctx.getORMHint());
            }
            return false;
        }
        return false;
    }

    @Deprecated
    public static void optWithVariableTable(QFilter filter) {
        HugeInUtil.__alterInQFilter(filter, " IN (SELECT COLUMN_VALUE FROM UDT_INTTABLE(?))", false, false);
    }

    public static void optWithVariableTable(QFilter filter, DBType dbType) {
        Object value = filter.getValue();
        String inSql = " IN (SELECT COLUMN_VALUE FROM UDT_INTTABLE(?))";
        if (TableVariableUtil.isDMDbType((DBType)dbType)) {
            inSql = " IN (SELECT TV.COLUMN_VALUE FROM UDT_INTTABLE(?) as TV)";
        } else if (value.getClass().isArray() && TableVariableUtil.allowSetTableVariableParams((DBType)dbType)) {
            Object[] ps = (Object[])value;
            inSql = ps[0] instanceof String ? " IN (SELECT TV.FID FROM UDT_VARCHARTABLE(?) as TV) " : " IN (SELECT TV.FID FROM UDT_INTTABLE(?) as TV) ";
        }
        HugeInUtil.__alterInQFilter(filter, inSql, false, TableVariableUtil.allowSetTableVariableParams((DBType)dbType));
    }

    private static void __alterInQFilter(QFilter filter, String inSQL, boolean removeParameter, boolean variableParams) {
        QParameter qp;
        Object value = filter.getValue();
        QFilter oldFilter = filter.copy();
        oldFilter.__setSelfDefinedQParameter(null);
        if (removeParameter) {
            qp = new QParameter(filter.getProperty() + inSQL, REMOVED_PARAMETER);
        } else if (variableParams) {
            Object[] ps = (Object[])value;
            SqlParameter parameter = new SqlParameter((Object)ps);
            if (ps[0] instanceof String) {
                parameter.setDbType(12);
                if (!(ps instanceof String[])) {
                    HashSet<String> set = new HashSet<String>(500);
                    for (int i = 0; i < ps.length; ++i) {
                        set.add(ps[i].toString());
                    }
                    parameter.setValue((Object)set.toArray(new String[set.size()]));
                }
            } else {
                HashSet<Long> set = new HashSet<Long>(500);
                parameter.setDbType(-5);
                for (int i = 0; i < ps.length; ++i) {
                    set.add(Long.parseLong(ps[i].toString()));
                }
                parameter.setValue((Object)set.toArray(new Long[set.size()]));
            }
            qp = new QParameter(filter.getProperty() + inSQL, parameter);
        } else {
            qp = new QParameter(filter.getProperty() + inSQL, new SqlParameter(value));
        }
        qp.setSQLBuilder((sql, ctx) -> {
            PropertyField field = oldFilter.__getParsedProperty(ctx);
            if (oldFilter != null && !oldFilter.getProperty().equalsIgnoreCase(field.getAlias())) {
                oldFilter.toQParameter(ctx);
            }
            String propertyAlias = oldFilter.getPropertyAlias(ctx, oldFilter.__getParsedProperty(ctx));
            String cp = oldFilter.getCP();
            if ("not in".equalsIgnoreCase(cp.trim())) {
                propertyAlias = propertyAlias + " NOT ";
            }
            return propertyAlias.trim() + inSQL;
        });
        filter.__setSelfDefinedQParameter(qp);
    }

    public static Pair<AutoRelease, QFilter> optWithTemplateTableAsJoin(QFilter filter, QFilter rootFilter, DBRoute dbRoute, Map<String, IDataEntityType> entityTypeCache, DBType dbType, String fullObjName, QContext ctx) {
        if (!HugeInUtil.__canTransToJoin(filter, rootFilter)) {
            return null;
        }
        Set<Object> noNullValueSet = HugeInUtil.__asNoNullValueSet(filter.getValue());
        if (noNullValueSet.size() < ORMUtil.toTempTableSize(ctx.getORMHint())) {
            filter.__setValue(noNullValueSet);
            return null;
        }
        if (!ThreadReadWriteContext.isAllowUseTempTable()) {
            return null;
        }
        ThreadReadWriteContext.forceSetWriteMode();
        ShardingHintContext shc = HugeInUtil.tryHint(filter, noNullValueSet);
        TemptableFacade table = HugeInUtil.__createTempTableFacade(filter, noNullValueSet, ctx);
        String innerJoinSql = HugeInUtil.getInnerSql(filter, ctx, table, fullObjName);
        QFilter joinFilter = QFilter.joinSQL(fullObjName, innerJoinSql, null);
        QFilterJoinSQLTransFunction function = new QFilterJoinSQLTransFunction();
        function.apply(joinFilter);
        filter.maskCurrent();
        DynamicObjectType dt = HugeInUtil.__createDataEntityType(table.getName(), dbRoute.getRouteKey());
        entityTypeCache.put(table.getName(), (IDataEntityType)dt);
        return new Pair((Object)HugeInUtil.createAutoRelease(shc), (Object)joinFilter);
    }

    private static AutoRelease createAutoRelease(final ShardingHintContext shc) {
        return new AutoRelease(){

            @Override
            public void close() {
            }

            @Override
            public void onQueried() {
                if (shc != null) {
                    shc.close();
                }
            }
        };
    }

    private static ShardingHintContext tryHint(QFilter filter, Set<Object> noNullValueSet) {
        PropertyField pf;
        ShardingHintContext shc = ShardingHintContext.get();
        if (shc == null && !filter.__getParsedPropertyFields().isEmpty() && (pf = filter.__getParsedPropertyFields().get(0)).getEntityType().getPrimaryKey() == pf.getPeropertyType() && (shc = ShardingHinter.tryHint(pf.getEntityType(), noNullValueSet.toArray())) != null) {
            shc.set();
            return shc;
        }
        return null;
    }

    private static boolean __canTransToJoin(QFilter filter, QFilter rootFilter) {
        String cp;
        if (filter.getCP() != null && "notin".equals(cp = filter.getCP().replaceAll(" ", "").toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        QFilterEvaluator evalor = f -> f != filter;
        return !rootFilter.eval(evalor);
    }

    private static Set<Object> __asNoNullValueSet(Object values) {
        HashSet<Object> noNullValueSet = new HashSet<Object>();
        if (values.getClass().isArray()) {
            int size = Array.getLength(values);
            for (int i = 0; i < size; ++i) {
                noNullValueSet.add(Array.get(values, i));
            }
        } else if (values instanceof Collection) {
            noNullValueSet.addAll((Collection)values);
        } else {
            for (Object value : (Iterable)values) {
                noNullValueSet.add(value);
            }
        }
        noNullValueSet.remove(null);
        return noNullValueSet;
    }

    private static TemptableFacade __createTempTableFacade(QFilter filter, Set<Object> noNullValueSet, QContext ctx) {
        TemptableFacade table;
        if (Number.class.isAssignableFrom(noNullValueSet.iterator().next().getClass())) {
            table = TemptableFacades.create((TemptableType)TemptableType.PK_LONG);
        } else {
            PropertyField pf = filter.__getParsedProperty(ctx);
            if (pf.isExpress()) {
                ArrayList<PropertyField> fields = new ArrayList<PropertyField>(pf.getPropertySegExpress().getPropertyFields());
                pf = (PropertyField)fields.get(0);
            }
            if (pf.getPeropertyType() == pf.getEntityType().getPrimaryKey() || pf.getPeropertyType() instanceof IComplexProperty) {
                table = TemptableFacades.create((TemptableType)TemptableType.PK_STRING);
            } else {
                int maxStringLength = 0;
                for (Object o : noNullValueSet) {
                    if (!(o instanceof String)) continue;
                    maxStringLength = Math.max(((String)o).length(), maxStringLength);
                }
                try (PKTempTableHint ignored = PKTempTableHints.newHint((int)maxStringLength);){
                    table = TemptableFacades.create((TemptableType)TemptableType.BIG_STRING);
                }
            }
        }
        table.insert(noNullValueSet);
        TemptableFacadeContexts.get().add(table);
        return table;
    }

    private static DynamicObjectType __createDataEntityType(String name, String dbRouteKey) {
        DynamicObjectType dt = new DynamicObjectType();
        dt.setName(name);
        dt.setAlias(name);
        dt.setDBRouteKey(dbRouteKey);
        DynamicSimpleProperty pid = new DynamicSimpleProperty();
        pid.setAlias("fid");
        pid.setName("id");
        pid.setPrimaryKey(true);
        dt.getProperties().add((Object)pid);
        return dt;
    }

    public static AutoRelease optWithTemplateTableAsSubQuery(QFilter filter, DBRoute dbRoute, QContext ctx) {
        Set<Object> noNullValueSet = HugeInUtil.__asNoNullValueSet(filter.getValue());
        if (noNullValueSet.size() < ORMUtil.toTempTableSize(ctx == null ? null : ctx.getORMHint())) {
            filter.__setValue(noNullValueSet);
            return null;
        }
        if (!ThreadReadWriteContext.isAllowUseTempTable()) {
            return null;
        }
        ThreadReadWriteContext.forceSetWriteMode();
        ShardingHintContext shc = HugeInUtil.tryHint(filter, noNullValueSet);
        TemptableFacade table = HugeInUtil.__createTempTableFacade(filter, noNullValueSet, ctx);
        String inSQL = " IN (SELECT FID FROM " + table.getName() + ")";
        HugeInUtil.__alterInQFilter(filter, inSQL, true, false);
        return HugeInUtil.createAutoRelease(shc);
    }

    private static String getInnerSql(QFilter filter, QContext ctx, TemptableFacade table, String sqlObjectName) {
        String innerJoinSQL;
        String simpleEntityAlias1;
        String fullObjectName;
        PropertyField propertyField = filter.__getParsedProperty(ctx);
        String joinField = propertyField.getField();
        if (StringUtils.isEmpty(propertyField.getEntityAlias())) {
            IDataEntityProperty propertyType;
            fullObjectName = propertyField.getFullObjectName();
            int index = fullObjectName.indexOf(".");
            String rootName = fullObjectName;
            if (index != -1) {
                rootName = fullObjectName.substring(0, index);
            }
            if (!((propertyType = QueryUtils.getPropertyType(propertyField, filter, ctx, rootName, fullObjectName)) == null || !ORMConfiguration.isMultiLangPropertyType(propertyType) || ORMConfiguration.useSingleLang() && propertyField.isGLField())) {
                simpleEntityAlias1 = ctx.getSimpleEntityAlias(fullObjectName + "_L");
            } else {
                String tableGroup;
                String string = tableGroup = propertyType == null ? "" : propertyType.getTableGroup();
                simpleEntityAlias1 = tableGroup != null && tableGroup.length() > 0 ? ctx.getSimpleEntityAlias(fullObjectName + "_" + tableGroup) : ctx.getSimpleEntityAlias(fullObjectName);
            }
        } else {
            String fullName;
            int index;
            DynamicSimpleProperty simpleProperty;
            IDataEntityProperty peropertyType;
            fullObjectName = propertyField.getEntityAlias();
            if (ORMConfig.ALIAS_NEW.getBoolean() && (peropertyType = propertyField.getPeropertyType()) != null && !ORMConfiguration.isEntryEntityType(peropertyType.getParent()) && peropertyType instanceof DynamicSimpleProperty && (simpleProperty = (DynamicSimpleProperty)peropertyType).isPrimaryKey() && (index = (fullName = propertyField.getFullName()).lastIndexOf(".")) != -1 && !(fullName = fullName.substring(0, index)).equalsIgnoreCase(sqlObjectName) && (index = fullName.lastIndexOf(".")) != -1) {
                String rootName;
                String joinFieldName = fullName.substring(1 + index);
                fullObjectName = (fullName = fullName.substring(0, index)).equals(rootName = ctx.getMainEntityItem().getFullObjectName()) ? fullName : (!fullName.startsWith(rootName + ".") ? rootName + "." + fullName : fullName);
                EntityItem entityItem = ctx.getEntityItem(fullObjectName);
                joinField = entityItem.getPropertyItem(joinFieldName).getPropertyType().getAlias();
                String group = entityItem.getPropertyItem(joinFieldName).getPropertyType().getTableGroup();
                if (Strings.isNotEmpty((CharSequence)group)) {
                    fullObjectName = fullObjectName + "_" + group;
                }
            }
            simpleEntityAlias1 = ctx.getSimpleEntityAlias(fullObjectName);
        }
        String simpleEntityAlias = ctx.getSimpleEntityAlias(table.getName());
        if (propertyField.isExpress()) {
            String sql = filter.getPropertyAlias(ctx, filter.__getParsedProperty(ctx));
            innerJoinSQL = "inner join " + table.getName() + " " + simpleEntityAlias + " on " + sql + "=" + simpleEntityAlias + ".fid";
        } else {
            innerJoinSQL = "inner join " + table.getName() + " " + simpleEntityAlias + " on " + simpleEntityAlias1 + "." + joinField + "=" + simpleEntityAlias + ".fid";
        }
        return innerJoinSQL;
    }
}

