/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.join;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.AlgoUtil;
import kd.bos.ksql.util.StringUtil;
import kd.bos.orm.JoinQueryParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.orm.query.join.FieldAlias;
import kd.bos.util.StringUtils;

public class JoinQueryBuilder {
    private String algoKey;
    private JoinQueryParameter jqp;
    private int aliasIndex = 0;
    private int paramIndex = 0;
    private Map<String, Set<FieldAlias>> entityAlaisSelectFieldsMap = new HashMap<String, Set<FieldAlias>>();
    private Map<String, Boolean> isCombineAndExpMap = new HashMap<String, Boolean>();
    private List<QFilter> mainEntityfilters = new ArrayList<QFilter>(4);

    public JoinQueryBuilder(String algoKey, JoinQueryParameter jqp) {
        this.algoKey = algoKey;
        this.jqp = jqp;
    }

    public DataSet query() {
        return this.crossDBQuery();
    }

    public int count() {
        this.jqp.limit(0);
        int count = 0;
        for (Row row : this.query()) {
            ++count;
        }
        return count;
    }

    private DataSet sameDBQuery() {
        List<QFilter> filters = this.getFilters();
        int start = this.jqp.getStart();
        int limit = this.jqp.getLimit();
        if (start >= 0 && limit > 0) {
            return ORM.create().queryDataSet(this.algoKey, this.jqp.getMainEntity(), this.jqp.getSelect(), filters.toArray(new QFilter[0]), this.jqp.getOrderBy(), start, limit, null);
        }
        return ORM.create().queryDataSet(this.algoKey, this.jqp.getMainEntity(), this.jqp.getSelect(), filters.toArray(new QFilter[0]), this.jqp.getOrderBy(), -1);
    }

    private List<QFilter> getFilters() {
        String mainEntityName = this.jqp.getMainEntity();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        QFilter[] filterArray = this.jqp.getFilter();
        if (filterArray != null) {
            for (QFilter filter : this.jqp.getFilter()) {
                filters.add(filter);
            }
        }
        HashSet<String> tempEntityNameSet = new HashSet<String>(this.jqp.getJoinQueryList().size());
        for (JoinQueryParameter.JoinQuery joinQuery : this.jqp.getJoinQueryList()) {
            tempEntityNameSet.add(joinQuery.getJoinEntity());
        }
        for (JoinQueryParameter.JoinQuery joinQuery : this.jqp.getJoinQueryList()) {
            QFilter andFilter = null;
            String andExp = joinQuery.getAndExp();
            if (!StringUtils.isEmpty((String)andExp)) {
                andExp = andExp.replaceAll(mainEntityName + ".", "");
                andFilter = QFilter.of(andExp, joinQuery.getAndExpParams());
            }
            String tempProp = joinQuery.getProperty();
            boolean isJoinMainEntity = true;
            if (tempEntityNameSet.contains(tempProp.split("\\.")[0])) {
                isJoinMainEntity = false;
            }
            tempProp = tempProp.replaceAll(mainEntityName + ".", "");
            QFilter joinFilter = QFilter.join(tempProp, joinQuery.getJoinProperty(), andFilter, joinQuery.getJoinHint(), isJoinMainEntity);
            filters.add(joinFilter);
        }
        return filters;
    }

    /*
     * WARNING - void declaration
     */
    private DataSet crossDBQuery() {
        boolean needDistinct;
        this.analyzeParameter();
        ORM orm = ORM.create();
        String mainEntityName = this.jqp.getMainEntity();
        DataSet mainDataSet = orm.queryDataSet(this.algoKey + mainEntityName, mainEntityName, this.getEntitySelectFields(mainEntityName), this.mainEntityfilters.toArray(new QFilter[0]), null, -1);
        StringBuilder afterJoinSelectFieldAlaiss = new StringBuilder(this.getEntitySelectAliass(mainEntityName));
        for (JoinQueryParameter.JoinQuery queryJoin : this.jqp.getJoinQueryList()) {
            String joinEntityName = queryJoin.getJoinEntity();
            String joinEntityNameAlais = queryJoin.getJoinEntityAlias();
            QFilter joinFilter = null;
            String string = queryJoin.getAndExp();
            if (!StringUtils.isEmpty((String)string) && !this.isCombineAndExpMap.get(joinEntityNameAlais).booleanValue()) {
                String string2 = string.replaceAll(joinEntityNameAlais + ".", "");
                joinFilter = QFilter.of(string2, queryJoin.getAndExpParams());
            }
            DataSet joinDataSet = orm.queryDataSet(this.algoKey + joinEntityName, joinEntityName, this.getEntitySelectFields(joinEntityNameAlais), new QFilter[]{joinFilter});
            afterJoinSelectFieldAlaiss.append(',').append(this.getEntitySelectAliass(joinEntityNameAlais));
            JoinType joinType = queryJoin.getJoinHint() == ORMHint.JoinHint.LEFT ? JoinType.LEFT : JoinType.INNER;
            String propertyAlais = this.getFieldAlias(queryJoin.getProperty());
            String joinPropertyAlais = this.getFieldAlias(queryJoin.getJoinProperty());
            String[] joinSelectFields = afterJoinSelectFieldAlaiss.toString().split(",");
            if (this.isCombineAndExpMap.get(joinEntityNameAlais).booleanValue()) {
                void var10_21;
                DataSet tempDataSet = mainDataSet.join(joinDataSet, JoinType.INNER).on(propertyAlais, joinPropertyAlais).select(joinSelectFields).finish();
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                tempDataSet = tempDataSet.filter(this.filterToExp(QFilter.of((String)var10_21, queryJoin.getAndExpParams()), paramMap), paramMap);
                if (JoinType.LEFT == joinType) {
                    tempDataSet = tempDataSet.select(this.getEntitySelectAliass(joinEntityName).split(","));
                    mainDataSet = mainDataSet.join(tempDataSet, JoinType.LEFT).on(propertyAlais, joinPropertyAlais).select(joinSelectFields).finish();
                    continue;
                }
                mainDataSet = tempDataSet;
                continue;
            }
            mainDataSet = mainDataSet.join(joinDataSet, joinType).on(propertyAlais, joinPropertyAlais).select(joinSelectFields).finish();
        }
        for (QFilter filter : this.jqp.getFilter()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            mainDataSet = mainDataSet.filter(this.filterToExp(filter, params), params);
        }
        StringBuilder finalSelectFields = new StringBuilder();
        StringBuilder finalSelectFieldsWithoutAsAlias = new StringBuilder();
        for (String string : this.jqp.getSelect().split(",")) {
            String[] selectFieldArr = string.split(" ");
            if (selectFieldArr.length == 2 && !StringUtils.isEmpty((String)selectFieldArr[1])) {
                finalSelectFields.append(selectFieldArr[1]).append(',');
                finalSelectFieldsWithoutAsAlias.append(selectFieldArr[1]).append(',');
                continue;
            }
            finalSelectFields.append(this.getFieldAlias(string)).append(" as ").append(string).append(',');
            finalSelectFieldsWithoutAsAlias.append(this.getFieldAlias(string)).append(',');
        }
        boolean bl = needDistinct = finalSelectFields.toString().split(",").length != afterJoinSelectFieldAlaiss.toString().split(",").length;
        if (needDistinct) {
            mainDataSet = mainDataSet.select(true, finalSelectFieldsWithoutAsAlias.substring(0, finalSelectFieldsWithoutAsAlias.length() - 1).split(","));
        }
        mainDataSet = mainDataSet.select(finalSelectFields.substring(0, finalSelectFields.length() - 1).split(","));
        String orderBy = this.jqp.getOrderBy();
        if (!StringUtils.isEmpty((String)orderBy)) {
            ArrayList<String> orderByFieldList = new ArrayList<String>(4);
            for (String orderByField : orderBy.split(",")) {
                orderByFieldList.add(orderByField);
            }
            mainDataSet = mainDataSet.orderBy(orderByFieldList.toArray(new String[0]));
        }
        int start = this.jqp.getStart();
        int n = this.jqp.getLimit();
        if (start >= 0 && n > 0) {
            return mainDataSet.range(start, n);
        }
        return mainDataSet;
    }

    private String filterToExp(QFilter filter, Map<String, Object> params) {
        StringBuilder sBuilder = new StringBuilder();
        if (filter.getCP().equalsIgnoreCase("not exists")) {
            QFilter qFilter = new QFilter(filter.getProperty(), "=", QEmptyValue.value);
            this.filterToExp1(qFilter, params, sBuilder);
        } else {
            this.filterToExp1(filter, params, sBuilder);
        }
        for (QFilter.QFilterNest nest : filter.getNests(false)) {
            sBuilder.insert(0, '(');
            if (nest.isAnd()) {
                sBuilder.append(" and");
            } else {
                sBuilder.append(" or");
            }
            QFilter q = nest.getFilter();
            if (!q.getNests(false).isEmpty()) {
                sBuilder.append(' ').append(this.filterToExp(q, params));
            } else {
                sBuilder.append(' ');
                this.filterToExp1(q, params, sBuilder);
            }
            sBuilder.append(')');
        }
        return sBuilder.toString();
    }

    private void filterToExp1(QFilter filter, Map<String, Object> params, StringBuilder sBuilder) {
        String paramKey;
        String property = filter.getProperty();
        DataType datatype = this.getFieldDataType(property);
        String propertyAlias = this.getFieldAlias(property);
        Object filterValue = filter.getOriginValue();
        String cp = filter.getCP();
        if (filterValue == QEmptyValue.value) {
            filterValue = datatype.equals((Object)DataType.IntegerType) ? Integer.valueOf(0) : (datatype.equals((Object)DataType.LongType) ? Long.valueOf(0L) : (datatype.equals((Object)DataType.StringType) ? " " : null));
        }
        if (DataType.StringType.equals((Object)datatype) && filterValue instanceof Number && AlgoUtil.equal((Object)filterValue, (Object)0)) {
            filterValue = " ";
        }
        if (DataType.BooleanType.equals((Object)datatype)) {
            if (filterValue instanceof List) {
                ArrayList<Boolean> tempFilterValue = new ArrayList<Boolean>(4);
                for (Object obj : (List)filterValue) {
                    if ("1".equals(String.valueOf(obj))) {
                        tempFilterValue.add(Boolean.TRUE);
                        continue;
                    }
                    if ("0".equals(String.valueOf(obj))) {
                        tempFilterValue.add(Boolean.FALSE);
                        continue;
                    }
                    tempFilterValue.add((Boolean)obj);
                }
                filterValue = tempFilterValue;
            } else if ("1".equals(String.valueOf(filterValue))) {
                filterValue = Boolean.TRUE;
            } else if ("0".equals(String.valueOf(filterValue))) {
                filterValue = Boolean.FALSE;
            }
        }
        if (filter.isExpressValue()) {
            sBuilder.append(propertyAlias);
            sBuilder.append(' ').append(cp);
            sBuilder.append(' ').append(this.getFieldAlias(String.valueOf(filterValue)));
        } else if (cp.equalsIgnoreCase("is null") || cp.equalsIgnoreCase("is not null")) {
            sBuilder.append(propertyAlias);
            sBuilder.append(' ').append(cp);
        } else if (cp.equalsIgnoreCase("like") || cp.equalsIgnoreCase("not like")) {
            sBuilder.append(propertyAlias);
            sBuilder.append(' ').append(cp);
            sBuilder.append(' ').append('\"').append(this.handleSpecilaChar(String.valueOf(filterValue))).append('\"');
        } else if (cp.equalsIgnoreCase("in") || cp.equalsIgnoreCase("not in")) {
            sBuilder.append('(').append(propertyAlias);
            sBuilder.append(' ').append(cp);
            paramKey = this.getParamKey();
            sBuilder.append(' ').append(paramKey).append(')');
            params.put(paramKey, filterValue);
        } else if (filter.getValue() == QEmptyValue.value && filterValue == null) {
            sBuilder.append(propertyAlias).append(" is null ");
        } else {
            sBuilder.append(propertyAlias);
            sBuilder.append(' ').append(cp);
            paramKey = this.getParamKey();
            sBuilder.append(' ').append(paramKey);
            params.put(paramKey, filterValue);
            if (filter.getValue() == QEmptyValue.value) {
                sBuilder.append(" or ").append(propertyAlias).append(" is null ");
                if (datatype.equals((Object)DataType.StringType)) {
                    paramKey = this.getParamKey();
                    sBuilder.append(" or ").append(propertyAlias).append(" = ").append(paramKey);
                    params.put(paramKey, "");
                }
            }
        }
    }

    private String handleSpecilaChar(String value) {
        return value.replace("\"", "\\\"");
    }

    private String getParamKey() {
        String paramKey = "jq_param_" + this.paramIndex;
        ++this.paramIndex;
        return paramKey;
    }

    private DataType getFieldDataType(String oName) {
        String entityName = null;
        String[] oNameArray = oName.split("\\.");
        String qName = null;
        String mainEntityName = this.jqp.getMainEntity();
        String entityNameAlais = oNameArray[0];
        if (this.entityAlaisSelectFieldsMap.containsKey(entityNameAlais)) {
            if (mainEntityName.equals(entityNameAlais)) {
                entityName = mainEntityName;
            } else {
                for (JoinQueryParameter.JoinQuery joinQuery : this.jqp.getJoinQueryList()) {
                    if (!joinQuery.getJoinEntityAlias().equals(entityNameAlais)) continue;
                    entityName = joinQuery.getJoinEntity();
                    break;
                }
            }
            qName = oNameArray.length > 1 ? oName.substring(oNameArray[0].length() + 1, oName.length()) : "id";
        } else {
            entityName = mainEntityName;
            qName = oName;
        }
        RowMeta rowMeta = ORM.create().createRowMeta(entityName, qName);
        return rowMeta.getFieldDataType(0);
    }

    private String getFieldAlias(String oName) {
        String entityName = null;
        String[] oNameArray = oName.split("\\.");
        String qName = null;
        if (this.entityAlaisSelectFieldsMap.containsKey(oNameArray[0])) {
            entityName = oNameArray[0];
            qName = oNameArray.length > 1 ? oName.substring(oNameArray[0].length() + 1, oName.length()) : "id";
        } else {
            entityName = this.jqp.getMainEntity();
            qName = oName;
        }
        for (FieldAlias fa : this.entityAlaisSelectFieldsMap.get(entityName)) {
            if (!fa.qName.equals(qName.split(" ")[0])) continue;
            return fa.alias;
        }
        return null;
    }

    private String getEntitySelectFields(String entityName) {
        StringBuilder stringB = new StringBuilder();
        for (FieldAlias fieldAlias : this.entityAlaisSelectFieldsMap.get(entityName)) {
            stringB.append(fieldAlias.qName).append(' ').append(fieldAlias.alias).append(',');
        }
        return stringB.substring(0, stringB.length() - 1);
    }

    private String getEntitySelectAliass(String entityName) {
        StringBuilder stringB = new StringBuilder();
        for (FieldAlias fieldAlais : this.entityAlaisSelectFieldsMap.get(entityName)) {
            stringB.append(fieldAlais.alias).append(',');
        }
        return stringB.substring(0, stringB.length() - 1);
    }

    private void analyzeParameter() {
        boolean includeOtherProperty;
        String split0Str;
        String orderByStr = this.jqp.getOrderBy();
        if (!StringUtil.isEmpty((String)orderByStr)) {
            Object[] tempStrs;
            HashSet<String> selectFields = new HashSet<String>(16);
            for (String str : this.jqp.getSelect().split(",")) {
                selectFields.add(str);
            }
            for (Object temp : tempStrs = orderByStr.trim().split(",")) {
                selectFields.add(((String)temp).trim().split(" ")[0].toLowerCase());
            }
            StringBuilder selectFiledSBuilder = new StringBuilder(64);
            for (String field : selectFields) {
                selectFiledSBuilder.append(field).append(',');
            }
            this.jqp.select(selectFiledSBuilder.substring(0, selectFiledSBuilder.length() - 1));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(6);
        for (QFilter filter : this.jqp.getFilter()) {
            if (filter != null) {
                filters.add(this.transFtlike(filter));
                continue;
            }
            filters.add(filter);
        }
        this.jqp.filter(filters.toArray(new QFilter[0]));
        List<JoinQueryParameter.JoinQuery> joinQuerys = this.jqp.getJoinQueryList();
        String mainEntityName = this.jqp.getMainEntity();
        this.entityAlaisSelectFieldsMap.put(mainEntityName, new HashSet());
        for (JoinQueryParameter.JoinQuery joinQuery : joinQuerys) {
            this.entityAlaisSelectFieldsMap.put(joinQuery.getJoinEntityAlias(), new HashSet());
        }
        for (JoinQueryParameter.JoinQuery queryJoin : joinQuerys) {
            String joinEntityNameAlais = queryJoin.getJoinEntityAlias();
            this.addSelectField(joinEntityNameAlais, queryJoin.getJoinProperty());
            String property = queryJoin.getProperty();
            split0Str = property.split("\\.")[0];
            if (this.entityAlaisSelectFieldsMap.containsKey(split0Str)) {
                this.addSelectField(split0Str, property);
            } else {
                this.addSelectField(mainEntityName, property);
            }
            String andExp = queryJoin.getAndExp();
            includeOtherProperty = false;
            if (andExp != null) {
                QFilter andFilter = QFilter.of(andExp, queryJoin.getAndExpParams());
                includeOtherProperty = this.analyzeFilter(joinEntityNameAlais, andFilter);
                for (QFilter.QFilterNest qFilterNest : andFilter.getNests(true)) {
                    boolean b = this.analyzeFilter(joinEntityNameAlais, qFilterNest.getFilter());
                    if (includeOtherProperty) continue;
                    includeOtherProperty = b;
                }
            }
            this.isCombineAndExpMap.put(joinEntityNameAlais, includeOtherProperty);
        }
        for (String selectField : this.jqp.getSelect().split(",")) {
            split0Str = selectField.split("\\.")[0];
            if (this.entityAlaisSelectFieldsMap.containsKey(split0Str)) {
                this.addSelectField(split0Str, selectField);
                continue;
            }
            this.addSelectField(mainEntityName, selectField);
        }
        ArrayList<QFilter> otherEntityFilter = new ArrayList<QFilter>(4);
        QFilter[] filterArray = this.jqp.getFilter();
        if (filterArray != null) {
            for (QFilter filter : filterArray) {
                if (filter == null) continue;
                includeOtherProperty = this.analyzeFilter(mainEntityName, filter);
                for (QFilter.QFilterNest qFilterNest : filter.getNests(true)) {
                    boolean b = this.analyzeFilter(mainEntityName, qFilterNest.getFilter());
                    if (includeOtherProperty) continue;
                    includeOtherProperty = b;
                }
                if (includeOtherProperty) {
                    otherEntityFilter.add(filter);
                    continue;
                }
                this.mainEntityfilters.add(filter);
            }
        }
        this.jqp.filter(otherEntityFilter.toArray(new QFilter[0]));
    }

    private QFilter transFtlike(QFilter originFilter) {
        QFilter filter;
        QFilter transfered = filter = originFilter.copy();
        if (filter != null) {
            transfered = this.doTransFtlike(filter);
        }
        return transfered;
    }

    private QFilter doTransFtlike(QFilter filter) {
        QFilter newQFilter = null;
        if ("ftlike".equals(filter.getCP())) {
            String[] values;
            String filterValue = String.valueOf(filter.getValue());
            String[] propertys = filter.getProperties();
            if (QMatches._isMatchSolt(filter.getProperty())) {
                int splitIndex = filterValue.indexOf("#");
                values = filterValue.substring(splitIndex + 1, filterValue.length()).split("\b");
            } else {
                values = new String[]{filterValue};
            }
            for (String property : propertys) {
                for (String value : values) {
                    if (newQFilter == null) {
                        newQFilter = QFilter.like(property, value);
                        continue;
                    }
                    newQFilter.or(QFilter.like(property, value));
                }
            }
        } else {
            newQFilter = new QFilter(filter.getProperty(), filter.getCP(), filter.getValue());
        }
        if (newQFilter != null) {
            List<QFilter.QFilterNest> nestList = filter.getNests(false);
            for (QFilter.QFilterNest nest : nestList) {
                QFilter transfer = this.doTransFtlike(nest.getFilter());
                if (transfer == null) continue;
                if (nest.isAnd()) {
                    newQFilter.and(transfer);
                    continue;
                }
                newQFilter.or(transfer);
            }
        }
        return newQFilter;
    }

    private boolean analyzeFilter(String entityName, QFilter filter) {
        String expValue;
        String expSplit0Str;
        boolean includeOtherProperty = false;
        if (filter == null) {
            return includeOtherProperty;
        }
        String propertyName = filter.getProperty();
        String split0Str = propertyName.split("\\.")[0];
        if (this.entityAlaisSelectFieldsMap.containsKey(split0Str)) {
            if (!entityName.equals(split0Str)) {
                includeOtherProperty = true;
            }
            this.addSelectField(split0Str, propertyName);
        } else {
            this.addSelectField(this.jqp.getMainEntity(), propertyName);
        }
        if (filter.isExpressValue() && this.entityAlaisSelectFieldsMap.containsKey(expSplit0Str = (expValue = String.valueOf(filter.getValue())).split("\\.")[0])) {
            if (!includeOtherProperty && !entityName.equals(expSplit0Str)) {
                includeOtherProperty = true;
            }
            this.addSelectField(expSplit0Str, expValue);
        }
        return includeOtherProperty;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addSelectField(String entityName, String oName) {
        String[] oNameArray = oName.split("\\.");
        FieldAlias fa = new FieldAlias();
        String qName = null;
        if (entityName.equals(oNameArray[0])) {
            if (oNameArray.length <= 1) return;
            qName = oName.substring(oNameArray[0].length() + 1, oName.length());
        } else {
            qName = oName;
        }
        String[] qNameArray = qName.split(" ");
        if (qNameArray.length == 2 && !StringUtils.isEmpty((String)qNameArray[1])) {
            fa.qName = qNameArray[0];
            fa.alias = qNameArray[1];
        } else {
            fa.qName = qName;
            fa.alias = "jq_ala_" + this.aliasIndex;
            ++this.aliasIndex;
        }
        this.entityAlaisSelectFieldsMap.get(entityName).add(fa);
    }
}

