/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kd.bos.algo.DataType;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.privacy.IPrivacyDataService;
import kd.bos.dataentity.privacy.IPrivacyProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DataSetDataType;
import kd.bos.db.QueryMeta;
import kd.bos.encrypt.Encrypters;
import org.apache.commons.beanutils.ConvertUtils;

public class FieldDecrypt {
    private static final QueryMeta.Converter textConverter = new QueryMeta.Converter(){

        public Object convert(Object value) {
            if (StringUtils.isBlank((Object)value)) {
                return "";
            }
            return Encrypters.decode((String)String.valueOf(value));
        }
    };
    private static final QueryMeta.Converter amountConverter = new QueryMeta.Converter(){

        public Object convert(Object value) {
            if (StringUtils.isBlank((Object)value)) {
                return null;
            }
            return new BigDecimal(Encrypters.decode((String)String.valueOf(value)));
        }
    };
    private static final QueryMeta.Converter timestampConverter = new QueryMeta.Converter(){

        public Object convert(Object value) {
            if (StringUtils.isBlank((Object)value)) {
                return null;
            }
            String str = Encrypters.decode((String)String.valueOf(value));
            return new Timestamp(Long.parseLong(str));
        }
    };

    public static QueryMeta.Converter getPrivacyConverter(IPrivacyProperty prop) {
        return new PrivacyConverter(prop);
    }

    public static QueryMeta.Converter get(ISimpleProperty p) {
        if (12 == p.getDbType() || -9 == p.getDbType()) {
            return textConverter;
        }
        if (DataType.TimestampType == DataSetDataType.getDataType((Class)p.getPropertyType())) {
            return timestampConverter;
        }
        return amountConverter;
    }

    static class ClassHolder {
        private static Class<?> textPropCls;

        ClassHolder() {
        }

        static {
            try {
                textPropCls = Class.forName("kd.bos.entity.property.TextProp");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class PrivacyConverter
    implements QueryMeta.Converter {
        IPrivacyProperty prop;

        public PrivacyConverter(IPrivacyProperty prop) {
            this.prop = prop;
        }

        public Object convert(Object arg0) {
            IPrivacyDataService service = this.prop.getPrivacyDataService();
            Object value = service.decode(arg0);
            return this.convertValue(value);
        }

        private boolean isNumeric(String s) {
            if (s != null && !"".equals(s.trim())) {
                return s.matches("^[0-9]*$");
            }
            return false;
        }

        private Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (this.prop.getParent() == null) {
                return value;
            }
            IDataEntityProperty originProp = (IDataEntityProperty)this.prop.getParent().getProperties().get((Object)this.prop.getOriginalPropKey());
            DataType newtype = DataSetDataType.getDataType((Class)originProp.getPropertyType());
            if (value.getClass().isAssignableFrom(newtype.getClass())) {
                return value;
            }
            switch (newtype.ordinal) {
                case 1: 
                case 3: 
                case 5: {
                    return ConvertUtils.convert((Object)value, (Class)newtype.getJavaType());
                }
                case 6: {
                    if (this.isNumeric(value.toString())) {
                        return new Date(Long.parseLong(value.toString()));
                    }
                    SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                    try {
                        return df.parse(value.toString());
                    }
                    catch (ParseException e) {
                        throw new OrmException("bos-exception", BosRes.get((String)"bos-ormengine", (String)"FieldDecrypt_0", (String)"Privacy data Decode error\uff0cvalue:{0}", (Object[])new Object[]{value}), (Throwable)e);
                    }
                }
                case 7: {
                    if (this.isNumeric(value.toString())) {
                        return new Timestamp(Long.parseLong(value.toString()));
                    }
                    SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                    try {
                        Date date = df.parse(value.toString());
                        return new Timestamp(date.getTime());
                    }
                    catch (ParseException e) {
                        throw new OrmException("bos-exception", BosRes.get((String)"bos-ormengine", (String)"FieldDecrypt_0", (String)"Privacy data Decode error\uff0cvalue:{0}", (Object[])new Object[]{value}), (Throwable)e);
                    }
                }
            }
            return value;
        }
    }
}

