/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.DataType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.privacy.IPrivacyDataService;
import kd.bos.dataentity.privacy.IPrivacyProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DataSetDataType;
import kd.bos.db.QueryMeta;
import kd.bos.encrypt.Encrypters;

public class FieldEncrypt {
    private static final BigDecimal zero = new BigDecimal("0");
    private static final QueryMeta.Converter textConverter = new QueryMeta.Converter(){

        public Object convert(Object value) {
            if (StringUtils.isBlank((Object)value)) {
                return "";
            }
            return Encrypters.encode((String)String.valueOf(value));
        }
    };
    private static final QueryMeta.Converter amountConverter = new QueryMeta.Converter(){

        public Object convert(Object value) {
            if (StringUtils.isBlank((Object)value)) {
                return null;
            }
            return Encrypters.encode((String)String.valueOf(value));
        }
    };
    private static final QueryMeta.Converter timestampConverter = new QueryMeta.Converter(){

        public Object convert(Object value) {
            if (StringUtils.isBlank((Object)value)) {
                return null;
            }
            return Encrypters.encode((String)String.valueOf(((Date)value).getTime()));
        }
    };

    public static QueryMeta.Converter getPrivacyConverter(IPrivacyProperty prop) {
        IPrivacyDataService service = prop.getPrivacyDataService();
        return new PrivacyConverter(service);
    }

    public static QueryMeta.Converter get(ISimpleProperty p) {
        if (12 == p.getDbType() || -9 == p.getDbType()) {
            return textConverter;
        }
        if (DataType.TimestampType == DataSetDataType.getDataType((Class)p.getPropertyType())) {
            return timestampConverter;
        }
        return amountConverter;
    }

    static class ClassHolder {
        private static Class<?> textPropCls;

        ClassHolder() {
        }

        static {
            try {
                textPropCls = Class.forName("kd.bos.entity.property.TextProp");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class PrivacyConverter
    implements QueryMeta.Converter {
        IPrivacyDataService service;

        public PrivacyConverter(IPrivacyDataService service) {
            this.service = service;
        }

        public Object convert(Object arg0) {
            return this.service.encode(arg0);
        }
    }
}

