/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import kd.bos.bundle.BosRes;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.crossdb.TenantAccountCrossDBRuntime;
import kd.bos.orm.query.multi.JoinTableTypeEnum;

public class JoinTableInfo {
    private final EntityItem entityItem;
    private String table;
    private String tableAlias;
    private String field;
    private ORMHint.JoinHint join;
    private final JoinTableTypeEnum joinTableType;
    private String joinTableAlias;
    private String joinField;
    private String andExpress;
    private QFilter joinFilter;
    private Object[] joinParameters;

    public JoinTableInfo copy() {
        JoinTableInfo copy = new JoinTableInfo(this.entityItem, this.joinTableType);
        copy.table = this.table;
        copy.tableAlias = this.tableAlias;
        copy.field = this.field;
        copy.join = this.join;
        copy.joinTableAlias = this.joinTableAlias;
        copy.joinField = this.joinField;
        copy.andExpress = this.andExpress;
        copy.joinFilter = this.joinFilter;
        copy.joinParameters = this.joinParameters;
        return copy;
    }

    public JoinTableInfo(EntityItem entityItem, JoinTableTypeEnum joinTableType) {
        this.entityItem = entityItem;
        this.joinTableType = joinTableType;
    }

    public String toJoinSql(String crossToRouteKey, boolean withCrossDBObjectOrFilter, QContext ctx) {
        return this.toJoinString(ctx.getSimpleEntityAlias(this.tableAlias), ctx.getSimpleEntityAlias(this.joinTableAlias), crossToRouteKey, withCrossDBObjectOrFilter, ctx);
    }

    private String toJoinString(String tableAlias, String joinTableAlias, String crossToRouteKey, boolean withCrossDBObjectOrFilter, QContext ctx) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("\r\n");
        sb.append(this.join.getJoin());
        sb.append(' ');
        if (crossToRouteKey == null) {
            sb.append(this.table);
        } else {
            sb.append(TenantAccountCrossDBRuntime.getCrossDBTable(this.entityItem == null ? null : this.entityItem.entityType.getDBRouteKey(), this.table, crossToRouteKey, withCrossDBObjectOrFilter));
        }
        sb.append(' ');
        sb.append(tableAlias);
        sb.append(" ON ");
        sb.append(tableAlias).append('.').append(this.field).append('=').append(joinTableAlias).append('.').append(this.joinField);
        if (this.andExpress != null) {
            sb.append(" AND ").append(this.andExpress);
        }
        if (this.joinFilter != null) {
            if (ctx != null) {
                QParameter qp = this.joinFilter.toQParameter(ctx);
                sb.append(" AND ").append(qp.getSql());
                this.joinParameters = qp.getParameters();
            } else {
                sb.append(" AND ").append(this.joinFilter);
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toJoinString(this.tableAlias, this.joinTableAlias, null, false, null);
    }

    public JoinTableTypeEnum getJoinTableType() {
        return this.joinTableType;
    }

    public EntityItem getEntityItem() {
        return this.entityItem;
    }

    public ORMHint.JoinHint getJoin() {
        return this.join;
    }

    public void setJoin(ORMHint.JoinHint join) {
        this.join = join;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        if (table == null || table.trim().length() == 0) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"JoinTableInfo_0", (String)"{0} table's name is empty.", (Object[])new Object[]{this.entityItem.entityType.getName()}));
        }
        this.table = table;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getJoinTableAlias() {
        return this.joinTableAlias;
    }

    public void setJoinTableAlias(String joinTableAlias) {
        this.joinTableAlias = joinTableAlias;
    }

    public String getJoinField() {
        return this.joinField;
    }

    public void setJoinField(String joinField) {
        this.joinField = joinField;
    }

    public String getAndExpress() {
        return this.andExpress;
    }

    public void setAndExpress(String andExpress) {
        this.andExpress = andExpress;
    }

    public QFilter getJoinFilters() {
        return this.joinFilter;
    }

    public void setJoinFilter(QFilter joinFilter) {
        this.joinFilter = joinFilter;
    }

    public Object[] getJoinParameters() {
        return this.joinParameters;
    }
}

