/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.impl.ORMOptimization;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ConfigurationUtil;

class MultiQueryParameter {
    private static final Log log = LogFactory.getLog((String)"ORM");
    private static boolean checkEmpty = false;
    private static boolean checkStar = false;
    private static boolean throwCheck = false;
    DBRoute dbRoute;
    IDataEntityType entityType;
    String selectFields;
    boolean shouldSelectPK;
    QFilter[] joinFilters;
    QFilter[] whereFilters;
    String groupBys;
    QFilter[] havings;
    String orderBys;
    int top;
    int start;
    int limit;
    Map<String, IDataEntityType> entityTypeCache;
    ORMHint ormHint;
    ORMOptimization optimization;
    Distinctable distinctable;

    MultiQueryParameter(DBRoute dbRoute, IDataEntityType entityType, String selectFields, boolean shouldSelectPK, QFilter[] filters, String groupBys, QFilter[] havings, String orderBys, int top, int start, int limit, Map<String, IDataEntityType> entityTypeCache, ORMHint ormHint, ORMOptimization optimization, Distinctable distinctable) {
        this.dbRoute = dbRoute;
        this.entityType = entityType;
        this.selectFields = selectFields;
        this.shouldSelectPK = shouldSelectPK;
        this.groupBys = groupBys;
        this.havings = havings;
        this.orderBys = orderBys;
        this.top = top;
        this.start = start;
        this.limit = limit;
        this.entityTypeCache = entityTypeCache;
        this.ormHint = ormHint;
        this.optimization = optimization;
        this.distinctable = distinctable;
        this.checkSelectFields();
        this.detachFilters(filters);
    }

    private void checkSelectFields() {
        if (checkEmpty) {
            if (this.selectFields == null || this.selectFields.trim().length() == 0) {
                this.checkSelectFieldsReport("ORM select fields can't be empty: SELECT FROM " + this.entityType.getName() + "...");
            }
        } else if (checkStar && this.selectFields != null && this.selectFields.indexOf(42) != -1) {
            this.checkSelectFieldsReport("ORM select fields can't contains *: SELECT " + this.selectFields + " FROM " + this.entityType.getName() + "...");
        }
    }

    private void checkSelectFieldsReport(String msg) {
        if (throwCheck) {
            throw new IllegalArgumentException(msg);
        }
        log.warn(msg);
    }

    private void detachFilters(QFilter[] filters) {
        if (filters != null && filters.length > 0) {
            ArrayList<QFilter> joinRecombies = new ArrayList<QFilter>();
            ArrayList<QFilter> whereRecombies = new ArrayList<QFilter>();
            int i = 0;
            QFilter[] newFilters = new QFilter[filters.length];
            for (QFilter filter : filters) {
                if (filter != null) {
                    newFilters[i] = filter.__copy(true);
                }
                ++i;
            }
            String rootName = this.entityType.getName();
            for (QFilter filter : newFilters) {
                if (filter == null) continue;
                String filterProperty = filter.getProperty();
                if (filterProperty.startsWith(rootName + ".")) {
                    filter.__setProperty(filterProperty.substring((rootName + ".").length()));
                }
                if (filter.isJoinFilter()) {
                    joinRecombies.add(filter.__copy(false));
                    filter.maskCurrent();
                }
                for (QFilter.QFilterNest next : filter.getNests(true)) {
                    if (next == null) continue;
                    String nestProperty = next.getFilter().getProperty();
                    if (nestProperty.startsWith(rootName + ".")) {
                        next.getFilter().__setProperty(nestProperty.substring((rootName + ".").length()));
                    }
                    if (!next.getFilter().isJoinFilter()) continue;
                    joinRecombies.add(next.getFilter().__copy(false));
                    next.getFilter().maskCurrent();
                }
            }
            for (QFilter filter : newFilters) {
                if (filter == null) continue;
                for (QFilter recombine : filter.recombine()) {
                    whereRecombies.add(recombine);
                    if (!recombine.isJoinFilter()) continue;
                    throw new RuntimeException("Where has join filter:" + recombine + "\n" + filter.toSerializedString());
                }
            }
            this.joinFilters = joinRecombies.toArray(new QFilter[joinRecombies.size()]);
            this.whereFilters = whereRecombies.toArray(new QFilter[whereRecombies.size()]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.entityType.getName() + "@" + this.dbRoute + ": ");
        sb.append("SELECT " + this.selectFields + ", ");
        sb.append("APPEND-PK " + this.shouldSelectPK);
        if (this.joinFilters != null) {
            sb.append(", JOIN-FILTERS " + Arrays.asList(this.joinFilters));
        }
        if (this.whereFilters != null) {
            sb.append(", WHERE-FILTERS " + Arrays.asList(this.whereFilters));
        }
        if (this.havings != null) {
            sb.append(", HAVINGS " + Arrays.asList(this.havings));
        }
        return sb.toString();
    }

    static {
        ConfigurationUtil.observeBoolean((String)"orm.selectfields.checkEmpty", (boolean)checkEmpty, v -> {
            checkEmpty = v;
        });
        ConfigurationUtil.observeBoolean((String)"orm.selectfields.checkStar", (boolean)checkStar, v -> {
            checkStar = v;
        });
        ConfigurationUtil.observeBoolean((String)"orm.selectfields.throwCheck", (boolean)throwCheck, v -> {
            throwCheck = v;
        });
    }
}

