/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.PropertySegExpress;
import kd.bos.orm.query.oql.g.expr.OrderBys;

public class OrderByInfo {
    private String fullObjectName;
    private String ordering;
    private PropertySegExpress propertySegExpress;

    static List<OrderByInfo> getOrderByList(String orderBys, String rootObjName) {
        if (orderBys == null || orderBys.trim().length() == 0) {
            return new ArrayList<OrderByInfo>();
        }
        return OrderBys.parseFrom(orderBys).createOrderInfos(rootObjName);
    }

    public OrderByInfo(String fullObjectName, PropertySegExpress propertySegExpress, String ordering) {
        this.fullObjectName = fullObjectName;
        this.propertySegExpress = propertySegExpress;
        this.ordering = ordering == null ? null : ordering.trim();
    }

    public String getFullObjectName() {
        return this.fullObjectName;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public PropertySegExpress getPropertySegExpress() {
        return this.propertySegExpress;
    }

    public void replaceWhenOneProperty(PropertyField pf) {
        this.fullObjectName = pf.getFullObjectName();
        this.propertySegExpress.replaceWhenOneProperty(pf);
    }

    public String toOrderByString(QContext ctx) {
        StringBuilder sb = new StringBuilder();
        int dot = this.fullObjectName.indexOf(46);
        String rootObjName = dot == -1 ? this.fullObjectName : this.fullObjectName.substring(0, dot);
        sb.append(this.propertySegExpress.toString(rootObjName, ctx));
        if (this.ordering != null && this.ordering.length() > 0) {
            sb.append(' ').append(this.ordering);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.propertySegExpress.toString());
        if (this.ordering != null && this.ordering.length() > 0) {
            sb.append(' ').append(this.ordering);
        }
        return sb.toString();
    }
}

