/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.EntityItemProperty;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.multi.PropertySegExpress;

public class PropertyField {
    public static final String as_null_field = "__NULL_FIELD";
    private String fullObjectName;
    private String name;
    private String field;
    private String alias;
    private PropertySegExpress propertySegExpress;
    private boolean multiLangProperty;
    private AtomicBoolean glField = null;
    private AtomicBoolean onlyGlLang;
    private String entityAlias;
    private IDataEntityType entityType;
    private IDataEntityProperty peropertyType;
    private EntityItemProperty propertyItem;
    private static Map<String, String> cachedEncryptData = new HashMap<String, String>(2);
    private static final int maxLength = Integer.getInteger("orm.field.alias.maxlength", 22);

    public PropertyField(String peropertyExpress) {
        peropertyExpress = peropertyExpress.trim();
        int blank = peropertyExpress.indexOf(32);
        if (blank == -1) {
            this.name = peropertyExpress;
        } else {
            this.name = peropertyExpress.substring(0, blank);
            this.alias = peropertyExpress.substring(blank + 1).trim();
            if (this.alias.toLowerCase(Locale.ENGLISH).startsWith("as ")) {
                this.alias = this.alias.substring(3).trim();
            }
        }
        int dot = this.name.lastIndexOf(46);
        if (dot != -1) {
            this.fullObjectName = this.name.substring(0, dot).toLowerCase();
            this.name = this.name.substring(dot + 1);
        }
        this.init();
    }

    public PropertyField(String fullObjectName, String name, String alias) {
        this.fullObjectName = fullObjectName == null ? null : fullObjectName.toLowerCase();
        this.name = name;
        this.alias = alias;
        this.init();
    }

    private void init() {
        if (this.fullObjectName == null) {
            this.fullObjectName = "";
        }
        if (this.alias == null || this.alias.length() == 0) {
            this.alias = this.name;
            if (this.fullObjectName.length() > 0) {
                this.alias = this.fullObjectName + '.' + this.alias;
            }
        }
    }

    public String getFullObjectName() {
        return this.fullObjectName;
    }

    public void setFullObjectName(String fullObjectName) {
        this.fullObjectName = fullObjectName == null ? null : fullObjectName.toLowerCase();
    }

    public String getFullName() {
        if (this.fullObjectName != null && this.fullObjectName.length() > 0) {
            return new StringBuilder(this.fullObjectName.length() + this.name.length() + 1).append(this.fullObjectName).append('.').append(this.name).toString();
        }
        return this.name;
    }

    public String getParentFullObjectName() {
        int dot;
        if (this.fullObjectName != null && this.fullObjectName.length() > 0 && (dot = this.fullObjectName.indexOf(46)) != -1) {
            return this.fullObjectName.substring(dot + 1);
        }
        return this.fullObjectName;
    }

    public boolean canIgnoreJoinMainTable() {
        if (this.multiLangProperty) {
            return !this.isGLField();
        }
        return false;
    }

    public String getParentFullName() {
        int dot;
        if (this.fullObjectName != null && this.fullObjectName.length() > 0 && (dot = this.fullObjectName.indexOf(46)) != -1) {
            return this.fullObjectName.substring(dot + 1) + '.' + this.name;
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setField(String field) {
        if (field == null || field.length() == 0) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"PropertyField_0", (String)"{0}The field must be not null.", (Object[])new Object[]{this.name}));
        }
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public void setEntityAlias(String entityAlias) {
        this.entityAlias = entityAlias;
    }

    public IDataEntityProperty getPeropertyType() {
        return this.peropertyType;
    }

    public void setPeropertyType(IDataEntityProperty peropertyType) {
        this.peropertyType = peropertyType;
    }

    public IDataEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(IDataEntityType entityType) {
        this.entityType = entityType;
    }

    public boolean isSameWith(PropertyField sf) {
        return sf.name.equalsIgnoreCase(this.name) && sf.fullObjectName.equalsIgnoreCase(this.fullObjectName);
    }

    public String toSingleTableSelectField(boolean alias, Function<String, PropertyField> propertyTrans) {
        if (this.isExpress()) {
            if (alias) {
                return this.propertySegExpress.toSingleTableString(alias, propertyTrans) + ' ' + '\"' + this.alias + '\"';
            }
            return this.propertySegExpress.toSingleTableString(alias, propertyTrans);
        }
        PropertyField pf = propertyTrans.apply(this.name);
        if (alias) {
            return pf.field + ' ' + '\"' + this.alias + '\"';
        }
        return pf.field;
    }

    public String toSelectField(boolean withAlias, QContext ctx) {
        return this.toSelectField(withAlias, ctx, false);
    }

    public String toSelectField(boolean withAlias, boolean newWhenSame, QContext ctx) {
        return this.toSelectField0(withAlias, ctx, false, newWhenSame);
    }

    public String toSelectField(boolean withAlias, QContext ctx, boolean ignoreGL) {
        return this.toSelectField0(withAlias, ctx, ignoreGL, false);
    }

    private String toSelectField0(boolean withAlias, QContext ctx, boolean ignoreGL, boolean newWhenSame) {
        if (as_null_field.equals(this.field)) {
            if (withAlias) {
                return "NULL " + this.genShortAlias(this.name, newWhenSame);
            }
            return "NULL";
        }
        StringBuilder selectField = new StringBuilder(64);
        if (this.isExpress()) {
            int dot = this.fullObjectName.indexOf(46);
            String rootObjName = dot == -1 ? this.fullObjectName : this.fullObjectName.substring(0, dot);
            selectField.append(this.propertySegExpress.toString(rootObjName, ctx, ignoreGL));
        } else {
            selectField.append(ctx.getSimpleEntityAlias(this.entityAlias)).append('.').append(this.field);
            if (this.peropertyType instanceof ISimpleProperty && ((ISimpleProperty)this.peropertyType).getPrivacyType() != 0L) {
                selectField.append("_pr");
            } else if (this.peropertyType instanceof ISimpleProperty && ((ISimpleProperty)this.peropertyType).isEncrypt()) {
                selectField.append("_enp");
            }
        }
        if (this.multiLangProperty && !ignoreGL && this.isGLField()) {
            String parentEntityAlias = this.fullObjectName;
            String glField = ctx.getSimpleEntityAlias(parentEntityAlias) + '.' + this.peropertyType.getAlias();
            StringBuilder tempSb = new StringBuilder(128);
            boolean _isSimpleProp = this.peropertyType instanceof ISimpleProperty;
            if (_isSimpleProp && ((ISimpleProperty)this.peropertyType).isEncrypt()) {
                glField = glField + "_enp";
                if (this.useGlLang()) {
                    tempSb.append(glField);
                } else {
                    tempSb.append("CASE WHEN ").append((CharSequence)selectField).append(" IS NULL THEN ").append(glField).append(" WHEN ").append("TO_CHAR(").append((CharSequence)selectField).append(")").append(" = '").append(this.getEncryptedData("")).append("' THEN ").append(glField).append(" WHEN ").append("TO_CHAR(").append((CharSequence)selectField).append(")").append(" = '").append(this.getEncryptedData(" ")).append("' THEN ").append(glField).append(" ELSE ").append((CharSequence)selectField).append(" END");
                }
            } else if (_isSimpleProp && ((ISimpleProperty)this.peropertyType).getPrivacyType() != 0L) {
                glField = glField + "_pr";
                if (this.useGlLang()) {
                    tempSb.append(glField);
                } else {
                    tempSb.append("CASE WHEN ").append((CharSequence)selectField).append(" IS NULL THEN ").append(glField).append(" ELSE ").append((CharSequence)selectField).append(" END");
                }
            } else if (ORMConfiguration.useSingleLang() || this.useGlLang()) {
                tempSb.append(glField);
            } else {
                tempSb.append("CASE WHEN ").append((CharSequence)selectField).append(" IS NULL THEN ").append(glField).append(" WHEN ").append((CharSequence)selectField).append(" = '' THEN ").append(glField).append(" WHEN ").append((CharSequence)selectField).append(" = ' ' THEN ").append(glField).append(" ELSE ").append((CharSequence)selectField).append(" END");
            }
            selectField = tempSb;
        }
        if (withAlias) {
            selectField.append(this.genShortAlias(selectField.toString(), newWhenSame));
        }
        return selectField.toString();
    }

    public boolean isGLField() {
        ISimpleProperty mainProperty;
        if (this.glField != null) {
            return this.glField.get();
        }
        this.glField = new AtomicBoolean();
        IDataEntityType mainDT = this.peropertyType.getParent().getParent();
        if (mainDT != null && (mainProperty = (ISimpleProperty)mainDT.getProperties().get((Object)this.name)) != null && !mainProperty.isDbIgnore() && !this.peropertyType.isDbIgnore()) {
            this.glField.set(true);
            return true;
        }
        return false;
    }

    public boolean useGlLang() {
        if (this.onlyGlLang != null) {
            return this.onlyGlLang.get();
        }
        if (this.peropertyType == null || this.name == null) {
            return false;
        }
        this.onlyGlLang = new AtomicBoolean(false);
        if (this.peropertyType instanceof ILocaleProperty) {
            this.onlyGlLang.set(((ILocaleProperty)this.peropertyType).useGlangText());
        } else {
            ISimpleProperty mainProperty;
            if (this.peropertyType.getParent() == null) {
                return this.onlyGlLang.get();
            }
            IDataEntityType mainDT = this.peropertyType.getParent().getParent();
            if (mainDT != null && (mainProperty = (ISimpleProperty)mainDT.getProperties().get((Object)this.name)) instanceof ILocaleProperty) {
                this.onlyGlLang.set(((ILocaleProperty)mainProperty).useGlangText());
            }
        }
        return this.onlyGlLang.get();
    }

    private String getEncryptedData(String str) {
        if (cachedEncryptData.containsKey(str)) {
            return cachedEncryptData.get(str);
        }
        String v = EncrypterFactory.getEncrypter().encode(str);
        cachedEncryptData.put(str, v);
        return v;
    }

    public String genShortAlias(String selectField, boolean newWhenSame) {
        if (this.alias.length() <= maxLength) {
            return " \"" + this.alias + '\"';
        }
        if (selectField.length() < maxLength && !newWhenSame) {
            return " \"" + selectField + '\"';
        }
        int h = selectField.hashCode();
        if (h == Integer.MIN_VALUE) {
            h = 0;
        } else if (h < 0) {
            h = -h;
        }
        return " \"_F_" + h + '\"';
    }

    public boolean isMultiLangProperty() {
        return this.multiLangProperty;
    }

    public void setMultiLangProperty(boolean multiLangProperty) {
        this.multiLangProperty = multiLangProperty;
    }

    public EntityItemProperty getPropertyItem() {
        return this.propertyItem;
    }

    public void setPropertyItem(EntityItemProperty propertyItem) {
        this.propertyItem = propertyItem;
    }

    public boolean isInnerField() {
        return this.alias != null && this.alias.startsWith("INNER_");
    }

    public boolean isExpress() {
        return this.propertySegExpress != null && this.propertySegExpress.isExpress();
    }

    public PropertySegExpress getPropertySegExpress() {
        return this.propertySegExpress;
    }

    public void setPropertySegExpress(PropertySegExpress propertySegExpress) {
        this.propertySegExpress = propertySegExpress;
    }

    public String getOriginalPropertyString() {
        StringBuilder s = new StringBuilder(128);
        if (this.isExpress()) {
            s.append(this.propertySegExpress);
        } else {
            if (this.fullObjectName != null && this.fullObjectName.length() > 0) {
                s.append(this.fullObjectName).append('.');
            }
            s.append(this.name);
        }
        return s.toString();
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getOriginalPropertyString());
        if (this.alias != null) {
            s.append(' ').append('\"').append(this.alias).append('\"');
        }
        return s.toString();
    }
}

