/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.sql.tree.Literal;
import kd.bos.bundle.BosRes;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.multi.PropertyField;

public class PropertySegExpress {
    private List<Seg> segs = new ArrayList<Seg>(50);
    private int s_len = 0;
    private int p_len = 0;
    private Map<String, PropertyField> fieldMap = new HashMap<String, PropertyField>();
    private Literal literal;

    public void setLiteral(Literal l) {
        this.literal = l;
    }

    public Literal getLiteral() {
        return this.literal;
    }

    public PropertySegExpress appendString(String s) {
        this.s_len += s.length();
        this.segs.add(new Seg(s, false));
        return this;
    }

    public PropertySegExpress appendProperty(String fullPropertyName) {
        this.p_len += fullPropertyName.length();
        this.segs.add(new Seg(fullPropertyName, true));
        return this;
    }

    public List<String> getFullPropertyNames() {
        HashMap<String, String> map = new HashMap<String, String>(this.p_len);
        for (Seg seg : this.segs) {
            if (!seg.isProperty) continue;
            map.put(seg.value.toLowerCase(), seg.value);
        }
        return new ArrayList<String>(map.values());
    }

    public List<String> getFullStringNames() {
        ArrayList<String> list = new ArrayList<String>(10);
        for (Seg seg : this.segs) {
            if (seg.isProperty) continue;
            list.add(seg.value);
        }
        return list;
    }

    public void putFieldMap(String fullObjPropertyName, PropertyField pf) {
        this.fieldMap.put(fullObjPropertyName.toLowerCase(), pf);
    }

    public PropertyField getFieldMap(String fullObjPropertyName) {
        return this.fieldMap.get(fullObjPropertyName.toLowerCase());
    }

    public Collection<PropertyField> getPropertyFields() {
        return this.fieldMap.values();
    }

    public PropertyField getPropertyField() {
        if (!this.isProperty()) {
            throw new IllegalStateException(BosRes.get((String)"bos-ormengine", (String)"PropertySegExpress_0", (String)"Expr is error.", (Object[])new Object[0]));
        }
        return this.fieldMap.values().iterator().next();
    }

    public void replaceWhenOneProperty(PropertyField pf) {
        this.fieldMap.clear();
        String fullObjPropertyName = pf.getFullName();
        String fullPropertyName = pf.getParentFullName();
        this.putFieldMap(fullObjPropertyName, pf);
        for (Seg seg : this.segs) {
            if (!seg.isProperty) continue;
            seg.value = fullPropertyName;
        }
    }

    public boolean isEmpty() {
        return this.segs.isEmpty();
    }

    public boolean isProperty() {
        return !this.isExpress();
    }

    public boolean isExpress() {
        int size = this.segs.size();
        if (size == 0) {
            return true;
        }
        if (size == 1) {
            return !this.segs.get((int)0).isProperty;
        }
        return true;
    }

    public String toSingleTableString(boolean alias, Function<String, PropertyField> propertyTrans) {
        StringBuilder s = new StringBuilder(this.s_len + this.p_len);
        for (Seg seg : this.segs) {
            if (seg.isProperty) {
                String fullPropertyName = seg.value;
                PropertyField pf = propertyTrans.apply(fullPropertyName);
                if (pf == null) {
                    throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"PropertySegExpress_1", (String)"The expr is error,only can choose one object's property:{0}", (Object[])new Object[]{this.toString()}));
                }
                s.append(pf.toSingleTableSelectField(false, propertyTrans));
                continue;
            }
            s.append(seg.value);
        }
        return s.toString();
    }

    public String toString(String rootObjName, QContext ctx) {
        return this.toString(rootObjName, ctx, false);
    }

    public String toString(String rootObjName, QContext ctx, boolean ignoreGL) {
        StringBuilder s = new StringBuilder(this.s_len + this.p_len);
        for (Seg seg : this.segs) {
            if (seg.isProperty) {
                String fullPropertyName = rootObjName + "." + seg.value;
                PropertyField pf = this.fieldMap.get(fullPropertyName.toLowerCase());
                if (pf == null) {
                    throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"PropertySegExpress_1", (String)"The expr is error,only can choose one object's property:{0}", (Object[])new Object[]{this.toString()}));
                }
                s.append(pf.toSelectField(false, ctx, ignoreGL));
                continue;
            }
            s.append(seg.value);
        }
        return s.toString();
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.s_len + this.p_len);
        for (Seg seg : this.segs) {
            s.append(seg.value);
        }
        return s.toString();
    }

    private static class Seg {
        boolean isProperty;
        String value;

        Seg(String value, boolean isProperty) {
            this.value = value;
            this.isProperty = isProperty;
        }

        public String toString() {
            return this.value;
        }
    }
}

