/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.function.Function;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.privacy.IPrivacyProperty;
import kd.bos.db.QueryMeta;
import kd.bos.exception.BosErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.FieldEncrypt;

public class QFilterPrivacyPropTransFunction
implements Function<QFilter, QFilter> {
    private String rootObjName;
    private QContext ctx;
    private Log logger = LogFactory.getLog(QFilterPrivacyPropTransFunction.class);

    public QFilterPrivacyPropTransFunction(String rootObjName, QContext ctx) {
        this.ctx = ctx;
        this.rootObjName = rootObjName;
    }

    @Override
    public QFilter apply(QFilter filter) {
        if (!filter.isExpressValue() && filter.getCP().equals("=")) {
            IDataEntityProperty dp;
            String obj;
            String p = filter.getProperty();
            int dot = p.lastIndexOf(46);
            if (dot == -1) {
                obj = this.rootObjName;
            } else {
                obj = this.rootObjName + '.' + p.substring(0, dot);
                p = p.substring(dot + 1);
            }
            EntityItem ei = null;
            try {
                ei = this.ctx.getEntityItem(obj);
            }
            catch (Exception e) {
                this.logger.error(obj + ", QFilterPrivacyPropTransFunction.apply getEntityItem occur an error: " + e.getMessage());
            }
            if (ei != null && (dp = (IDataEntityProperty)ei.entityType.getProperties().get((Object)p)) instanceof IPrivacyProperty) {
                if (!("=".equals(filter.getCP()) || "!=".equals(filter.getCP()) || "<>".equals(filter.getCP()))) {
                    throw new ORMArgInvalidException(BosErrorCode.filterSqlBuilder.getMessage(), BosRes.get((String)"bos-ormengine", (String)"QFilterPrivacyPropTransFunction_0", (String)"Privacy type fields only support exact matches.", (Object[])new Object[0]));
                }
                filter.__setProperty("to_char(" + p + ")");
                QueryMeta.Converter cc = FieldEncrypt.getPrivacyConverter((IPrivacyProperty)dp);
                Object value = cc.convert(filter.getValue());
                filter.__setValue(value);
            }
        }
        return filter;
    }
}

