/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ext.IQFilterValueConverterExt;
import kd.bos.dataentity.ext.QFilterValueConverterExtProxyImpl;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.orm.query.QFilterValue;
import kd.bos.orm.query.fulltext.QMatches;

public class QFilterValueConverterFunction
implements Function<QFilter, QFilter> {
    private String rootName;
    private QContext ctx;
    private IQFilterValueConverterExt converter;

    public QFilterValueConverterFunction(String rootName, QContext ctx) {
        this.rootName = rootName;
        this.ctx = ctx;
        if (ORMConfig.QFILTER_CONVERT.getBoolean(RequestContext.get().getTenantId())) {
            this.converter = new QFilterValueConverterExtProxyImpl();
        }
    }

    @Override
    public QFilter apply(QFilter filter) {
        Object convertValue;
        boolean isFtLike;
        if (!ORMConfig.QFILTER_CONVERT.getBoolean(RequestContext.get().getTenantId())) {
            return filter;
        }
        if (this.converter == null) {
            this.converter = new QFilterValueConverterExtProxyImpl();
        }
        String property = filter.getProperty();
        Object value = filter.getOriginValue();
        String cp = filter.getCP().toLowerCase(Locale.ENGLISH);
        boolean bl = isFtLike = "ftlike".equals(cp) || "match".equals(cp);
        if (this.ignoreConvert(filter)) {
            return filter;
        }
        if (isFtLike) {
            if ("1".equals(property) || "2".equals(property)) {
                QFilter newQFilter = this.convertFtlikeFilter(filter, property, (String)value);
                this.convertFtlikeValue(newQFilter);
                this.resetFtlikeQFilter(filter, newQFilter);
                return filter;
            }
        } else if (value instanceof MultiBaseDataFilterValue) {
            MultiBaseDataFilterValue multiTypeValue = (MultiBaseDataFilterValue)value;
            value = multiTypeValue.getValue();
        }
        Object newValue = convertValue = this.converter.convert(this.ctx.getEntityItem((String)this.rootName).entityType, property, value, filter.getCP());
        if (filter.getOriginValue() instanceof MultiBaseDataFilterValue) {
            MultiBaseDataFilterValue multiTypeValue = (MultiBaseDataFilterValue)filter.getOriginValue();
            multiTypeValue.setValue(convertValue);
            newValue = multiTypeValue;
        }
        filter.__setValue(newValue);
        return filter;
    }

    private boolean ignoreConvert(QFilter filter) {
        Object value = filter.getOriginValue();
        String cp = filter.getCP().trim().toLowerCase(Locale.ENGLISH);
        return value instanceof QEmptyValue || value instanceof QFilterValue || filter.isJoinFilter() || filter.isJoinSQLFilter() || "is not null".equals(cp) || "is null".equals(cp) || "exists".equals(cp) || "not exists".equals(cp);
    }

    private QFilter convertFtlikeFilter(QFilter filter, String filterProperty, String filterValue) {
        boolean isMultiValue = "2".equals(filterProperty);
        boolean isLeftMatch = ORMUtil.isFtlikeStartWith(filter.getQFilterHint());
        QMatches.Match match = QMatches.__decode(filterValue);
        String[] properties = match.getProperties();
        String[] values = match.getValues();
        if (properties == null || properties.length == 0) {
            return filter;
        }
        QFilter ret = null;
        for (String property : properties) {
            for (String value : values) {
                QFilter f = null;
                if (isMultiValue) {
                    String[] andVS;
                    for (String v : andVS = QMatches.splitMultiValue(value)) {
                        QFilter ff = new QFilter(property, "ftlike", (Object)v, isLeftMatch ? QFilterHint.FTLIKE_STARTWITH : QFilterHint.FTLIKE_CONTAINS);
                        f = f == null ? ff : f.and(ff);
                    }
                    ret = ret == null ? f : ret.or(f);
                    continue;
                }
                f = new QFilter(property, "ftlike", (Object)value, isLeftMatch ? QFilterHint.FTLIKE_STARTWITH : QFilterHint.FTLIKE_CONTAINS);
                ret = ret == null ? f : ret.or(f);
            }
        }
        return ret;
    }

    private void convertFtlikeValue(QFilter filter) {
        String property = filter.getProperty();
        String value = (String)filter.getOriginValue();
        Object convertValue = this.converter.convert(this.ctx.getEntityItem((String)this.rootName).entityType, property, (Object)value, filter.getCP());
        filter.__setValue(convertValue);
        List<QFilter.QFilterNest> nests = filter.getNests(true);
        if (nests != null && nests.size() > 0) {
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = nest.getFilter();
                property = nestFilter.getProperty();
                value = (String)nestFilter.getOriginValue();
                convertValue = this.converter.convert(this.ctx.getEntityItem((String)this.rootName).entityType, property, (Object)value, nestFilter.getCP());
                nestFilter.__setValue(convertValue);
            }
        }
    }

    private void resetFtlikeQFilter(QFilter origionFilter, QFilter newFilter) {
        origionFilter.maskCurrent();
        origionFilter.__setProperty(newFilter.getProperty());
        origionFilter.__setCP(newFilter.getCP());
        origionFilter.__setValue(newFilter.getOriginValue());
        origionFilter.setQFilterHint(newFilter.getQFilterHint());
        List<QFilter.QFilterNest> nests = newFilter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            if (nest.isAnd()) {
                origionFilter.and(nest.getFilter());
                continue;
            }
            origionFilter.or(nest.getFilter());
        }
    }
}

