/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IJoinProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.db.datasource.DBConfig;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.crossdb.TenantAccountCrossDBRuntime;
import kd.bos.orm.query.multi.OrderByInfo;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.JoinDBTodo;
import kd.bos.orm.query.optimize.PrepareJoinDB;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.query.oql.g.expr.SelectFields;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class QueryUtils {
    public static SingleQuery rebuildQuery(String algoKey, SingleQuery query) {
        if (query != null && !CollectionUtils.isEmpty(query.getSubQueryNodes())) {
            List<QueryTreeNode> subQueryNodes = query.getSubQueryNodes();
            for (QueryTreeNode node : subQueryNodes) {
                SingleQuery childQuery = node.getQuery();
                DataSet result = childQuery.query(algoKey, true);
                HashSet<Object> pkValueSet = new HashSet<Object>(16);
                while (result.hasNext()) {
                    pkValueSet.add(result.next().get(0));
                }
                String downFullName = QueryUtils.getUpFullName(childQuery, query);
                int dot = downFullName.indexOf(46);
                if (dot != -1) {
                    downFullName = downFullName.substring(dot + 1);
                }
                QFilter addFilter = QueryUtils.generateRoleUpCP(query, childQuery, downFullName, pkValueSet);
                QFilter filter = query.getWhereFilter();
                filter = filter == null ? addFilter : QueryUtils.generateRoleUpQFilter(filter, addFilter);
                query = query.optResetFilter(filter);
            }
            subQueryNodes.clear();
        }
        return query;
    }

    public static void rebuildRecursion(String algoKey, QueryTreeNode node) {
        QueryUtils.rebuildQuery(algoKey, node.getQuery());
        List<QueryTreeNode> children = node.getChildren();
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (QueryTreeNode childNode : children) {
            QueryUtils.rebuildRecursion(algoKey, childNode);
        }
    }

    public static String getUpFullName(SingleQuery childrenQuery, SingleQuery parentQuery) {
        String childFullObjName = childrenQuery.getFullObjName();
        QFilter existsQFilter = childrenQuery.getExistsQFilter();
        if (childrenQuery.isExistsSubquery() && existsQFilter != null) {
            String cp = existsQFilter.getCP().toLowerCase(Locale.ENGLISH);
            if ("exists".equals(cp) || "not exists".equals(cp)) {
                return parentQuery.getAllCtx().getMainEntityItem().getFullObjectName() + "." + existsQFilter.getProperty();
            }
            List<QFilter.QFilterNest> nests = existsQFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                String nestCp = nest.getFilter().getCP();
                if (!nestCp.equalsIgnoreCase("not exists") && !nestCp.equalsIgnoreCase("exists")) continue;
                return parentQuery.getAllCtx().getMainEntityItem().getFullObjectName() + "." + nest.getFilter().getProperty();
            }
            return parentQuery.getAllCtx().getMainEntityItem().getFullObjectName() + "." + childrenQuery.getExistsQFilter().getProperty();
        }
        QFilter childFilter = childrenQuery.getGenQueryParameterWhereQFilter();
        if (childFilter != null) {
            QFilter multiTypeQFilter;
            Object value = childFilter.getValue();
            if (value instanceof MultiBaseDataFilterValue) {
                MultiBaseDataFilterValue multi = (MultiBaseDataFilterValue)value;
                String joinProperty = multi.getJoinProperty();
                return parentQuery.getAllCtx().getMainEntityItem().getFullObjectName() + "." + joinProperty;
            }
            if ("1".equalsIgnoreCase(childFilter.getProperty()) && "=".equalsIgnoreCase(childFilter.getCP()) && (Integer)value == 1 && (multiTypeQFilter = childrenQuery.getMultiTypeQFilter()) != null && (value = multiTypeQFilter.getValue()) instanceof MultiBaseDataFilterValue) {
                MultiBaseDataFilterValue multi = (MultiBaseDataFilterValue)value;
                String joinProperty = multi.getJoinProperty();
                return parentQuery.getAllCtx().getMainEntityItem().getFullObjectName() + "." + joinProperty;
            }
        }
        return childFullObjName;
    }

    public static String getDownFullName(QFilter childQFilter, String childQueryFullObjectName, String pkName, boolean isMulTypBaseData) {
        Object value;
        if (childQFilter != null && (value = childQFilter.getValue()) instanceof MultiBaseDataFilterValue) {
            MultiBaseDataFilterValue multi = (MultiBaseDataFilterValue)value;
            return multi.getBaseDataName() + "." + pkName;
        }
        String downFullName = childQueryFullObjectName;
        int dot = downFullName.indexOf(46);
        downFullName = dot == -1 ? (isMulTypBaseData ? downFullName + "." + pkName : pkName) : downFullName.substring(dot + 1) + '.' + pkName;
        return downFullName;
    }

    public static QFilter generateRoleUpCP(SingleQuery parentQuery, SingleQuery childrenQuery, String downFullName, Set<Object> pkValueSet) {
        String cp = "in";
        String newCp = null;
        QFilter filter = parentQuery.getGenQueryParameterWhereQFilter();
        if (childrenQuery.isExistsSubquery() && filter != null) {
            if ("exists".equals(filter.getCP()) || "not exists".equals(filter.getCP())) {
                newCp = filter.getCP().toLowerCase();
            } else {
                List<QFilter.QFilterNest> nests = filter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    QFilter nestFilter = nest.getFilter();
                    if (nestFilter == null || !nestFilter.getCP().equalsIgnoreCase("not exists") && !nestFilter.getCP().equalsIgnoreCase("exists")) continue;
                    newCp = nest.getFilter().getCP();
                    break;
                }
            }
            if (newCp == null && childrenQuery.getExistsQFilter() != null) {
                newCp = childrenQuery.getExistsQFilter().getCP();
            }
        }
        if (childrenQuery.isExistsSubquery()) {
            if (newCp != null && newCp.equalsIgnoreCase("not exists")) {
                cp = "not in";
            }
            QFilter returnFilter = new QFilter(downFullName, cp, pkValueSet);
            returnFilter.setExistsFilter(true);
            if (newCp != null && newCp.equalsIgnoreCase("not exists") && pkValueSet != null && pkValueSet.isEmpty()) {
                QFilter zeroQFilter = QueryUtils.getQEmptyValueSql(downFullName, parentQuery.getAllCtx());
                returnFilter.or(zeroQFilter);
            }
            return returnFilter;
        }
        return new QFilter(downFullName, cp, pkValueSet);
    }

    public static QFilter generateRoleUpQFilter(QFilter oldFilter, QFilter inFilter) {
        if (inFilter.isExistsFilter()) {
            String cp = oldFilter.getCP();
            String filterProperty = oldFilter.getProperty();
            if (("exists".equals(cp) || "not exists".equals(cp)) && filterProperty.equals(inFilter.getProperty())) {
                oldFilter.maskCurrent();
                oldFilter.__setProperty(inFilter.getProperty());
                oldFilter.__setCP(inFilter.getCP());
                oldFilter.__setValue(inFilter.getValue());
                List<QFilter.QFilterNest> nests = inFilter.getNests(false);
                if (!CollectionUtils.isEmpty(nests)) {
                    oldFilter.addFirstNest(nests.get(0).getFilter(), "OR");
                }
            } else {
                List<QFilter.QFilterNest> nests = oldFilter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    QFilter nestFilter = nest.getFilter();
                    cp = nestFilter.getCP();
                    filterProperty = nestFilter.getProperty();
                    if (!"exists".equals(cp) && !"not exists".equals(cp) || !filterProperty.equals(inFilter.getProperty())) continue;
                    nestFilter.maskCurrent();
                    nestFilter.__setProperty(inFilter.getProperty());
                    nestFilter.__setCP(inFilter.getCP());
                    nestFilter.__setValue(inFilter.getValue());
                    List<QFilter.QFilterNest> nests1 = inFilter.getNests(false);
                    if (CollectionUtils.isEmpty(nests1)) continue;
                    nestFilter.addFirstNest(nests1.get(0).getFilter(), "OR");
                }
            }
            return oldFilter;
        }
        return oldFilter.and(inFilter);
    }

    public static boolean isNumber(IDataEntityProperty propertyType) {
        Class typeClass = null;
        if (propertyType instanceof DynamicComplexProperty) {
            DynamicComplexProperty basedataProp = (DynamicComplexProperty)propertyType;
            IDataEntityType complexType = basedataProp.getComplexType();
            ISimpleProperty primaryKey = complexType.getPrimaryKey();
            typeClass = primaryKey.getPropertyType();
        } else {
            typeClass = propertyType instanceof DynamicSimpleProperty ? propertyType.getPropertyType() : String.class;
        }
        return QFilterUtil.isNumber(typeClass);
    }

    public static QFilter getQEmptyValueSql(String downFullName, QContext ctx) {
        int index = downFullName.lastIndexOf(".");
        IDataEntityProperty type = index > -1 ? ctx.getEntityItem(ctx.getMainEntityItem().getFullObjectName() + "." + downFullName.substring(0, index)).getPropertyItem(downFullName.substring(index + 1)).getPropertyType() : ctx.getMainEntityItem().getPropertyItem(downFullName).getPropertyType();
        QFilter filter = new QFilter(downFullName, "is null", null);
        Class cls = type instanceof IJoinProperty ? ((IJoinProperty)type).getJoinProperty().getPropertyType() : (type instanceof IComplexProperty ? ((IComplexProperty)type).getComplexType().getPrimaryKey().getPropertyType() : (type.getParent().getPrimaryKey() == type ? type.getPropertyType() : type.getPropertyType()));
        if (cls == Integer.TYPE || cls == Integer.class || cls == Byte.TYPE || cls == Byte.class || cls == Short.TYPE || cls == Short.class || cls == Long.TYPE || cls == Long.class) {
            filter.or(new QFilter(downFullName, "=", 0));
        } else if (cls != java.util.Date.class && cls != Timestamp.class && cls != Date.class) {
            if (cls == BigDecimal.class || cls == Number.class || cls == Double.TYPE || cls == Double.class) {
                filter.or(new QFilter(downFullName, "=", 0.0));
            } else {
                filter.or(new QFilter(downFullName, "=", "")).or(new QFilter(downFullName, "=", " "));
            }
        }
        return filter;
    }

    public static String replayceTalbAilas(Map<String, String> parentAliasMap, SingleQuery subQuery) {
        SingleQuery.QueryParameter subQueryParameter = subQuery.getQueryParameter();
        String sql = subQueryParameter.getSql();
        Set<String> subTables = subQuery.getTables(true, true, true, true);
        String newSql = sql.toUpperCase();
        for (String table : subTables) {
            String entityName = subQuery.getTableToEntity().get(table.toLowerCase());
            if (StringUtils.isEmpty(entityName)) continue;
            String alias = subQuery.getCtx().getSimpleEntityAliasMap().get(entityName).toUpperCase();
            String entityAlias = alias + alias;
            if (!parentAliasMap.containsValue(alias)) continue;
            sql = sql.replace(alias + ".", entityAlias + ".");
            newSql = sql.toUpperCase();
            table = table.toUpperCase();
            int talbeIndex = newSql.indexOf(" " + table + " ");
            if (talbeIndex <= 0) continue;
            sql = sql.substring(0, talbeIndex) + " " + table + " " + entityAlias + " " + sql.substring(talbeIndex + table.length() + 3);
            newSql = sql.toUpperCase();
        }
        SingleQuery.QueryParameter queryParameter = subQuery.getQueryParameter();
        Object[] params = queryParameter.getParams();
        queryParameter.sql = sql = sql.replaceFirst("\\?", (String)params[0]);
        Object[] newparams = new Object[params.length - 1];
        System.arraycopy(params, 1, newparams, 0, params.length - 1);
        queryParameter.params = newparams;
        return sql;
    }

    public static IDataEntityProperty getPropertyType(PropertyField field, QFilter filter, QContext allContext, String rootName, String fullObjectName) {
        IDataEntityProperty propertyType = null;
        if (field != null && field.getPeropertyType() != null) {
            propertyType = field.getPeropertyType();
        } else {
            field = SelectFields.parseFrom(filter.getProperty()).createPropertyFields(rootName).get(0);
            propertyType = field.getPeropertyType();
            if (propertyType == null) {
                EntityItem entityItem = allContext.getEntityItem(fullObjectName);
                if (entityItem == null) {
                    throw new IllegalArgumentException("the property '" + filter.getProperty() + "' corresponding entity '" + fullObjectName + "' not exists");
                }
                String propertyName = "";
                if (field.isExpress() || filter.isExpressValue()) {
                    List<String> fullPropertyNames = field.getPropertySegExpress().getFullPropertyNames();
                    if (CollectionUtils.isEmpty(fullPropertyNames)) {
                        return propertyType;
                    }
                    propertyName = fullPropertyNames.get(0);
                } else {
                    propertyName = filter.getProperty();
                }
                int index = propertyName.lastIndexOf(".");
                propertyType = index == -1 ? entityItem.getPropertyItem(propertyName).getPropertyType() : entityItem.getPropertyItem(propertyName.substring(index + 1)).getPropertyType();
            }
        }
        return propertyType;
    }

    public static boolean containsExists(QFilter filter) {
        if (filter == null) {
            return false;
        }
        String cp = filter.getCP().trim().toLowerCase(Locale.ENGLISH);
        if ("not exists".equals(cp) || "exists".equals(cp)) {
            return true;
        }
        List<QFilter.QFilterNest> nests = filter.getNests(true);
        if (CollectionUtils.isEmpty(nests)) {
            return false;
        }
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFilter = nest.getFilter();
            if (nestFilter == null || !"not exists".equals(cp = nestFilter.getCP().trim().toLowerCase(Locale.ENGLISH)) && !"exists".equals(cp)) continue;
            return true;
        }
        return false;
    }

    @SdkInternal
    public static void joinInSameDatabase(QueryTreeNode root) {
        if (root.isLeaf()) {
            return;
        }
        List<QueryTreeNode> children = root.getChildren();
        int n = children.size();
        for (int i = 0; i < n; ++i) {
            QueryTreeNode child = children.get(i);
            QueryUtils.joinInSameDatabase(child);
            SingleQuery parentQuery = root.getQuery();
            SingleQuery query = child.getQuery();
            JoinDBTodo.test();
            List<DBConfig> parentSharing = PrepareJoinDB.getParentSharings(parentQuery, query);
            if (parentSharing.isEmpty()) {
                String crossDBTable;
                String crossToRouteKey = parentQuery.getDBRoute().getRouteKey();
                String table = query.getDataEntityType().getAlias().toLowerCase();
                if (!table.equals(crossDBTable = TenantAccountCrossDBRuntime.getCrossDBTable(query.getDataEntityType().getDBRouteKey(), table, crossToRouteKey, query.withCrossDBObjectOrFilter() || parentQuery.withCrossDBObjectOrFilter()))) {
                    parentSharing.addAll(parentQuery.getDBConfigSet());
                }
            }
            if (parentSharing.isEmpty()) continue;
            child.removeFromParent();
            root.setQuery(parentQuery.optMerge(query));
            parentQuery.setDBConfigSet(new HashSet<DBConfig>(parentSharing));
            --i;
            --n;
            List<QueryTreeNode> addChildren = child.getChildren();
            if (addChildren.size() <= 0) continue;
            for (QueryTreeNode subNode : addChildren) {
                subNode.addToParent(root);
            }
            n += addChildren.size();
        }
    }

    public static void tryMergeQuery(QueryTreeNode root, QContext ctx, boolean isReduceUnnessesaryJoin) {
        QueryUtils.reduceUnnessesaryJoin(root, ctx, isReduceUnnessesaryJoin);
        PrepareJoinDB.prepare(root);
        QueryUtils.joinInSameDatabase(root);
    }

    public static boolean reduceUnnessesaryJoin(QueryTreeNode root, QContext ctx, boolean isReduceUnnessesaryJoin) {
        if (!isReduceUnnessesaryJoin) {
            return false;
        }
        AtomicBoolean optimized = new AtomicBoolean(false);
        QueryUtils.moveUpField(root, optimized, ctx);
        return optimized.get();
    }

    private static List<PropertyField> moveUpField(QueryTreeNode node, AtomicBoolean optimized, QContext ctx) {
        boolean moveUp;
        ArrayList<PropertyField> ret = new ArrayList<PropertyField>();
        for (QueryTreeNode subNode : new ArrayList<QueryTreeNode>(node.getChildren())) {
            List<PropertyField> subRet = QueryUtils.moveUpField(subNode, optimized, ctx);
            ret.addAll(subRet);
        }
        boolean bl = moveUp = ret.size() == 0 && node.isLeaf() && node.getParent() != null;
        if (moveUp) {
            SingleQuery query = node.getQuery();
            EntityItem ei = ctx.getEntityItem(query.getFullObjName());
            PropertyField[] fields = query.getSelectFields();
            boolean bl2 = moveUp = !query.getCtx().isInnerJoinEntityItem(ei) && fields.length == 1;
            if (moveUp) {
                boolean bl3 = moveUp = query.getGroupByInfoList().size() == 0 && query.getCurFilterObjSet().size() == 1;
            }
            if (moveUp) {
                PropertyField pkPropertyField = fields[0];
                String string = query.getDataEntityType().getPrimaryKey().getAlias();
                if (string.equalsIgnoreCase(pkPropertyField.getField())) {
                    String pkPropertyFieldName = pkPropertyField.getParentFullName().toLowerCase();
                    Set<String> filterPropertySet = QueryUtils.getFilterPropertySet(query.getFullObjName(), query.getWhereFilter());
                    boolean bl4 = moveUp = filterPropertySet.size() == 0 || filterPropertySet.size() == 1 && filterPropertySet.contains(pkPropertyFieldName);
                    if (moveUp) {
                        Set<String> orderByPropertySet = QueryUtils.getOrderByPropertySet(query.getOrderInfoList());
                        boolean bl5 = moveUp = orderByPropertySet.size() == 0 || orderByPropertySet.size() == 1 && orderByPropertySet.contains(pkPropertyFieldName);
                    }
                    if (moveUp) {
                        boolean usingPKjoin = true;
                        if (query.getJoinOnFilter() != null) {
                            String joinProperty = String.valueOf(query.getJoinOnFilter().getValue());
                            if (!pkPropertyField.getAlias().equalsIgnoreCase(joinProperty)) {
                                usingPKjoin = false;
                            }
                        }
                        if (!usingPKjoin) {
                            moveUp = false;
                        }
                    }
                    if (moveUp) {
                        List<OrderByInfo> orderByList;
                        QFilter filter;
                        if (!optimized.get()) {
                            optimized.set(true);
                        }
                        QueryTreeNode parentNode = node.getParent();
                        node.removeFromParentIncludeField();
                        String fkName = ei.joinProperty.getParentOriginProperty().getName();
                        PropertyField fkField = new PropertyField(ei.joinProperty.getParentEntityItem().getFullObjectName(), fkName, pkPropertyField.getAlias());
                        if (!fkField.isInnerField()) {
                            ret.add(fkField);
                        }
                        if ((filter = query.getWhereFilter()) != null) {
                            String filterProperty = fkField.getParentFullName();
                            filter.__setProperty(filterProperty);
                            for (QFilter.QFilterNest next : filter.getNests(true)) {
                                next.getFilter().__setProperty(filterProperty);
                            }
                            query.getAllWhereFilterMap().remove(query.getFullObjName());
                            String parentFullObjectName = fkField.getFullObjectName();
                            QFilter parentFilter = query.getAllWhereFilterMap().get(parentFullObjectName);
                            parentFilter = parentFilter == null ? filter : parentFilter.and(filter);
                            query.getAllWhereFilterMap().put(parentFullObjectName, parentFilter);
                        }
                        if ((orderByList = query.getOrderInfoList()) != null && orderByList.size() > 0) {
                            for (OrderByInfo orderBy : orderByList) {
                                orderBy.replaceWhenOneProperty(fkField);
                            }
                        }
                        parentNode.setQuery(parentNode.getQuery().optRebuild());
                    }
                }
            }
        }
        if (!moveUp && ret.size() > 0) {
            PropertyField[] fields = node.getQuery().getSelectFields();
            String pkName = node.getQuery().getDataEntityType().getPrimaryKey().getName().toLowerCase(Locale.ENGLISH);
            HashSet<String> subNodeFKNameSet = new HashSet<String>(node.getChildren().size());
            for (QueryTreeNode queryTreeNode : node.getChildren()) {
                EntityItem ei = ctx.getEntityItem(queryTreeNode.getQuery().getFullObjName());
                String fkName = QueryUtils.getPKName(ei, queryTreeNode.getQuery(), node.getQuery());
                subNodeFKNameSet.add(fkName.toLowerCase());
            }
            ArrayList<PropertyField> removedInner = new ArrayList<PropertyField>();
            for (PropertyField field : fields) {
                if (!field.isInnerField() || pkName.equals(field.getName().toLowerCase(Locale.ENGLISH)) || subNodeFKNameSet.contains(field.getName().toLowerCase())) continue;
                removedInner.add(field);
            }
            SingleQuery singleQuery = node.getQuery().optMergeFields(ret, removedInner);
            node.setQuery(singleQuery);
            ret.clear();
        }
        return ret;
    }

    private static Set<String> getFilterPropertySet(String fullObjName, QFilter filter) {
        HashSet<String> propertySet = new HashSet<String>();
        if (filter != null) {
            String pname = filter.getProperty();
            if (pname.indexOf(46) == -1) {
                pname = fullObjName + '.' + pname;
            }
            propertySet.add(pname.toLowerCase());
            for (QFilter.QFilterNest next : filter.getNests(true)) {
                pname = next.getFilter().getProperty();
                if (pname.indexOf(46) == -1) {
                    pname = fullObjName + '.' + pname;
                }
                propertySet.add(pname.toLowerCase());
            }
        }
        return propertySet;
    }

    private static Set<String> getOrderByPropertySet(List<OrderByInfo> orderList) {
        HashSet<String> propertySet = new HashSet<String>();
        if (orderList != null) {
            for (OrderByInfo oi : orderList) {
                for (String fullPropertyName : oi.getPropertySegExpress().getFullPropertyNames()) {
                    propertySet.add(fullPropertyName.toLowerCase());
                }
            }
        }
        return propertySet;
    }

    private static String getPKName(EntityItem ei, SingleQuery childrenQuery, SingleQuery parentQuery) {
        return ei.joinProperty.getParentOriginProperty().getName();
    }
}

